/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.systemexternal;

import com.alibaba.fastjson.JSONObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.supplier.didi.systemexternal.IOffsetCaculateAble;

public class TripJSONAnalysisConstruct {
    private static final Log logger = LogFactory.getLog(TripJSONAnalysisConstruct.class);
    private String dataProName;
    private String recordsProName;
    private Object initOffset;
    private int maxLength;
    private IOffsetCaculateAble offsetCaculate;
    private String offsetProName;

    public TripJSONAnalysisConstruct(String dataProName, String recordsProName, String offsetProName, int initOffset, int maxLength, IOffsetCaculateAble offsetCaculate) {
        this.dataProName = dataProName;
        this.recordsProName = recordsProName;
        this.offsetProName = offsetProName;
        this.initOffset = initOffset;
        this.maxLength = maxLength;
        this.offsetCaculate = offsetCaculate;
    }

    public String getOffsetProName() {
        return this.offsetProName;
    }

    public String getDataProName() {
        return this.dataProName;
    }

    public String getRecordsProName() {
        return this.recordsProName;
    }

    public Object getInitOffset() {
        return this.initOffset;
    }

    public void setInitOffset(Object initOffset) {
        this.initOffset = initOffset;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public IOffsetCaculateAble getOffsetCaculate() {
        if (this.offsetCaculate == null) {
            this.offsetCaculate = new DefaultOffsetCaculation();
        }
        return this.offsetCaculate;
    }

    public static class DefaultOffsetCaculation
    implements IOffsetCaculateAble {
        @Override
        public Object caculateOffset(Object initOffset, int maxLength, JSONObject data) {
            if (initOffset instanceof Integer) {
                initOffset = (Integer)initOffset + maxLength;
            } else if (initOffset instanceof Long) {
                initOffset = (Long)initOffset + (long)maxLength;
            } else if (initOffset instanceof String) {
                try {
                    initOffset = Long.parseLong(String.valueOf(initOffset)) + (long)maxLength;
                }
                catch (NumberFormatException e) {
                    logger.info("kd.fi.er.business.trip.supplier.didi.systemexternal.TripJSONAnalysisConstruct.DefaultOffsetCaculation,\u8f6c\u578b\u9519\u8bef\uff0c\u8fd4\u56de\u503c\u5c06\u4ee50\u7684\u5f62\u5f0f\u8fd4\u56de");
                    initOffset = 0;
                }
            }
            return initOffset;
        }
    }
}

