/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.gaode;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class GaoDeServiceUtil {
    private static final Log logger = LogFactory.getLog(GaoDeServiceUtil.class);
    private static List<String> UN_SIGN_KEYS = ImmutableList.of((Object)"keyt", (Object)"ent", (Object)"sign");

    public static String genSign(Map<String, Object> paramsMap, String signKey) {
        paramsMap.remove("sign");
        String originParamStr = paramsMap.entrySet().stream().filter(entry -> !UN_SIGN_KEYS.contains(entry.getKey())).sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("&"));
        originParamStr = originParamStr + "@" + signKey;
        logger.info("JDK1.8\u53c2\u6570\u62fc\u63a5\u540e\u7684\u539f\u59cb\u7b7e\u540d\u4e32\uff1a{}", (Object)originParamStr);
        String sign = Hashing.md5().hashString((CharSequence)originParamStr, Charsets.UTF_8).toString().toUpperCase();
        return sign;
    }

    public static List<NameValuePair> getPostParams(Object data) {
        ArrayList<NameValuePair> body_params = new ArrayList<NameValuePair>();
        try {
            if (data instanceof JSONObject) {
                JSONObject dataJson = (JSONObject)data;
                for (Map.Entry entry : dataJson.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    body_params.add((NameValuePair)new BasicNameValuePair(key, String.valueOf(value)));
                }
            }
        }
        catch (Exception e) {
            logger.error("GaoDeServiceUtil.getPostParams", (Throwable)e);
        }
        return body_params;
    }
}

