/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.invoke;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.service.function.AbstractLoginInvoke;
import kd.fi.er.business.trip.supplier.meituan.enums.MeiTuanProductTypeEnum;
import kd.fi.er.business.trip.supplier.meituan.utils.MeiTuanTripUtil;
import kd.fi.er.business.trip.supplier.meituan.utils.RsaUtil;
import org.apache.commons.lang.RandomStringUtils;

public class MeiTuanLoginInvoke
extends AbstractLoginInvoke {
    private static Log logger = LogFactory.getLog(MeiTuanLoginInvoke.class);

    @Override
    public String login() {
        String loginURL = "";
        String productType = MeiTuanProductTypeEnum.SQT_HOME.getName();
        String nounce = MeiTuanLoginInvoke.getNounce();
        String appKey = MeiTuanTripUtil.getMeiTuanAppId();
        Long requestTime = this.getRequestTime();
        String entId = MeiTuanTripUtil.getMeiTuanOrationid();
        String staffNo = this.param.get("employeeNumber") != null ? (String)this.param.get("employeeNumber") : "";
        String signature = "";
        String params = "appKey=" + appKey + "&entId=" + entId + "&nounce=" + nounce + "&productType=" + productType + "&requestTime=" + requestTime + "&staffNo=" + staffNo;
        RSAPrivateKey rsaPrivateKey = null;
        try {
            rsaPrivateKey = RsaUtil.loadPrivateKey(MeiTuanTripUtil.getAppPrivateKey(true));
            signature = RsaUtil.sign(params.getBytes(), rsaPrivateKey);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u7b7e\u540d\u9519\u8bef:" + e.getMessage());
        }
        try {
            loginURL = MeiTuanTripUtil.getMeiTuanH5Url() + "?" + params + "&signature=" + URLEncoder.encode(signature, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u7f16\u53f7\u9519\u8bef:" + e.getMessage());
        }
        logger.info("\u7f8e\u56e2\u767b\u5f55URL:" + loginURL);
        return loginURL;
    }

    private Long getRequestTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return Long.valueOf(simpleDateFormat.format(new Date(System.currentTimeMillis())));
    }

    private static String getNounce() {
        return RandomStringUtils.random((int)36, (boolean)true, (boolean)true);
    }

    @Override
    protected void process(String loginString) {
        IFormView formView = (IFormView)this.param.get("view");
        formView.openUrl(loginString);
    }
}

