/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractMealApplicationBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.meituan.utils.MeiTuanTripUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.http.NameValuePair;

public class MeiTuanMealApplicationBillInvoke
extends AbstractMealApplicationBillInvoke {
    private static final Log logger = LogFactory.getLog(MeiTuanMealApplicationBillInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.MEITUAN.name();
    }

    @Override
    protected String function() {
        return "mealApplicationBillInvoke";
    }

    @Override
    protected Object getInnerData() {
        Object billId = this.getParams().get("billId");
        if (Objects.isNull(billId)) {
            return null;
        }
        DynamicObject info = BusinessDataServiceHelper.loadSingle(billId, (String)"er_mealapplication_bill");
        if (info == null) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230ID\u4e3a\u201c%s\u201d\u7684\u7528\u9910\u7533\u8bf7\u5355\u6570\u636e\u3002", (String)"MeiTuanMealApplicationBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), billId));
        } else {
            this.tripSyncLogParam.setBillno(info.getString("billno"));
        }
        return info;
    }

    protected Object convert(Object info) {
        if (info == null) {
            return null;
        }
        return this.dealBillData((DynamicObject)info);
    }

    protected String batPushProcess(Object o) {
        if (o == null) {
            logger.info("\u7f8e\u56e2\u7528\u9910\u7533\u8bf7\u5355\u540c\u6b65,\u8bf7\u6c42\u62a5\u6587\u4e3a\u7a7a");
            return "300";
        }
        JSONObject t = (JSONObject)o;
        String requestUrl = MeiTuanTripUtil.getMeiTuanUrl() + "/repast/apply/sync";
        this.tripSyncLogParam.setRequestdata(o);
        this.tripSyncLogParam.setRequesturl(requestUrl);
        List<NameValuePair> bodyParams = MeiTuanTripUtil.getBodyParams(t);
        Map<String, Object> resultMap = HttpServiceHelper.httpPost(requestUrl, bodyParams);
        this.tripSyncLogParam.setResponsedata(resultMap);
        if (resultMap != null) {
            String successCode = "";
            Object status = resultMap.get("status");
            if (!"0".equals(String.valueOf(status))) {
                successCode = "300";
                this.tripSyncLogParam.setMessage(resultMap.get("msg"));
            } else if (resultMap.containsKey("data") && resultMap.get("data") != null) {
                List data = (List)resultMap.get("data");
                for (Object obj : data) {
                    LinkedHashMap json = (LinkedHashMap)obj;
                    String result = json.get("result").toString();
                    if ("0".equals(result)) {
                        successCode = "200";
                        continue;
                    }
                    successCode = "300";
                    this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u7528\u9910\u7533\u8bf7\u5355:%1$s,\u540c\u6b65\u5931\u8d25,\u5931\u8d25\u539f\u56e0:%2$s", (String)"MeiTuanMealApplicationBillInvoke_2", (String)"fi-er-business", (Object[])new Object[0]), json.get("outRepastApplyNo"), json.get("msg")));
                }
            }
            return successCode;
        }
        return "300";
    }

    private JSONObject dealBillData(DynamicObject dynamicObject) {
        JSONObject data = new JSONObject();
        data.put("sceneType", (Object)dynamicObject.getInt("dinnerscene"));
        data.put("outRepastApplyNo", (Object)dynamicObject.getString("billno"));
        JSONObject submitStaffJson = new JSONObject();
        submitStaffJson.put("entStaffNum", dynamicObject.get("applier.number"));
        submitStaffJson.put("name", (Object)dynamicObject.getLocaleString("applier.name").getLocaleValue());
        data.put("submitStaff", (Object)submitStaffJson);
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        endDate = TripCommonUtil.addDayByDate(endDate, 1);
        String description = dynamicObject.getString("description");
        int length = description.getBytes(Charset.defaultCharset()).length;
        if (length > 100) {
            description = this.truncateStr(description, 100);
        }
        BigDecimal dinnerAmount = dynamicObject.getBigDecimal("dinneramount");
        JSONObject assistantStaffJson = new JSONObject();
        assistantStaffJson.put("entStaffNum", dynamicObject.get("creator.number"));
        assistantStaffJson.put("name", (Object)dynamicObject.getLocaleString("creator.name").getLocaleValue());
        JSONArray assistantStaffJsonArray = new JSONArray();
        assistantStaffJsonArray.add((Object)assistantStaffJson);
        data.put("assistantStaffList", (Object)assistantStaffJsonArray);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_mealapplication_bill", (String)"internalusers", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk(dynamicObject))});
        JSONArray innerStaffJsonArray = new JSONArray();
        this.dealInnerStaffs(innerStaffJsonArray, load);
        data.put("innerStaffList", (Object)innerStaffJsonArray);
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(ErCommonUtils.getPk(dynamicObject.get("costcompany")), true);
        DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"ftaxregnum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountOrgId)});
        if (orgInfo != null) {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("taxNum", orgInfo.get("ftaxregnum"));
            data.put("invoiceInfo", (Object)invoiceJson);
        }
        JSONArray requestJson = new JSONArray();
        data.put("startTime", (Object)startDate.getTime());
        data.put("endTime", (Object)(endDate.getTime() - 1000L));
        data.put("reason", (Object)description);
        data.put("limitAmount", (Object)dinnerAmount);
        requestJson.add((Object)data);
        JSONObject resJson = new JSONObject();
        MeiTuanTripUtil.delaCommonParams(resJson, "sync_bill");
        resJson.put("outRepastApplyList", (Object)requestJson);
        return resJson;
    }

    private void dealInnerStaffs(JSONArray innerStaffJsonArray, DynamicObject[] load) {
        if (load == null || load.length == 0) {
            return;
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        for (DynamicObject row : load) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)row.get("internalusers");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                Long fbasedataid = ErCommonUtils.getPk(dynamicObject.get("fbasedataid"));
                userIdSet.add(fbasedataid);
            }
        }
        QFilter qFilter = new QFilter("id", "in", userIdSet);
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        if (userArr == null || userArr.length == 0) {
            return;
        }
        for (int i = 0; i < userArr.length; ++i) {
            DynamicObject dynamicObject = userArr[i];
            JSONObject userJson = new JSONObject();
            userJson.put("entStaffNum", dynamicObject.get("number"));
            userJson.put("name", (Object)dynamicObject.getLocaleString("name").getLocaleValue());
            innerStaffJsonArray.add((Object)userJson);
        }
    }

    private String truncateStr(String description, int len) {
        char[] chrArr = description.toCharArray();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (char cc : chrArr) {
            if (count >= len) break;
            if (this.isChinese(cc)) {
                if (count + 1 == len) {
                    return sb.toString();
                }
                count += 2;
                sb = sb.append(cc);
                continue;
            }
            ++count;
            sb = sb.append(cc);
        }
        return sb.toString();
    }

    public boolean isChinese(char c) {
        return String.valueOf(c).getBytes().length > 1;
    }
}

