/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.trip.model.FlightItineraryImageAndTrainImageModel;
import kd.fi.er.business.trip.service.function.AbstractCheckingBillImageInvoke;
import kd.fi.er.business.trip.util.TripCheckingInvoiceImageInfoUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class TTripTrainImageInfoInvoke
extends AbstractCheckingBillImageInvoke {
    private static Log logger = LogFactory.getLog(TTripTrainImageInfoInvoke.class);

    protected Object process(Map params) {
        Map<String, List<String>> checkingBillDatas = this.getCheckingBillDatas();
        if (checkingBillDatas.isEmpty()) {
            return null;
        }
        List<String> trainBillNums = checkingBillDatas.get("train");
        if (CollectionUtils.isEmpty(trainBillNums)) {
            return null;
        }
        logger.info("\u706b\u8f66\u7c7b\u578b,\u8d26\u5355\u7f16\u53f7{}", trainBillNums);
        return this.getTrainImageInfo(trainBillNums);
    }

    private HashSet<JSONObject> getTrainImageInfo(List<String> trainBillNums) {
        String url = TripCommonUtil.getTravelNoOneApiUrl("queryTrainImageInfoByBillNo");
        this.tripSyncLogParam.setRequesturl(url);
        this.tripSyncLogParam.setStatus("A");
        return TripCheckingInvoiceImageInfoUtil.getTripResponseData(trainBillNums, url, "trainInfo");
    }

    protected Object convert(Object o) {
        if (o == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u706b\u8f66\u7968\u7968\u6839\u5f71\u50cf\u6570\u636e\u4e3a\u7a7a!", (String)"TTripTrainImageInfoInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        HashSet convertResult = (HashSet)o;
        if (convertResult.isEmpty()) {
            return null;
        }
        Iterator iterator = convertResult.iterator();
        ArrayList models = Lists.newArrayListWithCapacity((int)16);
        while (iterator.hasNext()) {
            JSONObject next = (JSONObject)iterator.next();
            if (next == null) continue;
            List<FlightItineraryImageAndTrainImageModel> imageModels = TripCheckingInvoiceImageInfoUtil.dealJSON(next, "trainInfo");
            this.handleSpecialFieldValue(imageModels);
            models.addAll(imageModels);
        }
        return models;
    }

    @Override
    protected void saveInfos(Object infos) {
        if (infos == null) {
            return;
        }
        logger.info("TTripTrainImageInfoInvoke saveInfos");
        List models = (List)infos;
        if (CollectionUtils.isEmpty((Collection)models)) {
            return;
        }
        this.dao = new ErOrm("er_checkingbill");
        String lockKey = "kd.fi.er.business.trip.supplier.travelno1.invoke.TTripTrainImageInfoInvoke";
        try (DLock dLock = DLock.create((String)lockKey);){
            boolean isLock = dLock.tryLock(30000L);
            if (isLock) {
                TripCheckingInvoiceImageInfoUtil.delData(models, "train");
                List<DynamicObject> dynamicObjects = this.handleFieldValue(models, this.dao);
                if (CollectionUtils.isNotEmpty(dynamicObjects)) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                } else {
                    logger.info("\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25:{}", (Object)lockKey);
                }
            }
        }
        catch (Exception e) {
            logger.error("TTripTrainImageInfoInvoke saveinfos error", (Throwable)e);
        }
    }

    public List<DynamicObject> handleFieldValue(List models, ErOrm erDao) {
        try {
            return TripCheckingInvoiceImageInfoUtil.innerHandleFieldValue(models, erDao);
        }
        catch (ParseException e) {
            logger.error("handleFieldValue \u5904\u7406\u5c5e\u6027\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

