/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.service.function.AbstractUserInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.invoke.TTripOrgAndUserInvokeUtil;
import kd.fi.er.business.trip.util.SyncUserTypeEnum;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.UserHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripUserGrantUtils;
import org.apache.commons.lang3.StringUtils;

public class TTripUserInvoke
extends AbstractUserInvoke {
    private static Log logger = LogFactory.getLog(TTripUserInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncpeopletamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncPeopleTamp = this.bizInfoObject.getString("lastsyncpeopletamp");
        return this.queryChangeInfo(this.lastSyncPeopleTamp, 1, 1000000, null);
    }

    protected Object getInnerData(String changeTime, Integer pageIndex, Integer pageSize, Map map) {
        return this.queryChangeInfoNew(changeTime, pageIndex, pageSize, map);
    }

    private Map<String, JSONArray> queryChangeInfo(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        Map<Object, Object> returnMap = Maps.newHashMapWithExpectedSize((int)16);
        SyncUserTypeEnum userTypeEnum = UserHelper.getSyncType(map);
        returnMap = userTypeEnum == SyncUserTypeEnum.SYNC_BY_USER ? this.getAllUserInfos(pageIndex, pageSize, map) : (userTypeEnum == SyncUserTypeEnum.SYNC_BY_ORG ? this.getChangedUserMap(changeTime, pageIndex, pageSize, map) : (TripCommonUtil.isInitTime(TripCommonUtil.convertToDate(changeTime)) ? this.getAllUserInfos(pageIndex, pageSize, map) : this.getChangedUserMap(changeTime, pageIndex, pageSize, map)));
        return returnMap;
    }

    private Map<String, JSONArray> queryChangeInfoNew(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        Map<Object, Object> returnMap = Maps.newHashMapWithExpectedSize((int)16);
        if (map != null && null == map.get("deleteflag")) {
            SyncUserTypeEnum userTypeEnum = UserHelper.getSyncType(map);
            returnMap = userTypeEnum == SyncUserTypeEnum.SYNC_BY_USER ? this.getAllUserInfos(pageIndex, pageSize, map) : (userTypeEnum == SyncUserTypeEnum.SYNC_BY_ORG ? this.getChangedUserMap(changeTime, pageIndex, pageSize, map) : (TripCommonUtil.isInitTime(TripCommonUtil.convertToDate(changeTime)) ? this.getAllUserInfos(pageIndex, pageSize, map) : this.getChangedUserMap(changeTime, pageIndex, pageSize, map)));
        } else {
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            returnMap = this.getChangedUserMapNew(changeTime, pageIndex, pageSize, map);
        }
        return returnMap;
    }

    private Map<String, JSONArray> getAllUserInfos(Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String companyId = supplierMap.get("orationid");
        String companyName = supplierMap.get("reservedfield1");
        String systemID = supplierMap.get("reservedfield5");
        List<Map<String, Object>> dosAlls = UserHelper.getAllUserChangeInfos(pageIndex, pageSize, map);
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevel(dosAlls.stream().map(e -> Long.parseLong((String)e.get("id"))).collect(Collectors.toSet()));
        HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
        JSONArray newList = new JSONArray();
        ArrayList<Map<String, Object>> maxTimeUserChangeInfos = new ArrayList<Map<String, Object>>();
        dosAlls.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> maxTimeUserChangeInfos.add(valueList.stream().filter(v -> v.get("changetime") != null).max(Comparator.comparing(v -> (Date)v.get("changetime"))).get()));
        this.sortList(maxTimeUserChangeInfos);
        maxTimeUserChangeInfos.stream().filter(userDo -> userDo.get("number") != null && userDo.get("dptId") != null).forEach(userDo -> this.buildNewMap(newList, userDo.get("number"), userDo.get("name"), userDo.get("phone"), userDo.get("email"), userDo.get("dptId"), userDo.get("dpt"), companyId, companyName, systemID, (String)reimburseLevelMap.get(Long.valueOf(String.valueOf(userDo.get("id")))), StringUtils.isBlank((CharSequence)((CharSequence)userDo.get("gender"))) || "2".equals(userDo.get("gender")) ? "0" : "1", (String)userDo.get("type"), (String)userDo.get("country"), userDo.get("supernumber")));
        dataMap.put("staffUniversalHandle", newList);
        return dataMap;
    }

    private Map<String, JSONArray> getChangedUserMapNew(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> paramMap) {
        List<Map<String, Object>> userChangeInfos = UserHelper.getUserInfosByTimeNew(pageIndex, pageSize, DateUtils.parseDate((Object)changeTime), paramMap);
        if (userChangeInfos == null || userChangeInfos.size() < 1) {
            return null;
        }
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String companyId = supplierMap.get("orationid");
        String companyName = supplierMap.get("reservedfield1");
        String systemID = supplierMap.get("reservedfield5");
        HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
        JSONArray newList = new JSONArray();
        ArrayList<Map> maxTimeUserChangeInfos = new ArrayList<Map>();
        userChangeInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> maxTimeUserChangeInfos.add(valueList.stream().filter(v -> v.get("modifytime") != null).max(Comparator.comparing(v -> (Date)v.get("modifytime"))).get()));
        maxTimeUserChangeInfos.sort(Comparator.comparing(t -> String.valueOf(t.get("modifytime"))));
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNew(userChangeInfos);
        Map<Long, Map<String, Object>> userDDeptMap = this.setBaseDataInfoNew(userChangeInfos);
        maxTimeUserChangeInfos.stream().filter(userChangeDO -> userChangeDO.get("number") != null).collect(Collectors.toList()).forEach(userChangeDO -> this.buildNewMapNew(newList, companyId, systemID, reimburseLevelMap, (Map<String, Object>)userChangeDO, userDDeptMap));
        dataMap.put("staffUniversalHandle", newList);
        return dataMap;
    }

    private void buildNewMapNew(JSONArray newList, String companyId, String systemID, Map<Long, String> reimburseLevelMap, Map<String, Object> userChangeDO, Map<Long, Map<String, Object>> userDDeptMap) {
        Object number = userChangeDO.get("number");
        Object name = userChangeDO.get("name");
        Object phone = userChangeDO.get("phone");
        Object dptId = userChangeDO.get("dptId");
        Object dptname = userChangeDO.get("dptName");
        Object dptNumber = userChangeDO.get("dptNumber");
        String userGender = userChangeDO.getOrDefault("gender", "").toString();
        String country = (String)userChangeDO.get("country");
        if (StringUtils.isBlank((CharSequence)userGender) || "2".equals(userGender)) {
            userGender = "0";
        }
        JSONObject newObj = new JSONObject();
        JSONObject createUserStaffInfo = new JSONObject();
        createUserStaffInfo.put("outCompanyID", (Object)companyId);
        createUserStaffInfo.put("empID", number);
        int intValue = TripSyncConfigUtil.getIntValue("trip_Superior", 0, Arrays.asList(0, 1));
        if (intValue == 1) {
            createUserStaffInfo.put("leaderEmpID", userChangeDO.get("supernumber") == null ? "" : userChangeDO.get("supernumber"));
        }
        createUserStaffInfo.put("name", name);
        createUserStaffInfo.put("phone", phone);
        createUserStaffInfo.put("gender", (Object)userGender);
        createUserStaffInfo.put("empStatus", (Object)"1");
        if (userChangeDO.get("deleteflag") != null && ((Boolean)userChangeDO.get("deleteflag")).booleanValue()) {
            createUserStaffInfo.put("empStatus", (Object)"0");
            logger.info("\u5dee\u65c5\u4e00\u53f7\uff0c\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u5220\u9664\uff1a{}:{}", userChangeDO.get("number"), userChangeDO.get("deleteflag"));
        } else if (null != userChangeDO.get("enable") && "0".equals(userChangeDO.get("enable").toString()) || null != userChangeDO.get("isforbidden") && "true".equals(userChangeDO.get("isforbidden").toString())) {
            logger.info("\u5dee\u65c5\u4e00\u53f7\uff0c\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u7981\u7528\uff1a{}:{},{}", new Object[]{userChangeDO.get("number"), userChangeDO.get("enable"), userChangeDO.get("isforbidden")});
            createUserStaffInfo.put("empStatus", (Object)"0");
        }
        createUserStaffInfo.put("nationality", (Object)country);
        JSONArray deptInfoArray = new JSONArray();
        JSONObject deptInfoList = new JSONObject();
        deptInfoList.put("outDeptNO", dptId);
        deptInfoList.put("deptName", dptname);
        deptInfoArray.add((Object)deptInfoList);
        JSONObject loginVoucherInfo = new JSONObject();
        loginVoucherInfo.put("empID", number);
        loginVoucherInfo.put("systemID", (Object)systemID);
        newObj.put("loginVoucherInfo", (Object)loginVoucherInfo);
        newObj.put("staffInfoTo", (Object)createUserStaffInfo);
        newObj.put("deptInfoList", (Object)deptInfoArray);
        newObj.put("positionName", (Object)reimburseLevelMap.get(Long.valueOf(String.valueOf(userChangeDO.get("id")))));
        JSONObject baseDataInfo = new JSONObject();
        JSONArray baseDataInfoDetail = new JSONArray();
        baseDataInfoDetail.add(userDDeptMap.get(Long.valueOf(String.valueOf(userChangeDO.get("id")))));
        baseDataInfo.put("baseDataList", (Object)baseDataInfoDetail);
        newObj.put("baseDataInfo", (Object)baseDataInfo);
        newList.add((Object)newObj);
    }

    private Map<String, JSONArray> getChangedUserMap(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> paramMap) {
        List<Map<String, Object>> userChangeInfos = UserHelper.getUserChangeInfosByTime(pageIndex, pageSize, DateUtils.parseDate((Object)changeTime), paramMap);
        if (userChangeInfos == null || userChangeInfos.size() < 1) {
            return null;
        }
        HashSet<Long> userIDSet = new HashSet<Long>(userChangeInfos.size());
        for (int i = 0; i < userChangeInfos.size(); ++i) {
            Map<String, Object> map = userChangeInfos.get(i);
            userIDSet.add(Long.valueOf(map.get("id").toString()));
        }
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevel(userIDSet);
        Map<Long, String> userGenderMap = this.getUserGender(userIDSet);
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String companyId = supplierMap.get("orationid");
        String companyName = supplierMap.get("reservedfield1");
        String systemID = supplierMap.get("reservedfield5");
        HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
        JSONArray newList = new JSONArray();
        ArrayList<Map<String, Object>> maxTimeUserChangeInfos = new ArrayList<Map<String, Object>>();
        userChangeInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> maxTimeUserChangeInfos.add(valueList.stream().filter(v -> v.get("changetime") != null).max(Comparator.comparing(v -> (Date)v.get("changetime"))).get()));
        this.sortList(maxTimeUserChangeInfos);
        maxTimeUserChangeInfos.stream().filter(userChangeDO -> userChangeDO.get("number") != null).collect(Collectors.toList()).forEach(userChangeDO -> this.buildNewMap(newList, userChangeDO.get("number"), userChangeDO.get("name"), userChangeDO.get("phone"), userChangeDO.get("email"), userChangeDO.get("dptId"), userChangeDO.get("dpt"), companyId, companyName, systemID, (String)reimburseLevelMap.get(Long.valueOf(String.valueOf(userChangeDO.get("id")))), (String)userGenderMap.get(Long.valueOf(String.valueOf(userChangeDO.get("id")))), (String)userChangeDO.get("type"), (String)userChangeDO.get("country"), userChangeDO.get("supernumber")));
        dataMap.put("staffUniversalHandle", newList);
        return dataMap;
    }

    private void buildNewMap(JSONArray newList, Object number, Object name, Object phone, Object email, Object dptId, Object dptname, String companyId, String companyName, String systemID, String reimburseleveName, String userGender, String type, String country, Object superNumber) {
        JSONObject newObj = new JSONObject();
        JSONObject createUserStaffInfo = new JSONObject();
        createUserStaffInfo.put("outCompanyID", (Object)companyId);
        createUserStaffInfo.put("empID", number);
        int intValue = TripSyncConfigUtil.getIntValue("trip_Superior", 0, Arrays.asList(0, 1));
        if (intValue == 1) {
            createUserStaffInfo.put("leaderEmpID", superNumber == null ? "" : superNumber);
        }
        createUserStaffInfo.put("name", name);
        createUserStaffInfo.put("phone", phone);
        createUserStaffInfo.put("gender", (Object)userGender);
        if (Arrays.asList("1", "2", "5").contains(type)) {
            createUserStaffInfo.put("empStatus", (Object)"1");
        } else if (Collections.singletonList("4").contains(type)) {
            createUserStaffInfo.put("empStatus", (Object)"0");
        } else if ("3".equals(type)) {
            createUserStaffInfo.put("empStatus", (Object)"2");
        }
        createUserStaffInfo.put("nationality", (Object)country);
        JSONArray deptInfoArray = new JSONArray();
        JSONObject deptInfoList = new JSONObject();
        deptInfoList.put("outDeptNO", dptId);
        deptInfoList.put("deptName", dptname);
        deptInfoArray.add((Object)deptInfoList);
        JSONObject loginVoucherInfo = new JSONObject();
        loginVoucherInfo.put("empID", number);
        loginVoucherInfo.put("systemID", (Object)systemID);
        newObj.put("loginVoucherInfo", (Object)loginVoucherInfo);
        newObj.put("staffInfoTo", (Object)createUserStaffInfo);
        newObj.put("deptInfoList", (Object)deptInfoArray);
        newObj.put("positionName", (Object)reimburseleveName);
        this.setBaseDataInfo(newObj, dptId, number);
        newList.add((Object)newObj);
    }

    private void buildUpdateMap(JSONArray updateList, Object number, Object phone, String systemID) {
        JSONObject updateObj = new JSONObject();
        updateObj.put("empID", number);
        updateObj.put("loginAccount", phone);
        updateObj.put("loginAccountType", (Object)1);
        updateObj.put("modifyType", (Object)0);
        updateObj.put("systemID", (Object)systemID);
        updateList.add((Object)updateObj);
    }

    protected Object convert(Object info) {
        Map userJSONArrayMap = (Map)info;
        HashSet userNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        Set entries = userJSONArrayMap.entrySet();
        for (Map.Entry entry : entries) {
            JSONArray oldJsonArray = (JSONArray)entry.getValue();
            int size = oldJsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = oldJsonArray.getJSONObject(i);
                JSONObject staffInfoTo = jsonObject.getJSONObject("staffInfoTo");
                if (staffInfoTo == null) continue;
                String empId = staffInfoTo.getString("empID");
                userNumberSet.add(empId);
            }
        }
        this.tripSyncLogParam.setBillno(StringUtils.join((Iterable)userNumberSet, (String)","));
        this.judgeGrantUser(userJSONArrayMap);
        return userJSONArrayMap;
    }

    protected String batPushProcess(Object data) {
        Map userJSONArrayMap = (Map)data;
        if (userJSONArrayMap == null || userJSONArrayMap.size() <= 0) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u4eba\u5458\u66f4\u65b0,\u4eba\u5458\u4e3a\u7a7a!", (String)"TTripUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return "200";
        }
        AtomicReference<Boolean> successflag = new AtomicReference<Boolean>(true);
        RefObject refObject = new RefObject(new ArrayList(10));
        userJSONArrayMap.forEach((key, value) -> {
            String url = "";
            switch (key) {
                case "staffUniversalHandle": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("staffUniversalHandle");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                    break;
                }
                case "new": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("adduserurlkey");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                    break;
                }
                case "updateuser": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("modifyuserurlkey");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                    break;
                }
                case "updatestaff": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("modifystaffurlkey");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                    break;
                }
                case "disable": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("disablestaffurlkey");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                    break;
                }
                case "enable": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("enableuserurlkey");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                    url = TripCommonUtil.getTravelNoOneApiUrl("enablestaffurlkey");
                    TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncUser", value, url, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
                }
            }
        });
        ((List)refObject.getValue()).stream().forEach(e -> this.addTripSyncLogParam((TripSyncLogParam)e));
        String code = "300";
        if (successflag.get().booleanValue()) {
            code = "200";
        }
        return code;
    }

    private Map<Long, String> getUserGender(Set<Long> userIDSet) {
        HashMap<Long, String> paraMap = new HashMap<Long, String>();
        QFilter filter = new QFilter("id", "in", userIDSet);
        QFilter[] qFilters = new QFilter[]{filter};
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id, gender", (QFilter[])qFilters);
        if (userMap.size() > 0) {
            Collection values = userMap.values();
            paraMap = new HashMap(userMap.size());
            for (DynamicObject user : values) {
                Long userId = (Long)user.get("id");
                String gender = user.getString("gender");
                if (StringUtils.isBlank((CharSequence)gender) || "2".equals(gender)) {
                    gender = "0";
                }
                paraMap.put(userId, gender);
            }
        }
        return paraMap;
    }

    @Override
    protected boolean syncUserByPage() {
        return true;
    }

    private void sortList(List<Map<String, Object>> maxTimeUserChangeInfos) {
        maxTimeUserChangeInfos.sort(Comparator.comparing(t -> String.valueOf(t.get("changetime"))));
    }

    private Map<Long, Map<String, Object>> setBaseDataInfoNew(List<Map<String, Object>> userChangeInfos) {
        HashMap<Long, Map<String, Object>> userDptMap = new HashMap<Long, Map<String, Object>>(userChangeInfos.size());
        boolean tripReqSyncIdFlag = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
        Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        String param = tripInfoDynamic.get("syncreqbillsettleorg");
        HashSet<Long> companyIds = new HashSet<Long>(userChangeInfos.size());
        HashSet<Long> accountOrgIds = new HashSet<Long>(userChangeInfos.size());
        for (Map<String, Object> userChangeInfo : userChangeInfos) {
            Long companyId = Long.parseLong(userChangeInfo.getOrDefault("companyId", "-1").toString());
            Long costCompanyId = Long.parseLong(userChangeInfo.getOrDefault("costCompanyId", "-1").toString());
            companyIds.add(companyId);
            accountOrgIds.add(costCompanyId);
        }
        Map orgInfoMap = new HashMap(userChangeInfos.size());
        try {
            orgInfoMap = "1".equals(param) ? BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", companyIds)}) : BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", accountOrgIds)});
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u4e3b\u804c\u4f4d\u6838\u7b97\u7ec4\u7ec7\u5931\u8d25" + e.getMessage());
        }
        for (Map<String, Object> userChangeInfo : userChangeInfos) {
            HashMap<String, Object> detail = new HashMap<String, Object>(2);
            Object dptname = userChangeInfo.get("dptName");
            Object dptNumber = userChangeInfo.get("dptNumber");
            Long dptId = Long.parseLong(userChangeInfo.getOrDefault("dptId", "-1").toString());
            Long companyId = Long.parseLong(userChangeInfo.getOrDefault("companyId", "-1").toString());
            Long costCompanyId = Long.parseLong(userChangeInfo.getOrDefault("costCompanyId", "-1").toString());
            DynamicObject orgInfo = null;
            if (null != orgInfoMap && !orgInfoMap.isEmpty()) {
                for (DynamicObject adminorg : orgInfoMap.values()) {
                    if ("1".equals(param)) {
                        if (!Long.valueOf(adminorg.getLong("id")).equals(companyId)) continue;
                        orgInfo = adminorg;
                        continue;
                    }
                    if (!Long.valueOf(adminorg.getLong("id")).equals(costCompanyId)) continue;
                    orgInfo = adminorg;
                }
            }
            if (tripReqSyncIdFlag) {
                if (dptNumber != null) {
                    detail.put("costCenterNO", dptNumber);
                    detail.put("costCenterName", dptname);
                } else {
                    detail.put("costCenterNO", "");
                    detail.put("costCenterName", "");
                }
                if (orgInfo != null) {
                    detail.put("regNO", orgInfo.get("number"));
                    detail.put("regName", orgInfo.getLocaleString("name").getLocaleValue());
                } else {
                    detail.put("regNO", "");
                    detail.put("regName", "");
                }
            } else {
                if (dptId != null) {
                    detail.put("costCenterNO", dptId);
                    detail.put("costCenterName", dptname);
                } else {
                    detail.put("costCenterNO", "");
                    detail.put("costCenterName", "");
                }
                if (orgInfo != null) {
                    detail.put("regNO", orgInfo.get("id"));
                    detail.put("regName", orgInfo.getLocaleString("name").getLocaleValue());
                } else {
                    detail.put("regNO", "");
                    detail.put("regName", "");
                }
            }
            userDptMap.put(Long.parseLong(userChangeInfo.getOrDefault("id", "-1").toString()), detail);
        }
        return userDptMap;
    }

    private void setBaseDataInfo(JSONObject newObj, Object dptId, Object number) {
        JSONObject baseDataInfo = new JSONObject();
        JSONArray baseDataInfoDetail = new JSONArray();
        JSONObject detail = new JSONObject();
        boolean tripReqSyncIdFlag = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", dptId)});
        DynamicObject[] userInfos = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,number,entryentity.dpt,entryentity.ispartjob,entryentity.id", (QFilter[])new QFilter[]{new QFilter("number", "=", number)});
        DynamicObject orgInfo = null;
        if (userInfos != null) {
            DynamicObjectCollection entryEntity = userInfos[0].getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                boolean ispartjob = dynamicObject.getBoolean("ispartjob");
                if (ispartjob) continue;
                Long id = ErCommonUtils.getPk(dynamicObject.get("dpt"));
                try {
                    Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
                    String param = tripInfoDynamic.get("syncreqbillsettleorg");
                    if ("1".equals(param)) {
                        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(id);
                        orgInfo = BusinessDataServiceHelper.loadSingle((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyId)});
                        continue;
                    }
                    Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(id);
                    orgInfo = BusinessDataServiceHelper.loadSingle((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountOrgId)});
                    continue;
                }
                catch (Exception e) {
                    logger.info("\u83b7\u53d6\u4e3b\u804c\u4f4d\u6838\u7b97\u7ec4\u7ec7\u5931\u8d25" + e.getMessage());
                }
            }
        }
        if (tripReqSyncIdFlag) {
            if (load != null && load.length > 0) {
                detail.put("costCenterNO", load[0].get("number"));
                detail.put("costCenterName", (Object)load[0].getLocaleString("name").getLocaleValue());
            } else {
                detail.put("costCenterNO", (Object)"");
                detail.put("costCenterName", (Object)"");
            }
            if (orgInfo != null) {
                detail.put("regNO", orgInfo.get("number"));
                detail.put("regName", (Object)orgInfo.getLocaleString("name").getLocaleValue());
            } else {
                detail.put("regNO", (Object)"");
                detail.put("regName", (Object)"");
            }
        } else {
            if (load != null && load.length > 0) {
                detail.put("costCenterNO", load[0].get("id"));
                detail.put("costCenterName", (Object)load[0].getLocaleString("name").getLocaleValue());
            } else {
                detail.put("costCenterNO", (Object)"");
                detail.put("costCenterName", (Object)"");
            }
            if (orgInfo != null) {
                detail.put("regNO", orgInfo.get("id"));
                detail.put("regName", (Object)orgInfo.getLocaleString("name").getLocaleValue());
            } else {
                detail.put("regNO", (Object)"");
                detail.put("regName", (Object)"");
            }
        }
        baseDataInfoDetail.add((Object)detail);
        baseDataInfo.put("baseDataList", (Object)baseDataInfoDetail);
        newObj.put("baseDataInfo", (Object)baseDataInfo);
    }

    private void judgeGrantUser(Map<String, JSONArray> returnMap) {
        if (returnMap == null || returnMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection servers = TripUserGrantUtils.getServers(this.supplier());
        if (CollectionUtils.isEmpty((Collection)servers)) {
            return;
        }
        DynamicObjectCollection dynamicObjects = TripUserGrantUtils.queryUserGrantInfosByServer(Collections.singletonList(this.supplier()));
        Set grantUserNos = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("grantuserno")).collect(Collectors.toSet());
        Set<Map.Entry<String, JSONArray>> entries = returnMap.entrySet();
        HashSet notGrantUserSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet userNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, JSONArray> entry : entries) {
            JSONArray newJsonArray = new JSONArray();
            JSONArray oldJsonArray = entry.getValue();
            int size = oldJsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = oldJsonArray.getJSONObject(i);
                JSONObject staffInfoTo = jsonObject.getJSONObject("staffInfoTo");
                if (staffInfoTo == null) continue;
                String empId = staffInfoTo.getString("empID");
                if (!grantUserNos.contains(empId)) {
                    notGrantUserSet.add(staffInfoTo.getString("name") + "(" + empId + ")");
                    userNumberSet.add(empId);
                    continue;
                }
                newJsonArray.add((Object)jsonObject);
            }
            returnMap.put(entry.getKey(), newJsonArray);
        }
        if (CollectionUtils.isNotEmpty((Collection)notGrantUserSet)) {
            TripSyncLogParam tripSyncLog = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
            String msg = String.join((CharSequence)",", notGrantUserSet);
            tripSyncLog.setMessage(String.format(ResManager.loadKDString((String)"\u7528\u6237\u672a\u6388\u6743\u5dee\u65c5\u58f9\u53f7\u5546\u65c5,\u5f85\u7528\u6237\u81ea\u884c\u6388\u6743\u540e\u53ef\u91cd\u65b0\u540c\u6b65\u4eba\u5458:%s", (String)"TTripUserInvoke_1", (String)"fi-er-business", (Object[])new Object[0]), msg));
            tripSyncLog.setStatus("B");
            tripSyncLog.setBillno(String.join((CharSequence)",", userNumberSet));
            TripSyncLogUtils.saveErrorLog(Collections.singletonList(tripSyncLog));
        }
    }
}

