/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class UpgradeReimburseSetting {
    private static Log logger = LogFactory.getLog(UpgradeReimburseSetting.class);
    private static String bos_user = "bos_user";

    public UpgradeResult executeSq(boolean waitEnd) {
        UpgradeResult result = new UpgradeResult();
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)"er_reimbursesetting");
        }
        catch (Exception var13) {
            result.setLog(var13.getMessage());
        }
        if (mainEntityType != null) {
            ORM orm = ORM.create();
            DataSet dataSet = orm.queryDataSet(UpgradeReimburseSetting.class.getName(), bos_user, "id", new QFilter[0], "id", 0, 1);
            Long min = ((Row)dataSet.iterator().next()).getLong("id");
            dataSet = orm.queryDataSet(UpgradeReimburseSetting.class.getName(), bos_user, "id", new QFilter[0], "id desc ", 0, 1);
            Long max = ((Row)dataSet.iterator().next()).getLong("id");
            List<QFilter> list = UpgradeReimburseSetting.splitById("id", min, max, 10L);
            final CountDownLatch countDownLatch = new CountDownLatch(list.size());
            for (final QFilter qFilter : list) {
                ThreadService.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UpgradeReimburseSetting.syncData(new QFilter[]{qFilter}, (RefObject<AtomicLong>)new RefObject((Object)new AtomicLong(0L)), 10000L);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        countDownLatch.countDown();
                    }
                }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
            }
            if (waitEnd) {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException var12) {
                    logger.error(var12.getMessage(), (Throwable)var12);
                }
            }
        }
        result.setLog("finished");
        return result;
    }

    public static void syncData(QFilter[] qFilters, RefObject<AtomicLong> from, Long length) {
        ORM orm = ORM.create();
        DataSet dataSet = orm.queryDataSet(UpgradeReimburseSetting.class.getName() + "." + ((AtomicLong)from.getValue()).get(), bos_user, "id", qFilters, "id", ((AtomicLong)from.getValue()).intValue(), length.intValue());
        if (UpgradeReimburseSetting.update(dataSet, length.intValue(), from)) {
            UpgradeReimburseSetting.syncData(qFilters, from, length);
        }
    }

    private static boolean update(DataSet dataSet, int length, RefObject<AtomicLong> refObject) {
        Iterator iterator = dataSet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            try {
                UpgradeReimburseSetting.updateReimburselevel(((Row)iterator.next()).getLong("id"));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        ((AtomicLong)refObject.getValue()).addAndGet(i);
        dataSet.close();
        return i >= length;
    }

    private static void updateReimburselevel(Long user) {
        Long deptId;
        Map companyByOrg;
        Long companyId;
        Map<String, Object> userMap = UpgradeReimburseSetting.getUserMap(user);
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept != null && (companyId = (Long)(companyByOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)(deptId = (Long)dept.getPkValue()))).get("id")) != null) {
            QFilter filter = new QFilter("user", "=", (Object)user);
            filter.and(new QFilter("company", "=", (Object)companyId));
            DynamicObject relOb = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimbursesetting_rel", (String)"reimburselevel", (QFilter[])new QFilter[]{filter});
            if (relOb != null) {
                Long lvId = UpgradeReimburseSetting.getPk(relOb.get("reimburselevel"));
                QFilter userFilter = new QFilter("id", "=", (Object)user);
                DynamicObject relUserOb = BusinessDataServiceHelper.loadSingle((String)"er_reimbursesetting", (String)"reimburselevel", (QFilter[])new QFilter[]{userFilter});
                if (relUserOb == null) {
                    relUserOb = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_reimbursesetting"));
                }
                relUserOb.set("reimburselevel", (Object)lvId);
                relUserOb.set("id", (Object)user);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{relUserOb});
            }
        }
    }

    private static Map<String, Object> getUserMap(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject user = UpgradeReimburseSetting.getUser(userId);
        if (user != null) {
            resultMap.put("tel", user.get("phone"));
            resultMap.put("name", user.get("name"));
            resultMap.put("number", user.get("number"));
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                resultMap.put("applierpositionstr", userEntry.getString("position"));
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                resultMap.put("org", dept);
                if (isPartjob) continue;
                break;
            }
        }
        return resultMap;
    }

    private static DynamicObject getUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,email,number,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    private static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        return entity instanceof Integer ? Long.valueOf(entity.toString()) : null;
    }

    protected static List<QFilter> splitById(String field, Long min, Long max, Long n) {
        long d = (max - min) / n;
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        int i = 0;
        while ((long)i < n) {
            QFilter qFilterOne = null;
            if (i > 0 && (long)i < n - 1L) {
                qFilterOne = new QFilter(field, ">=", (Object)(min + (long)i * d));
                qFilterOne.and(field, "<", (Object)(min + (long)(i + 1) * d));
            } else if (i == 0) {
                qFilterOne = new QFilter(field, ">=", (Object)min);
                qFilterOne.and(field, "<", (Object)(min + (long)(i + 1) * d));
            } else if ((long)i == n - 1L) {
                qFilterOne = new QFilter(field, ">=", (Object)(min + (long)i * d));
                qFilterOne.and(field, "<=", (Object)max);
            }
            list.add(qFilterOne);
            ++i;
        }
        return list;
    }
}

