/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainImageModel;
import kd.fi.er.business.trip.service.function.AbstractImageInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripImagePlaneConvert;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripInvoiceUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;

public class TTripImageInvoke
extends AbstractImageInvoke<JSONObject> {
    private static Log logger = LogFactory.getLog(TTripImageInvoke.class);
    public AtomicReference<Boolean> syncSuccessFlag = new AtomicReference<Boolean>(false);
    private Date lastSyncImageTamp;
    private Date currSyncImageTamp = new Date();
    private static final String LASTSYNCIMAGETAMP_PROP = "lastsyncimagetamp";
    private static final String TTRIPSYNCIMAGESIGN = "TTripSyncImage";
    private static final String TTRIPSYNCIMAGEDETAILSIGN = "TTripSyncImageDetail";
    private DynamicObject bizInfoObject = null;
    private Boolean isScheduledTask = true;

    public TTripImageInvoke() {
    }

    public TTripImageInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    protected Object process(Map params) throws TripException {
        if (params != null && params.get("jsondata") != null) {
            return params.get("jsondata");
        }
        JSONArray dataArray = new JSONArray();
        if (null == params || null == params.get("orderIds")) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,query\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u5f00\u59cb-------------");
            if (params != null && params.size() > 0 && params.get("beginDate") != null && params.get("endDate") != null) {
                Date beginNewDate = TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                Date endNewDate = TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                this.lastSyncImageTamp = beginNewDate;
                this.currSyncImageTamp = endNewDate;
                this.isScheduledTask = false;
            } else {
                this.isScheduledTask = true;
            }
            this.queryImageData(dataArray);
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,query\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u7ed3\u675f-------------");
        } else {
            this.queryImageDetailData(dataArray, params);
        }
        return dataArray;
    }

    private void queryImageDetailData(JSONArray dataArray, Map params) {
        ErCommonUtils.removeKeyFromAppCache(TTRIPSYNCIMAGEDETAILSIGN);
        String url = TripCommonUtil.getTravelNoOneApiUrl("queryimagedetailurlkey");
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("type", 2);
        bodyObject.put("values", JSON.parseArray((String)JSON.toJSONString(params.get("orderIds")), String.class));
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("tokenId", TravelNoOneSync.getCacheToken(TTRIPSYNCIMAGESIGN));
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        currentLog.setRequesturl(url);
        currentLog.setRequestdata(bodyObject);
        String jsonStr = JSON.toJSONString((Object)bodyObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String result = HttpServiceHelper.doPost_noVerify("TTripImageInvoke", url, headMap, jsonStr);
        currentLog.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject == null || null == jsonObject.getString("errcode") || !jsonObject.getString("errcode").equals("0")) {
            currentLog.setStatus("B");
            this.syncSuccessFlag.set(false);
            dataArray.clear();
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,\u83b7\u53d6\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u5931\u8d25, \u62a5\u9519\u4fe1\u606ferrmsg: %s" + result);
            return;
        }
        this.tripSyncLogParamList.add(currentLog);
        JSONObject currData = jsonObject.getJSONObject("data");
        if (currData == null) {
            return;
        }
        dataArray.add((Object)currData);
    }

    private void queryImageData(JSONArray dataArray) {
        if (this.isScheduledTask.booleanValue()) {
            this.getTTripLastSyncImageTamp();
        }
        this.syncSuccessFlag = new AtomicReference<Boolean>(true);
        int index = 1;
        int pageSize = TripSyncConfigUtil.getIntValue("ttrip_sync_orderbill_size", 500);
        ErCommonUtils.removeKeyFromAppCache(TTRIPSYNCIMAGESIGN);
        this.startQueryImageData(index, pageSize, dataArray);
    }

    private void getTTripLastSyncImageTamp() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)LASTSYNCIMAGETAMP_PROP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncImageTamp = this.bizInfoObject.getDate(LASTSYNCIMAGETAMP_PROP);
        if (this.lastSyncImageTamp.before(ErCommonUtils.getDateFromLocalDate(LocalDate.of(2000, 1, 1)))) {
            this.lastSyncImageTamp = TripCommonUtil.delayByMonth(new Date(), -1);
        }
    }

    private void startQueryImageData(int index, int pageSize, JSONArray dataArray) {
        String url = TripCommonUtil.getTravelNoOneApiUrl("queryimageurlkey");
        Map<String, Object> reqData = this.buildPostParams(index, pageSize);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("tokenId", TravelNoOneSync.getCacheToken(TTRIPSYNCIMAGESIGN));
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        currentLog.setRequesturl(url);
        currentLog.setRequestdata(reqData);
        String jsonStr = JSON.toJSONString(reqData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String result = HttpServiceHelper.doPost_noVerify("TTripImageInvoke", url, headMap, jsonStr);
        currentLog.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) {
            currentLog.setStatus("B");
            this.syncSuccessFlag.set(false);
            dataArray.clear();
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,\u83b7\u53d6\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u5931\u8d25, \u62a5\u9519\u4fe1\u606ferrmsg: %s" + result);
            return;
        }
        this.tripSyncLogParamList.add(currentLog);
        JSONObject currData = jsonObject.getJSONObject("data");
        if (currData == null) {
            return;
        }
        dataArray.add((Object)currData);
        if (index * pageSize < currData.getInteger("totalCount")) {
            this.startQueryImageData(++index, pageSize, dataArray);
        }
    }

    protected Map<String, Object> buildPostParams(int index, int pageSize) {
        if (this.isScheduledTask.booleanValue()) {
            String imagetime = TripSyncConfigUtil.getTripsyncSettingByKey("ctrip_image_info_time");
            this.currSyncImageTamp = null == imagetime || imagetime.trim().length() == 0 ? new Date() : TripCommonUtil.strToDate(imagetime, "yyyy-MM-dd HH:mm:ss");
        }
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("pageIndex", index);
        bodyObject.put("pageSize", pageSize);
        bodyObject.put("beginTime", TripCommonUtil.date2TimeStamp(this.lastSyncImageTamp, "yyyy-MM-dd HH:mm:ss"));
        bodyObject.put("endTime", TripCommonUtil.date2TimeStamp(this.currSyncImageTamp, "yyyy-MM-dd HH:mm:ss"));
        return bodyObject;
    }

    protected Object convert(Object object) {
        JSONArray billArray = (JSONArray)object;
        if (billArray == null || billArray.size() < 1) {
            return new ArrayList();
        }
        ArrayList<AbstractOrderModel> orderModels = new ArrayList<AbstractOrderModel>();
        for (int i = 0; i < billArray.size(); ++i) {
            JSONObject orderJson = JSON.parseObject((String)billArray.getString(i));
            JSONArray travelInfo = orderJson.getJSONArray("travelInfo");
            JSONArray trainInfo = orderJson.getJSONArray("trainInfo");
            this.dealTarvelInfo(orderModels, travelInfo);
            this.dealTrainInfo(orderModels, trainInfo);
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,convert\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u7ed3\u675f-------------");
        return orderModels;
    }

    private void dealTrainInfo(List<AbstractOrderModel> orderModels, JSONArray trainInfo) {
        if (null == trainInfo || trainInfo.isEmpty()) {
            return;
        }
        for (Object train : trainInfo) {
            JSONObject image = JSON.parseObject((String)JSON.toJSONString(train));
            TrainImageModel trainImageModel = (TrainImageModel)JSON.toJavaObject((JSON)image, TrainImageModel.class);
            String userName = trainImageModel.getUserName();
            trainImageModel.setOrderNum(trainImageModel.getOrderId() + "-" + userName);
            trainImageModel.setServer(this.supplier());
            this.handleTrainImageExtCovert(trainImageModel, image);
            orderModels.add(trainImageModel);
        }
    }

    private void dealTarvelInfo(List<AbstractOrderModel> orderModels, JSONArray travelInfo) {
        if (null == travelInfo || travelInfo.isEmpty()) {
            return;
        }
        for (Object travel : travelInfo) {
            JSONObject image = JSON.parseObject((String)JSON.toJSONString(travel));
            PlaneOrderModel planeOrderModel = TTripImagePlaneConvert.convert(image);
            this.handlePlaneImageExtCovert(planeOrderModel, image);
            orderModels.add(planeOrderModel);
        }
    }

    @Override
    public void execute() throws TripException {
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,save\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u5f00\u59cb-------------");
        super.execute();
        this.syncSuccessFlag.set(true);
        if (this.isScheduledTask.booleanValue()) {
            this.saveLastSyncOrderbilltTamp();
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,save\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u6570\u636e\u7ed3\u675f-------------");
    }

    private void saveLastSyncOrderbilltTamp() {
        if (this.syncSuccessFlag.get().booleanValue() && null != this.bizInfoObject) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f,\u66f4\u65b0\u540c\u6b65\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u65f6\u95f4\u6233\u4e3a\uff1a" + this.currSyncImageTamp);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentTime = sdf.format(this.currSyncImageTamp);
            this.bizInfoObject.set(LASTSYNCIMAGETAMP_PROP, (Object)currentTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bizInfoObject});
        }
    }

    @Override
    protected void handleAfterSave(Map<String, Map<String, DynamicObject>> orderMapping) {
        if (orderMapping.isEmpty()) {
            return;
        }
        try {
            Map<String, DynamicObject> planeBillMap = orderMapping.get("er_planebill");
            Map<String, DynamicObject> trainBillMap = orderMapping.get("er_trainbill");
            Map<String, DynamicObject> planeCheckingBillMap = orderMapping.get("er_planecheckingbill");
            Map<String, DynamicObject> trainCheckingBillMap = orderMapping.get("er_traincheckingbill");
            HashSet checkPassed = Sets.newHashSetWithExpectedSize((int)16);
            HashSet unCheckPassed = Sets.newHashSetWithExpectedSize((int)16);
            this.dealPlaneImage(planeBillMap, planeCheckingBillMap, checkPassed, unCheckPassed);
            this.dealTrainImage(trainBillMap, trainCheckingBillMap, checkPassed, unCheckPassed);
        }
        catch (Exception e) {
            logger.error("handleAfterSave error", (Throwable)e);
        }
    }

    private void dealTrainImage(Map<String, DynamicObject> trainBillMap, Map<String, DynamicObject> trainCheckingBillMap, Set<String> checkPassed, Set<String> unCheckPassed) {
        this.setInvoiceInfo(trainCheckingBillMap, checkPassed, unCheckPassed);
        this.setBillInvoiceInfo(trainBillMap, checkPassed, unCheckPassed, trainCheckingBillMap);
        this.saveData(trainBillMap, trainCheckingBillMap);
    }

    private void dealPlaneImage(Map<String, DynamicObject> planeBillMap, Map<String, DynamicObject> planeCheckingBillMap, Set<String> checkPassed, Set<String> unCheckPassed) {
        this.setInvoiceInfo(planeCheckingBillMap, checkPassed, unCheckPassed);
        this.setBillInvoiceInfo(planeBillMap, checkPassed, unCheckPassed, planeCheckingBillMap);
        this.saveData(planeBillMap, planeCheckingBillMap);
    }

    private void setBillInvoiceInfo(Map<String, DynamicObject> billMap, Set<String> checkPassed, Set<String> unCheckPassed, Map<String, DynamicObject> checkingBillMap) {
        if (billMap == null || billMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, DynamicObject>> entries = billMap.entrySet();
        for (Map.Entry<String, DynamicObject> entry : entries) {
            String orderNum = entry.getKey();
            DynamicObject dynamicObject = entry.getValue();
            DynamicObject checkingBill = checkingBillMap.get(orderNum);
            if (checkingBill == null) continue;
            dynamicObject.set("identityerrormsg", (Object)"");
            dynamicObject.set("serialno", (Object)"");
            if (checkPassed.contains(orderNum)) {
                dynamicObject.set("serialno", (Object)checkingBill.getString("serialno"));
            }
            if (!unCheckPassed.contains(orderNum)) continue;
            dynamicObject.set("identityerrormsg", (Object)checkingBill.getString("identityerrormsg"));
        }
    }

    private void setInvoiceInfo(Map<String, DynamicObject> checkingBillMap, Set<String> checkPassed, Set<String> unCheckPassed) {
        if (checkingBillMap == null || checkingBillMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, DynamicObject>> entries = checkingBillMap.entrySet();
        boolean enableXhInvoiceCloud = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        if (!enableXhInvoiceCloud) {
            for (Map.Entry<String, DynamicObject> entry : entries) {
                DynamicObject checkingBill = entry.getValue();
                Object settlemain = checkingBill.get("settlemain");
                Long costCompany = 0L;
                if (settlemain != null) {
                    costCompany = ErCommonUtils.getPk(settlemain);
                }
                Long pk = ErCommonUtils.getPk(checkingBill);
                String bxdKey = checkingBill.getString("formid") + pk;
                String userKey = "";
                String orderNum = checkingBill.getString("ordernum");
                try {
                    userKey = APIHelper.getCommonUserKey(costCompany, bxdKey, orderNum);
                }
                catch (InvoiceCloudException e) {
                    logger.error("aws invoicecloud \u83b7\u53d6userkey error", (Throwable)e);
                }
                if (TripInvoiceUtils.checkInvoiceIdentifyByAws(checkingBill, userKey, new HashSet<String>())) {
                    checkPassed.add(orderNum);
                    continue;
                }
                unCheckPassed.add(orderNum);
            }
        } else {
            InvoiceService instanceService = InvoiceService.getInstanceService();
            for (Map.Entry<String, DynamicObject> entry : entries) {
                DynamicObject checkingBill = entry.getValue();
                if (TripInvoiceUtils.checkingInvoiceIdentify(checkingBill, instanceService).booleanValue()) {
                    checkPassed.add(checkingBill.getString("ordernum"));
                    continue;
                }
                unCheckPassed.add(checkingBill.getString("ordernum"));
            }
        }
    }
}

