/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke.order;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripOrderCommonConvert;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TTripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang.StringUtils;

public class TTripOrderPlaneConvert {
    public static PlaneOrderModel convert(JSONObject orderJson) {
        PlaneOrderModel planeOrderModel = new PlaneOrderModel();
        new TTripOrderCommonConvert();
        TTripOrderCommonConvert.buildOrderCommonData(planeOrderModel, orderJson);
        planeOrderModel.setBookedname(orderJson.getString("orderUserName"));
        planeOrderModel.setTicketNum(orderJson.getString("otherNo"));
        planeOrderModel.setPnr(orderJson.getString("pNR"));
        String payStateName = orderJson.getString("payStateName");
        planeOrderModel.setOrderStatus(TTripPropMapping.getPlaneOrderStatusEnumByKey(payStateName));
        planeOrderModel.setOrderStatusName(payStateName);
        PlaneOrderModel.TicketStatus ticketStatusName = TTripPropMapping.getPlaneTicketStatusEnumByKey(orderJson.getString("ticketNoState"));
        planeOrderModel.setTicketStatus(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orderJson.getString("ticketNoState")) || ticketStatusName == null ? PlaneOrderModel.TicketStatus.B : ticketStatusName);
        planeOrderModel.setAirlineName(orderJson.getString("finallySupplyName"));
        planeOrderModel.setFlightNo(orderJson.getString("shiftNo"));
        planeOrderModel.setCabinClass(orderJson.getString("productLevel"));
        planeOrderModel.setCabin(orderJson.getString("cabin"));
        planeOrderModel.setFromCity(orderJson.getString("startAddress"));
        planeOrderModel.setFromCityName(orderJson.getString("startAddress"));
        planeOrderModel.setTakeoffTime(TripCommonUtil.convertToDate(orderJson.getString("travelTime")));
        planeOrderModel.setToCity(orderJson.getString("arriveAddress"));
        planeOrderModel.setToCityName(orderJson.getString("arriveAddress"));
        planeOrderModel.setLandingTime(TripCommonUtil.convertToDate(orderJson.getString("arriveTime")));
        planeOrderModel.setStandPrice(orderJson.getBigDecimal("thePositionPrice"));
        planeOrderModel.setDiscount(orderJson.getBigDecimal("calculateDiscount"));
        planeOrderModel.setAirportPrice(orderJson.getBigDecimal("airraxFee"));
        planeOrderModel.setServiceFee(orderJson.getBigDecimal("serviceFee"));
        planeOrderModel.setFuelPrice(orderJson.getBigDecimal("airOilFee"));
        planeOrderModel.setTicketPrice(orderJson.getBigDecimal("airTicketSalePrice"));
        if (ResManager.loadKDString((String)"\u9000\u7968", (String)"TTripOrderPlaneConvert_0", (String)"fi-er-business", (Object[])new Object[0]).equalsIgnoreCase(orderJson.getString("productSubTypeName"))) {
            planeOrderModel.setRefundAmount(orderJson.getBigDecimal("handleChargeFee"));
            planeOrderModel.setRefundReason(orderJson.getString("airTicketPref"));
        } else if (ResManager.loadKDString((String)"\u6539\u7b7e", (String)"TTripOrderPlaneConvert_1", (String)"fi-er-business", (Object[])new Object[0]).equalsIgnoreCase(orderJson.getString("productSubTypeName"))) {
            planeOrderModel.setEndorsementAmount(orderJson.getBigDecimal("handleChargeFee"));
            planeOrderModel.setChangeReason(orderJson.getString("airTicketPref"));
        }
        planeOrderModel.setAssuranceAmount(orderJson.getBigDecimal("insuranceMoney"));
        planeOrderModel.setOverflag(TTripPropMapping.planeOverFlagMap().get(orderJson.getString("isOverStandard")));
        planeOrderModel.setOverDesc(orderJson.getString("overBookingReason"));
        if (StringUtils.equals((String)ResManager.loadKDString((String)"\u5dee\u989d\u9000\u6b3e", (String)"TTripPropMapping_19", (String)"fi-er-business", (Object[])new Object[0]), (String)payStateName)) {
            planeOrderModel.setRefundAmount(orderJson.get((Object)"handleChargeFee") == null ? BigDecimal.ZERO : orderJson.getBigDecimal("handleChargeFee"));
        }
        return planeOrderModel;
    }
}

