/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractInvoiceSendInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class ETripInvoiceSendInvoke
extends AbstractInvoiceSendInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(ETripInvoiceSendInvoke.class);
    private Set<String> errorSet = new HashSet<String>();
    private static Map<String, String> serviceitemMap = new HashMap<String, String>(5);

    public ETripInvoiceSendInvoke() {
    }

    public ETripInvoiceSendInvoke(DynamicObject[] invoices) {
        super(invoices);
    }

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.getValue();
    }

    @Override
    protected Object getInnerData() {
        return this.pk;
    }

    protected JSONObject convert(Object value) {
        DynamicObject[] invoices = (DynamicObject[])value;
        JSONObject convert = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < invoices.length; ++i) {
            jsonArray.add((Object)this.toJsonObject(invoices[i]));
        }
        convert.put("invoices", (Object)jsonArray);
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u53d1\u7968\u5f00\u5177,\u8f6c\u6362\u540e\u7684\u6570\u636e\u4e3a:%s", convert.toJSONString()));
        return convert;
    }

    private JSONObject toJsonObject(DynamicObject invoiceOrderBill) {
        JSONObject jsonObject = new JSONObject();
        Long invoiceOrderId = (Long)invoiceOrderBill.get("id");
        jsonObject.put("invoiceorderid", (Object)invoiceOrderId);
        jsonObject.put("invoiceamount", (Object)invoiceOrderBill.getBigDecimal("settleamountwithtax"));
        jsonObject.put("InvoiceType", (Object)invoiceOrderBill.getString("invoicetype"));
        jsonObject.put("firmname", (Object)invoiceOrderBill.getString("expcommitcomnum.ffirmname"));
        jsonObject.put("taxregnum", (Object)invoiceOrderBill.getString("expcommitcomnum.ftaxregnum"));
        jsonObject.put("address", (Object)invoiceOrderBill.getString("expcommitcomnum.faddress"));
        jsonObject.put("phone", (Object)invoiceOrderBill.getString("expcommitcomnum.phone"));
        jsonObject.put("depositbank", (Object)invoiceOrderBill.getString("expcommitcomnum.depositbank"));
        jsonObject.put("bankaccount", (Object)invoiceOrderBill.getString("expcommitcomnum.bankaccount"));
        jsonObject.put("servicetype", (Object)this.convertServiceitem(invoiceOrderBill.getString("serviceitem")));
        QFilter queryOrderFilter = new QFilter("invoiceid", "=", (Object)invoiceOrderId);
        DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"er_invoicesettle_rel", (String)"settleid", (QFilter[])new QFilter[]{queryOrderFilter});
        ArrayList<String> settleIds = new ArrayList<String>();
        for (DynamicObject orderBill : orderBills) {
            Long orderNum = orderBill.getLong("settleid");
            settleIds.add(orderNum.toString());
        }
        QFilter queryCheckingBillFilter = new QFilter("checkingid", "in", settleIds);
        DynamicObjectCollection checkingBills = QueryServiceHelper.query((String)"er_allcheckingbill", (String)"checkingbillnum,ordernum", (QFilter[])new QFilter[]{queryCheckingBillFilter});
        ArrayListMultimap settlementMap = ArrayListMultimap.create();
        for (DynamicObject checkingBill : checkingBills) {
            String checkingBillNum = checkingBill.getString("checkingbillnum");
            String orderNum = checkingBill.getString("ordernum");
            settlementMap.put((Object)checkingBillNum, (Object)orderNum);
        }
        ArrayList settlementBills = Lists.newArrayListWithExpectedSize((int)settlementMap.size());
        for (String key : settlementMap.keySet()) {
            HashMap<String, Object> settlementBill = new HashMap<String, Object>();
            settlementBill.put("settlementbillnum", key);
            ArrayList checkBills = Lists.newArrayListWithExpectedSize((int)settlementMap.get((Object)key).size());
            for (String orderNum : settlementMap.get((Object)key)) {
                checkBills.add(orderNum);
            }
            settlementBill.put("checkbills", checkBills);
            settlementBills.add(settlementBill);
        }
        jsonObject.put("settlementbills", (Object)settlementBills);
        this.handleInvoiceSendExtDataConvert(invoiceOrderBill, jsonObject);
        return jsonObject;
    }

    protected String batPushProcess(Object t) {
        return this.process(t);
    }

    private String process(Object invoiceOrderDatas) {
        JSONObject jsonObject = (JSONObject)invoiceOrderDatas;
        JSONArray invoices = jsonObject.getJSONArray("invoices");
        String code = this.submitInvoiceRequest(invoices);
        this.updateInvoiceBillStatus(invoices, code);
        return code;
    }

    private String submitInvoiceRequest(JSONArray invoices) {
        Map<String, String> zteLoginInfo = TripCommonUtil.getTripServiceInfo(this.supplier());
        String kingdeeUserName = zteLoginInfo.get("appkey");
        String kingdeeUserKey = zteLoginInfo.get("appsecurity");
        String currentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String password = CommonServiceHelper.getMD5(kingdeeUserName + "invoice.syncinvoice" + kingdeeUserKey + currentTime).toUpperCase();
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("userName", (Object)kingdeeUserName);
        jsonParam.put("currentTime", (Object)currentTime);
        jsonParam.put("password", (Object)password);
        jsonParam.put("format", (Object)"json");
        jsonParam.put("method", (Object)"invoice.syncinvoice");
        String paramStr = invoices.toJSONString();
        jsonParam.put("data", (Object)paramStr);
        String beeUrl = zteLoginInfo.get("reservedfield1");
        this.tripSyncLogParam.setRequestdata(jsonParam);
        this.tripSyncLogParam.setRequesturl(beeUrl);
        JSONObject retJson = HttpRetryServiceHelper.httpPost(beeUrl, jsonParam, 20000);
        this.tripSyncLogParam.setResponsedata(retJson);
        String code = "200";
        String rtnCode = retJson.getString("code");
        if (code.equals(rtnCode)) {
            this.errorSet = null;
        } else {
            JSONObject dataJson = retJson.getJSONObject("data");
            if (dataJson != null && dataJson.size() > 0) {
                this.errorSet = dataJson.keySet();
                if (this.errorSet != null && this.errorSet.size() > 0) {
                    code = "300";
                    logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u53d1\u7968\u5f00\u5177,\u5f00\u7968\u5931\u8d25\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)dataJson));
                }
            }
        }
        return code;
    }

    private void updateInvoiceBillStatus(JSONArray invoices, String code) {
        int length = invoices.size();
        HashSet invoiceOrderIds = Sets.newHashSetWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            JSONObject invoiceObject = invoices.getJSONObject(i);
            Long id = 0L;
            String invoiceorderid = invoiceObject.getString("invoiceorderid");
            if (StringUtils.isNotEmpty((CharSequence)invoiceorderid)) {
                id = Long.valueOf(invoiceorderid);
            }
            invoiceOrderIds.add(id);
        }
        DynamicObject[] invoiceOrders = BusinessDataServiceHelper.load((String)"er_invoiceorderbill", (String)"invoicestatus, invoicestatustime", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceOrderIds)});
        Map<Long, DynamicObject> invoiceOrderMap = Arrays.stream(invoiceOrders).collect(Collectors.toMap(v -> (Long)v.getPkValue(), v -> v));
        if (invoiceOrderMap == null || invoiceOrderMap.size() < 1) {
            return;
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            JSONObject invoiceObject = invoices.getJSONObject(i);
            String invoiceorderid = invoiceObject.getString("invoiceorderid");
            String invoicestatus = code.equals("200") ? "2" : "5";
            DynamicObject invoiceOrder = invoiceOrderMap.get(Long.valueOf(invoiceorderid));
            invoiceOrder.set("invoicestatus", (Object)invoicestatus);
            invoiceOrder.set("invoicestatustime", (Object)new Date());
            resultList.add(invoiceOrder);
        }
        SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]));
    }

    private String convertServiceitem(String serviceItem) {
        return serviceitemMap.get(serviceItem);
    }

    static {
        serviceitemMap.put("\u7968\u4ef7", "2");
        serviceitemMap.put("\u673a\u7968\u884c\u7a0b\u5355", "0");
        serviceitemMap.put("\u884c\u7a0b\u5355-\u9000\u7968\u8d39", "1");
        serviceitemMap.put("\u4fdd\u9669\u8d39", "4");
        serviceitemMap.put("\u670d\u52a1\u8d39", "3");
    }
}

