/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimUpdateOrderEntrysUtil;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.service.function.AbstractOrderInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripCarOrderConvert;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripHotelOrderConvert;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripPlaneOrderConvert;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripTrainOrderConvert;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripOrderInvoke
extends AbstractOrderInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(ETripOrderInvoke.class);

    public ETripOrderInvoke() {
    }

    public ETripOrderInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.name();
    }

    protected JSONObject process(Map params) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,\u63a5\u6536\u6570\u636e\u5165\u53c2:" + params.toString());
        this.tripSyncLogParam.setResponsedata(params);
        JSONObject json = new JSONObject();
        json.put("method", params.get("method"));
        json.put("data", JSONArray.parse((String)((String)params.get("data"))));
        return json;
    }

    protected Object convert(Object json) throws TripException {
        JSONObject t = (JSONObject)json;
        JSONArray billArray = t.getJSONArray("data");
        int length = billArray.size();
        ArrayList<AbstractOrderModel> details = new ArrayList<AbstractOrderModel>();
        switch (t.getString("method")) {
            case "hotel.syncorder": {
                try {
                    for (int i = 0; i < length; ++i) {
                        JSONObject orderJson = billArray.getJSONObject(i);
                        details.addAll(ETripHotelOrderConvert.convert(orderJson));
                        HotelOrderModel orderModel = (HotelOrderModel)details.get(i);
                        this.handleHotelOrderExtCovert(orderModel, orderJson);
                    }
                    break;
                }
                catch (CloneNotSupportedException e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,CloneNotSupportedException:", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            case "domair.syncorder": 
            case "intair.syncorder": {
                for (int i = 0; i < length; ++i) {
                    JSONObject orderJson = billArray.getJSONObject(i);
                    details.addAll(ETripPlaneOrderConvert.convert(orderJson));
                    PlaneOrderModel orderModel = (PlaneOrderModel)details.get(i);
                    this.handlePlaneOrderExtCovert(orderModel, orderJson);
                }
                break;
            }
            case "train.syncorder": {
                for (int i = 0; i < length; ++i) {
                    JSONObject orderJson = billArray.getJSONObject(i);
                    details.addAll(ETripTrainOrderConvert.convert(orderJson));
                    TrainOrderModel orderModel = (TrainOrderModel)details.get(i);
                    this.handleTrainOrderExtCovert(orderModel, orderJson);
                }
                break;
            }
            case "car.syncorder": {
                for (int i = 0; i < length; ++i) {
                    JSONObject orderJson = billArray.getJSONObject(i);
                    details.addAll(ETripCarOrderConvert.convert(orderJson));
                    VehicleOrderModel orderModel = (VehicleOrderModel)details.get(i);
                    this.handleCarOrderExtCovert(orderModel, orderJson);
                }
                break;
            }
            case "domair.syncticketinfo": {
                this.updateTickitInfo(t);
                return null;
            }
        }
        return details;
    }

    private void updateTickitInfo(JSONObject json) {
        DynamicObject[] planeCheckingDyms;
        DynamicObject[] tickitsDyms;
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,\u540c\u6b65\u673a\u7968\u8ba2\u5355\u4f7f\u7528\u72b6\u6001");
        JSONArray data = json.getJSONArray("data");
        HashMap tickits = new HashMap();
        data.forEach(e -> {
            JSONObject tickit = (JSONObject)e;
            tickits.put(tickit.getString("orderNum"), tickit);
        });
        DynamicObject[] tickitsDymids = BusinessDataServiceHelper.load((String)"er_planebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("orderNum", "in", tickits.keySet())});
        Set ids = Stream.of(tickitsDymids).map(v -> v.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject tickitsDym : tickitsDyms = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_planebill"))) {
            JSONObject tickit = (JSONObject)tickits.get(tickitsDym.getString("orderNum"));
            String ticketStatus = tickit.getString("ticketStatus");
            tickitsDym.set("ticketstatus", (Object)ticketStatus);
        }
        SaveServiceHelper.save((DynamicObject[])tickitsDyms);
        TripReimUpdateOrderEntrysUtil.updateOrderEntrys(tickitsDyms);
        for (DynamicObject planeCheckingDym : planeCheckingDyms = BusinessDataServiceHelper.load((String)"er_planecheckingbill", (String)"id,orderNum,ticketstatus,itinerarynum,itinerarydate,downloadlink", (QFilter[])new QFilter[]{new QFilter("orderNum", "in", tickits.keySet())})) {
            String orderNum = planeCheckingDym.getString("orderNum");
            JSONObject tickit = (JSONObject)tickits.get(orderNum);
            String ticketStatus = tickit.getString("ticketStatus");
            String handleRouteNum = tickit.getString("handleRouteNum");
            String handleRoutePrintDate = tickit.getString("handleRoutePrintDate");
            String handleRoutePath = tickit.getString("handleRoutePath");
            planeCheckingDym.set("ticketstatus", (Object)ticketStatus);
            planeCheckingDym.set("itinerarynum", (Object)handleRouteNum);
            planeCheckingDym.set("itinerarydate", (Object)TripCommonUtil.convertToDate(handleRoutePrintDate));
            planeCheckingDym.set("downloadlink", (Object)handleRoutePath);
            logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,\u673a\u7968\u8ba2\u5355\u6539\u53d8\u66f4\u65b0\u7ed3\u7b97\u5355,orderNum:" + orderNum + ",ticketStatus:" + ticketStatus + ",handleRouteNum:" + handleRouteNum + ",handleRoutePrintDate:" + handleRoutePrintDate + ",handleRoutePath:" + handleRoutePath);
        }
        SaveServiceHelper.save((DynamicObject[])planeCheckingDyms);
    }
}

