/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripPlaneCheckingDetailConvert {
    private static final Log logger = LogFactory.getLog(ETripPlaneCheckingDetailConvert.class);

    public static List<AbstractCheckingBillDetailModel> convert(JSONObject planeJson) {
        ArrayList<AbstractCheckingBillDetailModel> details = new ArrayList<AbstractCheckingBillDetailModel>();
        PlaneCheckingBillDetailModel detail = new PlaneCheckingBillDetailModel();
        if ("30000".equals(planeJson.getString("orderStatus"))) {
            return details;
        }
        detail.setOaBillNum(planeJson.getString("oaBillNum"));
        detail.setOrderNum(planeJson.getString("orderNum"));
        detail.setServer(Supplier.ZHONGXING.name());
        detail.setOrderDate(TripCommonUtil.convertToDate(planeJson.getString("orderDate")));
        detail.setTotalAmount(planeJson.getBigDecimal("totalAmount"));
        String periodStartStr = planeJson.getString("periodStartDate");
        Date periodStartDate = TripCommonUtil.convertToDate(periodStartStr);
        detail.setBillPeriod(periodStartDate);
        detail.setHappendDate(periodStartDate);
        detail.setBatchno(planeJson.getString("batchno"));
        detail.setOrderNatrue(ETripPlaneCheckingDetailConvert.setOrderNatrue(planeJson.getString("errandType")));
        detail.setProductType(ETripPlaneCheckingDetailConvert.setProductType(planeJson.getString("paymentType")));
        detail.setSourceBookedId(planeJson.getString("sourceBookedId"));
        detail.setOrderStatus(ETripPlaneCheckingDetailConvert.setOrderStatus(planeJson.getString("orderStatus")));
        detail.setOrderType(ETripPlaneCheckingDetailConvert.setOrderType(planeJson.getString("orderType")));
        detail.setParentordernum(planeJson.getString("parentOrderNum"));
        Object settleMain = planeJson.get((Object)"settleMain");
        if (settleMain != null && !settleMain.toString().equals("")) {
            detail.setSettlemain(planeJson.getString("settleMain"));
        }
        detail.setTicketNum(planeJson.getString("ticketNum"));
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u7ed3\u7b97\u5355,CTripPlaneCheckingDetailConvert getItinerarynum" + planeJson.getString("ticketNum"));
        JSONArray flightInfos = planeJson.getJSONArray("flightInfos");
        JSONObject flightInfo = flightInfos.getJSONObject(0);
        detail.setFlightNo(flightInfo.getString("flightNo"));
        detail.setFromCityName(flightInfo.getString("fromCityName"));
        detail.setToCityName(flightInfo.getString("toCityName"));
        detail.setBookedname(planeJson.getString("bookedName"));
        detail.setTravelername(planeJson.getString("travelerName"));
        detail.setSourceTravelerId(planeJson.getString("sourceTravelerId"));
        BigDecimal ticketPrice = planeJson.getBigDecimal("ticketPrice");
        detail.setTicketPrice(ticketPrice);
        detail.setDiscount(planeJson.getBigDecimal("discount"));
        detail.setAirportPrice(planeJson.getBigDecimal("airportPrice"));
        detail.setAirlineName(flightInfo.getString("airlineName"));
        if (planeJson.getBigDecimal("tax") != null) {
            detail.setAirportPrice(planeJson.getBigDecimal("tax"));
            detail.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.B);
            detail.setParentordernum(planeJson.getString("demandOrderNum"));
            detail.setOperationType(AbstractOrderModel.OperationType.D);
        } else {
            detail.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.A);
            detail.setOperationType(AbstractOrderModel.OperationType.B);
        }
        detail.setFuelPrice(planeJson.getBigDecimal("fuelPrice"));
        detail.setRefundAmount(planeJson.getBigDecimal("refundAmount"));
        detail.setAssuranceAmount(planeJson.getBigDecimal("assuranceAmount"));
        detail.setServiceFee(planeJson.getBigDecimal("serviceFee"));
        detail.setCabin(flightInfo.getString("cabin"));
        detail.setCabinClass(flightInfo.getString("cabinClass"));
        detail.setTakeOffTime(TripCommonUtil.convertToDate(flightInfo.getString("takeoffTime")));
        detail.setLandingtime(TripCommonUtil.convertToDate(flightInfo.getString("landingTime")));
        detail.setItinerarynum(planeJson.getString("handleRouteNum"));
        if (planeJson.getString("handleRoutePrintDate") != null) {
            detail.setItinerarydate(TripCommonUtil.convertToDate(planeJson.getString("handleRoutePrintDate")));
        }
        detail.setTicketstatus(planeJson.getString("ticketStatus"));
        detail.setDownloadlink(planeJson.getString("handleRoutePath"));
        BigDecimal lowestPirce = planeJson.getBigDecimal("lowestPrice");
        detail.setLowestPirce(lowestPirce);
        if (lowestPirce != null && ticketPrice != null) {
            String islowestPirce = ticketPrice.compareTo(lowestPirce) <= 0 ? "1" : "0";
            detail.setIsLowestPirce(islowestPirce);
        }
        details.add(detail);
        return details;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String orderNatrue) {
        if ("1".equals(orderNatrue)) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static PlaneOrderModel.OrderStatus setOrderStatus(String string) {
        switch (string) {
            case "40000": {
                return PlaneOrderModel.OrderStatus.A;
            }
            case "50301": {
                return PlaneOrderModel.OrderStatus.B;
            }
            case "50302": {
                return PlaneOrderModel.OrderStatus.C;
            }
            case "50201": {
                return PlaneOrderModel.OrderStatus.D;
            }
            case "50202": {
                return PlaneOrderModel.OrderStatus.E;
            }
            case "10000": {
                return PlaneOrderModel.OrderStatus.F;
            }
            case "20000": {
                return PlaneOrderModel.OrderStatus.G;
            }
            case "40100": {
                return PlaneOrderModel.OrderStatus.H;
            }
            case "50203": {
                return PlaneOrderModel.OrderStatus.I;
            }
        }
        return PlaneOrderModel.OrderStatus.A;
    }

    private static AbstractOrderModel.OrderType setOrderType(String orderType) {
        if ("O".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.O;
        }
        if ("T".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.T;
        }
        return AbstractOrderModel.OrderType.G;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("1".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }
}

