/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripPlaneOrderConvert {
    private static final Log logger = LogFactory.getLog(ETripPlaneOrderConvert.class);

    public static List<AbstractOrderModel> convert(JSONObject orderJson) {
        JSONArray flighInfos;
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,CTripPlaneOrderConvert:" + orderJson.toJSONString());
        ArrayList orderModels = Lists.newArrayListWithExpectedSize((int)4);
        PlaneOrderModel planeOrderModel = new PlaneOrderModel();
        planeOrderModel.setAssuranceAmount(orderJson.getBigDecimal("assuranceAmount"));
        planeOrderModel.setChangeReason(orderJson.getString("changeReason"));
        planeOrderModel.setChooseNotMinReason(orderJson.getString("chooseNotMinReason"));
        planeOrderModel.setDiscount(orderJson.getBigDecimal("discount"));
        planeOrderModel.setEndorsementAmount(orderJson.getBigDecimal("endorsementAmount"));
        planeOrderModel.setFuelPrice(orderJson.getBigDecimal("fuelPrice"));
        planeOrderModel.setHappendDate(TripCommonUtil.convertToDate(orderJson.getString("happendDate")));
        planeOrderModel.setOaBillNum(orderJson.getString("oaBillNum"));
        planeOrderModel.setOrderDate(TripCommonUtil.convertToDate(orderJson.getString("orderDate")));
        planeOrderModel.setOrderNum(orderJson.getString("orderNum"));
        planeOrderModel.setOrderStatus(ETripPlaneOrderConvert.setOrderStatus(orderJson.getString("orderStatus")));
        planeOrderModel.setOrderType(ETripPlaneOrderConvert.setOrderType(orderJson.getString("orderType")));
        planeOrderModel.setAirportPrice(orderJson.getBigDecimal("airportPrice"));
        planeOrderModel.setOriOrderNum(orderJson.getString("oriOrderNum"));
        planeOrderModel.setOverflag(orderJson.getString("overFlag"));
        planeOrderModel.setParentOrderNum(orderJson.getString("parentOrderNum"));
        planeOrderModel.setPnr(orderJson.getString("pnr"));
        planeOrderModel.setRefundAmount(orderJson.getBigDecimal("refundAmount"));
        planeOrderModel.setRefundReason(orderJson.getString("refundReason"));
        planeOrderModel.setServiceFee(orderJson.getBigDecimal("serviceFee"));
        planeOrderModel.setSourceBookedId(orderJson.getString("sourceBookedId"));
        planeOrderModel.setSourcetravelerid(orderJson.getString("sourceTravelerId"));
        planeOrderModel.setStandPrice(orderJson.getBigDecimal("standPrice"));
        planeOrderModel.setTicketNum(orderJson.getString("ticketNum"));
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,CTripPlaneOrderConvert getItinerarynum" + orderJson.getString("ticketNum"));
        BigDecimal ticketPrice = orderJson.getBigDecimal("ticketPrice");
        planeOrderModel.setTicketPrice(ticketPrice);
        planeOrderModel.setTotalAmount(orderJson.getBigDecimal("totalAmount"));
        planeOrderModel.setBookedname(orderJson.getString("bookedName"));
        planeOrderModel.setTravelername(orderJson.getString("travelerName"));
        planeOrderModel.setOrderNatrue(ETripPlaneOrderConvert.setOrderNatrue(orderJson.getString("errandType")));
        planeOrderModel.setProductType(ETripPlaneOrderConvert.setProductType(orderJson.getString("paymentType")));
        planeOrderModel.setServer(Supplier.ZHONGXING.name());
        if (orderJson.getBigDecimal("tax") != null) {
            planeOrderModel.setAirportPrice(orderJson.getBigDecimal("tax"));
            planeOrderModel.setOrderSort(AbstractOrderModel.OrderSort.B);
            planeOrderModel.setParentOrderNum(orderJson.getString("demandOrderNum"));
            planeOrderModel.setOperationType(AbstractOrderModel.OperationType.D);
            planeOrderModel.setTicketStatus(PlaneOrderModel.TicketStatus.A);
        } else {
            planeOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
            planeOrderModel.setOperationType(AbstractOrderModel.OperationType.B);
        }
        if (AbstractOrderModel.OrderType.T == planeOrderModel.getOrderType()) {
            planeOrderModel.setAirportPrice(planeOrderModel.getAirportPrice().negate());
        }
        if ((flighInfos = orderJson.getJSONArray("flightInfos")) != null && flighInfos.size() > 0) {
            JSONObject flighInfo = flighInfos.getJSONObject(0);
            planeOrderModel.setAirline(flighInfo.getString("airline"));
            planeOrderModel.setAirlineName(flighInfo.getString("airlineName"));
            planeOrderModel.setCabin(flighInfo.getString("cabin"));
            planeOrderModel.setCabinClass(flighInfo.getString("cabinClass"));
            planeOrderModel.setFlightNo(flighInfo.getString("flightNo"));
            planeOrderModel.setFromCity(flighInfo.getString("fromCity"));
            planeOrderModel.setFromCityName(flighInfo.getString("fromCityName"));
            planeOrderModel.setLandingPort(flighInfo.getString("landingPort"));
            planeOrderModel.setLandingPortName(flighInfo.getString("landingPortName"));
            planeOrderModel.setLandingTime(TripCommonUtil.convertToDate(flighInfo.getString("landingTime")));
            planeOrderModel.setTakeoffPort(flighInfo.getString("takeoffPort"));
            planeOrderModel.setTakeoffPortName(flighInfo.getString("takeoffPortName"));
            planeOrderModel.setTakeoffTime(TripCommonUtil.convertToDate(flighInfo.getString("takeoffTime")));
            planeOrderModel.setToCity(flighInfo.getString("toCity"));
            planeOrderModel.setToCityName(flighInfo.getString("toCityName"));
        }
        planeOrderModel.setItinerarynum(orderJson.getString("handleRouteNum"));
        if (orderJson.getString("handleRoutePrintDate") != null) {
            planeOrderModel.setItinerarydate(TripCommonUtil.convertToDate(orderJson.getString("handleRoutePrintDate")));
        }
        planeOrderModel.setDownloadlink(orderJson.getString("handleRoutePath"));
        BigDecimal lowestPirce = orderJson.getBigDecimal("lowestPrice");
        planeOrderModel.setLowestPirce(lowestPirce);
        if (lowestPirce != null && ticketPrice != null) {
            String islowestPirce = ticketPrice.compareTo(lowestPirce) <= 0 ? "1" : "0";
            planeOrderModel.setIsLowestPirce(islowestPirce);
        }
        orderModels.add(planeOrderModel);
        return orderModels;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String orderNatrue) {
        if ("1".equals(orderNatrue)) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static PlaneOrderModel.OrderStatus setOrderStatus(String string) {
        switch (string) {
            case "40000": 
            case "103020": {
                return PlaneOrderModel.OrderStatus.A;
            }
            case "50301": 
            case "105010": 
            case "105021": 
            case "105030": {
                return PlaneOrderModel.OrderStatus.B;
            }
            case "50302": 
            case "105020": {
                return PlaneOrderModel.OrderStatus.C;
            }
            case "50201": 
            case "106010": 
            case "106020": 
            case "104010": 
            case "106030": {
                return PlaneOrderModel.OrderStatus.D;
            }
            case "50202": 
            case "106021": 
            case "104020": 
            case "106040": {
                return PlaneOrderModel.OrderStatus.E;
            }
            case "10000": {
                return PlaneOrderModel.OrderStatus.F;
            }
            case "20000": {
                return PlaneOrderModel.OrderStatus.G;
            }
            case "40100": 
            case "100000": 
            case "101000": 
            case "101010": 
            case "101011": 
            case "101020": 
            case "101030": 
            case "102010": 
            case "102020": 
            case "102030": 
            case "102040": 
            case "103010": {
                return PlaneOrderModel.OrderStatus.H;
            }
            case "50203": {
                return PlaneOrderModel.OrderStatus.I;
            }
            case "30000": {
                return PlaneOrderModel.OrderStatus.L;
            }
        }
        return PlaneOrderModel.OrderStatus.A;
    }

    private static AbstractOrderModel.OrderType setOrderType(String orderType) {
        if ("O".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.O;
        }
        if ("T".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.T;
        }
        return AbstractOrderModel.OrderType.G;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("1".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }
}

