/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.TrainOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.systemexternal.ETripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripTrainOrderConvert {
    private static final Log logger = LogFactory.getLog(ETripTrainOrderConvert.class);

    public static List<AbstractOrderModel> convert(JSONObject orderJson) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355:" + orderJson.toJSONString());
        ArrayList orderModels = Lists.newArrayListWithExpectedSize((int)4);
        TrainOrderModel trainOrderModel = new TrainOrderModel();
        trainOrderModel.setArriveTime(TripCommonUtil.convertToDate(orderJson.getString("arriveDate")));
        trainOrderModel.setSourceBookedId(orderJson.getString("sourceBookedId"));
        trainOrderModel.setBookedname(orderJson.getString("bookedName"));
        trainOrderModel.setOrderNatrue(ETripPropMapping.setOrderNatrue(orderJson.getString("errandType")));
        trainOrderModel.setDepartAddress(orderJson.getString("fromStation"));
        trainOrderModel.setDepartCity(orderJson.getString("fromCity"));
        trainOrderModel.setHappendDate(TripCommonUtil.convertToDate(orderJson.getString("happendDate")));
        trainOrderModel.setModifyTime(TripCommonUtil.convertToDate(orderJson.getString("lastUpdateDate")));
        trainOrderModel.setOaBillNum(orderJson.getString("oaBillNum"));
        trainOrderModel.setOrderDate(TripCommonUtil.convertToDate(orderJson.getString("orderDate")));
        trainOrderModel.setOrderNum(orderJson.getString("orderNum"));
        trainOrderModel.setOrderStatus(ETripPropMapping.setOrderStatus(orderJson.getString("orderStatus")));
        trainOrderModel.setOrderType(ETripPropMapping.setOrderType(orderJson.getString("orderType")));
        trainOrderModel.setOriOrderNum(orderJson.getString("oriOrderNum"));
        trainOrderModel.setParentOrderNum(orderJson.getString("parentOrderNum"));
        trainOrderModel.setRefundamount(orderJson.getBigDecimal("refundAmount"));
        trainOrderModel.setTrainseat(ETripPropMapping.setTrainseat(orderJson.getString("seatType")));
        trainOrderModel.setServiceFee(orderJson.getBigDecimal("serviceFee"));
        trainOrderModel.setDepartTime(TripCommonUtil.convertToDate(orderJson.getString("startDate")));
        trainOrderModel.setTicketPrice(orderJson.getBigDecimal("ticketPrice"));
        trainOrderModel.setArriveAddress(orderJson.getString("toStation"));
        trainOrderModel.setArriveCity(orderJson.getString("toCity"));
        trainOrderModel.setTotalAmount(orderJson.getBigDecimal("totalAmount"));
        trainOrderModel.setVendorName(orderJson.getString("trainNumber"));
        trainOrderModel.setPasseger(orderJson.getString("sourceTravelerId"));
        trainOrderModel.setPassegername(orderJson.getString("travelerName"));
        trainOrderModel.setServer(Supplier.ZHONGXING.name());
        trainOrderModel.setProductType(ETripPropMapping.setProductType2(orderJson.getString("paymentType")));
        trainOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
        trainOrderModel.setOperationType(AbstractOrderModel.OperationType.F);
        orderModels.add(trainOrderModel);
        return orderModels;
    }
}

