/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.common;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractTripUserTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AbstractTripUserTask.class);
    public static final String SYNC_USER_KEY = "syncUser";
    public static final String SYNC_USER_BY_ORG_KEY = "syncUserByOrg";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!map.containsKey("server") || StringUtils.isBlank((CharSequence)((String)map.get("server")))) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u4eba\u5458\u8c03\u5ea6,\u5b50\u7c7b\u672a\u6307\u5b9a\u670d\u52a1\u5546");
            return;
        }
        String server = map.get("server").toString();
        Boolean isEnble = TripCommonUtil.isEnbleServer(server);
        if (!isEnble.booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u670d\u52a1\u5546{}\u672a\u542f\u7528,\u8c03\u5ea6\u4efb\u52a1\u672a\u6267\u884c", (Object)server);
            return;
        }
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        logger.info("\u5546\u65c5\u96c6\u6210,\u670d\u52a1\u5546{},\u4eba\u5458\u540c\u6b65---AbstractTripUserTask", (Object)server);
        try {
            DynamicObject bizInfo = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"syncusertype, entryentity.org, entryentity.lastsyncstamp,entryentity.entrystatus", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)server)});
            String syncusertype = bizInfo.getString("syncusertype");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("taskServer", server);
            if ("2".equals(syncusertype)) {
                Map<Long, Date> orgMap = this.getOrgLastSyncDateList(bizInfo);
                for (Map.Entry<Long, Date> entry : orgMap.entrySet()) {
                    Long orgId = entry.getKey();
                    Date modifyTime = entry.getValue();
                    params.put("modifytime", modifyTime);
                    params.put("entryentity.dpt.id", orgId);
                    this.executeFunction(params, map.get(SYNC_USER_BY_ORG_KEY).toString());
                }
            } else {
                params.put("isScheduledTask", true);
                this.executeFunction(params, map.get(SYNC_USER_KEY).toString());
            }
            logger.info("\u5546\u65c5\u96c6\u6210,\u670d\u52a1\u5546{},\u4eba\u5458\u540c\u6b65,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u6210\u529f--", (Object)server);
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u4eba\u5458\u540c\u6b65,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25:", (Throwable)e);
        }
    }

    public void executeFunction(Map<String, Object> params, String fieldMappingNumber) {
        TripCommonUtil.invoke((String)params.get("taskServer"), "bos_user", null, fieldMappingNumber, params);
    }

    private Map<Long, Date> getOrgLastSyncDateList(DynamicObject bizInfo) {
        DynamicObjectCollection collection = bizInfo.getDynamicObjectCollection("entryentity");
        HashMap orgMap = Maps.newHashMapWithExpectedSize((int)collection.size());
        Calendar cal = Calendar.getInstance();
        for (DynamicObject d : collection) {
            if ("0".equals(d.getString("entrystatus")) || d.get("org") == null) continue;
            cal.setTime(d.getDate("lastsyncstamp"));
            cal.add(5, -1);
            orgMap.put(ErCommonUtils.getPk(d.get("org")), cal.getTime());
        }
        return orgMap;
    }
}

