/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.utils.ThrowableHelper;

public class SyncCheckingExpListTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SyncCheckingExpListTask.class);
    private static String CURRENT_MONTH = SyncCheckingExpListTask.getCurrentMonth();

    private static String getCurrentMonth() {
        return ResManager.loadKDString((String)"\u5f53\u6708", (String)"SyncCheckingExpListTask_01", (String)"fi-er-business", (Object[])new Object[0]);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u90e8\u95e8\u8d39\u7528\u6e05\u5355,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5f00\u59cb.");
        try {
            DynamicObject[] dynamicObjects;
            int i;
            String periodDate = TripCommonUtil.getLastMonth();
            String period = TripSyncConfigUtil.getTripsyncSettingByKey("checking_exp_list_period");
            if (CURRENT_MONTH.equals(period)) {
                periodDate = TripCommonUtil.date2TimeStamp(new Date(), "yyyy-MM");
            }
            if (period.indexOf(45) != -1) {
                try {
                    periodDate = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(period, "yyyy-MM"), "yyyy-MM");
                }
                catch (Exception e) {
                    logger.info("\u90e8\u95e8\u8d39\u7528\u6e05\u5355,\u8c03\u5ea6\u4efb\u52a1,\u5546\u65c5\u96c6\u6210\u8bbe\u7f6e\u53c2\u6570\u5f02\u5e38\uff1a{}: {}", (Object)"checking_exp_list_period", (Object)period);
                }
            }
            QFilter qFilter = new QFilter("period", "=", (Object)TripCommonUtil.strToDate(periodDate, "yyyy-MM"));
            qFilter.and("needsend", "=", (Object)"1");
            qFilter.and("msgcount", "=", (Object)0);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_checking_exp_list", (String)"id,user", (QFilter[])new QFilter[]{qFilter});
            if (null == load || load.length == 0) {
                return;
            }
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(load.length);
            for (i = 0; i < load.length; ++i) {
                arrayList.add(load[i]);
            }
            for (i = 0; i < load.length; ++i) {
                dynamicObjects = (DynamicObject[])load[i].get("user");
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
                arrayList.remove(load[i]);
            }
            List ids = arrayList.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_checking_exp_list"));
            if (null == dynamicObjects || dynamicObjects.length == 0) {
                return;
            }
            try {
                ErMessageServiceHelper.sendMsgOfcheckingExpList(dynamicObjects, "er_checking_exp_list");
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u90e8\u95e8\u8d39\u7528\u6e05\u5355,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25:{}", (Object)ThrowableHelper.toString((Exception)e));
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u90e8\u95e8\u8d39\u7528\u6e05\u5355,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25:{}", (Object)ThrowableHelper.toString((Exception)e));
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u4e2d\u7684\u90e8\u95e8\u8d39\u7528\u6e05\u5355,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002");
    }
}

