/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class SyncDailyVehicleBillToTripTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SyncDailyVehicleBillToTripTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u4e2d\u5931\u8d25\u7684\u7528\u8f66\u7533\u8bf7\u5355\u518d\u6b21\u540c\u6b65,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5f00\u59cb.");
        try {
            QFilter qFilter = new QFilter("function", "=", (Object)"dailyVehicleBillInvoke");
            qFilter.and("status", "=", (Object)"B");
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"er_tripsync_log", (String)"server, billid", (QFilter[])new QFilter[]{qFilter});
            if (rows == null || rows.size() < 1) {
                return;
            }
            Map params = rows.stream().filter(row -> StringUtils.isNotBlank((CharSequence)row.getString("billid")) && StringUtils.isNotBlank((CharSequence)row.getString("server"))).collect(Collectors.groupingBy(row -> row.getString("server"), Collectors.mapping(row -> row.getString("billid"), Collectors.toList())));
            for (Map.Entry param : params.entrySet()) {
                String server = param.getKey();
                List<Object> billids = param.getValue();
                String tripServiceName = TripCommonUtil.getStandtripname().get(server);
                ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
                billids.forEach(billid -> iTripService.synDilyVehicleToTrip(billid, "1"));
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u4e2d\u5931\u8d25\u7684\u7528\u8f66\u7533\u8bf7\u5355\u518d\u6b21\u540c\u6b65,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25:", (Throwable)e);
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u4e2d\u5931\u8d25\u7684\u7528\u8f66\u7533\u8bf7\u5355\u518d\u6b21\u540c\u6b65,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u7ed3\u675f.");
    }
}

