/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.common;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.utils.ThrowableHelper;

public class TripsyncLogTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(TripsyncLogTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5f00\u59cb.");
        try {
            QFilter qC;
            String numbers = TripSyncConfigUtil.getTripsyncSettingByKey("trip_log_error_msg");
            if (null == numbers || numbers.isEmpty()) {
                return;
            }
            String[] numberArr = numbers.split(",");
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", Arrays.stream(numberArr).collect(Collectors.toList()))});
            if (null == dynamicObjectMap || dynamicObjectMap.isEmpty()) {
                return;
            }
            List<Long> userIds = dynamicObjectMap.values().stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            QFilter qA = new QFilter("status", "=", (Object)"B");
            Date date = new Date();
            QFilter qB = new QFilter("synctime", ">=", (Object)TripCommonUtil.addDayByDate(date, -1));
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"er_tripsync_log", (String)"server", (QFilter[])new QFilter[]{qA, qB, qC = new QFilter("synctime", "<=", (Object)date)});
            if (null == dynamicObjectCollection || dynamicObjectCollection.isEmpty()) {
                return;
            }
            try {
                ErMessageServiceHelper.sendMsgById(userIds, "er_tripsync_log");
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25:{}", (Object)ThrowableHelper.toString((Exception)e));
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25:{}", (Object)ThrowableHelper.toString((Exception)e));
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u96c6\u6210\u65e5\u5fd7\u4e2d\u7684\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002");
    }
}

