/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CTripHotelUtil {
    public static void handleHotelJson(JSONArray detailCheckingBill) {
        ArrayList dataList = Lists.newArrayListWithCapacity((int)detailCheckingBill.size());
        HashMap sortMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, List<Object>> orderIdMap = detailCheckingBill.stream().collect(Collectors.groupingBy(obj -> ((JSONObject)obj).getJSONObject("SettlementDetail").getString("OrderID")));
        for (Map.Entry<String, List<Object>> entry : orderIdMap.entrySet()) {
            int i;
            List<Object> orderList = entry.getValue();
            if (CollectionUtils.isEmpty(orderList)) continue;
            Object o = orderList.get(0);
            JSONObject settlementInfoDetailObject = (JSONObject)o;
            JSONObject orderDetailObject = settlementInfoDetailObject.getJSONObject("OrderDetail");
            orderDetailObject = orderDetailObject == null ? new JSONObject() : orderDetailObject;
            JSONArray travelers = orderDetailObject.getJSONArray("ClientDetailList");
            travelers = travelers == null ? new JSONArray() : travelers;
            for (i = 0; i < travelers.size(); ++i) {
                String tmpEmployeeID = CTripHotelUtil.getEmployeeID(travelers, i);
                dataList.add(tmpEmployeeID);
                sortMap.put(tmpEmployeeID, i);
            }
            for (i = 1; i < orderList.size(); ++i) {
                Object otherObject = orderList.get(i);
                JSONObject otherSettlementInfoDetailObject = (JSONObject)otherObject;
                JSONObject otherOrderDetailObject = otherSettlementInfoDetailObject.getJSONObject("OrderDetail");
                otherOrderDetailObject = otherOrderDetailObject == null ? new JSONObject() : otherOrderDetailObject;
                JSONArray otherTravelers = otherOrderDetailObject.getJSONArray("ClientDetailList");
                otherTravelers = otherTravelers == null ? new JSONArray() : otherTravelers;
                ArrayList tmpList = Lists.newArrayListWithCapacity((int)otherTravelers.size());
                for (int z = 0; z < otherTravelers.size(); ++z) {
                    tmpList.add(CTripHotelUtil.getEmployeeID(otherTravelers, z));
                }
                boolean equals = String.join((CharSequence)"", tmpList).equals(String.join((CharSequence)"", dataList));
                if (equals) continue;
                CTripHotelUtil.dealDiffOrder(sortMap, otherOrderDetailObject, otherTravelers);
            }
        }
    }

    private static void dealDiffOrder(Map<String, Integer> sortMap, JSONObject orderDetailObject, JSONArray travelers) {
        TreeMap innerSortMap = Maps.newTreeMap();
        JSONArray finalTravelers = new JSONArray();
        for (int i = 0; i < travelers.size(); ++i) {
            JSONObject traveler = travelers.getJSONObject(i);
            Integer index = sortMap.get(CTripHotelUtil.getEmployeeID(travelers, i));
            if (index == null) continue;
            innerSortMap.put(index, traveler);
        }
        if (!innerSortMap.isEmpty()) {
            Set entries = innerSortMap.entrySet();
            for (Map.Entry entry : entries) {
                finalTravelers.add(entry.getValue());
            }
            orderDetailObject.remove((Object)"ClientDetailList");
            orderDetailObject.put("ClientDetailList", (Object)finalTravelers);
        }
    }

    public static String getEmployeeID(JSONArray travelers, int i) {
        JSONObject traveler = travelers.getJSONObject(i);
        if (null == traveler) {
            return "";
        }
        return (String)traveler.getOrDefault((Object)"EmployeeID", (Object)"");
    }

    public static Integer dealInvoiceType(JSONObject hotelObject) {
        String isHasSpecialInvoice = (String)hotelObject.getOrDefault((Object)"IsHasSpecialInvoice", (Object)"");
        if (StringUtils.isEmpty((CharSequence)isHasSpecialInvoice)) {
            return 9999;
        }
        switch (isHasSpecialInvoice) {
            case "T": {
                return 2;
            }
            case "F": {
                return 1;
            }
        }
        return 9999;
    }
}

