/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class TripCityUtil {
    private static Log logger = LogFactory.getLog(TripCityUtil.class);
    private static int eachLen = 1000000;

    @Deprecated
    public static List<DynamicObject> getDynamicObjects(JSONArray cropCityJsonArrays) {
        ArrayList<DynamicObject> cityDynamicObjectList = new ArrayList<DynamicObject>();
        String setectProperties = "id,nameen,admindivisionid.country.name,admindivisionid.fullspell,code,cityID,namePinyin";
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_city", (String)setectProperties, (QFilter[])new QFilter[0]);
        for (int i = 0; i < cropCityJsonArrays.size(); ++i) {
            JSONObject cropCityJsonArray = (JSONObject)cropCityJsonArrays.get(i);
            String name_En = cropCityJsonArray.getString("name_En");
            String countryName = cropCityJsonArray.getString("countryName");
            String code = cropCityJsonArray.getString("code");
            Integer cityid = cropCityJsonArray.getInteger("cityID");
            String namepinyin = cropCityJsonArray.getString("namePinyin");
            String name = cropCityJsonArray.getString("name");
            String name_EnStr = name_En.replaceAll("[\\pP\\p{Punct}]", "");
            for (DynamicObject value : objectDynamicObjectMap.values()) {
                if (value.getString("admindivisionid.fullspell") == null || value.getString("admindivisionid.country.name") == null || value.getString("admindivisionid.name") == null || !value.getString("admindivisionid.fullspell").equalsIgnoreCase(name_EnStr) || !value.getString("admindivisionid.country.name").equalsIgnoreCase(countryName) || !value.getString("admindivisionid.name").equalsIgnoreCase(name)) continue;
                value.set("code", (Object)code);
                value.set("cityid", (Object)cityid);
                value.set("namepinyin", (Object)namepinyin);
                cityDynamicObjectList.add(value);
            }
        }
        return cityDynamicObjectList;
    }

    public static void saveTripCityData(List<DynamicObject> cityDynamicObjectList) {
        try {
            if (cityDynamicObjectList != null && cityDynamicObjectList.size() > 0) {
                int tmpEachLen = eachLen;
                int parSize = cityDynamicObjectList.size() >= tmpEachLen ? tmpEachLen : 1000;
                Map<Integer, List<DynamicObject>> cityDynamicObjectMaps = TripCityUtil.groupPostDataMap(cityDynamicObjectList, parSize);
                for (List<DynamicObject> cityGroupList : cityDynamicObjectMaps.values()) {
                    SaveServiceHelper.save((DynamicObject[])cityGroupList.toArray(new DynamicObject[cityGroupList.size()]));
                    cityDynamicObjectList.removeAll(cityGroupList);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u66f4\u65b0\u5546\u65c5\u57ce\u5e02\u4fe1\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    private static Map<Integer, List<DynamicObject>> groupPostDataMap(List dynamicObjectList, int eachLen) {
        int i;
        int size = dynamicObjectList.size() / eachLen + 1;
        HashMap<Integer, List<DynamicObject>> map = new HashMap<Integer, List<DynamicObject>>(size);
        for (i = 0; i < size; ++i) {
            map.put(i, new ArrayList(eachLen));
        }
        for (i = 0; i < dynamicObjectList.size(); ++i) {
            int index = i / eachLen;
            ((List)map.get(index)).add((DynamicObject)dynamicObjectList.get(i));
        }
        return map;
    }

    public static void updateAdmindivisionIDList() {
        QFilter filter = new QFilter("iscity", "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter = filter.and(enableFilter);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection admindivisionIdsCol = QueryServiceHelper.query((String)"bd_admindivision", (String)"id", (QFilter[])filters);
        HashSet<Long> admindivisionIds = new HashSet<Long>();
        for (DynamicObject admindivisionObj : admindivisionIdsCol) {
            admindivisionIds.add(admindivisionObj.getLong("id"));
        }
        QFilter[] filters1 = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection cityIdsCol = QueryServiceHelper.query((String)"er_city", (String)"id", (QFilter[])filters1);
        HashSet<Long> cityIds = new HashSet<Long>();
        HashSet<Long> cityIds1 = new HashSet<Long>();
        for (DynamicObject cityObj : cityIdsCol) {
            cityIds.add(cityObj.getLong("id"));
        }
        cityIds1.addAll(cityIds);
        cityIds.removeAll(admindivisionIds);
        admindivisionIds.removeAll(cityIds1);
        String insertSql = "INSERT INTO T_ER_TRIPCITY (FID, FSTATUS, FENABLE, FCREATETIME, FMODIFYTIME, FADMINDIVISIONID) VALUES(?, ?, ?, ?, ?, ?)";
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(admindivisionIds.size());
        for (Long id : admindivisionIds) {
            insertParamsList.add(new Object[]{id, "C", "1", new Date(), new Date(), id});
        }
        try {
            if (cityIds.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"er_city"), (Object[])cityIds.toArray());
            }
            if (admindivisionIds.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("er"), (String)insertSql, insertParamsList);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u66f4\u65b0\u884c\u653f\u533a\u5212ID\u51fa\u73b0\u5f02\u5e38:" + e);
        }
    }

    public static Map<String, String> getCityInfo(Object fromAdmindivisionID, Object toAdmindivisionID) {
        HashMap<String, String> cityMap = new HashMap<String, String>();
        if (fromAdmindivisionID == null) {
            return cityMap;
        }
        Object[] ids = new Object[]{fromAdmindivisionID, toAdmindivisionID};
        QFilter noFilter = new QFilter("id", "in", (Object)ids);
        QFilter[] qFilters = new QFilter[]{noFilter};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_city", (String)"code,cityid,namepinyin,fullcityid", (QFilter[])qFilters);
        DynamicObject fromObject = (DynamicObject)map.get(Long.parseLong(fromAdmindivisionID.toString()));
        DynamicObject toObject = (DynamicObject)map.get(Long.parseLong(toAdmindivisionID.toString()));
        boolean paramValue = TripSyncConfigUtil.getBoolean("Ctrip_obtain_full_Interface");
        if (fromObject != null) {
            if (paramValue) {
                cityMap.put("fromFullCityID", fromObject.getString("fullcityid"));
            }
            cityMap.put("fromCode", fromObject.getString("code"));
            cityMap.put("fromPinyin", fromObject.getString("namepinyin"));
        }
        if (toObject != null) {
            if (paramValue) {
                cityMap.put("toID", toObject.getString("fullcityid"));
                cityMap.put("toFullCityID", toObject.getString("fullcityid"));
            } else {
                cityMap.put("toID", toObject.getString("cityid"));
            }
            cityMap.put("toCode", toObject.getString("code"));
            cityMap.put("toPinyin", toObject.getString("namepinyin"));
        }
        cityMap.put("isUsedFullCityId", Boolean.toString(paramValue));
        return cityMap;
    }

    public static List<Set<String>> getCityCodeAndIds(Set<Long> admindivisionIDs) {
        QFilter noFilter = new QFilter("id", "in", admindivisionIDs);
        QFilter[] qFilters = new QFilter[]{noFilter};
        ArrayList<Set<String>> list = new ArrayList<Set<String>>(2);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_city", (String)"code,cityid,fullcityid", (QFilter[])qFilters);
        LinkedHashSet<String> codes = new LinkedHashSet<String>(map.size());
        LinkedHashSet<String> cityids = new LinkedHashSet<String>(map.size());
        boolean paramValue = TripSyncConfigUtil.getBoolean("Ctrip_obtain_full_Interface");
        for (DynamicObject dobject : map.values()) {
            if (paramValue) {
                if ("0".equals(dobject.getString("fullcityid"))) continue;
                cityids.add(dobject.getString("fullcityid"));
                continue;
            }
            codes.add(dobject.getString("code"));
            if ("0".equals(dobject.getString("cityid"))) continue;
            cityids.add(dobject.getString("cityid"));
        }
        list.add(codes);
        list.add(cityids);
        return list;
    }

    public static Set<String> getCityIds(Set<Long> admindivisionIDs) {
        QFilter noFilter = new QFilter("id", "in", admindivisionIDs);
        QFilter[] qFilters = new QFilter[]{noFilter};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_city", (String)"code,cityid,fullcityid", (QFilter[])qFilters);
        boolean paramValue = TripSyncConfigUtil.getBoolean("Ctrip_obtain_full_Interface");
        LinkedHashSet<String> cityids = new LinkedHashSet<String>(map.size());
        String billfield = "cityid";
        if (paramValue) {
            billfield = "fullcityid";
        }
        for (DynamicObject dobject : map.values()) {
            if ("0".equals(dobject.getString(billfield))) continue;
            cityids.add(dobject.getString(billfield));
        }
        return cityids;
    }

    public static Map<Long, Object> getDiDiCityId(Long admindivisionID) {
        QFilter noFilter = new QFilter("id", "=", (Object)admindivisionID);
        QFilter[] qFilters = new QFilter[]{noFilter};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_city", (String)"id,didicityid", (QFilter[])qFilters);
        HashMap<Long, Object> cityidMap = new HashMap<Long, Object>(map.size());
        for (DynamicObject dobject : map.values()) {
            cityidMap.put(admindivisionID, dobject.getLong("didicityid"));
        }
        return cityidMap;
    }

    public static String judgeCityName(String cityName) {
        int length;
        if (StringUtils.isBlank((CharSequence)cityName)) {
            return cityName;
        }
        int needSubIndex = 0;
        if (cityName.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"CitySuffix_0", (String)"fi-er-business", (Object[])new Object[0])) || cityName.endsWith(ResManager.loadKDString((String)"\u533a", (String)"CitySuffix_1", (String)"fi-er-business", (Object[])new Object[0])) || cityName.endsWith(ResManager.loadKDString((String)"\u53bf", (String)"CitySuffix_2", (String)"fi-er-business", (Object[])new Object[0]))) {
            needSubIndex = 1;
        }
        if (cityName.endsWith(ResManager.loadKDString((String)"\u81ea\u6cbb\u5dde", (String)"CitySuffix_4", (String)"fi-er-business", (Object[])new Object[0])) || cityName.endsWith(ResManager.loadKDString((String)"\u81ea\u6cbb\u533a", (String)"CitySuffix_3", (String)"fi-er-business", (Object[])new Object[0]))) {
            needSubIndex = 3;
        }
        if ((length = cityName.length()) >= needSubIndex) {
            cityName = cityName.substring(0, length - needSubIndex);
        }
        return cityName;
    }
}

