/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.messagepublish.ErMessagePublisher;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.TrialOrgServiceHelper;
import kd.fi.er.business.servicehelper.invoice.GenerateInvoicerAssistant;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.mq.TripSyncMqConstants;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.server.gtrip.GtripFieldMappingInvoke;
import kd.fi.er.business.trip.v2.server.number.TripMappingNumber;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.JsonHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class TripCommonUtil {
    private static final Log logger = LogFactory.getLog(TripCommonUtil.class);
    public static final String BILL_DYNAMIC_OBJECT_BILLNO = "kd.fi.er.business.trip.util.TripCommonUtil.getDValueByfield.REQ_BILL_DYNAMIC_OBJECT_BILLNO";
    public static final String disableInvoke = "disableInvoke";
    public static final String orgInvoke = "orgInvoke";
    public static final String userInvoke = "userInvoke";
    public static final String tripReqBillInvoke = "tripReqBillInvoke";
    public static final String dailyVehicleBillInvoke = "dailyVehicleBillInvoke";
    public static final String loginInvoke = "loginInvoke";
    public static final String orderInvoke = "orderInvoke";
    public static final String imageInvoke = "imageInvoke";
    public static final String checkingInvoke = "checkingInvoke";
    public static final String invoiceSendInvoke = "invoiceSendInvoke";
    public static final String invoiceReceiveInvoke = "invoiceReceiveInvoke";
    public static final String orderUpdateInvoke = "orderUpdateInvoke";
    public static final String mealApplicationBillInvoke = "mealApplicationBillInvoke";
    public static final String tripBudgetInvoke = "budgetInvoke";
    public static final String AUTO_OPENED_INVOKE = "autoOpenedInvoke";
    public static final List<String> NotCopyField = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"id", "createtime", "creator", "auditor", "reimbursestatus", "billstatus", "isconfirm", "noticetimes", "billstatusname"}));
    public static Map<String, Object> notExpectedValueMap = new HashMap<String, Object>(16);
    public static final String CTripName = "CTripService";
    public static final String CTripClass = "kd.fi.er.business.trip.supplier.ctrip.CTripService";
    public static final String ETripName = "ETripService";
    public static final String ETripClass = "kd.fi.er.business.trip.supplier.zte.ETripService";
    public static final String TTripName = "TTripService";
    public static final String TTripClass = "kd.fi.er.business.trip.supplier.travelno1.TTripService";
    public static final String DiDiTripName = "DiDiTripService";
    public static final String DiDiTripClass = "kd.fi.er.business.trip.supplier.didi.DiDiTripService";
    public static final String MeiTuanTripName = "MeiTuanTripService";
    public static final String MeiTuanTripClass = "kd.fi.er.business.trip.supplier.meituan.MeiTuanTripService";
    private static final Map<String, String> standTripSrevice;
    private static final Map<String, String> standTripName;
    public static final String TABAP = "tabap";
    public static final String MOBILEFORM = "mobileform";

    public static Map<String, String> getInvokeClassMap() {
        HashMap<String, String> invokeClassMap = new HashMap<String, String>(16);
        invokeClassMap.put(orgInvoke, ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"TripCommonUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(userInvoke, ResManager.loadKDString((String)"\u4eba\u5458", (String)"TripCommonUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(tripReqBillInvoke, ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"TripCommonUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(dailyVehicleBillInvoke, ResManager.loadKDString((String)"\u7528\u8f66\u7533\u8bf7\u5355", (String)"TripCommonUtil_4", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(loginInvoke, ResManager.loadKDString((String)"\u767b\u5f55", (String)"TripCommonUtil_5", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(orderInvoke, ResManager.loadKDString((String)"\u8ba2\u5355", (String)"TripCommonUtil_6", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(imageInvoke, ResManager.loadKDString((String)"\u5f71\u50cf\u4fe1\u606f", (String)"TripCommonUtil_7", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(checkingInvoke, ResManager.loadKDString((String)"\u7ed3\u7b97\u5355", (String)"TripCommonUtil_8", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(invoiceSendInvoke, ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7", (String)"TripCommonUtil_9", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(invoiceReceiveInvoke, ResManager.loadKDString((String)"\u53d1\u7968\u63a5\u6536", (String)"TripCommonUtil_10", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(mealApplicationBillInvoke, ResManager.loadKDString((String)"\u7528\u9910\u7533\u8bf7\u5355", (String)"TripCommonUtil_11", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put("tripCityInvoke", ResManager.loadKDString((String)"\u57ce\u5e02\u66f4\u65b0", (String)"TripCommonUtil_12", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put("tripCarRegulationInvoke", ResManager.loadKDString((String)"\u51fa\u5dee\u7528\u8f66\u5236\u5ea6", (String)"TripCommonUtil_13", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(tripBudgetInvoke, ResManager.loadKDString((String)"\u9884\u7b97\u843d\u5730", (String)"TripCommonUtil_14", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(AUTO_OPENED_INVOKE, ResManager.loadKDString((String)"\u5546\u65c5\u81ea\u52a9\u5f00\u901a", (String)"TripCommonUtil_15", (String)"fi-er-business", (Object[])new Object[0]));
        invokeClassMap.put(orderUpdateInvoke, ResManager.loadKDString((String)"\u8ba2\u5355t+2", (String)"TripCommonUtil_16", (String)"fi-er-business", (Object[])new Object[0]));
        return invokeClassMap;
    }

    public static Map<String, String> getTripServiceInfo(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        String selectProperties = "appkey,name,appsecurity,orationid,reservedfield1,reservedfield2,reservedfield3,reservedfield4,reservedfield5,setcostorg,syncreqbillsettleorg,rsakey";
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject cacheObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)selectProperties, (QFilter[])qFilters);
        if (cacheObject != null) {
            HashMap<String, String> returnMap = new HashMap();
            String json = SerializationUtils.toJsonString((Object)cacheObject);
            returnMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            return returnMap;
        }
        return null;
    }

    public static Map<Object, DynamicObject> getTripServiceInfoDOMap(Set<String> numbers) {
        QFilter filter = new QFilter("number", "in", numbers);
        QFilter[] qFilters = new QFilter[]{filter};
        Map serviceInfoMap = BusinessDataServiceHelper.loadFromCache((String)"er_biz_info", (QFilter[])qFilters);
        return serviceInfoMap;
    }

    public static DynamicObject getTripServicePluginInfo(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info_plugin", (QFilter[])qFilters);
        return dynamicObject;
    }

    public static Map<String, String> initExtInvokeMap(String tripName) {
        return TripCommonUtil.getTripServicePluginDetailInfo(tripName);
    }

    public static Map<String, String> getTripServicePluginDetailInfo(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{filter};
        Object o = ActionLocalCache.get().get("bizInfo_dataEntity");
        DynamicObject dynamicObject = o != null ? (DynamicObject)o : BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info_plugin", (QFilter[])qFilters);
        HashMap<String, String> pluginMap = new HashMap<String, String>(16);
        if (dynamicObject == null) {
            return pluginMap;
        }
        DynamicObjectCollection pluginDetails = dynamicObject.getDynamicObjectCollection("entryentity");
        if (pluginDetails == null || pluginDetails.size() < 1) {
            return pluginMap;
        }
        for (DynamicObject pluginDetail : pluginDetails) {
            String function = pluginDetail.getString("function");
            String classpath = pluginDetail.getString("classpath");
            boolean enable = pluginDetail.getBoolean("enable");
            if (!StringUtils.isNotBlank((String)function) || !StringUtils.isNotBlank((String)classpath) || !enable) continue;
            pluginMap.put(function, classpath.trim());
        }
        return pluginMap;
    }

    public static Boolean existsTripServicePlugin(String number, String function) {
        QFilter qA = new QFilter("number", "=", (Object)number);
        QFilter qB = new QFilter("entryentity.function", "=", (Object)function);
        QFilter[] qFilters = new QFilter[]{qA, qB};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info_plugin", (QFilter[])qFilters);
        if (dynamicObject == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static void openOrderBill(String ordernum, String formNumber, IFormView view) {
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u62a5\u9500\u5355\u7684\u8ba2\u5355\u8d85\u94fe\u63a5\u70b9\u51fb\u3002\u8ba2\u5355\u53f7: %s, \u8ba2\u5355\u5143\u6570\u636e: %s", ordernum, formNumber));
        QFilter[] filters = new QFilter[]{new QFilter("ordernum", "=", (Object)ordernum)};
        DynamicObject trueOrderBill = QueryServiceHelper.queryOne((String)formNumber, (String)"id", (QFilter[])filters);
        if (trueOrderBill == null) {
            String tips = ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u3002", (String)"TripReimBillOrderEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
            view.showTipNotification(tips);
            return;
        }
        long trueOrderBillId = trueOrderBill.getLong("id");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formNumber);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setPkId((Object)trueOrderBillId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setHasRight(true);
        billShowParameter.setCustomParam("checkRightAppId", (Object)"tra");
        view.showForm((FormShowParameter)billShowParameter);
    }

    public static boolean reqPush(String billno, String billId, String server, String status) {
        if (server.equals(Supplier.XIECHENG.name())) {
            boolean isReqPushSuccess = Boolean.FALSE;
            if (TripCommonUtil.existsTripServicePlugin(server, tripReqBillInvoke).booleanValue()) {
                String tripServiceName = TripCommonUtil.getStandtripname().get(server);
                ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
                String code = iTripService.synReqbillToTrip(billId, String.valueOf(status));
                isReqPushSuccess = "200".equals(code);
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                params.put("status", "1");
                if (status.equals("2")) {
                    params.put("status", "0");
                }
                params.put("billno", billno);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trip_fieldmapping", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TripMappingNumber.C_BUDGET.getCode())});
                Object list = TripCommonUtil.invoke(server, "er_tripreqbill", null, null, params);
                if (null != list && list instanceof List) {
                    List ls = (List)list;
                    Map result = (Map)ls.get(0);
                    if (null == result || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) {
                        String tripServiceName = TripCommonUtil.getStandtripname().get(server);
                        ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
                        String code = iTripService.synReqbillToTrip(billId, String.valueOf(status));
                        isReqPushSuccess = "200".equals(code) && (null == dynamicObject || !dynamicObject.getBoolean("enable"));
                    } else {
                        boolean bl = isReqPushSuccess = TripCommonUtil.checkCTripReqResult(result) && (null == dynamicObject || !dynamicObject.getBoolean("enable"));
                    }
                }
            }
            if (isReqPushSuccess) {
                TripCommonUtil.tripBudgetPush(billId, billno, server, status);
            }
        } else if (Supplier.GAODE.name().equals(server)) {
            DynamicObjectCollection dataMapping = QueryServiceHelper.query((String)"er_tripsync_datamapping", (String)"outdataid", (QFilter[])new QFilter[]{new QFilter("innerdataid", "=", (Object)Long.parseLong(billId))});
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("id", billId);
            params.put("billno", billno);
            params.put("status", "1");
            if (status.equals("2")) {
                params.put("status", "0");
            }
            if (null == dataMapping || dataMapping.size() == 0) {
                GtripFieldMappingInvoke.syncReqBill(null, "1", params);
            } else {
                GtripFieldMappingInvoke.syncReqBill(null, "2", params);
            }
        } else if (Supplier.TONGCHENG.name().equals(server) || Supplier.QICHENG.name().equals(server)) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("id", billId);
            params.put("billno", billno);
            params.put("status", "1");
            if (status.equals("2")) {
                params.put("status", "2");
            }
            TripCommonUtil.invoke(server, "er_tripreqbill", null, null, params);
        } else if (Supplier.ALI.name().equals(server)) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("id", billId);
            params.put("billno", billno);
            params.put("status", "1");
            if (status.equals("2")) {
                params.put("status", "4");
            }
            TripCommonUtil.invoke(server, "er_tripreqbill", null, null, params);
        } else if (Supplier.QICHENG.name().equals(server)) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("id", billId);
            params.put("billno", billno);
            params.put("status", "1");
            TripCommonUtil.invoke(server, "er_tripreqbill", null, null, params);
        } else if (Supplier.MEIYA.name().equals(server)) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            ActionLocalCache localCache = ActionLocalCache.get();
            String operationType = (String)localCache.getDefaultIfNull("SyncReq.operationType", "submit");
            String billType = (String)localCache.getDefaultIfNull("SyncReq.billType", "er_tripreqbill");
            String synctype = "1";
            int applicationStatus = 4;
            if ("er_tripreqbill".equals(billType)) {
                switch (operationType) {
                    case "submit": 
                    case "audit": 
                    case "triprevoke": {
                        break;
                    }
                    case "invalidbtn": 
                    case "unsubmit": 
                    case "tripchange": 
                    case "noapproval": 
                    case "unaudit": {
                        synctype = "2";
                        applicationStatus = 8;
                        break;
                    }
                    case "closebill": {
                        synctype = "2";
                        applicationStatus = 9;
                    }
                }
            } else if ("er_tripreimbursebill".equals(billType)) {
                switch (operationType) {
                    case "submit": {
                        synctype = "2";
                        applicationStatus = 9;
                        break;
                    }
                    case "unsubmit": 
                    case "invalidbtn": 
                    case "noapproval": 
                    case "unaudit": {
                        synctype = "2";
                        applicationStatus = 4;
                    }
                }
            }
            params.put("status", applicationStatus);
            params.put("id", billId);
            params.put("billno", billno);
            TripCommonUtil.invoke(server, "er_tripreqbill", synctype, null, params);
        } else {
            String tripServiceName = TripCommonUtil.getStandtripname().get(server);
            ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
            iTripService.synReqbillToTrip(billId, String.valueOf(status));
        }
        return false;
    }

    public static Object invoke(String server, String function, String synctype, String number, Map<String, Object> params) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        QFilter qA = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (null != number) {
            qA.and(new QFilter("number", "=", (Object)number));
        } else {
            if (null != server) {
                qA.and(new QFilter("server.number", "=", (Object)server));
            } else {
                qA.and(new QFilter("server", "=", (Object)0L));
            }
            if (null != function) {
                qA.and(new QFilter("function", "=", (Object)function));
            }
            if (null != synctype) {
                qA.and(new QFilter("synctype", "=", (Object)synctype));
            }
            if (params.containsKey("porttype")) {
                qA.and(new QFilter("porttype", "=", params.get("porttype")));
            }
        }
        DynamicObject[] dynamicObjects = ErOrm.load("er_trip_fieldmapping", new QFilter[]{qA});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", Boolean.FALSE);
            result.put("msg", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5b57\u6bb5\u6620\u5c04{%s}\u4e0d\u5b58\u5728\u3002", (String)"TripCommonUtil_04", (String)"fi-er-business", (Object[])new Object[]{server}));
            list.add(result);
            return list;
        }
        DynamicObject bizinfo = null;
        if (null == server && null != params.get("input_data")) {
            JSONObject jsonObject = JSON.parseObject((String)params.get("input_data").toString());
            String service = jsonObject.getJSONObject("tripSync").getString("service");
            HashSet<String> strSet = new HashSet<String>(1);
            strSet.add(service);
            Map<Object, DynamicObject> tripServiceInfoDOMap = TripCommonUtil.getTripServiceInfoDOMap(strSet);
            if (null != tripServiceInfoDOMap && !tripServiceInfoDOMap.isEmpty()) {
                bizinfo = tripServiceInfoDOMap.values().iterator().next();
            }
        }
        Stream<DynamicObject> mappings = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(d -> Integer.parseInt(null == d.getString("synctype") || "".equals(d.getString("synctype").trim()) ? "0" : d.getString("synctype"))));
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            DynamicObject fieldmapping = (DynamicObject)iterator.next();
            if (null != bizinfo) {
                fieldmapping.set("server_id", (Object)ErCommonUtils.getPk(bizinfo));
                fieldmapping.set("server", bizinfo);
            }
            if (TripMappingNumber.C_BUDGET.getCode().equals(fieldmapping.getString("number")) && null != params.get("status") && "0".equals(params.get("status"))) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException | KDBizException e) {
                    logger.info("\u9884\u7b97\u843d\u5730\uff0c\u6309\u643a\u7a0b\u8981\u6c42\u5ef6\u8fdf10s");
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            if (!"1".equals(fieldmapping.getString("enable"))) {
                result.put("success", Boolean.FALSE);
                result.put("msg", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5b57\u6bb5\u6620\u5c04{%s}\u672a\u542f\u7528\u3002", (String)"TripCommonUtil_05", (String)"fi-er-business", (Object[])new Object[]{number}));
                list.add(result);
                continue;
            }
            if (fieldmapping.getDynamicObject("server") != null && !fieldmapping.getDynamicObject("server").getBoolean("enable")) {
                result.put("success", Boolean.FALSE);
                result.put("msg", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5b57\u6bb5\u6620\u5c04{%s}\u5bf9\u5e94\u670d\u52a1\u5546\u672a\u542f\u7528\u3002", (String)"TripCommonUtil_07", (String)"fi-er-business", (Object[])new Object[]{number}));
                list.add(result);
                continue;
            }
            params.put("fieldmap", fieldmapping);
            String classforname = fieldmapping.getString("classforname");
            if (null == classforname || !classforname.contains("#")) {
                result.put("msg", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5b57\u6bb5\u6620\u5c04{%s}\u63a5\u53e3\u63d2\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TripCommonUtil_06", (String)"fi-er-business", (Object[])new Object[]{number}));
                result.put("success", Boolean.FALSE);
                list.add(result);
                continue;
            }
            TripClassUtil.invokeClass(params, list, result, classforname);
        }
        return list;
    }

    public static Object getDValueByfield(DynamicObject bill, String field) {
        RowDataModel rowModel = (RowDataModel)ActionLocalCache.get().get(BILL_DYNAMIC_OBJECT_BILLNO, bill.getDataEntityType().getName() + "_" + bill.getString("id"), () -> {
            String function = bill.getDataEntityType().getName();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)function);
            return new RowDataModel(function, type);
        });
        ExpressionParameter calcParameter = new ExpressionParameter(field, rowModel, null);
        calcParameter.setActiveRow((Object)bill);
        Object ctx = CalcExprParser.getExpressionValue((ExpressionParameter)calcParameter);
        return ctx;
    }

    public static Boolean getEnbleServer() {
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qA};
        boolean isExistsServer = QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])qFilters);
        return isExistsServer;
    }

    public static Boolean isEnbleServer(String number) {
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("number", "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qA, qB};
        boolean isExistsServer = QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])qFilters);
        return isExistsServer;
    }

    public static Map<String, Boolean> isEnbleServer(List<String> numbers) {
        HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>(numbers.size());
        for (String number : numbers) {
            booleanMap.put(number, Boolean.FALSE);
        }
        QFilter qB = new QFilter("number", "in", numbers);
        QFilter[] qFilters = new QFilter[]{qB};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_biz_info", (QFilter[])qFilters);
        if (null != dynamicObjectMap) {
            for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
                for (String number : numbers) {
                    if (null == number || !number.equals(dynamicObject.getString("number")) || !dynamicObject.getBoolean("enable")) continue;
                    booleanMap.put(number, Boolean.TRUE);
                }
            }
        }
        return booleanMap;
    }

    public static void controlBusinessTrealPanleHiding(IFormView view) {
        Map<String, String> supplierKeyMap = Supplier.getSupplierKeyMap();
        Map<String, Map<String, Boolean>> map = TripCommonUtil.getTripBusinessServerTrialOrg(supplierKeyMap.values().stream().collect(Collectors.toList()));
        Map<String, String> activeTabMap = new LinkedHashMap<String, String>();
        HashMap<String, String> beeMap = new HashMap<String, String>(16);
        beeMap.put("domair", "flex_beedomair");
        beeMap.put("intair", "flex_beeintair");
        beeMap.put("hotel", "flex_beehotel");
        beeMap.put("train", "flex_beetrain");
        beeMap.put("car", "flex_beecar");
        beeMap.put("flexpanel", "beetabpageap");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.ZHONGXING.name(), beeMap, activeTabMap, map.get(Supplier.ZHONGXING.name()));
        HashMap<String, String> corpMap = new HashMap<String, String>(16);
        corpMap.put("domair", "flex_corpdomair");
        corpMap.put("intair", "flex_corpintair");
        corpMap.put("hotel", "flex_corphotel");
        corpMap.put("inthotel", "flex_corpinthotel");
        corpMap.put("car", "flex_corpcar");
        corpMap.put("train", "flex_corptrain");
        corpMap.put("flexpanel", "corptabpageap");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.XIECHENG.name(), corpMap, activeTabMap, map.get(Supplier.XIECHENG.name()));
        HashMap<String, String> travelnooneMap = new HashMap<String, String>(16);
        travelnooneMap.put("domair", "flex_travelnoonedomair");
        travelnooneMap.put("hotel", "flex_travelnoonehotel");
        travelnooneMap.put("car", "flex_travelnoonecar");
        travelnooneMap.put("train", "flex_travelnoonetrain");
        travelnooneMap.put("flexpanel", "travelnoonetabpageap");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.CHAILVYIHAO.name(), travelnooneMap, activeTabMap, map.get(Supplier.CHAILVYIHAO.name()));
        HashMap<String, String> didiMap = new HashMap<String, String>(16);
        didiMap.put("car", "flex_didicar");
        didiMap.put("home", "flex_didihome");
        didiMap.put("flexpanel", "diditabpageap");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.DIDI.name(), didiMap, activeTabMap, map.get(Supplier.DIDI.name()));
        HashMap<String, String> gaodeMap = new HashMap<String, String>(16);
        gaodeMap.put("car", "flex_gaodecar");
        gaodeMap.put("flexpanel", "gaodetabpageap");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.GAODE.name(), gaodeMap, activeTabMap, map.get(Supplier.GAODE.name()));
        HashMap<String, String> dtgMap = new HashMap<String, String>(16);
        dtgMap.put("flexpanel", "tongchengtab");
        dtgMap.put("domair", "flex_dtg_plane_in");
        dtgMap.put("intair", "flex_dtg_plane_out");
        dtgMap.put("hotel", "flex_dtg_hotel_in");
        dtgMap.put("inthotel", "flex_dtg_hotel_out");
        dtgMap.put("car", "flex_dtg_car");
        dtgMap.put("train", "flex_dtg_train");
        dtgMap.put("home", "flex_dtg_home");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.TONGCHENG.name(), dtgMap, activeTabMap, map.get(Supplier.TONGCHENG.name()));
        HashMap<String, String> aliMap = new HashMap<String, String>(16);
        aliMap.put("flexpanel", "alitab");
        aliMap.put("domair", "flex_ali_plane");
        aliMap.put("hotel", "flex_ali_hotel");
        aliMap.put("car", "flex_ali_car");
        aliMap.put("train", "flex_ali_train");
        aliMap.put("home", "flex_ali_home");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.ALI.name(), aliMap, activeTabMap, map.get(Supplier.ALI.name()));
        HashMap<String, String> qMap = new HashMap<String, String>(16);
        qMap.put("domair", "flex_qichengdomair");
        qMap.put("intair", "flex_qichengintair");
        qMap.put("hotel", "flex_qichengdomhotel");
        qMap.put("train", "flex_qichengtrain");
        qMap.put("car", "flex_qichengcar");
        qMap.put("flexpanel", "qichengtabpageap");
        qMap.put("home", "flex_qichenghome");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.QICHENG.name(), qMap, activeTabMap, map.get(Supplier.QICHENG.name()));
        HashMap<String, String> myMap = new HashMap<String, String>(16);
        myMap.put("flexpanel", "meiyatab");
        myMap.put("domair", "flex_meiya_plane");
        myMap.put("hotel", "flex_meiya_hotel");
        myMap.put("train", "flex_meiya_train");
        myMap.put("home", "flex_meiya_home");
        activeTabMap = TripCommonUtil.setTirpFlexVisible(view, Supplier.MEIYA.name(), myMap, activeTabMap, map.get(Supplier.MEIYA.name()));
        if (activeTabMap != null && activeTabMap.size() > 0) {
            Tab tab = (Tab)view.getControl(TABAP);
            tab.activeTab(activeTabMap.get(activeTabMap.keySet().toArray()[0]));
        }
    }

    public static Set<Boolean> getTrialTripBusniessOrgSet() {
        Map<String, String> supplierKeyMap = Supplier.getSupplierKeyMap();
        HashSet<Boolean> trialTripBusniessOrgSet = new HashSet<Boolean>();
        Map<String, Map<String, Boolean>> map = TripCommonUtil.getTripBusinessServerTrialOrg(supplierKeyMap.values().stream().collect(Collectors.toList()));
        for (Map.Entry<String, String> supplierEntry : supplierKeyMap.entrySet()) {
            Map<String, Boolean> params = map.get(supplierEntry.getValue());
            Collection<Boolean> mapvalue = params.values();
            trialTripBusniessOrgSet.addAll(mapvalue);
        }
        return trialTripBusniessOrgSet;
    }

    public static Map<String, String> setTirpFlexVisible(IFormView view, String server, Map<String, String> tmcMap, Map<String, String> activeTabMap) {
        Map<String, Boolean> map = TripCommonUtil.getTripBusinessServerTrialOrg(server);
        if (map != null && map.size() > 0) {
            boolean isActiveVisible;
            String modelType = view.getFormShowParameter().getFormConfig().getModelType();
            if (MOBILEFORM.equals(modelType) && Supplier.XIECHENG.name().equals(server)) {
                if (map.get("enabledomestic") != null && !map.get("enabledomestic").booleanValue() && tmcMap.get("domair") != null && !map.get("enableinternational").booleanValue() && tmcMap.get("intair") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{"flex_corpdomair"});
                }
                if (map.get("enabledomestic") != null && !map.get("enablehotel").booleanValue() && tmcMap.get("hotel") != null && !map.get("enableinternationalhotel").booleanValue() && tmcMap.get("inthotel") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{"flex_corphotel"});
                }
            } else {
                if (map.get("enabledomestic") != null && !map.get("enabledomestic").booleanValue() && tmcMap.get("domair") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("domair")});
                }
                if (map.get("enableinternational") != null && !map.get("enableinternational").booleanValue() && tmcMap.get("intair") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("intair")});
                }
                if (map.get("enablehotel") != null && !map.get("enablehotel").booleanValue() && tmcMap.get("hotel") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("hotel")});
                }
                if (map.get("enableinternationalhotel") != null && !map.get("enableinternationalhotel").booleanValue() && tmcMap.get("inthotel") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("inthotel")});
                }
            }
            if (map.get("enablecar") != null && !map.get("enablecar").booleanValue() && tmcMap.get("car") != null) {
                view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("car")});
            }
            if (map.get("enabletrain") != null && !map.get("enabletrain").booleanValue() && tmcMap.get("train") != null) {
                view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("train")});
            }
            if (isActiveVisible = TripCommonUtil.getServerMapValueSet(view, map, tmcMap.get("flexpanel"))) {
                activeTabMap.put(server, tmcMap.get("flexpanel"));
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("flexpanel")});
        }
        return activeTabMap;
    }

    public static Map<String, String> setTirpFlexVisible(IFormView view, String server, Map<String, String> tmcMap, Map<String, String> activeTabMap, Map<String, Boolean> map) {
        if (map != null && map.size() > 0) {
            boolean isActiveVisible;
            String modelType = view.getFormShowParameter().getFormConfig().getModelType();
            if (MOBILEFORM.equals(modelType) && Supplier.XIECHENG.name().equals(server)) {
                if (map.get("enabledomestic") != null && !map.get("enabledomestic").booleanValue() && tmcMap.get("domair") != null && !map.get("enableinternational").booleanValue() && tmcMap.get("intair") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{"flex_corpdomair"});
                }
                if (map.get("enabledomestic") != null && !map.get("enablehotel").booleanValue() && tmcMap.get("hotel") != null && !map.get("enableinternationalhotel").booleanValue() && tmcMap.get("inthotel") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{"flex_corphotel"});
                }
            } else {
                if (map.get("enabledomestic") != null && !map.get("enabledomestic").booleanValue() && tmcMap.get("domair") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("domair")});
                }
                if (map.get("enableinternational") != null && !map.get("enableinternational").booleanValue() && tmcMap.get("intair") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("intair")});
                }
                if (map.get("enablehotel") != null && !map.get("enablehotel").booleanValue() && tmcMap.get("hotel") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("hotel")});
                }
                if (map.get("enableinternationalhotel") != null && !map.get("enableinternationalhotel").booleanValue() && tmcMap.get("inthotel") != null) {
                    view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("inthotel")});
                }
            }
            if (map.get("enablecar") != null && !map.get("enablecar").booleanValue() && tmcMap.get("car") != null) {
                view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("car")});
            }
            if (map.get("enablehome") != null && !map.get("enablehome").booleanValue() && tmcMap.get("home") != null) {
                view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("home")});
            }
            if (map.get("enabletrain") != null && !map.get("enabletrain").booleanValue() && tmcMap.get("train") != null) {
                view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("train")});
            }
            if (isActiveVisible = TripCommonUtil.getServerMapValueSet(view, map, tmcMap.get("flexpanel"))) {
                activeTabMap.put(server, tmcMap.get("flexpanel"));
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{tmcMap.get("flexpanel")});
        }
        return activeTabMap;
    }

    public static boolean getServerMapValueSet(IFormView view, Map<String, Boolean> serverMap, String flexpanel) {
        boolean isActiveVisible = true;
        HashSet<Boolean> serverMapValueSet = new HashSet<Boolean>(serverMap.size());
        for (Map.Entry<String, Boolean> key : serverMap.entrySet()) {
            Boolean serverMapValue = key.getValue();
            serverMapValueSet.add(serverMapValue);
        }
        if (serverMapValueSet.size() == 1 && serverMapValueSet.contains(Boolean.FALSE)) {
            view.setVisible(Boolean.FALSE, new String[]{flexpanel});
            isActiveVisible = false;
        }
        return isActiveVisible;
    }

    public static Map<String, Boolean> getTripBusinessServerTrialOrg(String server) {
        Long userId = CommonServiceHelper.getCurrentUserID();
        HashMap<String, Boolean> parmsMap = new HashMap<String, Boolean>(16);
        Boolean isExistsServer = TripCommonUtil.isEnbleServer(server);
        if (isExistsServer.booleanValue()) {
            Map<String, Boolean> functionMap = TrialOrgServiceHelper.functionPermissionToUseNew(userId, false);
            if (Supplier.ZHONGXING.name().equals(server)) {
                parmsMap.put("enableinternational", functionMap.getOrDefault("bee_intair", Boolean.FALSE));
                parmsMap.put("enabledomestic", functionMap.getOrDefault("bee_domair", Boolean.FALSE));
                parmsMap.put("enablehotel", functionMap.getOrDefault("bee_hotel", Boolean.FALSE));
                parmsMap.put("enabletrain", functionMap.getOrDefault("bee_train", Boolean.FALSE));
                parmsMap.put("enablecar", functionMap.getOrDefault("bee_car", Boolean.FALSE));
            }
            if (Supplier.CHAILVYIHAO.name().equals(server)) {
                parmsMap.put("enabledomestic", functionMap.getOrDefault("travelnoone_domair", Boolean.FALSE));
                parmsMap.put("enablehotel", functionMap.getOrDefault("travelnoone_hotel", Boolean.FALSE));
                parmsMap.put("enablecar", functionMap.getOrDefault("travelnoone_car", Boolean.FALSE));
                parmsMap.put("enabletrain", functionMap.getOrDefault("travelnoone_train", Boolean.FALSE));
                parmsMap.put("enablemeal", functionMap.getOrDefault("travelnoone_meal", Boolean.FALSE));
            }
            if (Supplier.XIECHENG.name().equals(server)) {
                parmsMap.put("enabledomestic", functionMap.getOrDefault("corp_domair", Boolean.FALSE));
                parmsMap.put("enableinternational", functionMap.getOrDefault("corp_intair", Boolean.FALSE));
                parmsMap.put("enablehotel", functionMap.getOrDefault("corp_hotel", Boolean.FALSE));
                parmsMap.put("enableinternationalhotel", functionMap.getOrDefault("corp_inthotel", Boolean.FALSE));
                parmsMap.put("enablecar", functionMap.getOrDefault("corp_car", Boolean.FALSE));
                parmsMap.put("enabletrain", functionMap.getOrDefault("corp_train", Boolean.FALSE));
            }
            if (Supplier.DIDI.name().equals(server)) {
                parmsMap.put("enablecar", functionMap.getOrDefault("didi_car", Boolean.FALSE));
            }
            if (Supplier.MEITUAN.name().equals(server)) {
                parmsMap.put("enabledinner", functionMap.getOrDefault("meituan_dinner", Boolean.FALSE));
            }
        }
        return parmsMap;
    }

    public static Map<String, Map<String, Boolean>> getTripBusinessServerTrialOrg(List<String> servers) {
        Long userId = CommonServiceHelper.getCurrentUserID();
        HashMap<String, Map<String, Boolean>> serverParmsMap = new HashMap<String, Map<String, Boolean>>(16);
        Map<String, Boolean> booleanMap = TripCommonUtil.isEnbleServer(servers);
        Map<String, Boolean> functionMap = TrialOrgServiceHelper.functionPermissionToUseNew(userId, false);
        for (String server : servers) {
            HashMap<String, Boolean> parmsMap = new HashMap<String, Boolean>(16);
            Boolean isEnble = booleanMap.getOrDefault(server, Boolean.FALSE);
            if (Supplier.ZHONGXING.name().equals(server)) {
                parmsMap.put("enableinternational", isEnble != false ? functionMap.getOrDefault("bee_intair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("bee_domair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("bee_hotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("bee_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("bee_car", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.CHAILVYIHAO.name().equals(server)) {
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("travelnoone_domair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("travelnoone_hotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("travelnoone_car", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("travelnoone_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablemeal", isEnble != false ? functionMap.getOrDefault("travelnoone_meal", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("travelnoone_home", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.XIECHENG.name().equals(server)) {
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("corp_domair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enableinternational", isEnble != false ? functionMap.getOrDefault("corp_intair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("corp_hotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enableinternationalhotel", isEnble != false ? functionMap.getOrDefault("corp_inthotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("corp_car", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("corp_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("corp_home", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.DIDI.name().equals(server)) {
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("didi_car", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("didi_home", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.MEITUAN.name().equals(server)) {
                parmsMap.put("enabledinner", isEnble != false ? functionMap.getOrDefault("meituan_dinner", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.GAODE.name().equals(server)) {
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("gaode_car", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.TONGCHENG.name().equals(server)) {
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("dtg_plane_in", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enableinternational", isEnble != false ? functionMap.getOrDefault("dtg_plane_out", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("dtg_hotel_in", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enableinternationalhotel", isEnble != false ? functionMap.getOrDefault("dtg_hotel_out", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("dtg_car", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("dtg_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("dtg_home", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.ALI.name().equals(server)) {
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("ali_plane", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("ali_hotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("ali_car", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("ali_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("ali_home", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.QICHENG.name().equals(server)) {
                parmsMap.put("enableinternational", isEnble != false ? functionMap.getOrDefault("qicheng_intair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("qicheng_domair", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("qicheng_domhotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("qicheng_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablecar", isEnble != false ? functionMap.getOrDefault("qicheng_car", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("qicheng_home", Boolean.FALSE) : Boolean.FALSE);
            }
            if (Supplier.MEIYA.name().equals(server)) {
                parmsMap.put("enabledomestic", isEnble != false ? functionMap.getOrDefault("meiya_plane", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehotel", isEnble != false ? functionMap.getOrDefault("meiya_hotel", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enabletrain", isEnble != false ? functionMap.getOrDefault("meiya_train", Boolean.FALSE) : Boolean.FALSE);
                parmsMap.put("enablehome", isEnble != false ? functionMap.getOrDefault("meiya_home", Boolean.FALSE) : Boolean.FALSE);
            }
            serverParmsMap.put(server, parmsMap);
        }
        return serverParmsMap;
    }

    public static DynamicObject getTripControlSettings(Long orgId, String server) {
        QFilter qFilter1 = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("server", "=", (Object)server));
        String selectProperties = "id,server,domairdatectrl,domaircityctrl,domairroundtripctrl,domairdiscountctrl,domairbookcountctrl,intlairdatectrl,intlaircityctrl,intlairroundtripctrl,intlairdiscountctrl,intlairbookcountctrl,hoteldatectrl,hotelcityctrl,maxstarclass,mixstarclass,dayroomcount,hotelbookcountctrl,cardatectrl,carcityctrl,carbookcountctrl,domairtrippeoplectrl,hoteltrippeoplectrl,cartrippeoplectrl,endcityrule,startcityrule,traindatectrl,traincityctrl,trainroundtripctrl,traintrippeoplectrl";
        QFilter qfilter2 = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripcontrolsettings", (Long)orgId);
        DynamicObject contrlObjects = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripcontrolsettings", (String)selectProperties, (QFilter[])new QFilter[]{qFilter1, qfilter2});
        return contrlObjects;
    }

    public static Map<String, Object> getBusinessSectionInfoByDaily(Long billId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObject tripReqBillInfo = QueryServiceHelper.queryOne((String)"er_dailyvehiclebill", (String)"id,costcompany.name,company.name,description,billno,startdate,enddate,createtime,from,to,vehiclecity.id,vehiclecity.name", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, Object> urlDataMap = new HashMap<String, Object>(16);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String billno = tripReqBillInfo.getString("billNo");
        String fromCity = tripReqBillInfo.getString("from");
        String toCity = tripReqBillInfo.getString("to");
        Date fromDate = tripReqBillInfo.getDate("startdate");
        Date toDate = tripReqBillInfo.getDate("enddate");
        if (billno == null || fromCity == null || toCity == null || fromDate == null || toDate == null) {
            return null;
        }
        if (tripReqBillInfo.getString("costcompany.name") != null) {
            String costCompanyName = tripReqBillInfo.getString("costcompany.name");
            urlDataMap.put("costcompany", costCompanyName);
        }
        if (tripReqBillInfo.getString("company.name") != null) {
            String companyName = tripReqBillInfo.getString("company.name");
            urlDataMap.put("company", companyName);
        }
        RequestContext requestContext = RequestContext.get();
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(requestContext.getUserId()))};
        DynamicObject userObject = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,number,name", (QFilter[])qFilters1);
        urlDataMap.put("applyBillNumber", billno);
        urlDataMap.put("employeeNumber", userObject.get("number").toString());
        urlDataMap.put("employeeName", userObject.get("name").toString());
        urlDataMap.put("from", fromCity);
        urlDataMap.put("to", toCity);
        urlDataMap.put("startDate", df.format(fromDate));
        urlDataMap.put("endDate", df.format(toDate));
        return urlDataMap;
    }

    public static Map<String, Object> getBusinessSectionInfo(Long billId) {
        DynamicObject company;
        DynamicObject costCompany;
        DynamicObject tripReqBillInfo = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_tripreqbill", (String)"billNo,isloan,rfrom,rfirstto,rstartdate,rfirstenddate,costcompany,company,tripentry.from,tripentry.to");
        HashMap<String, Object> urlDataMap = new HashMap<String, Object>(16);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String billno = tripReqBillInfo.getString("billNo");
        String fromCity = tripReqBillInfo.getString("rfrom");
        String toCity = tripReqBillInfo.getString("rfirstto");
        Date fromDate = tripReqBillInfo.getDate("rstartdate");
        Date toDate = tripReqBillInfo.getDate("rfirstenddate");
        DynamicObjectCollection tripentry = tripReqBillInfo.getDynamicObjectCollection("tripentry");
        if (billno == null || fromCity == null || toCity == null || fromDate == null || toDate == null) {
            return null;
        }
        if (tripentry != null && tripentry.get(0) != null) {
            DynamicObject firstTripentry = (DynamicObject)tripentry.get(0);
            Long fromId = firstTripentry.getDynamicObject("from").getLong("id");
            Long toId = firstTripentry.getDynamicObject("to").getLong("id");
            urlDataMap.put("fromId", fromId);
            urlDataMap.put("toId", toId);
        }
        if ((costCompany = tripReqBillInfo.getDynamicObject("costcompany")) != null) {
            String costCompanyName = costCompany.getString("name");
            urlDataMap.put("costcompany", costCompanyName);
        }
        if ((company = tripReqBillInfo.getDynamicObject("company")) != null) {
            String companyName = company.getString("name");
            urlDataMap.put("company", companyName);
        }
        RequestContext requestContext = RequestContext.get();
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(requestContext.getUserId()))};
        DynamicObject userObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])qFilters1);
        urlDataMap.put("applyBillNumber", billno);
        urlDataMap.put("employeeNumber", userObject.get("number").toString());
        urlDataMap.put("employeeName", userObject.get("name").toString());
        urlDataMap.put("from", fromCity);
        urlDataMap.put("to", toCity);
        urlDataMap.put("startDate", df.format(fromDate));
        urlDataMap.put("endDate", df.format(toDate));
        urlDataMap.put("isloan", tripReqBillInfo.getBoolean("isloan"));
        return urlDataMap;
    }

    public static void openTripPage(IFormView view, Map<String, Object> paraMap) {
        FormShowParameter parameter = view.getFormShowParameter();
        String key = (String)parameter.getCustomParams().get("key");
        if (key == null) {
            key = (String)paraMap.get("key");
        }
        if ("bee_domair".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("bee", "domair", paraMap, view);
        } else if ("bee_intair".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("bee", "intair", paraMap, view);
        } else if ("bee_hotel".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("bee", "hotel", paraMap, view);
        } else if ("bee_train".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("bee", "train", paraMap, view);
        } else if ("bee_car".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("bee", "car", paraMap, view);
        } else if ("corp_domair".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "domair", paraMap, view);
        } else if ("corp_intair".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "intair", paraMap, view);
        } else if ("corp_inthotel".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "inthotel", paraMap, view);
        } else if ("corp_hotel".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "hotel", paraMap, view);
        } else if ("corp_car".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "car", paraMap, view);
        } else if ("corp_train".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "train", paraMap, view);
        } else if ("corp_home".equalsIgnoreCase(key)) {
            TripCommonUtil.openURL("corp", "home", paraMap, view);
        } else if (key != null && key.contains("travelnoone")) {
            HashMap travelnooneMap = Maps.newHashMapWithExpectedSize((int)16);
            travelnooneMap.put("travelnoone_domair", "domair");
            travelnooneMap.put("travelnoone_hotel", "hotel");
            travelnooneMap.put("travelnoone_car", "car");
            travelnooneMap.put("travelnoone_train", "train");
            travelnooneMap.put("travelnoone_meal", "meal");
            travelnooneMap.put("travelnoone_list", "orderlist");
            travelnooneMap.put("travelnoone_home", "home");
            String businessType = (String)travelnooneMap.get(key);
            if (businessType != null) {
                TripCommonUtil.openURL(Supplier.CHAILVYIHAO.name(), businessType, paraMap, view);
            }
        } else if (key != null && key.contains("didi")) {
            HashMap huiTongMap = Maps.newHashMapWithExpectedSize((int)16);
            huiTongMap.put("didi_plane", "domair");
            String businessType = (String)huiTongMap.get(key);
            if (businessType != null) {
                TripCommonUtil.openURL(Supplier.DIDI.name(), businessType, paraMap, view);
            }
        } else if (key != null && StringUtils.isNotEmpty((String)key) && key.contains("dtg")) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            Object billNo = paraMap.get("applyBillNumber");
            map.put("isPC", paraMap.get("isPC"));
            boolean isProductHome = true;
            if (billNo != null) {
                isProductHome = false;
            }
            switch (key) {
                case "dtg_home": {
                    map.put("entrance", 0);
                    break;
                }
                case "dtg_plane_in": {
                    map.put("entrance", 11);
                    if (isProductHome) break;
                    map.put("entrance", 111);
                    map.put("entranceParam", billNo);
                    break;
                }
                case "dtg_plane_out": {
                    map.put("entrance", 22);
                    if (isProductHome) break;
                    map.put("entrance", 221);
                    map.put("entranceParam", billNo);
                    break;
                }
                case "dtg_hotel_in": {
                    map.put("entrance", 33);
                    if (isProductHome) break;
                    map.put("entrance", 331);
                    map.put("entranceParam", billNo);
                    break;
                }
                case "dtg_hotel_out": {
                    map.put("entrance", 44);
                    if (isProductHome) break;
                    map.put("entrance", 441);
                    map.put("entranceParam", billNo);
                    break;
                }
                case "dtg_train": {
                    map.put("entrance", 55);
                    if (isProductHome) break;
                    map.put("entrance", 551);
                    map.put("entranceParam", billNo);
                    break;
                }
                case "dtg_car": {
                    map.put("entrance", 66);
                    if (isProductHome) break;
                    map.put("entrance", 661);
                    map.put("entranceParam", billNo);
                    break;
                }
                case "dtg_list": {
                    map.put("entrance", 80);
                }
            }
            map.put("view", view);
            TripCommonUtil.invoke(Supplier.TONGCHENG.getValue(), null, null, TripMappingNumber.DTG_LOGIN.getCode(), map);
        } else if (key != null && StringUtils.isNotEmpty((String)key) && key.contains("ali")) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            Object billNo = paraMap.get("applyBillNumber");
            Boolean isPC = paraMap.get("isPC") != null && (Boolean)paraMap.get("isPC") != false;
            int action_type = 7;
            int type = 1;
            switch (key) {
                case "ali_home": {
                    action_type = isPC != false ? 7 : 4;
                    break;
                }
                case "ali_plane": {
                    action_type = isPC != false ? 10 : 1;
                    type = 1;
                    break;
                }
                case "ali_hotel": {
                    action_type = isPC != false ? 10 : 1;
                    type = 3;
                    break;
                }
                case "ali_train": {
                    action_type = isPC != false ? 10 : 1;
                    type = 2;
                    break;
                }
                case "ali_car": {
                    action_type = 1;
                    type = 4;
                    break;
                }
                case "ali_list": {
                    action_type = 14;
                }
            }
            map.put("action_type", action_type);
            map.put("type", type);
            map.put("applyBillNumber", billNo);
            map.put("itinerary_id", billNo);
            map.put("view", view);
            TripCommonUtil.invoke(Supplier.ALI.getValue(), "er_triplogin", null, null, map);
        } else if (key != null && StringUtils.isNotEmpty((String)key) && key.contains("qicheng_")) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            Object billNo = paraMap.get("applyBillNumber");
            map.put("businessType", key.replace("qicheng_", ""));
            map.put("client", RequestContext.get().getClient());
            map.put("isPC", paraMap.get("isPC") != null && (Boolean)paraMap.get("isPC") != false);
            map.put("oaBillNum", billNo);
            try {
                if (key.contains("domair") || key.contains("intair") || key.contains("train") || key.contains("car")) {
                    if (null != paraMap.get("from")) {
                        map.put("departName", URLEncoder.encode(((String)paraMap.get("from")).trim(), StandardCharsets.UTF_8.name()));
                    }
                    if (null != paraMap.get("to")) {
                        map.put("arriveName", URLEncoder.encode(((String)paraMap.get("to")).trim(), StandardCharsets.UTF_8.name()));
                    }
                    map.put("departDate", paraMap.get("startDate"));
                    map.put("returnDate", paraMap.get("endDate"));
                }
                if (key.contains("hotel")) {
                    if (null != paraMap.get("to")) {
                        map.put("cityName", URLEncoder.encode(((String)paraMap.get("to")).trim(), StandardCharsets.UTF_8.name()));
                    }
                    map.put("checkInDate", paraMap.get("startDate"));
                    map.put("checkOutDate", paraMap.get("endDate"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            logger.info("qicheng \u5355\u70b9\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)map));
            map.put("view", view);
            TripCommonUtil.invoke(Supplier.QICHENG.getValue(), "er_triplogin", null, null, map);
        } else if (key != null && StringUtils.isNotEmpty((String)key) && key.contains("meiya")) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            Object billNo = paraMap.get("applyBillNumber");
            Boolean isPC = paraMap.get("isPC") != null && (Boolean)paraMap.get("isPC") != false;
            String pageCode = "I";
            switch (key) {
                case "meiya_home": {
                    pageCode = "I";
                    break;
                }
                case "meiya_plane": {
                    pageCode = isPC != false ? "FI" : "F";
                    break;
                }
                case "meiya_hotel": {
                    pageCode = isPC != false ? "HC" : "H";
                    break;
                }
                case "meiya_train": {
                    pageCode = isPC != false ? "TI" : "T";
                    break;
                }
                case "meiya_list": {
                    pageCode = "L";
                }
            }
            map.put("pageCode", pageCode);
            map.put("applyBillNumber", billNo);
            map.put("orderNo", billNo);
            map.put("view", view);
            map.put("isPC", isPC);
            TripCommonUtil.invoke(Supplier.MEIYA.getValue(), "er_triplogin", null, null, map);
        }
    }

    public static void openURL(String businessSys, String businessType, Map<String, Object> params, IFormView view) {
        QFilter[] qFilters;
        params.put("businessType", businessType);
        params.put("view", view);
        String tripflag = "";
        if (businessSys.equals("bee") || businessSys.equals(Supplier.ZHONGXING.name())) {
            tripflag = ETripName;
        } else if (businessSys.equals("corp") || businessSys.equals(Supplier.XIECHENG.name())) {
            tripflag = CTripName;
        } else if (businessSys.equals(Supplier.CHAILVYIHAO.name())) {
            if (params.get("employeeNumber") == null) {
                qFilters = new QFilter[]{new QFilter("id", "=", (Object)CommonServiceHelper.getCurrentUserID())};
                DynamicObject userObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"number", (QFilter[])qFilters);
                params.put("number", userObject.getString("number"));
            }
            tripflag = TTripName;
        } else if (businessSys.equals(Supplier.DIDI.name())) {
            tripflag = DiDiTripName;
        } else if (businessSys.equals(Supplier.MEITUAN.name())) {
            if (params.get("employeeNumber") == null) {
                qFilters = new QFilter[]{new QFilter("id", "=", (Object)CommonServiceHelper.getCurrentUserID())};
                DynamicObject userObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"number", (QFilter[])qFilters);
                params.put("employeeNumber", userObject.getString("number"));
            }
            tripflag = MeiTuanTripName;
        }
        ITripService tripService = TripServiceFactory.getTripService(tripflag);
        tripService.login(params);
    }

    public static boolean isCurrentUserLeader(Long userID) {
        boolean result = false;
        List orgList = UserServiceHelper.getMangedOrgsOfUser((long)userID);
        if (orgList.size() > 0) {
            result = true;
        }
        return result;
    }

    public static Map<String, String> getInvoiceInfoByOperation(String server, String operationtype) {
        List<Map<String, String>> invoiceSetting = GenerateInvoicerAssistant.getInvoiceSetting(server, null);
        Map<Object, List<Map>> invoiceSetGroup = invoiceSetting.stream().collect(Collectors.groupingBy(v -> (String)v.get("operationtype")));
        List<Map> invoiceSetByOperation = invoiceSetGroup.get(operationtype);
        HashMap invoiceSetMap = Maps.newHashMapWithExpectedSize((int)16);
        boolean isdeductible = false;
        if (invoiceSetByOperation != null) {
            for (Map invoiceSet : invoiceSetByOperation) {
                if (isdeductible) continue;
                isdeductible = Boolean.parseBoolean((String)invoiceSet.get("isdeductible"));
            }
        }
        invoiceSetMap.put("isdeductible", String.valueOf(isdeductible));
        return invoiceSetMap;
    }

    public static String getTravelNoOneApiUrl(String urlSign) {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        if (supplierMap == null || supplierMap.size() < 1 || supplierMap.get("reservedfield2") == null) {
            return "";
        }
        String url = supplierMap.get("reservedfield2") + (String)ExternalConstants.TRAVELNOONEURLMAP.get(urlSign);
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u63a5\u53e3url,\u63a5\u53e3[%s],\u5bf9\u5e94\u7684url: %s", urlSign, url));
        return url;
    }

    public static boolean validateBizInfo(String key, IFormView view) {
        boolean isCancel = false;
        HashMap serevrMap = Maps.newHashMapWithExpectedSize((int)16);
        serevrMap.put("bee", Supplier.ZHONGXING.getValue());
        serevrMap.put("corp", Supplier.XIECHENG.getValue());
        serevrMap.put("travelnoone", Supplier.CHAILVYIHAO.getValue());
        serevrMap.put("gaode", Supplier.GAODE.getValue());
        for (Map.Entry entry : serevrMap.entrySet()) {
            Map<String, String> paraMap;
            String number;
            Boolean isExistsServer;
            String serverKey = (String)entry.getKey();
            if (!key.contains(serverKey) || !(isExistsServer = TripCommonUtil.isEnbleServer(number = (String)serevrMap.get(serverKey))).booleanValue() || (paraMap = TripCommonUtil.getTripServiceInfo(number)) == null || !paraMap.get("appsecurity").isEmpty() && !paraMap.get("appkey").isEmpty() && !paraMap.get("reservedfield1").isEmpty()) continue;
            view.showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5546\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TripCommonUtil_3", (String)"fi-er-business", (Object[])new Object[0]));
            isCancel = true;
        }
        return isCancel;
    }

    @Deprecated
    public static void pushReqbillToMQ(Object reqBill, String approveType, String syncStatus, String operationType) {
    }

    public static void pushReqbillToMQ(String billtype, Long paramBillId, String operationType, String approveType, String syncStatus) {
        HashMap msgMap = Maps.newHashMapWithExpectedSize((int)16);
        msgMap.put("billType", billtype);
        msgMap.put("billId", paramBillId);
        msgMap.put("operationType", operationType);
        msgMap.put("approveType", approveType);
        msgMap.put("syncStatus", syncStatus);
        ErMessagePublisher.publishMessageToMq("fi", "fi.er.tripsync.tripReqBill.push", msgMap);
    }

    public static void pushDailyVehicleBillToMQ(String billtype, Long paramBillId, String operationType, String syncStatus) {
        HashMap msgMap = Maps.newHashMapWithExpectedSize((int)16);
        msgMap.put("billType", billtype);
        msgMap.put("billId", paramBillId);
        msgMap.put("operationType", operationType);
        msgMap.put("syncStatus", syncStatus);
        ErMessagePublisher.publishMessageToMq("fi", "fi.er.tripsync.dailyvehiclebill.push", msgMap);
    }

    public static void pushDailyApplBill(String billType, Long paramBillId, String operationType, String syncStatus) {
        Boolean isEnble = TripCommonUtil.isEnbleServer(Supplier.CHAILVYIHAO.name());
        if (!isEnble.booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u670d\u52a1\u5546\u672a\u542f\u7528\uff0c\u8d39\u7528\u7533\u8bf7\u5355\u540c\u6b65\u672a\u6267\u884c");
            return;
        }
        Set<Long> applyBillIds = new HashSet<Long>();
        applyBillIds.add(paramBillId);
        if ("er_publicreimbursebill".equals(billType)) {
            Map sourceBillMap = BFTrackerServiceHelper.findSourceBills((String)"er_publicreimbursebill", (Long[])new Long[]{paramBillId});
            if (sourceBillMap == null || sourceBillMap.size() < 1) {
                return;
            }
            applyBillIds = (Set)sourceBillMap.get("er_dailyapplybill");
        }
        if (applyBillIds == null || applyBillIds.size() < 1) {
            return;
        }
        DynamicObject[] applyBills = (DynamicObject[])QueryServiceHelper.query((String)"er_dailyapplybill", (String)"id,reimbursetype,billno,company", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)}).toArray((Object[])new DynamicObject[0]);
        if (applyBills == null || applyBills.length == 0) {
            logger.error("\u8d39\u7528\u7533\u8bf7\u5355\u540c\u6b65,\u8d39\u7528\u7533\u8bf7\u5355\u4e0d\u5b58\u5728" + paramBillId);
            return;
        }
        for (DynamicObject applyBill : applyBills) {
            Object companyId = applyBill.get("company");
            if (companyId == null || !SystemParamterUtil.getMeettingToTrip(ErCommonUtils.getPk(companyId))) {
                logger.info("\u8d39\u7528\u7533\u8bf7\u5355\u540c\u6b65,\u4f1a\u8bae\u8d39\u3001\u62db\u5f85\u8d39\u672a\u5f00\u542f\u5546\u65c5\u9884\u8ba2");
                continue;
            }
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("billno", applyBill.getString("billno"));
            if ("1".equals(syncStatus)) {
                TripCommonUtil.invoke(Supplier.CHAILVYIHAO.getValue(), "er_dailyapplybill", syncStatus, null, params);
                continue;
            }
            if (!"2".equals(syncStatus) && !"3".equals(syncStatus)) continue;
            params.put("data.validStatus", "3".equals(syncStatus) ? 1 : 2);
            TripCommonUtil.invoke(Supplier.CHAILVYIHAO.getValue(), "er_dailyapplybill", "2", "T_UpdateMeetOrEntertain", params);
        }
    }

    public static Date convertToDate(String time) {
        Date date = null;
        if (time == null || time.isEmpty()) {
            return date;
        }
        try {
            if (time.length() == 23) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(time);
            }
            if (time.length() == 19) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
            } else if (time.length() == 16) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(time);
            } else if (time.length() == 10) {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(time);
            } else if (time.length() == 7) {
                date = new SimpleDateFormat("yyyy-MM").parse(time);
            } else if (time.length() == 12) {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(time);
            }
        }
        catch (ParseException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,String\u8f6c\u5316\u6210\u4e3aDate\u5931\u8d25:", (Throwable)e);
        }
        return date;
    }

    public static String date2TimeStamp(String date_str, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return String.valueOf(sdf.parse(date_str).getTime());
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u65e5\u671f\u683c\u5f0f\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u65f6\u95f4\u6233\u5931\u8d25:", (Throwable)e);
            return "";
        }
    }

    public static Date addDayByDate(Date date, int i) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, i);
        return c.getTime();
    }

    public static Date addDayByHour(Date date, int i) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, i);
        return c.getTime();
    }

    public static String date2TimeStamp(Date date, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            String timeStamp = sdf.format(date);
            return timeStamp;
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u65e5\u671f\u8f6c\u5b57\u7b26\u4e32\u5931\u8d25:", (Throwable)e);
            return "";
        }
    }

    public static Date strToDate(String string, String formatStr) {
        Date date = null;
        if (StringUtils.isNotEmpty((String)string)) {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            try {
                date = sdf.parse(string);
            }
            catch (ParseException e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f\u5931\u8d25:", (Throwable)e);
            }
        }
        return date;
    }

    public static Date strToDate(String str, String pattern, Locale locale) {
        if (str == null || pattern == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(pattern, locale).parse(str);
        }
        catch (ParseException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    public static String getLastMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        String lastMonth = sdf.format(c.getTime());
        return lastMonth;
    }

    public static Date getLastMonthDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        return c.getTime();
    }

    public static String getMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMinimum(5));
        SimpleDateFormat firstDay = new SimpleDateFormat("yyyy-MM-dd");
        return firstDay.format(calendar.getTime());
    }

    public static String getLastMonthFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, 1);
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getLastMonthFirstDay(Date date) {
        Calendar cal = Calendar.getInstance();
        if (null == date) {
            return "";
        }
        cal.setTime(date);
        cal.add(2, -1);
        cal.set(5, 1);
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getLastMonthLastDay(Date date) {
        Calendar cal = Calendar.getInstance();
        if (null == date) {
            return "";
        }
        cal.setTime(date);
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getMonthFirstDay(Date date) {
        Calendar cal = Calendar.getInstance();
        if (null == date) {
            return "";
        }
        cal.setTime(date);
        cal.set(5, 1);
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getMonthLastDay(Date date) {
        Calendar cal = Calendar.getInstance();
        if (null == date) {
            return "";
        }
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(cal.getTime());
    }

    public static String getLastMonthLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static Date getLastDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -1);
        Date lastDay = c.getTime();
        return lastDay;
    }

    public static Date delayByMonth(Date date, int delayMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        cal.set(2, month + delayMonth);
        return cal.getTime();
    }

    public static String dateStr2DateStr(String str, String dataFormat, String dataFormat2) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dataFormat);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(dataFormat2);
        try {
            Date parse = simpleDateFormat.parse(str);
            return simpleDateFormat2.format(parse);
        }
        catch (ParseException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u65e5\u671f\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f\u5b57\u7b26\u4e32\u5931\u8d25:", (Throwable)e);
            return "";
        }
    }

    public static String timeStamp2DateStr(String seconds, String format) {
        if (seconds == null || seconds.isEmpty() || seconds.equals("null")) {
            return "";
        }
        if (seconds.length() == 10) {
            seconds = seconds + "000";
        }
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(Long.parseLong(seconds)));
    }

    public static Date timeStamp2Date(String seconds, String format) {
        return TripCommonUtil.convertToDate(TripCommonUtil.timeStamp2DateStr(seconds, format));
    }

    public static Date getLastMonthFirstDayByStr(String str) {
        Date date = TripCommonUtil.convertToDate(str);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static String DateToStr(Date date) {
        if (date == null) {
            return "";
        }
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String DateToShortStr(Date date) {
        if (date == null) {
            return "";
        }
        String format = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Map<String, String> getStandtripsrevice() {
        return standTripSrevice;
    }

    public static Map<String, String> getStandtripname() {
        return standTripName;
    }

    public static DynamicObject checkUserSync(String supplierName) {
        QFilter qFilter = new QFilter("number", "=", (Object)(supplierName + "_" + userInvoke));
        QFilter valueQFilter = new QFilter("value", "=", (Object)"true");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"er_tripsync_setting", (String)"number, value", (QFilter[])new QFilter[]{qFilter, valueQFilter});
        return dynamicObject;
    }

    public static boolean isInitTime(Date date) {
        return date == null || date.before(ErCommonUtils.getDateFromLocalDate(LocalDate.of(2000, 1, 1)));
    }

    public static String getUserSyncLockKey(String supplier) {
        return new StringBuilder(100).append(CacheKeyUtil.getAcctId()).append("_fi_er_usersync_").append(supplier).toString();
    }

    public static String getSyncLockKey(Map<String, Object> params, String type) {
        String tool = "";
        if (null == params) {
            return null;
        }
        if (null != params.get("notDeedLock") && ((Boolean)params.getOrDefault("notDeedLock", Boolean.FALSE)).booleanValue()) {
            return null;
        }
        if (null != params && null != params.get("istool") && ((Boolean)params.getOrDefault("istool", Boolean.FALSE)).booleanValue()) {
            tool = "tool";
        }
        DynamicObject fieldmap = (DynamicObject)params.get("fieldmap");
        String function = fieldmap.getDynamicObject("function").getString("number");
        String number = fieldmap.getString("number");
        String trip_nolock_form = TripSyncConfigUtil.getTripsyncSettingByKey("trip_nolock_form");
        if (null != trip_nolock_form && Arrays.stream(trip_nolock_form.split(",")).anyMatch(b -> b.equals(function))) {
            return null;
        }
        String server = fieldmap.getDynamicObject("server").getString("number");
        return new StringBuilder(100).append(CacheKeyUtil.getAcctId()).append("_fi_er_sync_").append(tool).append(type).append(server).append(function).append(number).toString();
    }

    public static boolean checkTripExistOrder(Long id, Long entryId) {
        if (id == null || id == 0L || entryId == null || entryId == 0L) {
            return false;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject == null) {
            return false;
        }
        String billno = dynamicObject.getString("billno");
        QFilter oabillnum = new QFilter("oabillnum", "=", (Object)billno);
        QFilter tripid = new QFilter("tripid", "=", (Object)String.valueOf(entryId));
        QFilter[] qFilters = new QFilter[]{oabillnum, tripid};
        for (String s : Arrays.asList("er_planebill", "er_hotelbill", "er_vehiclebill", "er_trainbill")) {
            if (QueryServiceHelper.queryOne((String)s, (String)"id", (QFilter[])qFilters) == null) continue;
            return true;
        }
        return false;
    }

    public static void pushMealApplicationBillToMQ(String billType, Long billId, String operationType, String syncStatus) {
        HashMap<String, Object> msgMap = new HashMap<String, Object>(4);
        msgMap.put("billType", billType);
        msgMap.put("billId", billId);
        msgMap.put("operationType", operationType);
        msgMap.put("syncStatus", syncStatus);
        ErMessagePublisher.publishMessageToMq("fi", TripSyncMqConstants.MEAL_APPLICATIONBILL_PUSH, msgMap);
    }

    public static DynamicProperty getDataTye(DynamicObjectType type, String queryfield) {
        DynamicProperty property = type.getProperty(queryfield);
        if (queryfield.contains(".") && null == property) {
            String[] as = queryfield.split("\\.");
            String a1 = as[0];
            StringBuilder newfields = new StringBuilder();
            for (int i = 1; i < as.length; ++i) {
                newfields.append(as[i]);
                newfields.append(".");
            }
            DynamicProperty subproperty = type.getProperty(a1);
            if (subproperty instanceof BasedataProp) {
                DynamicObjectType dynamicObjectType = ((BasedataProp)subproperty).getDynamicComplexPropertyType();
                return TripCommonUtil.getDataTye(dynamicObjectType, newfields.substring(0, newfields.toString().length() - 1));
            }
            if (subproperty instanceof EntryProp) {
                DynamicObjectType dynamicObjectType = ((EntryProp)subproperty).getDynamicCollectionItemPropertyType();
                return TripCommonUtil.getDataTye(dynamicObjectType, newfields.substring(0, newfields.toString().length() - 1));
            }
            if (subproperty instanceof MulBasedataProp) {
                DynamicObjectType dynamicObjectType = ((MulBasedataProp)subproperty).getDynamicCollectionItemPropertyType();
                return TripCommonUtil.getDataTye(dynamicObjectType, newfields.substring(0, newfields.toString().length() - 1));
            }
        }
        return property;
    }

    public static String getPkeyByMapsource(DynamicObjectCollection dynamicObjects) {
        if (null == dynamicObjects) {
            return null;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Boolean mapprimarykey;
            if (!"1".equals(dynamicObject.getString("mapstatus"))) continue;
            String field = "";
            field = StringUtils.isNotEmpty((String)dynamicObject.getString("mapsourcefield")) ? dynamicObject.getString("mapsourcefield") : dynamicObject.getString("maptargetfield");
            if (StringUtils.isNotEmpty((String)dynamicObject.getString("mapsourcefieldext"))) {
                field = dynamicObject.getString("mapsourcefieldext");
            }
            if (!(mapprimarykey = Boolean.valueOf(dynamicObject.getBoolean("mapprimarykey"))).booleanValue()) continue;
            return field;
        }
        return null;
    }

    public static Integer dealInvoiceType(Integer invoiceType) {
        Integer[] invoice = new Integer[]{1, 2, 4, 82, 81};
        if (invoiceType == null || !Arrays.asList(invoice).contains(invoiceType)) {
            return 9999;
        }
        switch (invoiceType) {
            case 1: 
            case 4: 
            case 82: {
                return 1;
            }
            case 2: 
            case 81: {
                return 2;
            }
        }
        return 9999;
    }

    public static String isMulBasedataProp(DynamicObjectType type, String queryfield) {
        String[] as;
        String a1;
        DynamicProperty subproperty;
        DynamicProperty property = type.getProperty(queryfield);
        if (queryfield.contains(".") && null == property && (subproperty = type.getProperty(a1 = (as = queryfield.split("\\."))[0])) instanceof MulBasedataProp && queryfield.endsWith(".id")) {
            StringBuilder stringBuilder = new StringBuilder(queryfield);
            int index = stringBuilder.lastIndexOf(".id");
            int length = stringBuilder.length();
            stringBuilder.replace(index, length, ".fbasedataid");
            return stringBuilder.toString();
        }
        return queryfield;
    }

    public static void updateLastsyncPeopleTampByOrg(String serverNumber, Long orgId, Date syncTime) {
        DynamicObject server = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"entryentity,entryentity.org,entryentity.lastsyncstamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serverNumber)});
        DynamicObjectCollection entryentity = server.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryentity) {
            if (!orgId.equals(ErCommonUtils.getPk(dynamicObject.getDynamicObject("org")))) continue;
            dynamicObject.set("lastsyncstamp", (Object)syncTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{server});
            return;
        }
    }

    public static String getReimburseType(String reimbursetype) {
        if ("meetting".equals(reimbursetype) || "meetting_bill".equals(reimbursetype)) {
            return "7";
        }
        if ("entertainment".equals(reimbursetype) || "entertainment_bill".equals(reimbursetype)) {
            return "6";
        }
        return "";
    }

    public static void openFieldMappingLogin(IFormView view, String key, String server) {
        String formid = "";
        if (key.endsWith("_car")) {
            formid = "er_trip_vehiclelogin";
        }
        if (key.endsWith("_list")) {
            formid = "er_trip_orderlogin";
        }
        if (key.endsWith("_domair")) {
            formid = "er_trip_planelogin";
        }
        if (key.endsWith("_hotel")) {
            formid = "er_trip_hotellogin";
        }
        if (key.endsWith("_train")) {
            formid = "er_trip_trainlogin";
        }
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("view", view);
        TripCommonUtil.invoke(server, formid, null, null, params);
    }

    public static void filter(Map<String, Object> jsonMap, List<Map<String, String>> filters, JSONObject json) {
        HashSet<String> deletekeys = new HashSet<String>(jsonMap.size());
        ArrayList<Map<String, String>> nobfilters = new ArrayList<Map<String, String>>(filters.size());
        ArrayList<Map<String, String>> bfilters = new ArrayList<Map<String, String>>(filters.size());
        Boolean isbracket = Boolean.FALSE;
        HashMap<String, String> andMap = new HashMap<String, String>(16);
        for (int z = 0; z < filters.size(); ++z) {
            Map<String, String> filter = filters.get(z);
            String leftbracket = filter.get("leftbracket");
            String rightbracket = filter.get("rightbracket");
            filter.put("seq", "" + z);
            if ("(".equals(leftbracket)) {
                bfilters.add(filter);
                isbracket = Boolean.TRUE;
                andMap.put("fandor", z == 0 ? "null" : filters.get(z - 1).get("logic"));
                andMap.put("fseq", "" + z);
                continue;
            }
            if (isbracket.booleanValue()) {
                bfilters.add(filter);
                if (!")".equals(rightbracket)) continue;
                isbracket = Boolean.FALSE;
                andMap.put("landor", z == filters.size() - 1 ? "null" : filters.get(z).get("logic"));
                andMap.put("lseq", "" + z);
                continue;
            }
            nobfilters.add(filter);
        }
        Iterator<Map.Entry<String, Object>> jsoniterator = jsonMap.entrySet().iterator();
        HashMap<String, Integer> keynumMap = new HashMap<String, Integer>(8);
        HashMap<String, Integer> delkeynumMap = new HashMap<String, Integer>(8);
        while (jsoniterator.hasNext()) {
            Integer num;
            String numkey;
            Map.Entry<String, Object> jnext = jsoniterator.next();
            String jkey = jnext.getKey();
            String zkey = JsonHelper.getZeroKey(jkey);
            Object jvalue = jnext.getValue();
            String curLastkey = jkey;
            if (jkey.contains("].")) {
                curLastkey = jkey.substring(0, jkey.lastIndexOf("].") + 2);
                numkey = curLastkey.substring(0, curLastkey.lastIndexOf(".["));
                num = keynumMap.get(numkey = numkey.substring(numkey.lastIndexOf(".") + 1)) == null ? Integer.valueOf(0) : (Integer)keynumMap.get(numkey);
                keynumMap.put(numkey, num + 1);
            }
            if (null == jvalue) {
                jvalue = "";
            }
            if (deletekeys.contains(curLastkey)) {
                if (!curLastkey.contains("].")) continue;
                numkey = curLastkey.substring(0, curLastkey.lastIndexOf(".["));
                num = delkeynumMap.get(numkey = numkey.substring(numkey.lastIndexOf(".") + 1)) == null ? Integer.valueOf(0) : (Integer)delkeynumMap.get(numkey);
                delkeynumMap.put(numkey, num + 1);
                continue;
            }
            Boolean iscondition = Boolean.TRUE;
            HashSet<Boolean> isconditions = new HashSet<Boolean>();
            if (!(iscondition = TripCommonUtil.getaBoolean(bfilters, zkey, jvalue, iscondition, isconditions, andMap)).booleanValue() || !"or".equals(andMap.get("fandor")) && !"or".equals(andMap.get("landor"))) {
                iscondition = TripCommonUtil.getaBoolean(nobfilters, zkey, jvalue, iscondition, isconditions, andMap);
            } else {
                isconditions.clear();
            }
            if (iscondition.booleanValue()) continue;
            deletekeys.add(curLastkey);
            if (!curLastkey.contains("].")) continue;
            String numkey2 = curLastkey.substring(0, curLastkey.lastIndexOf(".["));
            Integer num2 = delkeynumMap.get(numkey2 = numkey2.substring(numkey2.lastIndexOf(".") + 1)) == null ? Integer.valueOf(0) : (Integer)delkeynumMap.get(numkey2);
            delkeynumMap.put(numkey2, num2 + 1);
        }
        for (Map.Entry next : delkeynumMap.entrySet()) {
            String key = (String)next.getKey();
            Integer value = (Integer)next.getValue();
            if (!((Integer)keynumMap.get(key)).equals(value)) continue;
            deletekeys.add(key);
        }
        Long s1 = System.currentTimeMillis();
        TreeSet<String> sortedSet = new TreeSet<String>((o1, o2) -> o2.compareTo((String)o1));
        sortedSet.addAll(deletekeys);
        for (String deletekey : sortedSet) {
            Object ob = json;
            String[] keyarr = deletekey.split("\\.");
            if (!deletekey.contains("]")) {
                json.clear();
                return;
            }
            String lasterarrkey = deletekey.substring(0, deletekey.lastIndexOf(".["));
            lasterarrkey = lasterarrkey.substring(lasterarrkey.lastIndexOf(".") + 1);
            Boolean islastkey = Boolean.FALSE;
            for (int i = 0; i < keyarr.length; ++i) {
                String s = keyarr[i];
                if (s.contains("]")) {
                    String z = s.replaceAll("\\[", "");
                    z = z.replaceAll("]", "");
                    if (islastkey.booleanValue()) {
                        ((JSONObject)((JSONArray)ob).get(Integer.parseInt(z))).clear();
                        continue;
                    }
                    ob = ((JSONArray)ob).get(Integer.parseInt(z));
                    continue;
                }
                if (ob instanceof JSONObject) {
                    islastkey = s.equals(lasterarrkey);
                    ob = ob.get((Object)s);
                    continue;
                }
                if (!(ob instanceof JSONArray)) continue;
                islastkey = s.equals(lasterarrkey);
            }
        }
    }

    public static Boolean getaBoolean(List<Map<String, String>> bfilters, String zkey, Object jvalue, Boolean iscondition, Set<Boolean> isconditions, Map<String, String> andMap) {
        Boolean isBracket = Boolean.FALSE;
        for (int i = 0; i < bfilters.size(); ++i) {
            Map<String, String> filter = bfilters.get(i);
            String field = filter.get("field");
            String fvalue = filter.get("value");
            String seq = filter.get("seq");
            String filtercondition = filter.get("condition");
            String filterleftbracket = filter.get("leftbracket");
            String filterlogic = filter.get("logic");
            String zfield = JsonHelper.getZeroKey(field);
            if (!zfield.equals(zkey)) continue;
            iscondition = TripCommonUtil.getIscondition(jvalue, iscondition, fvalue, filtercondition);
            String logic = filterlogic;
            if ("(".equals(filterleftbracket)) {
                isBracket = Boolean.TRUE;
            }
            if (isBracket.booleanValue()) {
                if (i != 0) {
                    logic = bfilters.get(i - 1).get("logic");
                }
            } else if (null != andMap.get("lseq") && !andMap.get("lseq").trim().isEmpty() && Integer.parseInt(seq) - Integer.parseInt(andMap.get("lseq")) == 1) {
                logic = andMap.get("landor");
            } else if (i != 0) {
                logic = bfilters.get(i - 1).get("logic");
            }
            andMap.put("andor", filterlogic);
            isconditions.add(iscondition);
            if ("or".equals(logic)) {
                iscondition = isconditions.contains(Boolean.TRUE);
                if (!iscondition.booleanValue()) continue;
                break;
            }
            iscondition = !isconditions.contains(Boolean.FALSE);
            if (!iscondition.booleanValue()) continue;
            isconditions.clear();
        }
        return iscondition;
    }

    public static Boolean getIscondition(Object jvalue, Boolean iscondition, String fvalue, String filtercondition) {
        if (null == filtercondition) {
            iscondition = jvalue.toString().equals(fvalue);
        } else {
            switch (filtercondition) {
                case "=": {
                    iscondition = jvalue.toString().equals(fvalue);
                    break;
                }
                case ">": {
                    if (jvalue instanceof Date) {
                        iscondition = ((Date)jvalue).after(TripCommonUtil.strToDate(fvalue, "yyyy-MM-dd HH:mm:ss"));
                        break;
                    }
                    iscondition = new BigDecimal(jvalue.toString()).compareTo(new BigDecimal(fvalue)) > 0;
                    break;
                }
                case "<": {
                    if (jvalue instanceof Date) {
                        iscondition = ((Date)jvalue).before(TripCommonUtil.strToDate(fvalue, "yyyy-MM-dd HH:mm:ss"));
                        break;
                    }
                    iscondition = new BigDecimal(jvalue.toString()).compareTo(new BigDecimal(fvalue)) < 0;
                    break;
                }
                case "!=": {
                    iscondition = !jvalue.toString().equals(fvalue);
                    break;
                }
                case "in": {
                    iscondition = Arrays.asList(fvalue.split(",")).contains(jvalue.toString());
                    break;
                }
                case "is null": {
                    iscondition = jvalue.toString().trim().isEmpty();
                    break;
                }
                case "is not null": {
                    iscondition = !jvalue.toString().trim().isEmpty();
                }
            }
        }
        return iscondition;
    }

    public static Boolean reqBookIsEnableServer(boolean isPc) {
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        List stdServers = Arrays.stream(Supplier.values()).map(Supplier::getValue).collect(Collectors.toList());
        Map allServers = BusinessDataServiceHelper.loadFromCache((String)"er_biz_info", (String)"number", (QFilter[])new QFilter[]{qA});
        List serverNumbes = allServers.values().stream().map(v -> v.getString("number")).collect(Collectors.toList());
        serverNumbes.removeAll(stdServers);
        QFilter qb = null;
        if (!isPc) {
            serverNumbes.addAll(Arrays.asList("CHAILVYIHAO", "ZHONGXING", "XIECHENG", "DIDI", "TONGCHENG", "ALI", "QICHENG", "MEIYA"));
            qb = new QFilter("number", "in", serverNumbes);
        } else {
            serverNumbes.addAll(Arrays.asList("CHAILVYIHAO", "ZHONGXING", "XIECHENG", "TONGCHENG", "ALI", "QICHENG", "MEIYA"));
            qb = new QFilter("number", "in", serverNumbes);
        }
        QFilter[] qFilters = new QFilter[]{qA, qb};
        return TripCommonUtil.reqBtnIsVisible(qFilters);
    }

    public static Boolean reqBtnIsVisible(QFilter[] qFilters) {
        return QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])qFilters);
    }

    public static void tripBudgetPush(Object billId, String billno, String server, String status) {
        if (!server.equals(Supplier.XIECHENG.name())) {
            return;
        }
        if (!"1".equals(status)) {
            return;
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException | KDBizException e) {
            logger.info("\u9884\u7b97\u843d\u5730\uff0c\u6309\u643a\u7a0b\u8981\u6c42\u5ef6\u8fdf20s");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("billno", billno);
        Object list = TripCommonUtil.invoke(server, "er_tripreqbill", null, TripMappingNumber.C_BUDGET.getCode(), params);
        JSONObject result = TripCommonUtil.checkMappingInvokeResult(list);
        if (result != null) {
            return;
        }
        boolean isEnable = TripSyncConfigUtil.getBoolean("Ctrip_budget_interface");
        if (!isEnable) {
            return;
        }
        ITripService cTripService = TripServiceFactory.getTripService(CTripName);
        cTripService.budgetPush(billId, status);
    }

    public static JSONObject checkMappingInvokeResult(Object list) {
        if (!(list instanceof List)) {
            return null;
        }
        List ls = (List)list;
        Map result = (Map)ls.get(0);
        if (result == null || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) {
            return null;
        }
        return new JSONObject(result);
    }

    public static boolean checkCTripReqResult(Map<String, Object> result) {
        JSONObject jsonObject = new JSONObject(result);
        return jsonObject.getBoolean("success");
    }

    public static String getTraceidIndex(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        if (null == fieldmapping || null == fieldmapping.getString("number")) {
            return tripSyncLogParam.getTraceid();
        }
        String index = fieldmapping.getString("number") + tripSyncLogParam.getTraceid();
        return index;
    }

    public static DynamicObject getFieldmap(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!map.containsKey("params")) {
            return null;
        }
        Object paramsob = map.get("params");
        Map params = (Map)paramsob;
        if (!map.containsKey("params")) {
            return null;
        }
        if (!params.containsKey("fieldmap")) {
            return null;
        }
        DynamicObject fieldmapping = (DynamicObject)params.get("fieldmap");
        if (null == fieldmapping) {
            return null;
        }
        return fieldmapping;
    }

    public static Set<String> getOrderNums(Set<String> orderBills) {
        Iterator<String> iterator = orderBills.iterator();
        HashSet orderNumSet = Sets.newHashSetWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            String ordernum = iterator.next();
            int i = ordernum.indexOf("-");
            if (ordernum.contains("-")) {
                String newOrderNum = ordernum.substring(0, i);
                orderNumSet.add(newOrderNum);
                continue;
            }
            orderNumSet.add(ordernum);
        }
        return orderNumSet;
    }

    public static String getBookAbleProducts(String serverNum, Map<String, Long> orgIdAndCompanyIdMap, String formId) {
        String defaultValue = "";
        if ("er_tripreqbill".equals(formId)) {
            defaultValue = "1,2,3,4,5,6";
        }
        if ("er_dailyvehiclebill".equals(formId)) {
            defaultValue = "6";
        }
        try {
            String reslut;
            DynamicObject serverData = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"syncapplybilltype,id,applybilltypeentity.applybillorg,applybilltypeentity.applybilltype,applybilltypeentity.bookproducts", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serverNum)});
            int applyBillType = serverData.getInt("syncapplybilltype");
            if (applyBillType == 1) {
                return defaultValue;
            }
            DynamicObjectCollection entity = serverData.getDynamicObjectCollection("applybilltypeentity");
            if (applyBillType == 2) {
                if (CollectionUtils.isEmpty((Collection)entity)) {
                    return "";
                }
                DynamicObject dynamicObject = (DynamicObject)entity.get(0);
                if (TripCommonUtil.checkFormId(formId, entity)) {
                    return "";
                }
                return TripCommonUtil.dealResult(dynamicObject.getString("bookproducts"));
            }
            if (CollectionUtils.isEmpty((Collection)entity)) {
                return "";
            }
            if (orgIdAndCompanyIdMap.isEmpty()) {
                return "";
            }
            Long orgId = orgIdAndCompanyIdMap.get("orgId");
            Long companyId = orgIdAndCompanyIdMap.get("companyId");
            if (orgId == null && companyId == null) {
                return "";
            }
            Boolean orgIsNull = Boolean.FALSE;
            if (orgId == null) {
                orgIsNull = Boolean.TRUE;
            }
            ArrayList fitOrgList = Lists.newArrayListWithCapacity((int)16);
            if (!orgIsNull.booleanValue() && !StringUtils.isEmpty((String)(reslut = TripCommonUtil.getResult(formId, entity, orgId, fitOrgList)))) {
                return reslut;
            }
            String result = TripCommonUtil.getResult(formId, entity, companyId, fitOrgList);
            if (StringUtils.isNotEmpty((String)result)) {
                return result;
            }
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u53ef\u9884\u8ba2\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25", (Throwable)ex);
        }
        return defaultValue;
    }

    private static String getResult(String formId, DynamicObjectCollection entity, Long id, List<DynamicObject> fitOrgList) {
        for (DynamicObject dynamicObject : entity) {
            List formIds;
            DynamicObjectCollection applyBillTypeCollection;
            DynamicObjectCollection orgCollection = dynamicObject.getDynamicObjectCollection("applybillorg");
            if (orgCollection.isEmpty() || (applyBillTypeCollection = dynamicObject.getDynamicObjectCollection("applybilltype")).isEmpty() || !(formIds = applyBillTypeCollection.stream().filter(obj -> obj != null && obj.get("fbasedataid_id") != null).map(obj -> obj.get("fbasedataid_id").toString()).collect(Collectors.toList())).contains(formId)) continue;
            List<Object> orgFitResult = Lists.newArrayList();
            orgFitResult = orgCollection.stream().filter(org -> org != null && org.get("fbasedataid") != null && id.equals(ErCommonUtils.getPk(org.get("fbasedataid")))).collect(Collectors.toList());
            if (orgFitResult.isEmpty()) continue;
            fitOrgList.add(dynamicObject);
            break;
        }
        if (CollectionUtils.isNotEmpty(fitOrgList)) {
            DynamicObject dynamicObject = fitOrgList.get(0);
            return TripCommonUtil.dealResult(dynamicObject.getString("bookproducts"));
        }
        return null;
    }

    private static String dealResult(String products) {
        if (StringUtils.isEmpty((String)products)) {
            return "";
        }
        String[] productsArr = products.split(",");
        List list = Arrays.stream(productsArr).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return String.join((CharSequence)",", list);
    }

    public static boolean checkIsNeedBill(String serverNum, Map<String, Long> orgIdAndCompanyIdMap, String formId) {
        try {
            if (orgIdAndCompanyIdMap == null || orgIdAndCompanyIdMap.isEmpty()) {
                return Boolean.TRUE;
            }
            DynamicObject serverData = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"syncapplybilltype,id,applybilltypeentity.applybillorg,applybilltypeentity.applybilltype,applybilltypeentity.bookproducts", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serverNum)});
            int applyBillType = serverData.getInt("syncapplybilltype");
            if (applyBillType == 1) {
                return Boolean.TRUE;
            }
            DynamicObjectCollection entity = serverData.getDynamicObjectCollection("applybilltypeentity");
            if (applyBillType == 2) {
                if (CollectionUtils.isEmpty((Collection)entity)) {
                    return Boolean.FALSE;
                }
                if (TripCommonUtil.checkFormId(formId, entity)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (applyBillType == 3) {
                Map<String, Boolean> resultMap;
                Long orgId = orgIdAndCompanyIdMap.get("orgId");
                Long companyId = orgIdAndCompanyIdMap.get("companyId");
                if (orgId == null && companyId == null) {
                    return Boolean.TRUE;
                }
                Boolean orgIsNull = Boolean.FALSE;
                if (orgId == null) {
                    orgIsNull = Boolean.TRUE;
                }
                if (!orgIsNull.booleanValue() && (resultMap = TripCommonUtil.getBooleanResult(formId, entity, orgId)).get("org").booleanValue()) {
                    return resultMap.get("form");
                }
                Map<String, Boolean> res = TripCommonUtil.getBooleanResult(formId, entity, companyId);
                return res.get("form");
            }
        }
        catch (Exception ex) {
            logger.error("\u5224\u65ad\u7533\u8bf7\u5355\u662f\u5426\u9700\u8981\u540c\u6b65 \u9519\u8bef", (Throwable)ex);
        }
        return Boolean.TRUE;
    }

    private static Map<String, Boolean> getBooleanResult(String formId, DynamicObjectCollection entity, Long orgId) {
        boolean isOrg = Boolean.FALSE;
        boolean isFormId = Boolean.FALSE;
        for (DynamicObject dynamicObject : entity) {
            List formIds;
            DynamicObjectCollection applyBillTypeCollection;
            DynamicObjectCollection orgCollection = dynamicObject.getDynamicObjectCollection("applybillorg");
            if (orgCollection.isEmpty() || (applyBillTypeCollection = dynamicObject.getDynamicObjectCollection("applybilltype")).isEmpty()) continue;
            List<Object> orgFitResult = Lists.newArrayList();
            orgFitResult = orgCollection.stream().filter(org -> org != null && org.get("fbasedataid") != null && orgId.equals(ErCommonUtils.getPk(org.get("fbasedataid")))).collect(Collectors.toList());
            if (orgFitResult.isEmpty() || !(formIds = applyBillTypeCollection.stream().filter(obj -> obj != null && obj.get("fbasedataid_id") != null).map(obj -> obj.get("fbasedataid_id").toString()).collect(Collectors.toList())).contains(formId)) continue;
            isOrg = Boolean.TRUE;
            isFormId = Boolean.TRUE;
            break;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        resultMap.put("org", isOrg);
        resultMap.put("form", isFormId);
        return resultMap;
    }

    private static boolean checkFormId(String formId, DynamicObjectCollection entity) {
        DynamicObject dynamicObject = (DynamicObject)entity.get(0);
        DynamicObjectCollection applyBillTypeCollection = dynamicObject.getDynamicObjectCollection("applybilltype");
        if (applyBillTypeCollection.isEmpty()) {
            return Boolean.TRUE;
        }
        List formIds = applyBillTypeCollection.stream().filter(obj -> obj != null && obj.get("fbasedataid_id") != null).map(obj -> obj.get("fbasedataid_id").toString()).collect(Collectors.toList());
        if (!formIds.contains(formId)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String genSign(Map<String, Object> params) {
        params.remove("sign");
        StringBuilder buf = new StringBuilder();
        try {
            ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(params.entrySet());
            infoIds.sort(new Comparator<Map.Entry<String, Object>>(){

                @Override
                public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            for (Map.Entry entry : infoIds) {
                String val;
                if (entry.getKey() == null || ((String)entry.getKey()).isEmpty()) continue;
                String key = (String)entry.getKey();
                String string = val = entry.getValue() == null ? "" : entry.getValue().toString();
                if (buf.toString().isEmpty()) {
                    buf.append(key).append("=").append(val);
                    continue;
                }
                buf.append("&").append(key).append("=").append(val);
            }
            logger.info("\u5546\u65c5\u63a8\u9001:\u751f\u6210\u7b7e\u540d\u524d\u5b57\u7b26\u4e32\uff1a{}", (Object)buf.toString());
        }
        catch (TripException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u7b7e\u540d,\u5931\u8d25:%s", (String)"TripCommonUtil_03", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e}));
        }
        return buf.toString();
    }

    static {
        HashMap<String, BigDecimal> propAndNotExpectedMap = new HashMap<String, BigDecimal>(16);
        propAndNotExpectedMap.put("settlementamount", BigDecimal.ZERO);
        notExpectedValueMap = Collections.unmodifiableMap(propAndNotExpectedMap);
        standTripSrevice = new HashMap<String, String>(16);
        standTripName = new HashMap<String, String>(16);
        standTripSrevice.put(CTripName, CTripClass);
        standTripSrevice.put(ETripName, ETripClass);
        standTripSrevice.put(TTripName, TTripClass);
        standTripSrevice.put(DiDiTripName, DiDiTripClass);
        standTripSrevice.put(MeiTuanTripName, MeiTuanTripClass);
        standTripName.put(Supplier.XIECHENG.name(), CTripName);
        standTripName.put(Supplier.ZHONGXING.name(), ETripName);
        standTripName.put(Supplier.CHAILVYIHAO.name(), TTripName);
        standTripName.put(Supplier.DIDI.name(), DiDiTripName);
        standTripName.put(Supplier.MEITUAN.name(), MeiTuanTripName);
    }
}

