/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class TripReqChangeUtil {
    private static Map<String, String> TRIPHISTORY_MAPPINGRESULT = new HashMap<String, String>();

    public static Map<String, String> getTriphistoryMappingresult() {
        return TRIPHISTORY_MAPPINGRESULT;
    }

    public static void recordChangeTrip(DynamicObject[] dynamicObjects) {
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])Arrays.stream(dynamicObjects).map(m -> m.getPkValue()).toArray(), (DynamicObjectType)dynamicObjects[0].getDynamicObjectType());
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection tripenrtys = dynamicObject.getDynamicObjectCollection("tripentry");
            HashMap<Object, DynamicObject> currentTripInfo = new HashMap<Object, DynamicObject>(tripenrtys.size());
            for (DynamicObject tripenrty : tripenrtys) {
                currentTripInfo.put(tripenrty.getPkValue(), tripenrty);
            }
            if (!dynamicObject.getBoolean("ischange")) continue;
            if (dynamicObjectMap.get(dynamicObject.getPkValue()) == null || ((DynamicObject)dynamicObjectMap.get(dynamicObject.getPkValue())).getDynamicObjectCollection("tripchangehistoryentry") == null) {
                return;
            }
            DynamicObjectCollection oldTripcollection = ((DynamicObject)dynamicObjectMap.get(dynamicObject.getPkValue())).getDynamicObjectCollection("tripentry");
            Map<Object, List<DynamicObject>> map = oldTripcollection.stream().collect(Collectors.groupingBy(n -> n.getPkValue()));
            DynamicObjectCollection oldTripHistoryColl = dynamicObject.getDynamicObjectCollection("tripchangehistoryentry");
            TripReqChangeUtil.compareAndDeleteHistoryTripWithOld(map, currentTripInfo, oldTripHistoryColl);
        }
    }

    private static void compareAndDeleteHistoryTripWithOld(Map<Object, List<DynamicObject>> oldTripInfoMap, Map<Object, DynamicObject> currentTripInfo, DynamicObjectCollection oldTripHistoryColl) {
        Map<String, String> propetyMapping = TRIPHISTORY_MAPPINGRESULT;
        if (propetyMapping.size() == 0 || currentTripInfo.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> latestTripChangeList = new ArrayList<DynamicObject>(oldTripInfoMap.size());
        for (Map.Entry<Object, List<DynamicObject>> entry : oldTripInfoMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
            latestTripChangeList.add(entry.getValue().get(0));
        }
        for (DynamicObject oldTripHistoryEntry : latestTripChangeList) {
            Object srcTripEntryPk = oldTripHistoryEntry.getPkValue();
            DynamicObject currentTrip = currentTripInfo.get(srcTripEntryPk);
            if (currentTrip == null) continue;
            boolean isEquals = true;
            for (Map.Entry<String, String> entry : propetyMapping.entrySet()) {
                Object oldProprtyValue = oldTripHistoryEntry.get(entry.getValue());
                Object newProprtyValue = currentTrip.get(entry.getValue());
                isEquals = oldProprtyValue == null || newProprtyValue == null ? oldProprtyValue == newProprtyValue : (oldProprtyValue instanceof DynamicObject && newProprtyValue instanceof DynamicObject ? ((DynamicObject)oldProprtyValue).getPkValue().equals(((DynamicObject)newProprtyValue).getPkValue()) : (oldProprtyValue instanceof Timestamp ? newProprtyValue.equals(oldProprtyValue) : (oldProprtyValue instanceof DynamicObjectCollection ? TripReqChangeUtil.compareTravels((DynamicObjectCollection)oldProprtyValue, (DynamicObjectCollection)newProprtyValue) : oldProprtyValue.equals(newProprtyValue))));
                if (isEquals) continue;
                break;
            }
            if (isEquals) continue;
            Date changeDate = new Date();
            DynamicObject newHistory = oldTripHistoryColl.addNew();
            newHistory.set("srcentryid", oldTripHistoryEntry.getPkValue());
            String srcData = SerializationUtils.toJsonString((Object)oldTripHistoryEntry);
            newHistory.set("srcentrydata", (Object)(srcData.length() > 100 ? srcData.substring(0, 100) + "..." : srcData));
            newHistory.set("srcentrydata_tag", (Object)srcData);
            newHistory.set("changetime", (Object)changeDate);
            newHistory.set("changer", (Object)CommonServiceHelper.getUser(CommonServiceHelper.getCurrentUserID()));
            newHistory.set("changer_id", (Object)CommonServiceHelper.getCurrentUserID());
            for (Map.Entry<String, String> mappingEntry : TRIPHISTORY_MAPPINGRESULT.entrySet()) {
                if (oldTripHistoryEntry.get(mappingEntry.getValue()) instanceof DynamicObjectCollection) {
                    DynamicObjectCollection histroryCollection = newHistory.getDynamicObjectCollection(mappingEntry.getKey());
                    for (DynamicObject d : oldTripHistoryEntry.getDynamicObjectCollection(mappingEntry.getValue())) {
                        DynamicObject n = histroryCollection.addNew();
                        n.set("fbasedataid", (Object)d.getDynamicObject("fbasedataid"));
                        n.set("fbasedataid_id", (Object)ErCommonUtils.getPk(d.getDynamicObject("fbasedataid")));
                    }
                    continue;
                }
                newHistory.set(mappingEntry.getKey(), oldTripHistoryEntry.get(mappingEntry.getValue()));
            }
        }
    }

    private static boolean compareTravels(DynamicObjectCollection oldProprtyValue, DynamicObjectCollection newProprtyValue) {
        if (oldProprtyValue.size() != newProprtyValue.size()) {
            return false;
        }
        if (oldProprtyValue.size() == newProprtyValue.size() && newProprtyValue.size() == 0) {
            return true;
        }
        for (int i = 0; i < oldProprtyValue.size(); ++i) {
            if (!(oldProprtyValue.get(i) == null || newProprtyValue.get(i) == null ? oldProprtyValue.get(i) != null || newProprtyValue.get(i) != null : !((DynamicObject)oldProprtyValue.get(i)).getPkValue().equals(((DynamicObject)newProprtyValue.get(i)).getPkValue()))) continue;
            return false;
        }
        return true;
    }

    static {
        TRIPHISTORY_MAPPINGRESULT.put("historystartdate", "startdate");
        TRIPHISTORY_MAPPINGRESULT.put("historyenddate", "enddate");
        TRIPHISTORY_MAPPINGRESULT.put("historyfromcity", "from");
        TRIPHISTORY_MAPPINGRESULT.put("historytocity", "to");
        TRIPHISTORY_MAPPINGRESULT.put("historyvehicle", "vehicle");
        TRIPHISTORY_MAPPINGRESULT.put("historyvehicles", "vehicles");
        TRIPHISTORY_MAPPINGRESULT.put("historyexpenseitem", "tripexpenseitem");
        TRIPHISTORY_MAPPINGRESULT.put("historycostdept", "entrycostdept");
        TRIPHISTORY_MAPPINGRESULT.put("historycostcompany", "entrycostcompany");
        TRIPHISTORY_MAPPINGRESULT.put("historyproject", "std_project");
        TRIPHISTORY_MAPPINGRESULT.put("historyoriamount", "triporiamount");
        TRIPHISTORY_MAPPINGRESULT.put("historyamount", "tripamount");
        TRIPHISTORY_MAPPINGRESULT.put("historyoriappamount", "triporiaccappamount");
        TRIPHISTORY_MAPPINGRESULT.put("historyappamount", "tripaccappamount");
        TRIPHISTORY_MAPPINGRESULT.put("historytripcurrency", "tripcurrency");
        TRIPHISTORY_MAPPINGRESULT.put("historytripexchangerate", "tripexchangerate");
        TRIPHISTORY_MAPPINGRESULT.put("history_ismulcurrency", "istripmulcurrency");
        TRIPHISTORY_MAPPINGRESULT.put("historytripchangetravel", "travelers");
        TRIPHISTORY_MAPPINGRESULT.put("historyentrymulwayto", "mulwayto");
        TRIPHISTORY_MAPPINGRESULT.put("tripchangehistoryentry.seq", "tripentry.seq");
    }
}

