/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util.order.gettripid;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class GetOrderBillTripId {
    private static final Log logger = LogFactory.getLog(GetOrderBillTripId.class);

    public Object match(DynamicObject orderBill, DynamicObjectCollection tripColl) {
        Map<Object, Object> userTripMapping;
        Map dateTripMapping;
        if (tripColl == null || tripColl.size() == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5339\u914d\u884c\u7a0btripid,\u51fa\u5dee\u7533\u8bf7\u5355\u53f7\u884c\u7a0b\u5206\u5f55\u4e3a\u7a7a,\u51fa\u5dee\u5355\u53f7:" + orderBill.getString("oabillnum"));
            return null;
        }
        if (tripColl.size() == 1) {
            return ((DynamicObject)tripColl.get(0)).getPkValue();
        }
        Map matchAllCityMapping = (Map)this.matchAllCity(orderBill, tripColl);
        Map locationTripMapping = (Map)this.matchCity(orderBill, tripColl);
        Object pk = this.getMatchedTripId(locationTripMapping, dateTripMapping = (Map)this.matchDate(orderBill, tripColl), userTripMapping = this.matchTraveler(orderBill, tripColl), matchAllCityMapping);
        if (pk == null) {
            pk = ((DynamicObject)tripColl.get(0)).getPkValue();
        }
        return pk;
    }

    private Object getMatchedTripId(Map<Object, Object> locationTripMapping, Map<Object, Object> dateTripMapping, Map<Object, Object> userTripMapping, Map<Object, Object> allCityMapping) {
        Object result = null;
        if (userTripMapping == null || userTripMapping.size() == 0) {
            if (allCityMapping != null && allCityMapping.size() > 0) {
                Object[] tripId = new Object[2];
                for (Map.Entry<Object, Object> entry : allCityMapping.entrySet()) {
                    if (tripId[0] != null) break;
                    Object tempTripId = entry.getKey();
                    if (tempTripId == null) continue;
                    if (tripId[1] == null) {
                        tripId[1] = tempTripId;
                    }
                    if (dateTripMapping == null || dateTripMapping.get(tempTripId) == null) continue;
                    tripId[0] = tempTripId;
                }
                result = tripId[0] != null ? tripId[0] : tripId[1];
            } else if (locationTripMapping != null && locationTripMapping.size() > 0) {
                Object[] tripId = new Object[2];
                for (Map.Entry<Object, Object> entry : locationTripMapping.entrySet()) {
                    if (tripId[0] != null) break;
                    Object tempTripId = entry.getKey();
                    if (tempTripId == null) continue;
                    if (tripId[1] == null) {
                        tripId[1] = tempTripId;
                    }
                    if (dateTripMapping == null || dateTripMapping.get(tempTripId) == null) continue;
                    tripId[0] = tempTripId;
                }
                result = tripId[0] != null ? tripId[0] : tripId[1];
            } else if (dateTripMapping != null && dateTripMapping.size() > 0) {
                for (Map.Entry<Object, Object> entry : dateTripMapping.entrySet()) {
                    if (result == null) {
                        result = entry.getKey();
                        continue;
                    }
                    break;
                }
            }
        } else {
            Object[] tripId = new Object[6];
            for (Map.Entry<Object, Object> entry : userTripMapping.entrySet()) {
                if (tripId[0] != null) break;
                Object tempTripId = entry.getKey();
                if (tempTripId == null) continue;
                if (tripId[5] == null) {
                    tripId[5] = tempTripId;
                }
                if (allCityMapping != null && allCityMapping.get(tempTripId) != null && dateTripMapping != null && dateTripMapping.get(tempTripId) != null) {
                    tripId[0] = tempTripId;
                    continue;
                }
                if (tripId[1] == null && locationTripMapping != null && locationTripMapping.get(tempTripId) != null && dateTripMapping != null && dateTripMapping.get(tempTripId) != null) {
                    tripId[1] = tempTripId;
                    continue;
                }
                if (tripId[2] == null && allCityMapping != null && allCityMapping.get(tempTripId) != null) {
                    tripId[2] = tempTripId;
                    continue;
                }
                if (tripId[3] == null && locationTripMapping != null && locationTripMapping.get(tempTripId) != null) {
                    tripId[3] = tempTripId;
                    continue;
                }
                if (tripId[4] != null || dateTripMapping == null || dateTripMapping.get(tempTripId) == null) continue;
                tripId[4] = tempTripId;
            }
            result = tripId[0] != null ? tripId[0] : (tripId[1] != null ? tripId[1] : (tripId[2] != null ? tripId[2] : (tripId[3] != null ? tripId[3] : (tripId[4] != null ? tripId[4] : tripId[5]))));
        }
        return result;
    }

    protected abstract Object matchCity(DynamicObject var1, DynamicObjectCollection var2);

    protected abstract Object matchDate(DynamicObject var1, DynamicObjectCollection var2);

    protected Map<Object, Object> matchTraveler(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        Object userPkValue;
        Object user = bizBill.get(this.getTravelerPropName());
        if (user == null || tripColl == null || tripColl.size() == 0) {
            return null;
        }
        if (user instanceof DynamicObject) {
            userPkValue = ((DynamicObject)user).getPkValue();
        } else if (user instanceof Long) {
            userPkValue = user;
        } else if (user instanceof String) {
            userPkValue = Long.valueOf(user.toString());
        } else {
            return null;
        }
        Object pk = null;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (DynamicObject trip : tripColl) {
            if (!this.isContainsTraver(userPkValue, trip)) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
        }
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5339\u914d\u884c\u7a0btripid,\u8ba2\u5355[oabillnum=%s, \u4f7f\u7528\u4eba=%s], \u5339\u914d\u4f7f\u7528\u4eba[%s]", bizBill.getString("oabillnum"), userPkValue, pk == null ? "\u5931\u8d25" : "\u6210\u529f"));
        return result;
    }

    protected String getTravelerPropName() {
        return "sourcetravelerid";
    }

    private boolean isContainsTraver(Object userPkValue, DynamicObject trip) {
        DynamicObjectCollection travelers = trip.getDynamicObjectCollection("travelers");
        for (int i = 0; i < travelers.size(); ++i) {
            if (!userPkValue.equals(((DynamicObject)travelers.get(i)).getLong("fbasedataid_id"))) continue;
            return true;
        }
        return false;
    }

    protected String getFromCityByTrip(DynamicObject trip) {
        return trip.get("from") == null ? null : this.fixCity(trip.getString("from.name"));
    }

    protected String getToCityByTrip(DynamicObject trip) {
        return trip.get("to") == null ? null : this.fixCity(trip.getString("to.name"));
    }

    protected String getStartDateByTrip(DynamicObject trip) {
        return trip.getDate("startdate") == null ? null : this.date2Str(trip.getDate("startdate"));
    }

    protected String getEndDateByTrip(DynamicObject trip) {
        return trip.getDate("enddate") == null ? null : this.date2Str(trip.getDate("enddate"));
    }

    protected String date2Str(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    protected String fixCity(String cityname) {
        return cityname == null ? "" : cityname.replaceAll(ResManager.loadKDString((String)"\u5e02", (String)"EGetOrderBillTripId_0", (String)"fi-er-business", (Object[])new Object[0]), "").replaceAll(ResManager.loadKDString((String)"\u533a", (String)"EGetOrderBillTripId_1", (String)"fi-er-business", (Object[])new Object[0]), "").replaceAll(ResManager.loadKDString((String)"\u53bf", (String)"EGetOrderBillTripId_2", (String)"fi-er-business", (Object[])new Object[0]), "").replaceAll(ResManager.loadKDString((String)"\u81ea\u6cbb\u533a", (String)"EGetOrderBillTripId_3", (String)"fi-er-business", (Object[])new Object[0]), "");
    }

    protected abstract Object matchAllCity(DynamicObject var1, DynamicObjectCollection var2);
}

