/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util.order.gettripid;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.util.order.gettripid.GetOrderBillTripId;

public class GetPlaneBillTripId
extends GetOrderBillTripId {
    private static final Log logger = LogFactory.getLog(GetPlaneBillTripId.class);

    @Override
    protected Object matchCity(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        if (tripColl == null || tripColl.size() == 0) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Object pk = null;
        String fromCityName = this.fixCity(bizBill.getString("fromcityname"));
        String toCityName = this.fixCity(bizBill.getString("tocityname"));
        for (DynamicObject trip : tripColl) {
            if (fromCityName != null && fromCityName.equals(this.getFromCityByTrip(trip))) {
                pk = trip.getPkValue();
                result.put(pk, pk);
                continue;
            }
            if (toCityName == null || !toCityName.equals(this.getToCityByTrip(trip))) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
        }
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5339\u914d\u884c\u7a0btripid,\u673a\u7968\u8ba2\u5355[oabillnum=%s, fromcityname=%s, tocityname=%s], \u5339\u914d\u57ce\u5e02[%s]", bizBill.getString("oabillnum"), fromCityName, toCityName, pk == null ? "\u5931\u8d25" : "\u6210\u529f"));
        return result;
    }

    @Override
    protected Object matchDate(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        if (tripColl == null || tripColl.size() == 0) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Date dtakeoffTime = bizBill.getDate("takeofftime");
        String takeoffTime = dtakeoffTime != null ? this.date2Str(dtakeoffTime) : null;
        for (DynamicObject trip : tripColl) {
            Object pk;
            if (takeoffTime != null && takeoffTime.equals(this.getStartDateByTrip(trip))) {
                pk = trip.getPkValue();
                result.put(pk, pk);
                continue;
            }
            if (takeoffTime == null || takeoffTime.compareTo(this.getStartDateByTrip(trip)) <= 0 || takeoffTime.compareTo(this.getEndDateByTrip(trip)) >= 0) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
        }
        return result;
    }

    @Override
    protected Object matchAllCity(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        if (tripColl == null || tripColl.size() == 0) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Object pk = null;
        String fromCityName = this.fixCity(bizBill.getString("fromcityname"));
        String toCityName = this.fixCity(bizBill.getString("tocityname"));
        for (DynamicObject trip : tripColl) {
            if (fromCityName == null || !fromCityName.equals(this.getFromCityByTrip(trip)) || toCityName == null || !toCityName.equals(this.getToCityByTrip(trip))) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
            break;
        }
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5339\u914d\u884c\u7a0btripid,\u673a\u7968\u8ba2\u5355[oabillnum=%s, fromcityname=%s, tocityname=%s], \u5339\u914d\u5168\u57ce\u5e02[%s]", bizBill.getString("oabillnum"), fromCityName, toCityName, pk == null ? "\u5931\u8d25" : "\u6210\u529f"));
        return result;
    }
}

