/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util.order.gettripid;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.util.order.gettripid.GetOrderBillTripId;

public class GetTrainBillTripId
extends GetOrderBillTripId {
    private static final Log logger = LogFactory.getLog(GetTrainBillTripId.class);

    @Override
    protected Object matchCity(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        if (tripColl == null || tripColl.size() == 0) {
            return null;
        }
        Object pk = null;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        String fromCityName = this.fixCity(bizBill.getString("departcity"));
        String toCityName = this.fixCity(bizBill.getString("arrivecity"));
        for (DynamicObject trip : tripColl) {
            if (fromCityName != null && fromCityName.contains(this.getFromCityByTrip(trip))) {
                pk = trip.getPkValue();
                result.put(pk, pk);
                continue;
            }
            if (toCityName == null || !toCityName.contains(this.getToCityByTrip(trip))) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
        }
        logger.info(String.format("business integration,stroke matching tripid,trainbill[oabillnum=%s, fromcityname=%s, tocityname=%s], matching city[%s]", bizBill.getString("oabillnum"), fromCityName, toCityName, pk == null ? "failure" : "success"));
        return result;
    }

    @Override
    protected Object matchDate(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        if (tripColl == null || tripColl.size() == 0) {
            return null;
        }
        Object pk = null;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Date dtakeoffTime = bizBill.getDate("departTime");
        String takeoffTime = dtakeoffTime != null ? this.date2Str(dtakeoffTime) : null;
        for (DynamicObject trip : tripColl) {
            if (takeoffTime != null && takeoffTime.equals(this.getStartDateByTrip(trip))) {
                pk = trip.getPkValue();
                result.put(pk, pk);
                continue;
            }
            if (takeoffTime == null || takeoffTime.compareTo(this.getStartDateByTrip(trip)) <= 0 || takeoffTime.compareTo(this.getEndDateByTrip(trip)) >= 0) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
        }
        logger.info(String.format("business integration,stroke matching tripid,trainbill[oabillnum=%s, takeofftime=%s], matching date[%s]", bizBill.getString("oabillnum"), takeoffTime, pk == null ? "failure" : "success"));
        return result;
    }

    @Override
    protected String getTravelerPropName() {
        return "passeger";
    }

    @Override
    protected Object matchAllCity(DynamicObject bizBill, DynamicObjectCollection tripColl) {
        if (tripColl == null || tripColl.size() == 0) {
            return null;
        }
        Object pk = null;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        String fromCityName = this.fixCity(bizBill.getString("departcity"));
        String toCityName = this.fixCity(bizBill.getString("arrivecity"));
        for (DynamicObject trip : tripColl) {
            if (fromCityName == null || !fromCityName.contains(this.getFromCityByTrip(trip)) || toCityName == null || !toCityName.contains(this.getToCityByTrip(trip))) continue;
            pk = trip.getPkValue();
            result.put(pk, pk);
        }
        logger.info(String.format("business integration,stroke matching tripid,trainbill[oabillnum=%s, fromcityname=%s, tocityname=%s], matching all city[%s]", bizBill.getString("oabillnum"), fromCityName, toCityName, pk == null ? "failure" : "success"));
        return result;
    }
}

