/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class BillPlugin {
    private static final Log logger = LogFactory.getLog(BillPlugin.class);
    public static final String REQ_BILL_DYNAMIC_OBJECT = "kd.fi.er.business.trip.v2.plugin.BillPlugin.BILL_DYNAMIC_OBJECT";

    public static BillPlugin getInstance() {
        return loadClass.service;
    }

    public Object getFromBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (null == bill) {
            return null;
        }
        String mapsourcefield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(bill, mapsourcefield);
        return ctx;
    }

    public Object getOutDataId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (null == bill) {
            return null;
        }
        Long outDataId = 0L;
        long id = bill.getLong("id");
        DynamicObjectCollection dataMapping = QueryServiceHelper.query((String)"er_tripsync_datamapping", (String)"outdataid", (QFilter[])new QFilter[]{new QFilter("innerdataid", "=", (Object)id)});
        if (null != dataMapping) {
            for (DynamicObject dynamicObject : dataMapping) {
                if (0L == dynamicObject.getLong("outdataid")) continue;
                outDataId = dynamicObject.getLong("outdataid");
                break;
            }
        }
        return outDataId;
    }

    public Object getOaBillFormId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.getOrDefault("jsonvalue", "")) {
            logger.info("BillPlugin getOaBillFormId billNo is null");
            return "";
        }
        String billNo = map.getOrDefault("jsonvalue", "").toString();
        if ("".equals(billNo.trim())) {
            logger.info("BillPlugin getOaBillFormId billNo is null");
            return "";
        }
        Map params = (Map)map.get("params");
        Map billMapping = params.getOrDefault("billMapping", new HashMap());
        DynamicObject bill = (DynamicObject)billMapping.get(billNo);
        if (bill == null) {
            logger.info("BillPlugin getOaBillFormId dynamicObject is null");
            return "";
        }
        String oaBillFormId = bill.getDynamicObjectType().getName();
        return oaBillFormId;
    }

    private static class loadClass {
        private static BillPlugin service = new BillPlugin();

        private loadClass() {
        }
    }
}

