/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class BizInfoPlugin {
    private static final Log logger = LogFactory.getLog(BizInfoPlugin.class);
    public static final String SERVER_DYNAMIC_OBJECT_MAP = "kd.fi.er.business.trip.v2.plugin.BizInfoPlugin.SERVER_DYNAMIC_OBJECT_MAP";
    public static final String SERVER_COMPANY_INFO_MAP = "kd.fi.er.business.trip.v2.plugin.BizInfoPlugin.SERVER_COMPANY_INFO_MAP";

    public static BizInfoPlugin getInstance() {
        return loadClass.service;
    }

    public Object getId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("id");
    }

    public Object getAppKey(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("appkey");
    }

    public DynamicObject getServer(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        return (DynamicObject)ActionLocalCache.get().get(SERVER_DYNAMIC_OBJECT_MAP, index, () -> {
            Object paramsob = map.get("params");
            Map params = (Map)paramsob;
            DynamicObject fieldmapping = (DynamicObject)params.get("fieldmap");
            DynamicObject server = fieldmapping.getDynamicObject("server");
            if (null == server) {
                return null;
            }
            server = BusinessDataServiceHelper.loadSingleFromCache((Object)server.getLong("id"), (String)"er_biz_info");
            return server;
        });
    }

    public Object getTenantid(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("tenantid");
    }

    public Object getAccountid(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("accountid");
    }

    public Object getAppsecurity(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("appsecurity");
    }

    public Object getOrationid(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("orationid");
    }

    public Object getReservedfield1(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("reservedfield1");
    }

    public Object getReservedfield2(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("reservedfield2");
    }

    public Object getReservedfield3(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("reservedfield3");
    }

    public Object getReservedfield4(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("reservedfield4");
    }

    public Object getReservedfield5(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("reservedfield5");
    }

    public Object getCheckingCurrency(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        if (server == null) {
            return 1L;
        }
        Long checkingcurrency = ErCommonUtils.getPk(server.get("checkingcurrency"));
        if (null == checkingcurrency) {
            return 1L;
        }
        return checkingcurrency;
    }

    public Object getSetcostorg(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("setcostorg");
    }

    public Object getSyncreqbillsettleorg(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server == null ? "" : server.getString("syncreqbillsettleorg");
    }

    public Object getLastSyncOrgTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        Date lastsyncorgtamp = server.getDate("lastsyncorgtamp");
        return lastsyncorgtamp;
    }

    public Object getLastSyncUserTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        Date lastsyncorgtamp = server.getDate("lastsyncpeopletamp");
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastsyncorgtamp);
        cal.add(5, -1);
        return cal.getTime();
    }

    public Object getLastSyncOrderTimeStamp(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("beginDate")) {
            return params.get("beginDate");
        }
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        String lastSyncOrderDateStr = server.getString("lastsyncorderbilltamp");
        String lastSyncOrderDateTamp = TripCommonUtil.date2TimeStamp(lastSyncOrderDateStr, "yyyy-MM-dd HH:mm:ss");
        return lastSyncOrderDateTamp;
    }

    public Object getMultiCompanyId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        return server.getBoolean("multicompanyid");
    }

    public Map<String, Object> getCompanyInfo(Map<String, Object> map, TripSyncLogParam tripSyncLogParam, Long accountOrgId) {
        HashMap<String, Object> companyInfoMap = new HashMap<String, Object>();
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        String serverNumber = server.getString("number");
        HashMap cacheMap = (HashMap)ActionLocalCache.get().get(SERVER_COMPANY_INFO_MAP, serverNumber, HashMap::new);
        boolean isMultiCompanyId = server.getBoolean("multicompanyid");
        if (isMultiCompanyId) {
            if (null != cacheMap.get(accountOrgId)) {
                return (Map)cacheMap.get(accountOrgId);
            }
            DynamicObjectCollection companyinfoentity = server.getDynamicObjectCollection("companyinfoentity");
            for (DynamicObject entry : companyinfoentity) {
                DynamicObject accountorg = entry.getDynamicObject("accountorg");
                if (!Objects.equals(ErCommonUtils.getPk(accountorg), accountOrgId)) continue;
                companyInfoMap.put("companyId", entry.getString("companyid"));
                companyInfoMap.put("signKey", entry.getString("signkey"));
                companyInfoMap.put("staffCode", entry.getString("staffcode"));
                companyInfoMap.put("realName", entry.getString("realname"));
                cacheMap.put(accountOrgId, companyInfoMap);
                return companyInfoMap;
            }
        } else {
            if (null != cacheMap.get(-100L)) {
                return (Map)cacheMap.get(-100L);
            }
            companyInfoMap.put("companyId", server.getString("orationid"));
            companyInfoMap.put("signKey", server.getString("appsecurity"));
            companyInfoMap.put("staffCode", server.getString("reservedfield1"));
            companyInfoMap.put("realName", server.getString("reservedfield2"));
            cacheMap.put(-100L, companyInfoMap);
            return companyInfoMap;
        }
        return new HashMap<String, Object>();
    }

    public Object getAccountOrgByCompanyId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam, String companyId) {
        DynamicObject server = this.getServer(map, tripSyncLogParam);
        if (server == null) {
            logger.info("BizInfoPlugin.getAccountOrgByCompanyId  server\u4e3a\u7a7a");
            return 0L;
        }
        if (StringUtils.isBlank((CharSequence)companyId)) {
            logger.info("BizInfoPlugin.getAccountOrgByCompanyId  companyId\u4e3a\u7a7a");
            return 0L;
        }
        boolean isMultiCompanyId = server.getBoolean("multicompanyid");
        if (isMultiCompanyId) {
            DynamicObjectCollection companyInfoEntity = server.getDynamicObjectCollection("companyinfoentity");
            for (DynamicObject entry : companyInfoEntity) {
                if (!companyId.equals(entry.getString("companyid"))) continue;
                return ErCommonUtils.getPk(entry.getDynamicObject("accountorg"));
            }
        } else {
            return OrgUnitServiceHelper.getRootOrgId();
        }
        return 0L;
    }

    private static class loadClass {
        private static BizInfoPlugin service = new BizInfoPlugin();

        private loadClass() {
        }
    }
}

