/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.TripType;
import kd.fi.er.business.trip.util.TripVerifyComparator;

public class CheckingPlugin {
    private static final Log logger = LogFactory.getLog(CheckingPlugin.class);
    private static final String[][] compareProps = new String[][]{{"ordernum"}, {"totalamount"}, {"server"}, {"operationtype"}};
    private static final TripVerifyComparator verifyComparator = new TripVerifyComparator(compareProps);

    public static CheckingPlugin getInstance() {
        return loadClass.service;
    }

    public Object getIsbalance(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return this.getIsbalance(map);
    }

    private String getIsbalance(Map<String, Object> map) {
        String isBalance = "2";
        Map params = (Map)map.get("params");
        if (null == params || null == params.get("orderMapping")) {
            return isBalance;
        }
        String pkvalue = (String)map.get("pkvalue");
        Map orderMapping = (Map)params.get("orderMapping");
        DynamicObject order = (DynamicObject)orderMapping.get(pkvalue);
        if (null == order) {
            return isBalance;
        }
        DynamicObject checking = (DynamicObject)map.get("dynamicObject");
        if (null == checking) {
            return isBalance;
        }
        if ("2".equalsIgnoreCase(checking.getString("producttype")) && "2".equalsIgnoreCase(checking.getString("servicefeepaytype"))) {
            return isBalance;
        }
        if (verifyComparator.compare(checking, order) != 0) {
            return isBalance;
        }
        return "1";
    }

    public Object allOrderId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params || null == params.get("allorderMapping")) {
            return 0L;
        }
        if (null == map.get("pkvalue")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u4e3b\u952e\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u4fdd\u8bc1\u4e3b\u952e\u5728\u5b57\u6bb5\u6620\u5c04\u4f18\u5148\u6267\u884c\u3002", (String)"CheckingPlugin_01", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return 0L;
        }
        String pkvalue = (String)map.get("pkvalue");
        Map orderMapping = (Map)params.get("allorderMapping");
        DynamicObject allorder = (DynamicObject)orderMapping.get(pkvalue);
        if (null == allorder) {
            return 0L;
        }
        return allorder.getLong("id");
    }

    public Object getIsreconciliation(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String isbalance = this.getIsbalance(map);
        return "1".equals(isbalance);
    }

    public Boolean getIsdeductible(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Boolean isdeductible = Boolean.FALSE;
        List<Map<String, String>> invoiceSetByOperation = this.getInvoiceSetByOperation(map, tripSyncLogParam);
        if (invoiceSetByOperation != null) {
            for (Map<String, String> invoiceSet : invoiceSetByOperation) {
                if (isdeductible.booleanValue()) continue;
                isdeductible = Boolean.parseBoolean(invoiceSet.get("isdeductible"));
                logger.info("\u5546\u65c5\u96c6\u6210,\u6839\u636e\u8ba2\u5355\u7c7b\u578b\u83b7\u53d6\u5f00\u7968\u8bbe\u7f6e\u4fe1\u606f,getInvoiceInfoByOperation isdeductible:" + isdeductible);
            }
        }
        return isdeductible;
    }

    private List<Map<String, String>> getInvoiceSetByOperation(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params || null == params.get("invoiceSetting")) {
            return null;
        }
        List invoiceSetting = (List)params.get("invoiceSetting");
        if (null == invoiceSetting) {
            return null;
        }
        if (null == map.get("dynamicObject")) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return null;
        }
        if (!dynamicObject.containsProperty("operationtype") || null == dynamicObject.getString("operationtype")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5b57\u6bb5\u6620\u5c04\uff0c\u5e76\u786e\u4fdd\u5728\u6267\u884c\u201c\u53ef\u62b5\u6263\u201d\u524d\u3002", (String)"CheckingPlugin_02", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return null;
        }
        Map<Object, List<Map>> invoiceSetGroup = invoiceSetting.stream().collect(Collectors.groupingBy(v -> (String)v.get("operationtype")));
        return invoiceSetGroup.get(dynamicObject.getString("operationtype"));
    }

    public BigDecimal getOrderdeductrate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        BigDecimal deductrate = BigDecimal.ZERO;
        if (null == map.get("dynamicObject")) {
            return deductrate;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return deductrate;
        }
        if (!dynamicObject.containsProperty("operationtype") || null == dynamicObject.getString("operationtype")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5b57\u6bb5\u6620\u5c04\uff0c\u5e76\u786e\u4fdd\u5728\u6267\u884c\u201c\u53ef\u62b5\u6263\u201d\u524d\u3002", (String)"CheckingPlugin_02", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return deductrate;
        }
        Serviceitem item = null;
        if (TripType._PLANE.getOperationtype().equals(dynamicObject.getString("operationtype")) || TripType.PLANE.getOperationtype().equals(dynamicObject.getString("operationtype"))) {
            if (dynamicObject.containsProperty("ticketstatus") && "REFOUND".equals(dynamicObject.getString("ticketstatus"))) {
                item = Serviceitem.ITINERARY;
            } else {
                List<Map<String, String>> invoiceSetByOperation = this.getInvoiceSetByOperation(map, tripSyncLogParam);
                if (invoiceSetByOperation != null) {
                    for (Map<String, String> invoiceSet : invoiceSetByOperation) {
                        Serviceitem serviceItem = Serviceitem.getItem(invoiceSet.get("serviceitem"));
                        if (null == serviceItem || !Serviceitem.ITINERARY.getValue().equals(serviceItem.getValue())) continue;
                        item = Serviceitem.ITINERARY;
                    }
                }
            }
        } else {
            item = Serviceitem.TICKET;
        }
        deductrate = this.getDeductrate(map, tripSyncLogParam, item);
        return deductrate.multiply(new BigDecimal(100));
    }

    public BigDecimal getOrderamounttax(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        BigDecimal orderamounttax = BigDecimal.ZERO;
        BigDecimal deductrate = this.getOrderdeductrate(map, tripSyncLogParam).divide(new BigDecimal(100), RoundingMode.CEILING);
        if (null == map.get("dynamicObject")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u661f\u701a\u5bf9\u63a5\u529f\u80fd\u5bf9\u8c61\u672a\u751f\u6210\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"CheckingPlugin_08", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return orderamounttax;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (!dynamicObject.containsProperty("servicefee") || null == dynamicObject.getString("servicefee")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u670d\u52a1\u8d39\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u8d39\u201d\u5b57\u6bb5\uff0c\u5e76\u786e\u4fdd\u5728\u201c\u7968\u4ef7\u7a0e\u989d\u201d\u4e4b\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_03", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return orderamounttax;
        }
        if (!dynamicObject.containsProperty("totalamount") || null == dynamicObject.getString("totalamount")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u91d1\u989d\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u201c\u7ed3\u7b97\u91d1\u989d\u201d\uff0c\u786e\u4fdd\u5728\u201c\u7968\u4ef7\u7a0e\u989d\u201d\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_04", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return orderamounttax;
        }
        if (!dynamicObject.containsProperty("servicefeepaytype") || null == dynamicObject.get("servicefeepaytype")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u670d\u52a1\u8d39\u7c7b\u578b\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u8d39\u7c7b\u578b\u201d\u5b57\u6bb5\uff0c\u5e76\u786e\u4fdd\u5728\u201c\u7968\u4ef7\u7a0e\u989d\u201d\u4e4b\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_05", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return orderamounttax;
        }
        BigDecimal servicefee = "1".equals(dynamicObject.getString("servicefeepaytype")) ? dynamicObject.getBigDecimal("servicefee") : BigDecimal.ZERO;
        orderamounttax = dynamicObject.getBigDecimal("totalamount").subtract(servicefee).multiply(deductrate).divide(BigDecimal.ONE.add(deductrate), 2, RoundingMode.HALF_UP);
        return orderamounttax;
    }

    public BigDecimal getServicedeductrate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return this.getDeductrate(map, tripSyncLogParam, Serviceitem.SERVICE).multiply(new BigDecimal(100));
    }

    private BigDecimal getDeductrate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam, Serviceitem item) {
        BigDecimal deductrate = BigDecimal.ZERO;
        List<Map<String, String>> invoiceSetByOperation = this.getInvoiceSetByOperation(map, tripSyncLogParam);
        if (invoiceSetByOperation != null) {
            for (Map<String, String> invoiceSet : invoiceSetByOperation) {
                Serviceitem serviceItem = Serviceitem.getItem(invoiceSet.get("serviceitem"));
                BigDecimal rate = new BigDecimal(invoiceSet.getOrDefault("deductrate", "0"));
                if (null == item || !item.equals(serviceItem) || BigDecimal.ZERO.compareTo(rate) >= 0) continue;
                deductrate = rate;
            }
        }
        return deductrate;
    }

    public BigDecimal getServiceamounttax(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        BigDecimal serviceamounttax = BigDecimal.ZERO;
        BigDecimal deductrate = this.getServicedeductrate(map, tripSyncLogParam).divide(new BigDecimal(100), RoundingMode.CEILING);
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (!dynamicObject.containsProperty("servicefee") || null == dynamicObject.getString("servicefee")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u670d\u52a1\u8d39\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u8d39\u201d\u5b57\u6bb5\uff0c\u5e76\u786e\u4fdd\u5728\u201c\u7968\u4ef7\u7a0e\u989d\u201d\u4e4b\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_03", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return serviceamounttax;
        }
        if (!dynamicObject.containsProperty("servicefeepaytype") || null == dynamicObject.get("servicefeepaytype")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u670d\u52a1\u8d39\u7c7b\u578b\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u8d39\u7c7b\u578b\u201d\u5b57\u6bb5\uff0c\u5e76\u786e\u4fdd\u5728\u201c\u7968\u4ef7\u7a0e\u989d\u201d\u4e4b\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_05", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return serviceamounttax;
        }
        BigDecimal servicefee = "1".equals(dynamicObject.getString("servicefeepaytype")) ? dynamicObject.getBigDecimal("servicefee") : BigDecimal.ZERO;
        serviceamounttax = servicefee.multiply(deductrate).divide(BigDecimal.ONE.add(deductrate), 2, RoundingMode.HALF_UP);
        return serviceamounttax;
    }

    public BigDecimal getTotaltax(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        BigDecimal totaltax = BigDecimal.ZERO;
        if (null == map.get("dynamicObject")) {
            return totaltax;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return totaltax;
        }
        if (!dynamicObject.containsProperty("serviceamounttax") || null == dynamicObject.getString("serviceamounttax")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u670d\u52a1\u8d39\u7a0e\u989d\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\u3002\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u8d39\u7a0e\u989d\u201d\u5b57\u6bb5\uff0c\u5e76\u786e\u4fdd\u5728\u201c\u53ef\u62b5\u6263\u7a0e\u989d\u201d\u4e4b\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_06", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return totaltax;
        }
        if (!dynamicObject.containsProperty("orderamounttax") || null == dynamicObject.getString("orderamounttax")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a\u7968\u4ef7\u7a0e\u989d\u4e3a\u7a7a\u6216\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u201c\u7968\u4ef7\u7a0e\u989d\u201d\u5b57\u6bb5\uff0c\u5e76\u786e\u4fdd\u5728\u201c\u53ef\u62b5\u6263\u7a0e\u989d\u201d\u4e4b\u524d\u6267\u884c\u3002", (String)"CheckingPlugin_07", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return totaltax;
        }
        return dynamicObject.getBigDecimal("serviceamounttax").add(dynamicObject.getBigDecimal("orderamounttax"));
    }

    public Object getProject(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject checking = (DynamicObject)map.get("dynamicObject");
        if (null == checking) {
            return null;
        }
        Map params = (Map)map.get("params");
        if (null == params || null == params.get("orderMapping")) {
            return null;
        }
        String pkvalue = (String)map.get("pkvalue");
        Map orderMapping = (Map)params.get("orderMapping");
        DynamicObject order = (DynamicObject)orderMapping.get(pkvalue);
        if (null == order) {
            return null;
        }
        return order.getDynamicObject("std_project");
    }

    private static class loadClass {
        private static CheckingPlugin service = new CheckingPlugin();

        private loadClass() {
        }
    }
}

