/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.v2.plugin.BizInfoPlugin;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang3.StringUtils;

public class EnumPlugin {
    public static final String TRIP_ENUM_MAP = "kd.fi.er.business.trip.v2.plugin.EnumPlugin.TRIP_ENUM_MAP";
    private static final Log logger = LogFactory.getLog(EnumPlugin.class);

    public static EnumPlugin getInstance() {
        return loadClass.service;
    }

    public String getEnum(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.getOrDefault("jsonvalue", "")) {
            logger.info("EnumPlugin getEnum jsonvalue is null");
            return "";
        }
        if (null == map.getOrDefault("jsonfield", "")) {
            logger.info("EnumPlugin getEnum jsonfield is null");
            return "";
        }
        if (null == map.getOrDefault("billfield", "")) {
            logger.info("EnumPlugin getEnum billfield is null");
            return "";
        }
        String jsonfield = map.getOrDefault("jsonfield", "").toString();
        String billfield = map.getOrDefault("billfield", "").toString();
        String jsonValue = map.getOrDefault("jsonvalue", "").toString();
        String serverId = BizInfoPlugin.getInstance().getId(map, tripSyncLogParam).toString();
        if (StringUtils.isBlank((CharSequence)serverId) || StringUtils.isBlank((CharSequence)jsonfield)) {
            logger.info("EnumPlugin getEnum serverId:{},jsonfield:{}", (Object)serverId, (Object)jsonfield);
            return "";
        }
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        if (null == fieldmapping) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPushInvoke_01", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        String function = fieldmapping.getDynamicObject("function").getString("number");
        Map enumMap = (Map)ActionLocalCache.get().get(TRIP_ENUM_MAP, serverId + "_" + function, () -> this.getEnumMap(serverId, function));
        return enumMap.getOrDefault(billfield + "_" + jsonfield + "_" + jsonValue, "");
    }

    private Map<String, String> getEnumMap(String serverId, String function) {
        HashMap<String, String> enumMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return enumMap;
        }
        Map tripEnum = BusinessDataServiceHelper.loadFromCache((String)"er_trip_enum", (QFilter[])new QFilter[]{new QFilter("server", "=", (Object)Long.valueOf(serverId)), new QFilter("function", "=", (Object)function)});
        for (DynamicObject value : tripEnum.values()) {
            DynamicObjectCollection entryentity = value.getDynamicObjectCollection("entryentity");
            if (null == entryentity) continue;
            for (DynamicObject dynamicObject : entryentity) {
                String jfield = dynamicObject.getString("jfield");
                String jvalue = dynamicObject.getString("jvalue");
                String bfield = dynamicObject.getString("bfield");
                String bvalue = dynamicObject.getString("bvalue");
                String mapkey = bfield + "_" + jfield + "_" + jvalue;
                enumMap.put(mapkey, bvalue);
            }
        }
        return enumMap;
    }

    public String getEnumByPsuh(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.getOrDefault("billvalue", "")) {
            logger.info("EnumPlugin getEnum billvalue is null");
            return "";
        }
        if (null == map.getOrDefault("jsonfield", "")) {
            logger.info("EnumPlugin getEnum jsonfield is null");
            return "";
        }
        if (null == map.getOrDefault("billfield", "")) {
            logger.info("EnumPlugin getEnum billfield is null");
            return "";
        }
        String jsonfield = map.getOrDefault("jsonfield", "").toString();
        String billfield = map.getOrDefault("billfield", "").toString();
        String billvalue = map.getOrDefault("billValue", "").toString();
        String serverId = BizInfoPlugin.getInstance().getId(map, tripSyncLogParam).toString();
        if (StringUtils.isBlank((CharSequence)serverId) || StringUtils.isBlank((CharSequence)jsonfield)) {
            logger.info("EnumPlugin getEnum serverId:{},jsonfield:{}", (Object)serverId, (Object)jsonfield);
            return "";
        }
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        if (null == fieldmapping) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPushInvoke_01", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        String function = fieldmapping.getDynamicObject("function").getString("number");
        Map enumMap = (Map)ActionLocalCache.get().get(TRIP_ENUM_MAP, serverId + "_" + function, () -> this.getEnumMapByPush(serverId, function));
        return enumMap.getOrDefault(billfield + "_" + jsonfield + "_" + billvalue, "");
    }

    private Map<String, String> getEnumMapByPush(String serverId, String function) {
        HashMap<String, String> enumMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return enumMap;
        }
        Map tripEnum = BusinessDataServiceHelper.loadFromCache((String)"er_trip_enum", (QFilter[])new QFilter[]{new QFilter("server", "=", (Object)Long.valueOf(serverId)), new QFilter("function", "=", (Object)function)});
        for (DynamicObject value : tripEnum.values()) {
            DynamicObjectCollection entryentity = value.getDynamicObjectCollection("entryentity");
            if (null == entryentity) continue;
            for (DynamicObject dynamicObject : entryentity) {
                String jfield = dynamicObject.getString("jfield");
                String jvalue = dynamicObject.getString("jvalue");
                String bfield = dynamicObject.getString("bfield");
                String bvalue = dynamicObject.getString("bvalue");
                String mapkey = bfield + "_" + jfield + "_" + bvalue;
                enumMap.put(mapkey, jvalue);
            }
        }
        return enumMap;
    }

    private static class loadClass {
        private static EnumPlugin service = new EnumPlugin();

        private loadClass() {
        }
    }
}

