/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TimePlugin {
    private static final Log logger = LogFactory.getLog(TimePlugin.class);
    private static final String yyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    private static final String yy_MM_dd = "yyyy-MM-dd";
    private static final String yyMMdd = "yyyyMMdd";
    private static final String yyMMdian = "yyyy.MM";
    public static final String PARAMS_TIME = "kd.fi.er.business.trip.v2.plugin.TimePlugin_PARAMS_TIME";
    public static final String DS_DATE = "kd.fi.er.business.trip.v2.plugin.TimePlugin_DS_DATE";
    public static final String QUERY_DATE = "kd.fi.er.business.trip.v2.plugin.TimePlugin_QUERY_DATE";

    public static TimePlugin getInstance() {
        return loadClass.service;
    }

    public Object getShortNowDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return this.shortDateToStr(new Date());
    }

    public Object getShortDateByBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billfield = (String)map.getOrDefault("billfield", "");
        if (StringUtils.isBlank((String)billfield)) {
            logger.info("TimePlugin-getShortDateByBill---billfield is null");
            return "";
        }
        Object bill = map.get("bill");
        if (bill == null) {
            logger.info("TimePlugin-getShortDateByBill---bill is null");
            return "";
        }
        Date date = ((DynamicObject)bill).getDate(billfield);
        if (null == date && map.get("billValue") instanceof Date) {
            date = (Date)map.get("billValue");
        }
        return this.shortDateToStr(date);
    }

    public Object getShortDateByBillValue(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object billvalue = map.getOrDefault("billValue", "");
        if (null == billvalue || !(billvalue instanceof Date)) {
            logger.info("TimePlugin-getShortDateByBillValue---billvalue is null");
            return "";
        }
        return this.shortDateToStr((Date)billvalue);
    }

    public Object getLongNowDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return this.longDateToStr(new Date());
    }

    public Object getNowTimeStr(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("endDate")) {
            return params.get("endDate");
        }
        return String.valueOf(System.currentTimeMillis());
    }

    public Object getNowTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return System.currentTimeMillis();
    }

    public Object getNowData(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return new Date();
    }

    public String shortDateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(yy_MM_dd);
        return sdf.format(date);
    }

    public String longDateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(yyMMddHHmmss);
        return sdf.format(date);
    }

    public Object getSoleTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        Date date = new Date();
        if (null == params) {
            return date;
        }
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(PARAMS_TIME, index, () -> new Date());
        return datec;
    }

    public Object getDsStartDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("beginDate")) {
            return params.get("beginDate");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(yyMMdd);
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(DS_DATE, index, () -> new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.add(2, -1);
        cal.set(5, 1);
        return sdf.format(cal.getTime());
    }

    public Object getDsEndDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("endDate")) {
            return params.get("endDate");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(yyMMdd);
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(DS_DATE, index, () -> new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.add(2, -1);
        int days = cal.getActualMaximum(5);
        cal.set(5, days);
        return sdf.format(cal.getTime());
    }

    public Object getStartDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("beginDate")) {
            return params.get("beginDate");
        }
        Integer jsonvalue = 3;
        if (null != map.get("jsonvalue") && NumberUtils.isDigits((String)map.get("jsonvalue").toString())) {
            jsonvalue = Integer.valueOf(map.get("jsonvalue").toString());
        }
        SimpleDateFormat sdf = new SimpleDateFormat(yyMMddHHmmss);
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(QUERY_DATE, index, () -> new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.set(5, cal.get(5) - jsonvalue);
        return sdf.format(cal.getTime());
    }

    public Object getEndDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("endDate")) {
            return params.get("endDate");
        }
        Integer jsonvalue = 0;
        if (null != map.get("jsonvalue") && NumberUtils.isDigits((String)map.get("jsonvalue").toString())) {
            jsonvalue = Integer.valueOf(map.get("jsonvalue").toString());
        }
        SimpleDateFormat sdf = new SimpleDateFormat(yyMMddHHmmss);
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(QUERY_DATE, index, () -> new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.set(5, cal.get(5) - jsonvalue);
        return sdf.format(cal.getTime());
    }

    public Object getStartTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("beginDate")) {
            return ((Date)params.get("beginDate")).getTime();
        }
        Integer jsonvalue = 3;
        if (null != map.get("jsonvalue") && NumberUtils.isDigits((String)map.get("jsonvalue").toString())) {
            jsonvalue = Integer.valueOf(map.get("jsonvalue").toString());
        }
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(QUERY_DATE, index, () -> new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.set(5, cal.get(5) - jsonvalue);
        return cal.getTime().getTime();
    }

    public Object getEndTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null != params.get("endDate")) {
            return ((Date)params.get("endDate")).getTime();
        }
        Integer jsonvalue = 0;
        if (null != map.get("jsonvalue") && NumberUtils.isDigits((String)map.get("jsonvalue").toString())) {
            jsonvalue = Integer.valueOf(map.get("jsonvalue").toString());
        }
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Date datec = (Date)ActionLocalCache.get().get(QUERY_DATE, index, () -> new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.set(5, cal.get(5) - jsonvalue);
        return cal.getTime().getTime();
    }

    public Object getShortStartDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Date datec;
        Map params = (Map)map.get("params");
        SimpleDateFormat sdf = new SimpleDateFormat(yy_MM_dd);
        Integer jsonvalue = 0;
        if (null != params.get("beginDate")) {
            datec = (Date)params.get("beginDate");
        } else {
            jsonvalue = 3;
            if (null != map.get("jsonvalue") && NumberUtils.isDigits((String)map.get("jsonvalue").toString())) {
                jsonvalue = Integer.valueOf(map.get("jsonvalue").toString());
            }
            String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
            datec = (Date)ActionLocalCache.get().get(QUERY_DATE, index, () -> new Date());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.set(5, cal.get(5) - jsonvalue);
        return sdf.format(cal.getTime());
    }

    public Object getShortEndDate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Date datec;
        Map params = (Map)map.get("params");
        SimpleDateFormat sdf = new SimpleDateFormat(yy_MM_dd);
        Integer jsonvalue = 0;
        if (null != params.get("endDate")) {
            datec = (Date)params.get("endDate");
        } else {
            jsonvalue = 3;
            if (null != map.get("jsonvalue") && NumberUtils.isDigits((String)map.get("jsonvalue").toString())) {
                jsonvalue = Integer.valueOf(map.get("jsonvalue").toString());
            }
            if (map.containsKey("jsonvalue") && map.get("jsonvalue") != null && StringUtils.isEmpty((String)map.get("jsonvalue").toString())) {
                jsonvalue = 0;
            }
            String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
            datec = (Date)ActionLocalCache.get().get(QUERY_DATE, index, () -> new Date());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(datec);
        cal.set(5, cal.get(5) - jsonvalue);
        return sdf.format(cal.getTime());
    }

    public Object getPeriod(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.get("dynamicObject")) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return null;
        }
        if (!dynamicObject.containsProperty("happenddate") || null == dynamicObject.get("happenddate")) {
            if (TripSyncConfigUtil.getBoolean("ttrip_period_value", Boolean.TRUE).booleanValue()) {
                tripSyncLogParam.setStatus("B");
                String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u7ed3\u7b97\u53d1\u751f\u65f6\u95f4\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u3010\u7ed3\u7b97\u53d1\u751f\u65f6\u95f4\u3011\uff0c\u5e76\u4fdd\u8bc1\u5728\u3010\u671f\u95f4\u3011\u524d\u9762\u6267\u884c\u3002", (String)"CheckingPlugin_09", (String)"fi-er-business", (Object[])new Object[0]);
                tripSyncLogParam.setMessage(msg);
            }
            return null;
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat(yyMMdian);
        return sdf1.format(dynamicObject.getDate("happenddate"));
    }

    private static class loadClass {
        private static TimePlugin service = new TimePlugin();

        private loadClass() {
        }
    }
}

