/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.cache.TraceCache;
import kd.fi.er.business.trip.exception.TripSyncLogParam;

public class TripAutoOpenedCommonPlugin {
    private static final ThreadLocal<TraceCache<String, DynamicObject>> THREAD_LOCAL = ThreadLocal.withInitial(TraceCache::new);
    private static final String CACHE_KEY = "AutoOpened.";

    public DynamicObject getCacheData(String serverNum) {
        String finalCacheKey = CACHE_KEY + serverNum;
        TraceCache<String, DynamicObject> traceCache = THREAD_LOCAL.get();
        if (!traceCache.isCurrentTrace()) {
            traceCache.clearAndSetTraceId();
        } else if (traceCache.isCurrentTrace() && traceCache.containKey(finalCacheKey)) {
            return traceCache.get(finalCacheKey);
        }
        DynamicObject cacheData = BusinessDataServiceHelper.loadSingleFromCache((String)"er_autoopened", (String)"id,servers,companynum,companyname,approvaltype,tripadminuser,orderstatusaddr,channelid,channelkeys,openedstatus,syncadminstatus,enableservers,billstatus,synctraceid,syncusertraceid", (QFilter[])new QFilter[]{new QFilter("servers", "=", (Object)serverNum)});
        if (cacheData == null) {
            return new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_autoopened"));
        }
        THREAD_LOCAL.get().put(finalCacheKey, cacheData);
        return cacheData;
    }

    public String getInitTime(Map<String, Object> params, TripSyncLogParam tripSyncLogParam) {
        return "1900-01-01 00:00:00";
    }
}

