/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.plugin.OrgPlugin;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class UserPlugin {
    private static final Log logger = LogFactory.getLog(UserPlugin.class);
    public static final String USER_DYNAMIC_OBJECT_MAP = "kd.fi.er.business.trip.v2.plugin.UserPlugin.USER_DYNAMIC_OBJECT_MAP";
    public static final String USER_COMPANY_DYNAMIC_OBJECT_MAP = "kd.fi.er.business.trip.v2.plugin.UserPlugin.USER_COMPANY_DYNAMIC_OBJECT_MAP";
    public static final String CURR_USER_MAP = "kd.fi.er.business.trip.v2.plugin.UserPlugin.CURRENT_USER_MAP";

    public static UserPlugin getInstance() {
        return loadClass.service;
    }

    public DynamicObject getUser(Map<String, Object> map) {
        Map params = (Map)map.get("params");
        String usernumber = map.getOrDefault("jsonvalue", 0).toString();
        DynamicObject user = (DynamicObject)ActionLocalCache.get().get(USER_DYNAMIC_OBJECT_MAP, usernumber, () -> this.getUser(usernumber, params));
        return user;
    }

    public Long getUser(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.getOrDefault("jsonvalue", 0)) {
            return 0L;
        }
        DynamicObject user = this.getUser(map);
        return user == null ? 0L : user.getLong("id");
    }

    public String getUserName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.getOrDefault("jsonvalue", 0)) {
            return "";
        }
        DynamicObject user = this.getUser(map);
        return user == null ? "" : user.getString("name");
    }

    public Long getUserDept(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = 0L;
        DynamicObject user = this.getUser(map);
        if (null == user) {
            return deptId;
        }
        return UserPlugin.getDept(user);
    }

    public static Long getDept(DynamicObject user) {
        Long deptId = 0L;
        DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
        if (null == userEntrys) {
            return deptId;
        }
        for (DynamicObject userEntry : userEntrys) {
            DynamicObject dept = userEntry.getDynamicObject("dpt");
            boolean isPartjob = userEntry.getBoolean("ispartjob");
            if (isPartjob || null == dept) continue;
            deptId = dept.getLong("id");
            break;
        }
        return deptId;
    }

    public Long getUserCompany(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = this.getUserDept(map, tripSyncLogParam);
        return OrgPlugin.getCompanyByDeptId(deptId, tripSyncLogParam.getTraceid());
    }

    public Object getPassegerUserDept(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = 0L;
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty() && NumberUtils.isCreatable((String)map.get("jsonvalue").toString()) && Long.parseLong(map.get("jsonvalue").toString()) != 0L) {
            return map.get("jsonvalue");
        }
        if (null == map.get("params")) {
            return deptId;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return deptId;
        }
        Map params = (Map)map.get("params");
        Long passegerId = 0L;
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"passeger")) {
            if (null == dynamicObject.get("passeger")) {
                logger.info("Passeger : \u4e58\u5ba2\u8d4b\u503c\u4e3anull");
                return deptId;
            }
            passegerId = ErCommonUtils.getPk(dynamicObject.get("passeger"));
            if (null == passegerId) {
                logger.info("Passeger : \u4e58\u5ba2\u4e3b\u952enull");
                return deptId;
            }
        }
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"sourcetravelerid")) {
            if (null == dynamicObject.get("sourcetravelerid")) {
                logger.info("Passeger : \u4e58\u5ba2\u8d4b\u503c\u4e3anull");
                return deptId;
            }
            passegerId = ErCommonUtils.getPk(dynamicObject.get("sourcetravelerid"));
            if (null == passegerId) {
                logger.info("Passeger : \u4e58\u5ba2\u4e3b\u952enull");
                return deptId;
            }
        }
        if (passegerId == 0L) {
            return deptId;
        }
        DynamicObject user = this.getUserById(passegerId.toString(), params);
        if (null == user) {
            logger.info("BookUser : \u4e58\u5ba2\u4e0d\u5b58\u5728");
            return deptId;
        }
        return UserPlugin.getDept(user);
    }

    public Object getBookUserDept(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = 0L;
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty() && NumberUtils.isCreatable((String)map.get("jsonvalue").toString()) && Long.parseLong(map.get("jsonvalue").toString()) != 0L) {
            return map.get("jsonvalue");
        }
        if (null == map.get("params")) {
            return deptId;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return deptId;
        }
        Map params = (Map)map.get("params");
        deptId = OrgPlugin.getApplyBillOrgId(map, "org");
        if (0L != deptId) {
            return deptId;
        }
        if (!dynamicObject.getDataEntityType().getProperties().containsKey((Object)"sourcebookedid")) {
            logger.info("BookUser : \u6ca1\u6709\u9884\u5b9a\u4eba\u5b57\u6bb5");
            return deptId;
        }
        if (null == dynamicObject.get("sourcebookedid")) {
            logger.info("BookUser : \u9884\u5b9a\u4eba\u8d4b\u503c\u4e3anull");
            return deptId;
        }
        Long bookedId = ErCommonUtils.getPk(dynamicObject.get("sourcebookedid"));
        if (null == bookedId) {
            logger.info("BookUser : \u9884\u5b9a\u4eba\u8d4b\u503c\u4e3b\u952enull");
            return deptId;
        }
        DynamicObject user = this.getUserById(bookedId.toString(), params);
        if (null == user) {
            logger.info("BookUser : \u9884\u5b9a\u4eba\u4e0d\u5b58\u5728");
            return deptId;
        }
        return UserPlugin.getDept(user);
    }

    public Object getBookUserCompany(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty() && NumberUtils.isCreatable((String)map.get("jsonvalue").toString()) && Long.parseLong(map.get("jsonvalue").toString()) != 0L) {
            return map.get("jsonvalue");
        }
        Long deptId = OrgPlugin.getApplyBillOrgId(map, "org");
        if (0L != deptId) {
            return deptId;
        }
        deptId = (Long)this.getBookUserDept(map, tripSyncLogParam);
        if (deptId == null) {
            return 0L;
        }
        return OrgPlugin.getCompanyByDeptId(Long.parseLong(deptId.toString()), tripSyncLogParam.getTraceid());
    }

    public DynamicObject getUser(Object usernumber, Map<String, Object> params) {
        if (null == usernumber || usernumber.toString().trim().isEmpty()) {
            return null;
        }
        if (null == params || params.get("userMapping") == null) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", usernumber)});
        }
        Map userMapping = (Map)params.get("userMapping");
        return (DynamicObject)userMapping.get(usernumber);
    }

    public DynamicObject getUserById(String id, Map<String, Object> params) {
        if (null == id || id.trim().isEmpty() || 0L == Long.parseLong(id)) {
            return null;
        }
        if (null == params || params.get("userMapping") == null) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id))});
        }
        Map userMapping = (Map)params.get("userMapping");
        return (DynamicObject)userMapping.get(id);
    }

    public String getCurrentUserName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        DynamicObject curruser = (DynamicObject)ActionLocalCache.get().get(CURR_USER_MAP, RequestContext.get().getCurrUserId(), () -> this.getUserById(String.valueOf(RequestContext.get().getCurrUserId()), params));
        return curruser.getString("name");
    }

    public Object getCurrentUserId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return RequestContext.get().getCurrUserId();
    }

    public String getCurrentUserNumber(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        DynamicObject curruser = (DynamicObject)ActionLocalCache.get().get(CURR_USER_MAP, RequestContext.get().getCurrUserId(), () -> this.getUserById(String.valueOf(RequestContext.get().getCurrUserId()), params));
        return curruser.getString("number");
    }

    public String getCurrentUserPhone(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        DynamicObject curruser = (DynamicObject)ActionLocalCache.get().get(CURR_USER_MAP, RequestContext.get().getCurrUserId(), () -> this.getUserById(String.valueOf(RequestContext.get().getCurrUserId()), params));
        return curruser.getString("phone");
    }

    public DynamicObject getCurrentUser(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        DynamicObject curruser = (DynamicObject)ActionLocalCache.get().get(CURR_USER_MAP, RequestContext.get().getCurrUserId(), () -> this.getUserById(String.valueOf(RequestContext.get().getCurrUserId()), params));
        return curruser;
    }

    public String getPartJobDptId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String partJobdpt = "";
        DynamicObject bill = (DynamicObject)map.get("bill");
        return UserPlugin.getDept(bill).toString();
    }

    public Object getPartJobCostCompanyId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = 0L;
        DynamicObject bill = (DynamicObject)map.get("bill");
        deptId = UserPlugin.getDept(bill);
        return CoreBaseBillServiceHelper.getAccountOrgId(deptId, true);
    }

    public Object getPartJobCostCompanyName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object companyId = this.getPartJobCostCompanyId(map, tripSyncLogParam);
        if (null == companyId) {
            return null;
        }
        DynamicObject org = OrgPlugin.getOrg(Long.parseLong(companyId.toString()), (Map)map.get("params"));
        if (null == org) {
            return "";
        }
        return org.getString("name");
    }

    public String getPartJobCompanyId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = 0L;
        DynamicObject bill = (DynamicObject)map.get("bill");
        deptId = UserPlugin.getDept(bill);
        Long companyByDeptId = OrgPlugin.getCompanyByDeptId(deptId, tripSyncLogParam.getTraceid());
        return companyByDeptId == null ? "0" : String.valueOf(companyByDeptId);
    }

    public Object getExtInfo(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String deptId = this.getPartJobDptId(map, tripSyncLogParam);
        Long companyId = OrgPlugin.getCompanyByDeptId(Long.parseLong(deptId), tripSyncLogParam.getTraceid());
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId(Long.valueOf(deptId), true);
        DynamicObject std_costcenter = ErCostCenterUtil.getCostCenterByCostDept(Long.parseLong(deptId));
        Long stdCostcenterId = 0L;
        if (std_costcenter != null) {
            stdCostcenterId = std_costcenter.getLong("id");
        }
        JSONObject extJson = new JSONObject();
        extJson.put("deptId", (Object)deptId);
        extJson.put("companyId", (Object)companyId);
        extJson.put("costCompanyId", (Object)costCompanyId);
        extJson.put("stdCostcenterId", (Object)stdCostcenterId);
        return extJson.toJSONString();
    }

    @Deprecated
    public Object getPositionLevelName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject company;
        DynamicObject user = (DynamicObject)map.get("bill");
        String employeeNumber = user.getString("number");
        Long dept = UserPlugin.getDept(user);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        long userId = user.getLong("id");
        paramMap.put("id", userId);
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(dept);
        paramMap.put("companyId", companyId);
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNew(Collections.singletonList(paramMap));
        if (reimburseLevelMap.isEmpty()) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5bf9\u5e94\u5458\u5de5ID{}\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u62a5\u9500\u7ea7\u522b\u6570\u636e", (Object)userId, (Object)companyId);
        }
        if ((company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyId)})) == null) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5458\u5de5{}\u6839\u636e\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u516c\u53f8\u6570\u636e", (Object)employeeNumber, (Object)companyId);
        }
        String result = "";
        int intValue = (Integer)ActionLocalCache.get().get("qtrip_personnel_rank", "qtrip_personnel_rank", () -> TripSyncConfigUtil.getIntValue("qtrip_personnel_rank", 2));
        switch (intValue) {
            case 1: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) || company == null) break;
                result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                break;
            }
            case 2: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
                break;
            }
            case 3: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                if (company == null) break;
                result = String.format(ResManager.loadKDString((String)"%s-\u666e\u901a\u5458\u5de5", (String)"UserPlugin_0", (String)"fi-er-business", (Object[])new Object[0]), company.getString("number"));
                break;
            }
            case 4: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) {
                    result = reimburseLevelMap.get(userId);
                    break;
                }
                result = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"MTripPlugin_1", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            case 5: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                result = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"MTripPlugin_1", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            default: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
            }
        }
        return result;
    }

    private static class loadClass {
        private static UserPlugin service = new UserPlugin();

        private loadClass() {
        }
    }
}

