/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.alitrip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.plugin.UserPlugin;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class ALiTripPlugin {
    private static final String cacheKey = "er.trip.ali.token";
    private static final Log logger = LogFactory.getLog(ALiTripPlugin.class);

    public static String getCacheToken(String appKey) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String strCache = (String)cache.get(cacheKey + appKey);
        if (StringUtils.isBlank((CharSequence)strCache)) {
            strCache = ALiTripPlugin.getToken();
            logger.info(cacheKey + appKey + ":" + strCache);
            if (StringUtils.isNotBlank((CharSequence)strCache)) {
                cache.put(cacheKey + appKey, (Object)strCache, 1200);
            }
        }
        return strCache;
    }

    private static String getToken() {
        Object result = TripCommonUtil.invoke(Supplier.ALI.getValue(), "er_biz_info", null, null, new HashMap<String, Object>());
        String token = "";
        if (result instanceof List) {
            List resultList = (List)result;
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return "";
            }
            Map resultMap = (Map)resultList.get(0);
            if (resultMap.isEmpty() || !((Boolean)resultMap.get("success")).booleanValue()) {
                return "";
            }
            Object data = resultMap.get("data");
            JSONArray dataArray = JSON.parseArray((String)JSON.toJSONString(data));
            if (dataArray.isEmpty()) {
                return "";
            }
            JSONObject dataJson = dataArray.getJSONObject(0);
            JSONObject module = dataJson.getJSONObject("module");
            if (module == null) {
                return "";
            }
            token = module.getString("token");
        }
        return token;
    }

    @Deprecated
    public Object getPositionLevelName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject company;
        DynamicObject user = (DynamicObject)map.get("bill");
        String employeeNumber = user.getString("number");
        Object dept = map.get("billValue");
        if (employeeNumber == null || !(dept instanceof Long)) {
            logger.info("\u672a\u83b7\u53d6\u5230\u5458\u5de5{}\u6216\u8005\u90e8\u95e8{}", (Object)employeeNumber, dept);
            return "";
        }
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        long userId = user.getLong("id");
        paramMap.put("id", userId);
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)dept);
        paramMap.put("companyId", companyId);
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNew(Collections.singletonList(paramMap));
        if (reimburseLevelMap.isEmpty()) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5bf9\u5e94\u5458\u5de5ID{}\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u62a5\u9500\u7ea7\u522b\u6570\u636e", (Object)userId, (Object)companyId);
        }
        if ((company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyId)})) == null) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5458\u5de5{}\u6839\u636e\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u516c\u53f8\u6570\u636e", (Object)employeeNumber, (Object)companyId);
        }
        String result = "";
        int intValue = (Integer)ActionLocalCache.get().get("atrip_personnel_rank", "atrip_personnel_rank", () -> TripSyncConfigUtil.getIntValue("atrip_personnel_rank", 2));
        switch (intValue) {
            case 1: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) || company == null) break;
                result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                break;
            }
            case 2: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
                break;
            }
            case 3: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                if (company == null) break;
                result = String.format(ResManager.loadKDString((String)"%s-\u666e\u901a\u5458\u5de5", (String)"UserPlugin_0", (String)"fi-er-business", (Object[])new Object[0]), company.getString("number"));
                break;
            }
            case 4: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) {
                    result = reimburseLevelMap.get(userId);
                    break;
                }
                result = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"MTripPlugin_1", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            case 5: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                result = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"MTripPlugin_1", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            default: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
            }
        }
        return result;
    }

    public Object getCostCenter(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object deptId = map.get("billValue");
        if (!(deptId instanceof Long)) {
            return 0L;
        }
        return ActionLocalCache.get().get("aliCostCenterMap", deptId, () -> CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId, true));
    }

    public Object getTripCityNameStr(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        DynamicObjectCollection tripentry = req.getDynamicObjectCollection("tripentry");
        if (tripentry == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject entry : tripentry) {
            String fromName = entry.getDynamicObject("from") != null ? entry.getDynamicObject("from").getString("name") : "";
            String toName = entry.getDynamicObject("to") != null ? entry.getDynamicObject("to").getString("name") : "";
            stringBuilder.append(fromName).append("\uff0c");
            stringBuilder.append(toName).append("\uff0c");
        }
        stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("\uff0c"));
        return stringBuilder.toString();
    }

    public Object getTripCityCodeStr(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        DynamicObjectCollection tripentry = req.getDynamicObjectCollection("tripentry");
        if (tripentry == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject entry : tripentry) {
            String fromCode = entry.getDynamicObject("from") != null ? entry.getDynamicObject("from").getString("areacode") : "";
            String toCode = entry.getDynamicObject("to") != null ? entry.getDynamicObject("to").getString("areacode") : "";
            stringBuilder.append(fromCode).append("\uff0c");
            stringBuilder.append(toCode).append("\uff0c");
        }
        stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("\uff0c"));
        return stringBuilder.toString();
    }

    public Object getTravelerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        JSONArray result = new JSONArray();
        List<String> numberList = this.getAllTravelersNumberList(map, tripSyncLogParam);
        for (String number : numberList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("user_id", (Object)number);
            result.add((Object)jsonObject);
        }
        return result;
    }

    public List<String> getAllTravelersNumberList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        ArrayList<String> numberList = new ArrayList<String>();
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            logger.info("getFirstTripEntryId req\u4e3a\u7a7a");
            return numberList;
        }
        DynamicObjectCollection tripentry = req.getDynamicObjectCollection("tripentry");
        if (tripentry == null) {
            return numberList;
        }
        HashSet<String> travelerSet = new HashSet<String>();
        for (DynamicObject entry : tripentry) {
            DynamicObjectCollection travelers = entry.getDynamicObjectCollection("travelers");
            if (travelers == null) continue;
            for (DynamicObject traveler : travelers) {
                DynamicObject user = traveler.getDynamicObject("fbasedataid");
                if (user == null) continue;
                travelerSet.add(user.getString("number"));
            }
        }
        travelerSet.remove("");
        travelerSet.remove(null);
        numberList.addAll(travelerSet);
        return numberList;
    }

    public Object getLoginCostCenter(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object billno;
        DynamicObject reqBill;
        Map paramsMap;
        Object params = map.get("params");
        if (params != null && (paramsMap = (Map)params).get("applyBillNumber") != null && StringUtils.isNotBlank((CharSequence)((String)paramsMap.get("applyBillNumber"))) && (reqBill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"costcompany", (QFilter[])new QFilter[]{new QFilter("billno", "=", billno = paramsMap.get("applyBillNumber"))})) != null) {
            return ErCommonUtils.getPk(reqBill.get("costcompany"));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)currUserId, (String)"bos_user");
        Long deptId = UserPlugin.getDept(user);
        return CoreBaseBillServiceHelper.getAccountOrgId(deptId, true);
    }
}

