/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.ctrip;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.codec.digest.DigestUtils;

public class CtripPlugin {
    private static final Log logger = LogFactory.getLog(CtripPlugin.class);

    public static CtripPlugin getInstance() {
        return loadClass.service;
    }

    public Object getStatusByParams(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params) {
            return "1";
        }
        return params.getOrDefault("status", "1");
    }

    public Object createBudgetSign(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(Supplier.XIECHENG.name());
        if (corpMap == null) {
            return null;
        }
        String appSecurity = corpMap.get("appsecurity");
        DynamicObject bill = (DynamicObject)map.get("bill");
        String billNo = bill.getString("billno");
        BigDecimal amount = bill.getBigDecimal("approveamount");
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            amount = BigDecimal.ZERO;
        }
        String plainText = billNo + "543" + amount + DigestUtils.sha1Hex((String)appSecurity);
        return DigestUtils.sha1Hex((String)plainText);
    }

    private static class loadClass {
        private static CtripPlugin service = new CtripPlugin();

        private loadClass() {
        }
    }
}

