/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.dailyapply;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class DailyApplyBillPlugin {
    private static final Log logger = LogFactory.getLog(DailyApplyBillPlugin.class);

    public static DailyApplyBillPlugin getInstance() {
        return loadClass.service;
    }

    public Object getBeginTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (null == bill) {
            return null;
        }
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("expenseentryentity");
        Optional<DynamicObject> first = dynamicObjectCollection.stream().filter(v -> v.getDate("happendate") != null).sorted(Comparator.comparing(e -> e.getDate("happendate"))).findFirst();
        String beginTime = first.isPresent() ? TripCommonUtil.date2TimeStamp(first.get().getDate("happendate"), "yyyy-MM-dd HH:mm:ss") : "";
        return beginTime;
    }

    public String getEndTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (null == bill) {
            return null;
        }
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("expenseentryentity");
        Optional<DynamicObject> first = dynamicObjectCollection.stream().filter(v -> v.getDate("happendate") != null).sorted(Comparator.comparing(e -> e.getDate("happendate"))).findFirst();
        if (!first.isPresent()) {
            return "";
        }
        int daysnum = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            daysnum += dynamicObject.getInt("daysnum");
        }
        Date date = TripCommonUtil.addDayByDate(first.get().getDate("happendate"), daysnum);
        return TripCommonUtil.date2TimeStamp(date, "yyyy-MM-dd HH:mm:ss");
    }

    private String getMixTime(DynamicObject req, Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        ArrayList<Date> dates = new ArrayList<Date>(32);
        if (ctx instanceof Object[]) {
            Object[] os;
            for (Object o : os = (Object[])ctx) {
                if (!(o instanceof Date)) continue;
                dates.add((Date)o);
            }
        }
        return TripCommonUtil.date2TimeStamp((Date)Collections.min(dates), "yyyy-MM-dd HH:mm:ss");
    }

    private String getMaxTime(DynamicObject req, Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        ArrayList<Date> dates = new ArrayList<Date>(32);
        if (ctx instanceof Object[]) {
            Object[] os;
            for (Object o : os = (Object[])ctx) {
                if (!(o instanceof Date)) continue;
                dates.add((Date)o);
            }
        }
        return TripCommonUtil.date2TimeStamp((Date)Collections.max(dates), "yyyy-MM-dd");
    }

    public Object getOrderStaffs(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        JSONObject jsonObject;
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (null == bill) {
            return null;
        }
        JSONArray staffList = new JSONArray();
        DynamicObject creator = bill.getDynamicObject("creator");
        DynamicObject applier = bill.getDynamicObject("applier");
        if (creator != null) {
            jsonObject = new JSONObject();
            jsonObject.put("staffCode", (Object)creator.getString("number"));
            jsonObject.put("staffName", (Object)creator.getString("name"));
            staffList.add((Object)jsonObject);
        }
        if (!(applier == null || creator != null && ErCommonUtils.getPk(creator).equals(ErCommonUtils.getPk(applier)))) {
            jsonObject = new JSONObject();
            jsonObject.put("staffCode", (Object)applier.getString("number"));
            jsonObject.put("staffName", (Object)applier.getString("name"));
            staffList.add((Object)jsonObject);
        }
        return staffList;
    }

    private static class loadClass {
        private static DailyApplyBillPlugin service = new DailyApplyBillPlugin();

        private loadClass() {
        }
    }
}

