/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.req;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.plugin.OrgPlugin;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ReqBillPlugin {
    private static final Log logger = LogFactory.getLog(ReqBillPlugin.class);
    public static final String REQ_BILL_DYNAMIC_OBJECT_ID = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_ID";
    public static final String REQ_BILL_DYNAMIC_OBJECT_ID_CODE = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_ID_CODE";
    public static final String REQ_BILL_DYNAMIC_OBJECT_STARTDATE = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_STARTDATE";
    public static final String REQ_BILL_DYNAMIC_OBJECT_LONGSTARTDATE = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_LONGSTARTDATE";
    public static final String REQ_BILL_DYNAMIC_OBJECT_ENDDATE = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_ENDDATE";
    public static final String REQ_BILL_DYNAMIC_OBJECT_LONGENDDATE = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_LONGENDDATE";
    public static final String REQ_BILL_DYNAMIC_OBJECT_CRL = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_CRL";
    public static final String REQ_BILL_DYNAMIC_OBJECT_TWO_COUNTRY_CODE_MAP = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_TWO_COUNTRY_CODE_MAP";
    public static final String REQ_BILL_DYNAMIC_OBJECT_COSTTENTER = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_COSTTENTER";
    public static final String REQ_BILL_DYNAMIC_OBJECT_COSTTENTER_NUMBER = "kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin.REQ_BILL_DYNAMIC_OBJECT_COSTTENTER_NUMBER";

    public static ReqBillPlugin getInstance() {
        return loadClass.service;
    }

    public Object getIdsByBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        List cityCodeAndIds = (List)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_ID_CODE, req.getString("billno"), () -> this.getIdsAndCodes(req, map, tripSyncLogParam));
        return cityCodeAndIds.get(1);
    }

    public Object getTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx1 = TripCommonUtil.getDValueByfield(req, billfield);
        return ctx1;
    }

    private List<Set<String>> getIdsAndCodes(DynamicObject req, Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Set<Long> ids = this.getBillCityIds(req, map);
        return TripCityUtil.getCityCodeAndIds(ids);
    }

    private Set<Long> getBillCityIds(DynamicObject req, Map<String, Object> map) {
        Object ctx2;
        Boolean ispasswaypush;
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx1 = TripCommonUtil.getDValueByfield(req, billfield);
        Set<Object> cityIds1 = new HashSet(16);
        Set<Object> cityIds2 = new HashSet(16);
        Set<Object> cityIds3 = new HashSet(16);
        if (ctx1 != null && !ctx1.toString().isEmpty()) {
            cityIds1 = this.getCityIdInfo(ctx1);
        }
        if ((ispasswaypush = Boolean.valueOf(TripSyncConfigUtil.getBoolean("ctrip_PassWay_Push"))).booleanValue() && (ctx2 = TripCommonUtil.getDValueByfield(req, "tripentry.mulwayto.id")) != null && !ctx2.toString().isEmpty()) {
            cityIds2 = this.getCityIdInfo(ctx2);
        }
        String field = "";
        field = "tripentry.to.id".equals(billfield) ? "tripentry.from.id" : "tripentry.to.id";
        Object ctx3 = TripCommonUtil.getDValueByfield(req, field);
        if (ctx3 != null && !ctx3.toString().isEmpty()) {
            cityIds3 = this.getCityIdInfo(ctx3);
        }
        HashSet<Long> ids = new HashSet<Long>(64);
        ids.addAll(cityIds1);
        ids.addAll(cityIds2);
        ids.addAll(cityIds3);
        return ids;
    }

    public Object getCIds(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billValue = map.getOrDefault("billValue", "").toString();
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>(64);
        ids.add(Long.parseLong(billValue));
        Set cityCodeAndIds = (Set)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_ID, ids + tripSyncLogParam.getTraceid(), () -> TripCityUtil.getCityIds(ids));
        return StringUtils.join((Collection)cityCodeAndIds, (String)",");
    }

    private Set<Long> getCityIdInfo(Object ctx) {
        if (ctx instanceof Object[]) {
            Object[] os = (Object[])ctx;
            HashSet<Long> ids = new HashSet<Long>(os.length);
            for (Object o : os) {
                if (!(o instanceof Long)) continue;
                ids.add(Long.valueOf(o.toString()));
            }
            return ids;
        }
        return new HashSet<Long>();
    }

    public Object getCodesByBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        List cityCodeAndIds = (List)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_ID_CODE, req.getString("billno"), () -> this.getIdsAndCodes(req, map, tripSyncLogParam));
        return cityCodeAndIds.get(0);
    }

    public Object getStartTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        return (String)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_STARTDATE, req.getString("billno"), () -> this.getMixTime(req, map, tripSyncLogParam, "yyyy-MM-dd"));
    }

    public Object getLongStartTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        return (String)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_LONGSTARTDATE, req.getString("billno"), () -> this.getMixTime(req, map, tripSyncLogParam, "yyyy-MM-dd HH:mm:ss"));
    }

    private Object getMixTime(DynamicObject req, Map<String, Object> map, TripSyncLogParam tripSyncLogParam, String format) {
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        HashSet<Date> dates = new HashSet<Date>(32);
        if (ctx instanceof Object[]) {
            Object[] os;
            for (Object o : os = (Object[])ctx) {
                if (!(o instanceof Date)) continue;
                dates.add((Date)o);
            }
        }
        return TripCommonUtil.date2TimeStamp((Date)Collections.min(dates), format);
    }

    public Object getEndTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.get("bill")) {
            return null;
        }
        DynamicObject req = (DynamicObject)map.get("bill");
        return ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_ENDDATE, req.getString("billno"), () -> this.getMaxTime(req, map, tripSyncLogParam, "yyyy-MM-dd"));
    }

    public Object getLongEndTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null == map.get("bill")) {
            return null;
        }
        DynamicObject req = (DynamicObject)map.get("bill");
        return ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_LONGENDDATE, req.getString("billno"), () -> this.getMaxTime(req, map, tripSyncLogParam, "yyyy-MM-dd HH:mm:ss"));
    }

    private Object getMaxTime(DynamicObject req, Map<String, Object> map, TripSyncLogParam tripSyncLogParam, String format) {
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        HashSet<Date> dates = new HashSet<Date>(32);
        if (ctx instanceof Object[]) {
            Object[] os;
            for (Object o : os = (Object[])ctx) {
                if (!(o instanceof Date)) continue;
                dates.add((Date)o);
            }
        }
        return TripCommonUtil.date2TimeStamp((Date)Collections.max(dates), format);
    }

    public Object getFlightWay(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return "2";
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        return tripCtrlObject.getString("domairroundtripctrl");
    }

    public Object getDiscount(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        return tripCtrlObject.getBigDecimal("domairdiscountctrl").toString();
    }

    public Object getFPassengerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        ArrayList<Map<String, Object>> listNumber = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> listName = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(64);
        this.getUserInfoList(ctx, listNumber, listName, list);
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String domPeopleCtr = tripCtrlObject.getString("domairtrippeoplectrl");
        if (StringUtils.isNotEmpty((String)domPeopleCtr) && "1".equals(domPeopleCtr)) {
            return list;
        }
        if (StringUtils.isNotEmpty((String)domPeopleCtr) && "0".equals(domPeopleCtr)) {
            return listName;
        }
        if (StringUtils.isNotEmpty((String)domPeopleCtr) && "2".equals(domPeopleCtr)) {
            return list;
        }
        return null;
    }

    private void getUserInfoList(Object ctx, List<Map<String, Object>> listNumber, List<Map<String, Object>> listName, List<Map<String, Object>> list) {
        if (!(ctx instanceof Object[])) {
            return;
        }
        Object[] os = (Object[])ctx;
        ArrayList<String> set = new ArrayList<String>(64);
        for (Object o : os) {
            if (!(o instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection travelers = (DynamicObjectCollection)o;
            for (DynamicObject traveler : travelers) {
                HashMap<String, String> number = new HashMap<String, String>(2);
                HashMap<String, String> name = new HashMap<String, String>(2);
                HashMap<String, String> p = new HashMap<String, String>(2);
                DynamicObject user = traveler.getDynamicObject("fbasedataid");
                if (set.contains(user.getString("number")) || user.getString("number").trim().isEmpty()) continue;
                set.add(user.getString("number"));
                p.put("Name", user.getString("name"));
                p.put("EID", user.getString("number"));
                number.put("EID", user.getString("number"));
                name.put("Name", user.getString("name"));
                list.add(p);
                listNumber.add(number);
                listName.add(name);
            }
        }
    }

    public Object getFSkipFields(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return "64991";
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String domPeopleCtr = tripCtrlObject.getString("domairtrippeoplectrl");
        Integer flightSkipFields = (Integer)tripControlSettingMap.get("flightSkipFields");
        if (StringUtils.isNotEmpty((String)domPeopleCtr) && "2".equals(domPeopleCtr)) {
            flightSkipFields = flightSkipFields + 32;
        }
        return flightSkipFields;
    }

    public Object getMaxStart(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        return tripCtrlObject.getInt("maxstarclass");
    }

    public Object getMinStart(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        return tripCtrlObject.getInt("mixstarclass");
    }

    public Object getRoomCount(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        int dayroomcount = tripCtrlObject.getInt("dayroomcount");
        dayroomcount = dayroomcount >= 8 ? (dayroomcount = 8) : dayroomcount;
        return dayroomcount;
    }

    public Object getHPassengerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        ArrayList<Map<String, Object>> listNumber = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> listName = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(64);
        this.getUserInfoList(ctx, listNumber, listName, list);
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String hotelPeopleCtr = tripCtrlObject.getString("hoteltrippeoplectrl");
        if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "1".equals(hotelPeopleCtr)) {
            return list;
        }
        if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "0".equals(hotelPeopleCtr)) {
            return listName;
        }
        if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "2".equals(hotelPeopleCtr)) {
            return list;
        }
        return null;
    }

    public Object getHSkipFields(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return "16367";
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String hotelPeopleCtr = tripCtrlObject.getString("hoteltrippeoplectrl");
        Integer hotelSkipFields = (Integer)tripControlSettingMap.get("hotelSkipFields");
        if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "2".equals(hotelPeopleCtr)) {
            hotelSkipFields = hotelSkipFields + 16;
        }
        return hotelSkipFields;
    }

    private Map<String, Object> getTripSetting(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject tripCtrlObject;
        HashMap<String, Object> tripControlSettingMap = new HashMap<String, Object>(16);
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (null == bill) {
            return tripControlSettingMap;
        }
        Object paramsob = map.get("params");
        if (!(paramsob instanceof Map)) {
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return tripControlSettingMap;
        }
        Map params = (Map)paramsob;
        DynamicObject fieldmapping = (DynamicObject)params.get("fieldmap");
        DynamicObject company = bill.getDynamicObject("company");
        if (null == company) {
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return tripControlSettingMap;
        }
        Long orgId = company.getLong("id");
        String server = fieldmapping.getDynamicObject("server").getString("number");
        if (orgId != null && (tripCtrlObject = TripCommonUtil.getTripControlSettings(orgId, server)) != null) {
            String cardatectrl;
            String hotelcityctrl;
            String hoteldatectrl;
            String cityctrl;
            int flightSkipFields = 64991;
            int hotelSkipFields = 16367;
            int carSkipFields = 2046;
            int trainSkipFields = 2047;
            flightSkipFields -= 8;
            String datectrl = tripCtrlObject.getString("domairdatectrl");
            if (!"0".equals(datectrl)) {
                flightSkipFields = flightSkipFields - 2 - 4 - 128 - 256;
            }
            if (!"0".equals(cityctrl = tripCtrlObject.getString("domaircityctrl"))) {
                flightSkipFields = flightSkipFields - 16 - 1024;
            }
            if (!"0".equals(hoteldatectrl = tripCtrlObject.getString("hoteldatectrl"))) {
                hotelSkipFields = hotelSkipFields - 1 - 2 - 4 - 8;
            }
            if (!"0".equals(hotelcityctrl = tripCtrlObject.getString("hotelcityctrl"))) {
                hotelSkipFields -= 32;
            }
            hotelSkipFields -= 4096;
            hotelSkipFields -= 512;
            hotelSkipFields -= 1024;
            String carcityctrl = tripCtrlObject.getString("carcityctrl");
            if (!"0".equals(carcityctrl)) {
                carSkipFields -= 2;
            }
            if (!"0".equals(cardatectrl = tripCtrlObject.getString("cardatectrl"))) {
                carSkipFields = carSkipFields - 8 - 16;
            }
            String trainDateCtrl = tripCtrlObject.getString("traindatectrl");
            String trainCityCtrl = tripCtrlObject.getString("traincityctrl");
            String trainTripPeopleCtrl = tripCtrlObject.getString("traintrippeoplectrl");
            --trainSkipFields;
            if (StringUtils.isNotEmpty((String)trainDateCtrl) && "1".equals(trainDateCtrl)) {
                trainSkipFields = trainSkipFields - 2 - 4 - 8 - 16;
            }
            if (StringUtils.isNotEmpty((String)trainCityCtrl) && "1".equals(trainCityCtrl)) {
                trainSkipFields = trainSkipFields - 64 - 128;
            }
            if (StringUtils.isNotEmpty((String)trainTripPeopleCtrl) && !"2".equals(trainTripPeopleCtrl)) {
                trainSkipFields -= 32;
            }
            tripControlSettingMap.put("orgId", orgId);
            tripControlSettingMap.put("tripCtrlObject", tripCtrlObject);
            tripControlSettingMap.put("flightSkipFields", flightSkipFields);
            tripControlSettingMap.put("hotelSkipFields", hotelSkipFields);
            tripControlSettingMap.put("carSkipFields", carSkipFields);
            if (StringUtils.isEmpty((String)trainDateCtrl) && StringUtils.isEmpty((String)trainCityCtrl) && StringUtils.isEmpty((String)trainTripPeopleCtrl)) {
                tripControlSettingMap.put("trainSkipFields", 1792);
            } else {
                tripControlSettingMap.put("trainSkipFields", trainSkipFields);
            }
        }
        return tripControlSettingMap;
    }

    public Object getCIdStrByBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Set<Long> ids = this.getBillCityIds(req, map);
        Set cityCodeAndIds = (Set)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_ID, ids + tripSyncLogParam.getTraceid(), () -> TripCityUtil.getCityIds(ids));
        return StringUtils.join((Collection)cityCodeAndIds, (String)",");
    }

    public Object getCPassengerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return null;
        }
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        ArrayList<Map<String, Object>> listNumber = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> listName = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(64);
        this.getUserInfoList(ctx, listNumber, listName, list);
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String carPeopleCtr = tripCtrlObject.getString("cartrippeoplectrl");
        if (StringUtils.isNotEmpty((String)carPeopleCtr) && "1".equals(carPeopleCtr)) {
            return list;
        }
        if (StringUtils.isNotEmpty((String)carPeopleCtr) && "0".equals(carPeopleCtr)) {
            return listName;
        }
        if (StringUtils.isNotEmpty((String)carPeopleCtr) && "2".equals(carPeopleCtr)) {
            return list;
        }
        return null;
    }

    public Object getCSkipFields(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return "2046";
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        Integer carSkipFields = (Integer)tripControlSettingMap.get("carSkipFields");
        String carPeopleCtr = tripCtrlObject.getString("cartrippeoplectrl");
        if (StringUtils.isNotEmpty((String)carPeopleCtr) && "2".equals(carPeopleCtr)) {
            carSkipFields = carSkipFields + 1;
        }
        return carSkipFields;
    }

    public Object getTPassengerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield);
        ArrayList<Map<String, Object>> listNumber = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> listName = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(64);
        this.getUserInfoList(ctx, listNumber, listName, list);
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return list;
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String trainPeopleCtr = tripCtrlObject.getString("traintrippeoplectrl");
        if (StringUtils.isNotEmpty((String)trainPeopleCtr) && "1".equals(trainPeopleCtr)) {
            return list;
        }
        if (StringUtils.isNotEmpty((String)trainPeopleCtr) && "0".equals(trainPeopleCtr)) {
            return listName;
        }
        if (StringUtils.isNotEmpty((String)trainPeopleCtr) && "2".equals(trainPeopleCtr)) {
            return list;
        }
        return list;
    }

    public Object getTripPassengerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        ArrayList<Object> ctx = new ArrayList<Object>(8);
        if (map.get("billValue") instanceof Object[]) {
            Object[] os = (Object[])map.get("billValue");
            ctx.addAll(Arrays.asList(os));
        } else {
            ctx.add(map.get("billValue"));
        }
        ArrayList<Map<String, Object>> listNumber = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> listName = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(64);
        this.getUserInfoList(ctx.toArray(), listNumber, listName, list);
        return list;
    }

    public Object getEmployeeIDByBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object ctx;
        boolean paramValue;
        Object ctx2;
        Boolean isdoc;
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        HashSet<String> numbers = new HashSet<String>(8);
        String billfield = map.getOrDefault("billfield", "").toString();
        Object ctx1 = TripCommonUtil.getDValueByfield(req, billfield);
        if (null != ctx1 && !ctx1.toString().trim().isEmpty()) {
            numbers.add(ctx1.toString());
        }
        if ((isdoc = Boolean.valueOf(TripSyncConfigUtil.getBoolean("ctrip_reqbill_DocumentMaker"))).booleanValue() && null != (ctx2 = TripCommonUtil.getDValueByfield(req, "creator.number")) && !ctx2.toString().trim().isEmpty()) {
            numbers.add(ctx2.toString());
        }
        if ((paramValue = TripSyncConfigUtil.getBoolean("Reservation_ personnel_range")) && (ctx = TripCommonUtil.getDValueByfield(req, "tripentry.travelers")) instanceof Object[]) {
            Object[] os;
            for (Object o : os = (Object[])ctx) {
                if (!(o instanceof DynamicObjectCollection)) continue;
                DynamicObjectCollection travelers = (DynamicObjectCollection)o;
                for (DynamicObject dynamicObject : travelers) {
                    String number = dynamicObject.getDynamicObject("fbasedataid").getString("number");
                    if (null == number || number.trim().isEmpty()) continue;
                    numbers.add(number);
                }
            }
        }
        return StringUtils.join(numbers, (String)",");
    }

    public Object getCityAreaCodeByBill(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        HashSet<String> cityAreaCodeset = new HashSet<String>();
        ArrayList<String> cityAreaCodes = new ArrayList<String>();
        if (null == req) {
            logger.info("getCityAreaCodeByBill req\u4e3a\u7a7a");
            return null;
        }
        DynamicObjectCollection tripentry = req.getDynamicObjectCollection("tripentry");
        for (DynamicObject entry : tripentry) {
            DynamicObject from = entry.getDynamicObject("from");
            DynamicObject to = entry.getDynamicObject("to");
            cityAreaCodeset.add(from.getString("areacode"));
            cityAreaCodeset.add(to.getString("areacode"));
        }
        cityAreaCodes.addAll(cityAreaCodeset);
        return cityAreaCodes;
    }

    public Object getReqCompanyId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = 0L;
        String billfield = (String)map.getOrDefault("billfield", "");
        if (null == map.get("params")) {
            return deptId;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return deptId;
        }
        Long applyBillOrgId = OrgPlugin.getApplyBillOrgId(map, billfield);
        if (0L != applyBillOrgId) {
            return applyBillOrgId;
        }
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty()) {
            if (NumberUtils.isCreatable((String)map.get("jsonvalue").toString())) {
                return Long.parseLong(map.get("jsonvalue").toString());
            }
            String jsonvalue = map.get("jsonvalue").toString();
            if (jsonvalue.contains("{")) {
                JSONObject json = JSON.parseObject((String)jsonvalue);
                if (billfield.equals("org")) {
                    return json.getOrDefault((Object)"deptId", (Object)deptId);
                }
                return json.getOrDefault((Object)"companyId", (Object)deptId);
            }
            DynamicObject org = OrgPlugin.getOrgByNumber(jsonvalue);
            return org == null ? deptId : ErCommonUtils.getPk(org);
        }
        deptId = OrgPlugin.getUserDeptId(map, true);
        if (billfield.equals("org")) {
            return deptId;
        }
        return OrgPlugin.getCompanyByDeptId(deptId, tripSyncLogParam.getTraceid());
    }

    public Object getReqCostcenter(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long std_costcenter = 0L;
        Long applyBillOrgId = OrgPlugin.getApplyBillOrgId(map, "std_costcenter");
        if (0L != applyBillOrgId) {
            return applyBillOrgId;
        }
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty()) {
            if (NumberUtils.isCreatable((String)map.get("jsonvalue").toString())) {
                return Long.parseLong(map.get("jsonvalue").toString());
            }
            String jsonvalue = map.get("jsonvalue").toString();
            if (jsonvalue.contains("stdCostcenterId") && jsonvalue.contains("{")) {
                JSONObject json = JSON.parseObject((String)jsonvalue);
                return json.getOrDefault((Object)"stdCostcenterId", (Object)0L);
            }
            DynamicObject costCenterByCostDept = ReqBillPlugin.getCostcenterByNumber(jsonvalue);
            return null == costCenterByCostDept ? std_costcenter : ErCommonUtils.getPk(costCenterByCostDept.get(0));
        }
        OrgPlugin orgplugin = OrgPlugin.getInstance();
        Object deptId = orgplugin.getSettleDept(map, tripSyncLogParam);
        if (deptId == null) {
            return std_costcenter;
        }
        DynamicObject costCenterByCostDept = (DynamicObject)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_COSTTENTER, RequestContext.get().getTraceId() + deptId, () -> ErCostCenterUtil.getCostCenterByCostDept(Long.parseLong(deptId.toString())));
        return null == costCenterByCostDept ? std_costcenter.longValue() : costCenterByCostDept.getLong("id");
    }

    public static DynamicObject getCostcenterByNumber(String jsonvalue) {
        return (DynamicObject)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_COSTTENTER_NUMBER, RequestContext.get().getTraceId() + jsonvalue, () -> {
            QFilter qFilter = new QFilter("number", "=", (Object)jsonvalue);
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{qFilter, new QFilter("enable", "=", (Object)"1")});
        });
    }

    public Object getEmployeeID(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        HashSet<String> numbers = new HashSet<String>(64);
        DynamicObject applierDynamic = req.getDynamicObject("applier");
        DynamicObject creatorDynamic = req.getDynamicObject("creator");
        numbers.add(applierDynamic.getString("number"));
        numbers.add(creatorDynamic.getString("number"));
        DynamicObjectCollection tripentry = req.getDynamicObjectCollection("tripentry");
        if (null != tripentry) {
            for (DynamicObject trip : tripentry) {
                DynamicObjectCollection travelers = trip.getDynamicObjectCollection("travelers");
                if (null == travelers) continue;
                for (DynamicObject traveler : travelers) {
                    numbers.add(traveler.getDynamicObject("fbasedataid").getString("number"));
                }
            }
        }
        return StringUtils.join((Object[])numbers.toArray(), (String)",");
    }

    public Object getTrainSkipFields(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return "1792";
        }
        return tripControlSettingMap.get("trainSkipFields");
    }

    public Object getTrainTripType(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        if (null == req) {
            return null;
        }
        Map tripControlSettingMap = (Map)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_CRL, req.getString("billno"), () -> this.getTripSetting(map, tripSyncLogParam));
        if (null == tripControlSettingMap || null == tripControlSettingMap.get("tripCtrlObject") || !(tripControlSettingMap.get("tripCtrlObject") instanceof DynamicObject)) {
            return "2";
        }
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        String tripType = tripCtrlObject.getString("trainroundtripctrl");
        return StringUtils.isEmpty((String)tripType) ? "2" : tripType;
    }

    public Object getIsHaveForeignCity(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject req = (DynamicObject)map.get("bill");
        Object billValue = map.get("billValue");
        if (null == req) {
            logger.info("getIsHaveForeignCity req\u4e3a\u7a7a");
            return Boolean.FALSE;
        }
        DynamicObjectCollection tripentry = req.getDynamicObjectCollection("tripentry");
        for (DynamicObject entry : tripentry) {
            String countryCode;
            DynamicObject country;
            if (null != billValue && !billValue.toString().equals(entry.getString("id"))) continue;
            DynamicObject from = entry.getDynamicObject("from");
            DynamicObject to = entry.getDynamicObject("to");
            if (null != from) {
                country = from.getDynamicObject("country");
                countryCode = (String)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_TWO_COUNTRY_CODE_MAP, country.getString("id"), () -> {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"twocountrycode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)country.getLong("id"))});
                    return dynamicObject == null ? "CN" : dynamicObject.getString("twocountrycode");
                });
                if (!"CN".equals(countryCode)) {
                    return Boolean.TRUE;
                }
            }
            if (null == to) continue;
            country = to.getDynamicObject("country");
            countryCode = (String)ActionLocalCache.get().get(REQ_BILL_DYNAMIC_OBJECT_TWO_COUNTRY_CODE_MAP, country.getString("id"), () -> {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"twocountrycode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)country.getLong("id"))});
                return dynamicObject == null ? "CN" : dynamicObject.getString("twocountrycode");
            });
            if ("CN".equals(countryCode)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static class loadClass {
        private static ReqBillPlugin service = new ReqBillPlugin();

        private loadClass() {
        }
    }
}

