/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.server.dtrip;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.server.dtrip.DtripPullCommonInvoke;

public class DtripSyncCheckInvoke
extends DtripPullCommonInvoke {
    private static final Log logger = LogFactory.getLog(DtripSyncCheckInvoke.class);

    @Override
    public Object execute(Map<String, Object> params) {
        return super.execute(params);
    }

    @Override
    public Object batpull(Object t) {
        return super.batpull(t);
    }

    @Override
    public Object fieldmapping(Object data) {
        if (data == null) {
            return super.fieldmapping(data);
        }
        return super.fieldmapping(data);
    }

    @Override
    protected Object filterdata(Object data) {
        if (null == data) {
            logger.info("DtripSyncCheckInvoke infos is null");
            return null;
        }
        if ((data = super.filterdata(data)) == null) {
            return null;
        }
        JSONObject jsonData = (JSONObject)data;
        JSONObject json = jsonData.getJSONObject("data");
        if (json == null) {
            return jsonData;
        }
        JSONArray dataList = json.getJSONArray("list");
        if (dataList == null || dataList.size() == 0) {
            return jsonData;
        }
        int size = dataList.size();
        String orgId = "";
        if (this.params.containsKey("org")) {
            orgId = this.params.get("org").toString();
        }
        String operationType = "";
        if (this.params.containsKey("operationtype")) {
            operationType = TypeEnum.getTripType(this.params.get("operationtype").toString()).getType();
        }
        ArrayList removeOutJsonList = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = dataList.getJSONObject(i);
            Object out_budget_id = jsonObject.get((Object)"out_budget_id");
            if (StringUtils.isNotEmpty((String)orgId) && out_budget_id != null && !orgId.equals(out_budget_id.toString())) {
                removeOutJsonList.add(jsonObject);
                continue;
            }
            JSONArray sub_bill_summary = jsonObject.getJSONArray("sub_bill_summary");
            if (sub_bill_summary == null || sub_bill_summary.size() == 0) continue;
            int subSize = sub_bill_summary.size();
            ArrayList removeJsonList = Lists.newArrayListWithCapacity((int)subSize);
            for (int subIndex = 0; subIndex < subSize; ++subIndex) {
                JSONObject subJson = sub_bill_summary.getJSONObject(subIndex);
                String business_type = subJson.getString("business_type");
                if (StringUtils.isNotEmpty((String)operationType) && !operationType.equals(business_type)) {
                    removeJsonList.add(subJson);
                    continue;
                }
                if (!subJson.containsKey((Object)"refund_amount") || !subJson.containsKey((Object)"amount_money")) continue;
                BigDecimal refund_amount = subJson.getBigDecimal("refund_amount");
                BigDecimal amount_money = subJson.getBigDecimal("amount_money");
                if (refund_amount == null || amount_money == null || BigDecimal.ZERO.compareTo(refund_amount) != 0 || BigDecimal.ZERO.compareTo(amount_money) != 0) continue;
                removeJsonList.add(subJson);
            }
            if (!CollectionUtils.isNotEmpty((Collection)removeJsonList)) continue;
            for (JSONObject removeJson : removeJsonList) {
                sub_bill_summary.remove((Object)removeJson);
            }
            if (sub_bill_summary.size() != 0) continue;
            removeOutJsonList.add(jsonObject);
        }
        if (CollectionUtils.isNotEmpty((Collection)removeOutJsonList)) {
            for (JSONObject removeJson : removeOutJsonList) {
                dataList.remove((Object)removeJson);
            }
        }
        return jsonData;
    }

    @Override
    public Boolean businessIsContinue() {
        return Boolean.FALSE;
    }

    @Override
    public boolean isComfirmUpdate(DynamicObject object) {
        Boolean confirmed_data_modified = TripSyncConfigUtil.getBoolean("confirmed_data_modified");
        return confirmed_data_modified != false || !Arrays.asList("2", "3").contains(object.getString("billstatusname"));
    }

    private static enum TypeEnum {
        PLANE_202("202", "er_planebill", "er_planecheckingbill", "2"),
        PLANE_205("205", "er_planebill", "er_planecheckingbill", "4"),
        HOTEL_201("201", "er_hotelbill", "er_hotelcheckingbill", "1"),
        HOTEL_204("204", "er_hotelbill", "er_hotelcheckingbill", "5"),
        TRAIN_203("203", "er_trainbill", "er_traincheckingbill", "6");

        private String order;
        private String checking;
        private String operationtype;
        private String type;

        private TypeEnum(String type, String order, String checking, String operationtype) {
            this.type = type;
            this.order = order;
            this.checking = checking;
            this.operationtype = operationtype;
        }

        public static TypeEnum getTripType(String type) {
            for (TypeEnum value : TypeEnum.values()) {
                if (!value.operationtype.equals(type)) continue;
                return value;
            }
            return PLANE_202;
        }

        public String getOrder() {
            return this.order;
        }

        public String getChecking() {
            return this.checking;
        }

        public String getOperationtype() {
            return this.operationtype;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

