/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.server.mytrip;

import com.google.common.util.concurrent.RateLimiter;
import java.time.Duration;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.function.PushInvoke;
import kd.fi.er.business.trip.v2.utils.SyncUserUtils;

public class MTripSyncUserInvoke
extends PushInvoke {
    private final RateLimiter rateLimiter;
    private static Log logger = LogFactory.getLog(MTripSyncUserInvoke.class);

    public MTripSyncUserInvoke() {
        int qps = TripSyncConfigUtil.getIntValue("meiya_qps", 4);
        this.rateLimiter = RateLimiter.create((double)qps);
    }

    @Override
    public Object fieldmapping(Object datas) {
        String serverName = Supplier.MEIYA.name();
        Object grantData = SyncUserUtils.checkGrantUser(serverName, datas, this.tripSyncLogParam);
        if (grantData == null) {
            return grantData;
        }
        return super.fieldmapping(grantData);
    }

    @Override
    public String httpPost(String url, Object o) {
        if (this.rateLimiter.tryAcquire(Duration.ofSeconds(30L))) {
            return super.httpPost(url, o);
        }
        throw new RuntimeException(ResManager.loadKDString((String)"\u7f8e\u4e9a\u4eba\u5458\u540c\u6b65\u63a5\u53e3\u9650\u6d41\uff0c\u7ec8\u6b62\u8bf7\u6c42\u3002", (String)"MTripSyncUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
    }
}

