/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.tripstd.service.imp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TTripPropMapping;
import kd.fi.er.business.tripstd.model.TripReimEntryValidateItem;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdControlService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.type.SubsidiesDayParamEnum;
import org.apache.commons.lang.StringUtils;

public class ErTripStdControlServiceImpl
implements IErTripStdControlService {
    private static final Log log = LogFactory.getLog(ErTripStdControlServiceImpl.class);

    @Override
    public BigDecimal calDaycount(Object dayCount, Long companyId) {
        if (dayCount == null || companyId == null) {
            log.warn(String.format("\u65b9\u6cd5calDaycount\u63a5\u6536\u5230\u53c2\u6570dayCount \uff1a%s \u4e3a\u7a7a\u6216\u8005\u53c2\u6570companyId\uff1a%s \u4e3a\u7a7a", dayCount, companyId));
            return BigDecimal.ZERO;
        }
        BigDecimal calDayCount = new BigDecimal(Integer.parseInt(dayCount.toString()));
        BigDecimal tripDays = BigDecimal.ZERO;
        int subsidiesDayControl = ErCommonUtils.getSubsidiesDays(companyId);
        tripDays = this.addDaysBySubsidiesDayControl(calDayCount, subsidiesDayControl);
        return tripDays;
    }

    public BigDecimal addDaysBySubsidiesDayControl(BigDecimal calDayCount, int subsidiesDayControl) {
        BigDecimal tripDays = BigDecimal.ZERO;
        if (subsidiesDayControl == SubsidiesDayParamEnum.NORMAL_CONTROL.getValue()) {
            tripDays = calDayCount;
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_ONE_CONTROL.getValue()) {
            tripDays = calDayCount.add(BigDecimal.ONE);
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_HALF_CONTROL.getValue()) {
            tripDays = calDayCount.add(BigDecimal.valueOf(0.5));
        }
        return tripDays;
    }

    @Override
    public boolean checkCabinIsOver(Map<String, String> vehicleStd, String cabinclass, String vehicleType) {
        if (cabinclass == null) {
            log.info("\u8231\u4f4d\u6821\u9a8c\u5931\u8d25, \u8ba2\u5355\u8231\u4f4d\u4e3a\u7a7a");
            return true;
        }
        if (vehicleStd != null && vehicleType != null) {
            if (vehicleStd.get(vehicleType) == null) {
                return true;
            }
            if (StringUtils.equals((String)"air", (String)vehicleType)) {
                if (cabinclass.contains(ResManager.loadKDString((String)"\u7ecf\u6d4e", (String)"ErTripStdControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0])) || cabinclass.contains(ResManager.loadKDString((String)"\u5168\u4ef7\u8231", (String)"ErTripStdControlServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]))) {
                    cabinclass = ResManager.loadKDString((String)"\u7ecf\u6d4e", (String)"ErTripStdControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
                } else if (cabinclass.contains(ResManager.loadKDString((String)"\u516c\u52a1", (String)"ErTripStdControlServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0])) || cabinclass.contains(ResManager.loadKDString((String)"\u5546\u52a1", (String)"ErTripStdControlServiceImpl_3", (String)"fi-er-business", (Object[])new Object[0]))) {
                    cabinclass = ResManager.loadKDString((String)"\u5546\u52a1", (String)"ErTripStdControlServiceImpl_3", (String)"fi-er-business", (Object[])new Object[0]);
                } else if (cabinclass.contains(ResManager.loadKDString((String)"\u5934\u7b49", (String)"ErTripStdControlServiceImpl_4", (String)"fi-er-business", (Object[])new Object[0]))) {
                    cabinclass = ResManager.loadKDString((String)"\u5934\u7b49", (String)"ErTripStdControlServiceImpl_4", (String)"fi-er-business", (Object[])new Object[0]);
                }
            }
            if (StringUtils.equals((String)"train", (String)vehicleType)) {
                Map<String, String> trainSeatMap = TTripPropMapping.trainSeatMap();
                vehicleStd.put(vehicleType, Arrays.stream(vehicleStd.get(vehicleType).split(",")).map(vhc -> (String)trainSeatMap.get(vhc)).collect(Collectors.joining(",")));
            }
            return !vehicleStd.get(vehicleType).contains(cabinclass) && !cabinclass.contains(vehicleStd.get(vehicleType));
        }
        return true;
    }

    @Override
    public boolean checkCabinIsOver(DynamicObject entry, Long userId, Long companyId) {
        String ordernum = entry.getString("ordernum");
        String orderformid = entry.getString("orderformid");
        return this.checkCabinIsOver(ordernum, orderformid, userId, companyId);
    }

    @Override
    public boolean checkCabinIsOver(String ordernum, String orderformid, Long userId, Long companyId) {
        log.info(String.format("\u68c0\u67e5\u4ed3\u4f4d\u662f\u5426\u8d85\u6807,\u8ba2\u5355\u53f7:%s,\u8ba2\u5355\u8868\u5355ID:%s,\u7528\u6237ID:%s,\u516c\u53f8ID:%s", ordernum, orderformid, userId, companyId));
        boolean checkCabinIsOver = false;
        if (!StringUtils.isBlank((String)ordernum) && !StringUtils.isBlank((String)orderformid)) {
            DynamicObject order = ErDaoFactory.getInstance(orderformid).queryOne(new QFilter("ordernum", "=", (Object)ordernum));
            String cabinclass = null;
            String vehicleType = null;
            if (StringUtils.equals((String)"er_staffplanebill", (String)orderformid) || StringUtils.equals((String)"er_planebill", (String)orderformid)) {
                vehicleType = "air";
                cabinclass = order.getString("cabinclass");
            } else if (StringUtils.equals((String)"er_trainbill", (String)orderformid)) {
                cabinclass = order.getString("trainseat");
                vehicleType = "train";
            }
            ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
            DynamicObject airVehicle = tripStdService.getVehicleStdByUserIdAndVehicleType(userId, "air", companyId);
            log.info(String.format("\u67e5\u8be2\u5230\u7528\u6237%s,\u516c\u53f8%s\u7684\u673a\u7968\u6807\u51c6\u4e3a%s", userId, companyId, airVehicle == null ? "" : airVehicle.getString("cabinstr")));
            DynamicObject trainVehicle = tripStdService.getVehicleStdByUserIdAndVehicleType(userId, "train", companyId);
            log.info(String.format("\u67e5\u8be2\u5230\u7528\u6237%s,\u516c\u53f8%s\u7684\u706b\u8f66\u6807\u51c6\u4e3a%s", userId, companyId, trainVehicle == null ? "" : trainVehicle.getString("cabinstr")));
            HashMap vehicleStd = Maps.newHashMap();
            vehicleStd.put("air", airVehicle == null ? null : airVehicle.getString("cabinstr"));
            vehicleStd.put("train", trainVehicle == null ? null : trainVehicle.getString("cabinstr"));
            checkCabinIsOver = this.checkCabinIsOver(vehicleStd, cabinclass, vehicleType);
            log.info(String.format("\u68c0\u67e5\u7528\u6237%s,\u516c\u53f8%s\u7684\u6b64\u6b21\u884c\u7a0b\u662f\u5426\u8d85\u6807%s", userId, companyId, checkCabinIsOver));
        }
        return checkCabinIsOver;
    }

    @Override
    public boolean checkTripStandardAmountIsOver(DynamicObject tripEntry, DynamicObject expenseItemEntry, Long companyId, Long userId) {
        boolean isOver = true;
        BigDecimal tripDays = (BigDecimal)expenseItemEntry.get("caldaycount");
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        DynamicObject tripArea = tripEntry.getDynamicObject("tripEntryArea");
        BigDecimal oriEntryAmount = expenseItemEntry.getBigDecimal("orientryamount");
        DynamicObject expenseitem = expenseItemEntry.getDynamicObject("expenseitem");
        DynamicObject currency = tripEntry.getDynamicObject("tripcurrency");
        String expenseitemId = expenseitem.getPkValue().toString();
        String currencyId = currency.getPkValue().toString();
        List<TripStandardDetail> tripStandardDetailList = tripStdService.getTripStandardDetailList(userId, companyId);
        if (tripArea != null) {
            BigDecimal tripStandardAmount = tripStdService.getTripStandardAmountByTripArea(tripArea.getPkValue().toString(), expenseitemId, currencyId, tripStandardDetailList);
            log.info(String.format("\u7528\u6237\uff1a%s \u7684\u5dee\u65c5\u6807\u51c6\u91d1\u989d\u4e3a\uff1a%s \u4eba\u5929,\u5929\u6570\u4e3a:%s", userId, tripStandardAmount, tripDays));
            BigDecimal totalAmount = tripStandardAmount.multiply(tripDays);
            log.info(String.format("\u7528\u6237\uff1a%s \u7684\u5dee\u65c5\u6807\u51c6\u603b\u91d1\u989d\u4e3a\uff1a%s,\u62a5\u9500\u91d1\u989d\u4e3a\uff1a%s", userId, totalAmount, oriEntryAmount));
            isOver = totalAmount.compareTo(oriEntryAmount) < 0;
        }
        return isOver;
    }

    @Override
    public boolean checkTripStandardAmountIsOver(List<Long> travelerIds, Long companyId, String tripStdCtrlType, DynamicObject tripEntry, DynamicObject expenseItemEntry) {
        BigDecimal tripDays = (BigDecimal)expenseItemEntry.get("caldaycount");
        boolean isOver = false;
        BigDecimal oriEntryAmount = expenseItemEntry.getBigDecimal("orientryamount");
        DynamicObject expenseitem = expenseItemEntry.getDynamicObject("expenseitem");
        boolean userOutStdCtrl = expenseItemEntry.getBoolean("useroutstdctrl");
        if (expenseitem == null || userOutStdCtrl) {
            return isOver;
        }
        BigDecimal stdAmount = expenseItemEntry.getBigDecimal("tripstandardamount");
        String expenseAttribute = expenseitem.getString("attribute");
        if (StringUtils.equals((String)expenseAttribute, (String)"1") || StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)tripStdCtrlType, (String)"sum")) {
            BigDecimal totalAmount = stdAmount.multiply(tripDays);
            log.info("GroupedTripStandardValidate>>> reimburseAmount: " + oriEntryAmount + "; totalAmount: " + totalAmount);
            return oriEntryAmount.compareTo(totalAmount) > 0;
        }
        if (StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)tripStdCtrlType, (String)"max")) {
            BigDecimal totalAmount = stdAmount.multiply(tripDays.multiply(new BigDecimal(travelerIds.size())));
            log.info("GroupedTripStandardValidate>>> reimburseAmount: " + oriEntryAmount + "; totalAmount: " + totalAmount);
            return oriEntryAmount.compareTo(totalAmount) > 0;
        }
        return isOver;
    }

    @Override
    public boolean checkTripStandardGroupedAmountIsOver(List<Long> travelerIds, TripReimEntryValidateItem validateItem, String tripStdCtrlType, DynamicObject tripEntry) {
        BigDecimal totalAmount;
        boolean isOver = false;
        Long companyId = validateItem.getCompanyId();
        BigDecimal tripDays = new BigDecimal(this.getTripDays(tripEntry, companyId));
        BigDecimal reimburseAmount = validateItem.getReimAmount();
        BigDecimal stdAmount = validateItem.getStdAmount();
        DynamicObject tripExpenseItem = validateItem.getTripExpenseItem();
        String expenseAttribute = tripExpenseItem.getString("attribute");
        String travelersStdControlType = (String)ErCommonUtils.getEMParameter(companyId, "tripstdsummarycheck");
        if (StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)"yes", (String)travelersStdControlType)) {
            Date endDate = tripEntry.getDate("enddate");
            Date startdate = tripEntry.getDate("startdate");
            tripDays = new BigDecimal(ErTripStdControlServiceImpl.differentDaysByMillisecond(startdate, endDate));
        }
        if (StringUtils.equals((String)expenseAttribute, (String)"1") || StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)tripStdCtrlType, (String)"sum")) {
            totalAmount = stdAmount.multiply(tripDays);
            log.info("GroupedTripStandardValidate>>> tripDays: " + tripDays + "; reimburseAmount: " + reimburseAmount + "; totalAmount: " + totalAmount);
            return reimburseAmount.compareTo(totalAmount) > 0;
        }
        if (StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)tripStdCtrlType, (String)"max")) {
            totalAmount = stdAmount.multiply(tripDays.multiply(new BigDecimal(travelerIds.size())));
            log.info("GroupedTripStandardValidate>>> tripDays: " + tripDays + " reimburseAmount: " + reimburseAmount + "; totalAmount: " + totalAmount);
            return reimburseAmount.compareTo(totalAmount) > 0;
        }
        return isOver;
    }

    private float getTripDays(DynamicObject tripEntry, Long companyId) {
        float tripDays = 0.0f;
        int subsidiesDayControl = ErCommonUtils.getSubsidiesDays(companyId);
        Date endDate = tripEntry.getDate("enddate");
        Date startdate = tripEntry.getDate("startdate");
        if (subsidiesDayControl == SubsidiesDayParamEnum.NORMAL_CONTROL.getValue()) {
            tripDays = Float.parseFloat(ErTripStdControlServiceImpl.differentDaysByMillisecond(startdate, endDate));
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_ONE_CONTROL.getValue()) {
            tripDays = Float.parseFloat(ErTripStdControlServiceImpl.differentDaysByMillisecond(startdate, endDate)) + 1.0f;
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_HALF_CONTROL.getValue()) {
            tripDays = Float.parseFloat(ErTripStdControlServiceImpl.differentDaysByMillisecond(startdate, endDate)) + 0.5f;
        }
        return tripDays;
    }

    public static String differentDaysByMillisecond(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return "0";
        }
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return Integer.toString(days);
    }

    @Override
    public BigDecimal getSubsidyDaysBetween(Date start, Date end, Long companyId) {
        LocalDate startLocalDate = this.dateToLocalDate(start);
        LocalDate endLocalDate = this.dateToLocalDate(end);
        long days = startLocalDate.until(endLocalDate, ChronoUnit.DAYS);
        BigDecimal subsidyDays = BigDecimal.valueOf(days);
        int subsidiesDayControl = ErCommonUtils.getSubsidiesDays(companyId);
        if (subsidiesDayControl == SubsidiesDayParamEnum.NORMAL_CONTROL.getValue()) {
            subsidyDays = subsidyDays.add(BigDecimal.ZERO);
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_ONE_CONTROL.getValue()) {
            subsidyDays = subsidyDays.add(new BigDecimal("1"));
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_HALF_CONTROL.getValue()) {
            subsidyDays = subsidyDays.add(new BigDecimal("0.5"));
        }
        return subsidyDays;
    }

    private LocalDate dateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.toLocalDate();
    }

    @Override
    public List<String> hasTripVhc(List<Object> allTravlerId, String vehicleType, Long companyId) {
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        log.info("\u51fa\u5dee\u4ebaid\uff1a" + allTravlerId + ",\u516c\u53f8\uff1a" + companyId);
        HashSet allVhcStd = Sets.newHashSet();
        for (Object travelerId : allTravlerId) {
            DynamicObject dObjVhcStd = tripStdService.getVehicleStdByUserIdAndVehicleType((Long)travelerId, vehicleType, companyId);
            if (dObjVhcStd == null) continue;
            List<String> vhcStd = Arrays.asList(dObjVhcStd.getString("cabinstr").split(","));
            allVhcStd.addAll(vhcStd);
        }
        return Lists.newArrayList((Iterable)allVhcStd);
    }
}

