/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.tripstd.service.imp;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.model.TripStandardModel;
import kd.fi.er.business.tripstd.context.StdPreCalContext;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ErTripStdServiceImp
implements IErTripStdService {
    private static final Log log = LogFactory.getLog(ErTripStdServiceImp.class);
    public static final String USER_COMPANYS = "kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.USER_COMPANYS";
    public static final String ORG_COMPANY = "kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.ORG_COMPANY";
    public static final String CITY_TRIP_AREA = "kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.CITY_TRIP_AREA";
    private static final String USER_TRIP_STANDARD_VEHICLE = "kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.USER_TRIP_STANDARD_VEHICLE";
    private static final String USER_TRIP_INCLUDE_EMPLOYEE = "kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.USER_TRIP_INCLUDE_EMPLOYEE";
    private static final String USER_REIM_LEVEL = "kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.USER_REIM_LEVEL";

    @Override
    @Deprecated
    public DynamicObject getReimburseLevelByUserId(Long userId) {
        if (userId == null) {
            return null;
        }
        IErDao reimburseLevelSettingDao = ErDaoFactory.getInstance("er_reimbursesetting");
        DynamicObject reimburseLevel = reimburseLevelSettingDao.queryOne(QFilter.of((String)"id=? and auditstatus='C' and reimburselevel is not null and reimburselevel != 0 and enable ='1'", (Object[])new Object[]{userId}));
        if (reimburseLevel == null) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)587648782179519488L)};
            return BusinessDataServiceHelper.loadSingle((String)"er_reimburselevel", (String)"masterid,name,number", (QFilter[])filters);
        }
        return reimburseLevel.getDynamicObject("reimburselevel");
    }

    @Override
    public DynamicObject getReimburseLevelByUserId(Long userId, Long orgId) {
        return this.getReimburseLevelByUserId(userId, orgId, null);
    }

    public DynamicObject getReimburseLevelByUserId(Long userId, Long orgId, StdPreCalContext stdPreCalContext) {
        if (userId == null || orgId == null) {
            return null;
        }
        String cacheKey = String.format("%s,%s", userId, orgId);
        DynamicObject reimburseLevel = (DynamicObject)ActionLocalCache.get().get(USER_REIM_LEVEL, cacheKey, () -> {
            Long orgId2 = ErTripStdServiceImp.getTripStdOrg4ReimburseLevel(userId, orgId, stdPreCalContext);
            return this.queryReimburseLevel(userId, orgId2, stdPreCalContext);
        });
        return reimburseLevel;
    }

    public DynamicObject queryReimburseLevel(Long userId, Long orgId) {
        return this.queryReimburseLevel(userId, orgId, null);
    }

    public DynamicObject queryReimburseLevel(Long userId, Long orgId, StdPreCalContext stdPreCalContext) {
        if (stdPreCalContext == null) {
            Object entrylevel;
            log.debug("process stdPreCalContext == null");
            QFilter q1 = QFilter.of((String)"id=? and auditstatus='C' and enable ='1'", (Object[])new Object[]{userId});
            QFilter q2 = QFilter.of((String)"user=? and company =?", (Object[])new Object[]{userId, orgId});
            DataSet userDs = QueryServiceHelper.queryDataSet((String)"getReimburseLevelByUserId1", (String)"er_reimbursesetting", (String)"id", (QFilter[])new QFilter[]{q1}, (String)"id");
            DataSet relDs = QueryServiceHelper.queryDataSet((String)"getReimburseLevelByUserId2", (String)"er_reimbursesetting_rel", (String)"user,reimburselevel", (QFilter[])new QFilter[]{q2}, (String)"user");
            DataSet finish = userDs.join(relDs).on("id", "user").select(new String[]{"reimburselevel"}).finish();
            if (finish.hasNext() && (entrylevel = finish.next().get("reimburselevel")) != null) {
                log.debug("entrylevel :" + entrylevel);
                return BusinessDataServiceHelper.loadSingleFromCache((Object)entrylevel, (String)"er_reimburselevel");
            }
        } else {
            log.debug("process stdPreCalContext != null");
            Object entrylevel = ((Map)stdPreCalContext.getUserComReimLevelObj().getUserComReimLevelMap().getOrDefault(userId, new HashMap(0))).get(orgId);
            if (entrylevel != null) {
                log.debug("entrylevel :" + entrylevel);
                return BusinessDataServiceHelper.loadSingleFromCache(entrylevel, (String)"er_reimburselevel");
            }
        }
        log.debug("return default: reimburselevel");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)587648782179519488L)};
        return BusinessDataServiceHelper.loadSingle((String)"er_reimburselevel", (String)"masterid,name,number", (QFilter[])filters);
    }

    @Override
    public DynamicObject getVehicleStdByUserIdAndVehicleType(Long userId, String vehicleType, Long companyId) {
        StdPreCalContext stdPreCalContext = (StdPreCalContext)ThreadCache.get((Object)"stdPreCalContext");
        return this.getVehicleStdByUserIdAndVehicleType(userId, vehicleType, companyId, stdPreCalContext);
    }

    public DynamicObject getVehicleStdByUserIdAndVehicleType(Long userId, String vehicleType, Long companyId, StdPreCalContext stdPreCalContext) {
        DynamicObject reimburseLevel;
        String cacheKey;
        IErDao vehicleStdDao = ErDaoFactory.getInstance("er_tripstandard_vehicle");
        Long companyId2 = companyId = ErTripStdServiceImp.getUserTripStdMainOrgByCompany(userId, companyId, stdPreCalContext);
        List<Object> includeEmployees = new ArrayList(0);
        includeEmployees = stdPreCalContext != null ? (List)stdPreCalContext.getIncludeEmployeeObj().getInCludeEmployeesByStand("er_tripstandard_vehicle").getOrDefault(userId, new ArrayList(0)) : this.getIncludeEmployeeByUserIdAndSourceBillType(userId, "er_tripstandard_vehicle");
        if (includeEmployees != null && !includeEmployees.isEmpty()) {
            cacheKey = String.format("%s,%s,%s,%s", userId, "er_tripstandard_vehicle", vehicleType, companyId);
            List<Object> finalIncludeEmployees = includeEmployees;
            DynamicObject vehicleStd = (DynamicObject)ActionLocalCache.get().get(USER_TRIP_STANDARD_VEHICLE, cacheKey, () -> {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripstandard_vehicle", (Long)companyId2);
                QFilter q1 = new QFilter("id", "in", finalIncludeEmployees.stream().map(includeEmployee -> includeEmployee.get("tripstandard")).collect(Collectors.toList()));
                return vehicleStdDao.queryOne(q1.and(new QFilter("standardtype", "=", (Object)vehicleType).and(baseDataFilter).and(new QFilter("enable", "=", (Object)Boolean.TRUE))));
            });
            if (vehicleStd != null) {
                log.info("\u6b64\u7528\u6237" + userId + "\u5904\u5728\u673a\u7968\u62a5\u9500\u6807\u51c6\u7684\u4f8b\u5916\u4e2d(\u673a\u7968\u6807\u51c6id=" + vehicleStd.getPkValue() + ")");
                return vehicleStd;
            }
        }
        if ((reimburseLevel = this.getReimburseLevelByUserId(userId, companyId, stdPreCalContext)) == null) {
            log.info("\u5f53\u524d\u7528\u6237(id=" + userId + ")\u5728\u62a5\u9500\u7ea7\u522b\u8bbe\u7f6e\u8868(t_sec_user_e)\u4e2d\u672a\u67e5\u8be2\u5230\u5df2\u5ba1\u6838\u7684\u62a5\u9500\u7ea7\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e");
        } else {
            DynamicObject[] vehicleStds = new DynamicObject[]{};
            Object reimLevelId = reimburseLevel.getPkValue();
            cacheKey = String.format("reimLevel:%s,%s,%s,%s", reimLevelId, "er_tripstandard_vehicle", vehicleType, companyId);
            DynamicObject[] vehicleStds2 = (DynamicObject[])ActionLocalCache.get().get(USER_TRIP_STANDARD_VEHICLE, cacheKey, () -> {
                DynamicObject[] vehicleStds3 = null;
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripstandard_vehicle", (Long)companyId2);
                if (baseDataFilter != null) {
                    baseDataFilter.and(new QFilter("reimburselevel.fbasedataid_id", "=", reimburseLevel.getPkValue()));
                    baseDataFilter.and(new QFilter("enable", "=", (Object)"1"));
                    baseDataFilter.and(new QFilter("standardtype", "=", (Object)vehicleType));
                    log.info(String.format("accmod\u67e5\u8be2\u6761\u4ef6\uff1a%s", baseDataFilter.toString()));
                    vehicleStds3 = vehicleStdDao.query(baseDataFilter);
                } else {
                    vehicleStds3 = vehicleStdDao.query(QFilter.of((String)"reimburselevel.fbasedataid_id=? and useorg =? and enable =? and standardtype =?", (Object[])new Object[]{reimburseLevel.getPkValue(), companyId2, "1", vehicleType}));
                }
                return vehicleStds3;
            });
            if (vehicleStds2 != null) {
                vehicleStds = vehicleStds2;
            }
            if (vehicleStds.length == 0) {
                log.info("\u8be5\u62a5\u9500\u7ea7\u522b\uff08id=" + reimburseLevel.getPkValue() + "\uff09\u672a\u8bbe\u7f6e\u5dee\u65c5\u6807\u51c6_\u4ea4\u901a\u5de5\u5177(" + vehicleType + ")");
            } else {
                return vehicleStds[0];
            }
        }
        return null;
    }

    @Override
    public DynamicObject[] getAccmodationStdByUserId(Long userId, Long companyId) {
        IErDao tripStdDao = ErDaoFactory.getInstance("er_tripstand_accmodation");
        Long mainOrg = ErTripStdServiceImp.getUserTripStdMainOrgByCompany(userId, companyId);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripstand_accmodation", (Long)mainOrg);
        List<DynamicObject> includeEmployees = this.getIncludeEmployeeByUserIdAndSourceBillType(userId, "er_tripstand_accmodation");
        DynamicObject[] includeAccmodationStds = null;
        if (!includeEmployees.isEmpty()) {
            QFilter q1 = new QFilter("id", "in", includeEmployees.stream().map(includeEmployee -> includeEmployee.get("tripstandard")).collect(Collectors.toList())).and(baseDataFilter).and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            includeAccmodationStds = tripStdDao.query(q1);
        }
        DynamicObject[] normalAccmodationStds = null;
        DynamicObject reimburseLevel = this.getReimburseLevelByUserId(userId, companyId);
        if (reimburseLevel == null) {
            log.info("\u5f53\u524d\u7528\u6237(id=" + userId + ")\u5728\u62a5\u9500\u7ea7\u522b\u8bbe\u7f6e\u8868(t_sec_user_e)\u4e2d\u672a\u67e5\u8be2\u5230\u5df2\u5ba1\u6838\u7684\u62a5\u9500\u7ea7\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e");
            normalAccmodationStds = new DynamicObject[]{};
        } else {
            DynamicObject[] tripstdAccmods;
            if (baseDataFilter != null) {
                baseDataFilter.and(new QFilter("reimburselevel.fbasedataid_id", "=", reimburseLevel.getPkValue()));
                baseDataFilter.and(new QFilter("enable", "=", (Object)"1"));
                log.info(String.format("accmod\u67e5\u8be2\u6761\u4ef6\uff1a%s", baseDataFilter.toString()));
                tripstdAccmods = tripStdDao.query(baseDataFilter);
            } else {
                tripstdAccmods = tripStdDao.query(QFilter.of((String)"reimburselevel.fbasedataid_id=? and useorg =? and enable =?", (Object[])new Object[]{reimburseLevel.getPkValue(), mainOrg, "1"}));
            }
            normalAccmodationStds = tripstdAccmods;
        }
        return this.union(includeAccmodationStds, normalAccmodationStds);
    }

    private DynamicObject[] union(DynamicObject[] includeAccmodationStds, DynamicObject[] normalAccmodationStds) {
        if (includeAccmodationStds == null || includeAccmodationStds.length == 0) {
            return normalAccmodationStds;
        }
        List<DynamicObject> normal = this.duplicateRemove(includeAccmodationStds, normalAccmodationStds);
        includeAccmodationStds[0].getDynamicObjectCollection("entryentity").addAll(normal);
        return includeAccmodationStds;
    }

    private List<DynamicObject> duplicateRemove(DynamicObject[] includeAccmodationStds, DynamicObject[] normalAccmodationStds) {
        List include = Stream.of(includeAccmodationStds).flatMap(acc -> acc.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        List<DynamicObject> normal = Stream.of(normalAccmodationStds).flatMap(acc -> acc.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        HashSet<String> set = new HashSet<String>(include.size());
        for (DynamicObject tripStdEntry : include) {
            set.add(this.getHash(tripStdEntry));
        }
        Iterator iterator = normal.iterator();
        while (iterator.hasNext()) {
            DynamicObject tripStdEntry;
            tripStdEntry = (DynamicObject)iterator.next();
            if (set.add(this.getHash(tripStdEntry))) continue;
            iterator.remove();
        }
        return normal;
    }

    private String getHash(DynamicObject tripStdEntry) {
        return String.format("%s,%s,%s", tripStdEntry.get("currency_id"), tripStdEntry.get("triparea_id"), tripStdEntry.get("tripstandardtype_id"));
    }

    @Override
    public List<DynamicObject> getIncludeEmployeeByUserIdAndSourceBillType(Long userId, String sourceBillType) {
        String cacheKey = String.format("%s,%s", userId, sourceBillType);
        List includeEmployeeLst = (List)ActionLocalCache.get().get(USER_TRIP_INCLUDE_EMPLOYEE, cacheKey, () -> {
            IErDao includeEmployeeDao = ErDaoFactory.getInstance("er_include_employee");
            DynamicObject[] includeEmployees = includeEmployeeDao.query(QFilter.of((String)"entryentity.user=? and sourcebilltype=?", (Object[])new Object[]{userId, sourceBillType}));
            if (includeEmployees == null || includeEmployees.length < 1) {
                return new ArrayList();
            }
            return Arrays.stream(includeEmployees).collect(Collectors.toList());
        });
        return includeEmployeeLst;
    }

    @Override
    public DynamicObject getExpenseItemByName(String name) {
        return ErDaoFactory.getInstance("er_expenseitemedit").queryOne(QFilter.of((String)"name=?", (Object[])new Object[]{name}));
    }

    @Override
    public BigDecimal getTripStandardAmount(Long userId, String cityId, String expenseItemId, String currencyId, Long companyId) {
        List<TripStandardDetail> tripStandardDetailList = this.getTripStandardDetailList(userId, companyId);
        return this.getTripStandardAmountByStandardDetail(cityId, expenseItemId, currencyId, tripStandardDetailList);
    }

    @Override
    public List<TripStandardDetail> getTripStandardDetailList(Long userId, Long companyId) {
        log.info("\u62a5\u9500\u4ebaid\u4e3a\uff1a" + userId + ",\u516c\u53f8\u4e3a\uff1a" + companyId);
        ArrayList tripStandardDetails = Lists.newArrayList();
        DynamicObject[] accmodations = this.getAccmodationStdByUserId(userId, companyId);
        if (accmodations != null && accmodations.length > 0) {
            log.info("\u62a5\u9500\u4ebaid\uff1a" + userId + ",\u67e5\u8be2\u5230\u8865\u52a9\u6807\u51c6\uff1a" + SerializationUtils.toJsonString((Object)accmodations));
            List<DynamicObject> coll = Stream.of(accmodations).flatMap(acc -> acc.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            if (coll != null && !coll.isEmpty()) {
                coll.forEach(v -> {
                    TripStandardDetail detail = new TripStandardDetail();
                    detail.setCurrency(v.getDynamicObject("currency").getPkValue().toString());
                    detail.setTripstandardtype(v.getDynamicObject("tripstandardtype").getPkValue().toString());
                    detail.setStandardamount(v.getBigDecimal("standardamount"));
                    detail.setUserId(userId);
                    DynamicObject tripareaObj = v.getDynamicObject("triparea");
                    Set userSet = v.getDynamicObjectCollection("outtripstdctrluser").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    if (userSet.contains(userId)) {
                        detail.setUserOutStdCtrl(Boolean.TRUE);
                    } else {
                        detail.setUserOutStdCtrl(Boolean.FALSE);
                    }
                    if (tripareaObj != null) {
                        Object tripAreaPk = tripareaObj.getPkValue();
                        detail.setTripArea(String.valueOf(tripAreaPk));
                        DynamicObject tripArea = BusinessDataServiceHelper.loadSingleFromCache((Object)tripAreaPk, (String)"er_triparea");
                        DynamicObjectCollection citys = tripArea.getDynamicObjectCollection("entryentity");
                        ArrayList cityIds = Lists.newArrayList();
                        if (citys != null && !citys.isEmpty()) {
                            citys.forEach(city -> {
                                Long citypkId = city.getLong("city_id");
                                if (citypkId != null) {
                                    cityIds.add(String.valueOf(citypkId));
                                }
                            });
                        }
                        detail.setCityIds(cityIds);
                    }
                    tripStandardDetails.add(detail);
                });
            }
        } else {
            log.info("\u62a5\u9500\u4ebaid\uff1a" + userId + "\u672a\u67e5\u8be2\u5230\u8865\u52a9\u6807\u51c6");
        }
        return tripStandardDetails;
    }

    @Override
    public DynamicObject getAccmodationStd(Long userId, Long companyId, Object currencyId, Object tripAreaId, Object tripExpenseItemId) {
        StdPreCalContext stdPreCalContext = (StdPreCalContext)ThreadCache.get((Object)"stdPreCalContext");
        return this.getAccmodationStd(userId, companyId, currencyId, tripAreaId, tripExpenseItemId, stdPreCalContext);
    }

    public DynamicObject getAccmodationStd(Long userId, Long companyId, Object currencyId, Object tripAreaId, Object tripExpenseItemId, StdPreCalContext stdPreCalContext) {
        DynamicObject[] normalAccmodationStds;
        QFilter baseDataFilter;
        IErDao tripStdDao = ErDaoFactory.getInstance("er_tripstand_accmodation");
        Long mainOrg = ErTripStdServiceImp.getUserTripStdMainOrgByCompany(userId, companyId, stdPreCalContext);
        if (mainOrg == null) {
            return null;
        }
        if (ThreadCache.get((Object)("filterAccmStd" + mainOrg)) != null) {
            baseDataFilter = QFilter.fromSerializedString((String)((String)ThreadCache.get((Object)("filterAccmStd" + mainOrg))));
        } else {
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripstand_accmodation", (Long)mainOrg);
            ThreadCache.put((Object)("filterAccmStd" + mainOrg), (Object)baseDataFilter.toSerializedString());
        }
        List<Object> includeEmployees = new ArrayList(0);
        log.debug("stdPreCalContext !=null : " + (stdPreCalContext != null));
        includeEmployees = stdPreCalContext != null ? (List)stdPreCalContext.getIncludeEmployeeObj().getInCludeEmployeesByStand("er_tripstand_accmodation").getOrDefault(userId, new ArrayList(0)) : this.getIncludeEmployeeByUserIdAndSourceBillType(userId, "er_tripstand_accmodation");
        DynamicObject[] includeAccmodationStds = null;
        QFilter stdFilter = baseDataFilter.and(new QFilter("entryentity.tripstandardtype", "=", tripExpenseItemId)).and(new QFilter("entryentity.triparea", "=", tripAreaId)).and(new QFilter("entryentity.currency", "=", currencyId)).and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (!includeEmployees.isEmpty()) {
            log.debug("query includeEmployees tripstandard");
            QFilter includeFilter = new QFilter("id", "in", includeEmployees.stream().map(includeEmployee -> includeEmployee.get("tripstandard")).collect(Collectors.toList()));
            includeFilter = includeFilter.and(stdFilter);
            includeAccmodationStds = tripStdDao.query(includeFilter);
        }
        if (includeAccmodationStds != null && includeAccmodationStds.length > 0) {
            log.debug("return includeEmployees tripstandard");
            return includeAccmodationStds[0];
        }
        DynamicObject reimburseLevel = this.getReimburseLevelByUserId(userId, companyId, stdPreCalContext);
        if (reimburseLevel == null) {
            log.info("\u5f53\u524d\u7528\u6237(id=" + userId + ")\u5728\u62a5\u9500\u7ea7\u522b\u8bbe\u7f6e\u8868(t_sec_user_e)\u4e2d\u672a\u67e5\u8be2\u5230\u5df2\u5ba1\u6838\u7684\u62a5\u9500\u7ea7\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e");
            normalAccmodationStds = new DynamicObject[]{};
        } else {
            log.debug("reimburseLevel.getPkValue():" + reimburseLevel.getPkValue());
            stdFilter = stdFilter.and(new QFilter("reimburselevel.fbasedataid_id", "=", reimburseLevel.getPkValue()));
            log.info(String.format("accmod\u67e5\u8be2\u6761\u4ef6\uff1a%s", baseDataFilter.toString()));
            normalAccmodationStds = tripStdDao.query(stdFilter);
        }
        log.debug("normalAccmodationStds != null && normalAccmodationStds.length > 0 : " + (normalAccmodationStds != null && normalAccmodationStds.length > 0));
        if (normalAccmodationStds != null && normalAccmodationStds.length > 0) {
            return normalAccmodationStds[0];
        }
        return null;
    }

    @Override
    public BigDecimal getTripStandardAmountByStandardDetail(String cityId, String expenseItemId, String currencyId, List<TripStandardDetail> details) {
        BigDecimal tripSTDAmount = BigDecimal.ZERO;
        for (TripStandardDetail detail : details) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)detail.getTripstandardtype(), (CharSequence)expenseItemId) || !StringUtils.equalsIgnoreCase((CharSequence)detail.getCurrency(), (CharSequence)currencyId) || CollectionUtils.isEmpty(detail.getCityIds()) || !detail.getCityIds().contains(cityId)) continue;
            tripSTDAmount = detail.getStandardamount();
            break;
        }
        return tripSTDAmount;
    }

    @Override
    public DynamicObject getTripAreaByCityIdAndCompanyId(Long cityId, Long companyId) {
        String key2 = String.format("%s,%s", cityId, companyId);
        return (DynamicObject)ActionLocalCache.get().get(CITY_TRIP_AREA, key2, () -> this._getTripAreaByCityIdAndCompanyId(cityId, companyId));
    }

    private DynamicObject _getTripAreaByCityIdAndCompanyId(Long cityId, Long companyId) {
        QFilter filter = new QFilter("entryentity.city.id", "=", (Object)cityId);
        filter.and(new QFilter("enable", "=", (Object)true));
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triparea", (Long)companyId);
        if (null != baseFilter) {
            filter.and(baseFilter);
        }
        IErDao erDao = ErDaoFactory.getInstance("er_triparea");
        DynamicObject dobject = erDao.queryOne(filter);
        return dobject;
    }

    @Override
    public List<String> getAllowedCabinsByVehicleType(Long userId, Long companyId, String vehicleType) {
        DynamicObject vehicleStd = this.getVehicleStdByUserIdAndVehicleType(userId, vehicleType, companyId);
        List<String> cabins = Arrays.asList(vehicleStd.getString("cabinstr").split(","));
        if (cabins == null || cabins.isEmpty()) {
            return new ArrayList<String>();
        }
        return cabins;
    }

    @Override
    public String getHighestLevelCabinByVehicleType(Long userId, Long companyId, String vehicleType) {
        List<String> allowedCabins = this.getAllowedCabinsByVehicleType(userId, companyId, vehicleType);
        if (allowedCabins.isEmpty()) {
            return "";
        }
        return allowedCabins.get(0);
    }

    @Override
    public List<DynamicObject> getTripStdEntryByUserIdAndCompanyId(Long userId, Long companyId) {
        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>();
        DynamicObject[] accmodationStds = this.getAccmodationStdByUserId(userId, companyId);
        if (accmodationStds != null && accmodationStds.length > 0) {
            return Arrays.stream(accmodationStds).flatMap(acc -> acc.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        }
        return entrys;
    }

    @Override
    public TripStandardModel getUserTripStandard(Long userId, Long companyId, List<String> cityIds, String currencyId) {
        TripStandardModel model = new TripStandardModel();
        IErDao erDao = ErDaoFactory.getInstance("er_expenseitemedit");
        DynamicObject obj = erDao.queryOne("id", new QFilter("number", "=", (Object)"002"));
        List<TripStandardDetail> tripStandardDetailList = this.getTripStandardDetailList(userId, companyId);
        BigDecimal tripStandardAmount = BigDecimal.ZERO;
        for (String cityId : cityIds) {
            BigDecimal tempAmount = this.getTripStandardAmountByStandardDetail(cityId, obj.getPkValue().toString(), currencyId, tripStandardDetailList);
            int compareResult = tripStandardAmount.compareTo(tempAmount);
            if (compareResult >= 0) continue;
            tripStandardAmount = tempAmount;
        }
        List<String> allowedCabinsByVehicleType = this.getAllowedCabinsByVehicleType(userId, companyId, "air");
        model.setAmount(tripStandardAmount);
        model.setPlaneType(Arrays.toString(allowedCabinsByVehicleType.toArray()));
        return model;
    }

    @Override
    public BigDecimal getTripStandardAmountByTripArea(String tripAreaId, String expenseitemId, String currencyId, List<TripStandardDetail> tripStandardDetails) {
        TripStandardDetail tripStdDetail = this.getTripStandardByTripArea(tripAreaId, expenseitemId, currencyId, tripStandardDetails);
        return tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getStandardamount();
    }

    @Override
    public TripStandardDetail getTripStandardByTripArea(String tripAreaId, String expenseitemId, String currencyId, List<TripStandardDetail> tripStandardDetails) {
        for (TripStandardDetail detail : tripStandardDetails) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)detail.getTripstandardtype(), (CharSequence)expenseitemId) || !StringUtils.equalsIgnoreCase((CharSequence)detail.getCurrency(), (CharSequence)currencyId) || !StringUtils.equalsIgnoreCase((CharSequence)detail.getTripArea(), (CharSequence)tripAreaId)) continue;
            return detail;
        }
        return null;
    }

    public static Long getUserTripStdMainOrgByCompany(Long userId, Long companyId) {
        return ErTripStdServiceImp.getUserTripStdMainOrgByCompany(userId, companyId, null);
    }

    public static Long getUserTripStdMainOrgByCompany(Long userId, Long companyId, StdPreCalContext stdPreCalContext) {
        boolean takeOff;
        Object tripStdOrgType = ErCommonUtils.getEMParameter(companyId, "tripstdorgtype");
        if (tripStdOrgType == null || "0".equals(tripStdOrgType)) {
            Object dept = CommonServiceHelper.getUserMap(userId, null, true, stdPreCalContext).get("org");
            if (stdPreCalContext != null) {
                return (Long)stdPreCalContext.getDepCompanyObj().getComByOrgs(ErCommonUtils.getPk(dept)).get("id");
            }
            return (Long)OrgUnitServiceHelper.getCompanyfromOrg((Long)ErCommonUtils.getPk(dept)).get("id");
        }
        if ("1".equals(tripStdOrgType)) {
            DynamicObject org = (DynamicObject)CommonServiceHelper.getUserMap(userId, null, true, stdPreCalContext).get("org");
            return ErCommonUtils.getPk(org);
        }
        if ("2".equals(tripStdOrgType) && !(takeOff = ErTripStdServiceImp.takeOfficeImCompany(userId, companyId, stdPreCalContext))) {
            if (stdPreCalContext != null) {
                return CommonServiceHelper.getCompanyIdByUserId(userId, stdPreCalContext);
            }
            return CommonServiceHelper.getCompanyIdByUserId(userId);
        }
        return companyId;
    }

    public static Long getTripStdOrg4ReimburseLevel(Long userId, Long companyId) {
        return ErTripStdServiceImp.getTripStdOrg4ReimburseLevel(userId, companyId, null);
    }

    private static Long getTripStdOrg4ReimburseLevel(Long userId, Long companyId, StdPreCalContext stdPreCalContext) {
        Object tripStdOrgType = ErCommonUtils.getEMParameter(companyId, "tripstdorgtype");
        if (tripStdOrgType == null || "1".equals(tripStdOrgType) || "0".equals(tripStdOrgType) || !ErTripStdServiceImp.takeOfficeImCompany(userId, companyId, stdPreCalContext)) {
            Object dept = CommonServiceHelper.getUserMap(userId, null, true, stdPreCalContext).get("org");
            Long deptId = ErCommonUtils.getPk(dept);
            companyId = stdPreCalContext != null ? ErCommonUtils.getPk(stdPreCalContext.getDepCompanyObj().getComByOrgs(deptId).get("id")) : (Long)ActionLocalCache.get().get(ORG_COMPANY, deptId, () -> (Long)OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId).get("id"));
            companyId = companyId == null ? Long.valueOf(0L) : companyId;
        }
        return companyId;
    }

    private static boolean takeOfficeImCompany(Long userId, Long companyId) {
        return ErTripStdServiceImp.takeOfficeImCompany(userId, companyId, null);
    }

    private static boolean takeOfficeImCompany(Long userId, Long companyId, StdPreCalContext stdPreCalContext) {
        Set companyIds = (Set)ActionLocalCache.get().get(USER_COMPANYS, userId, () -> {
            DynamicObject user = null;
            user = stdPreCalContext != null ? stdPreCalContext.getUserDynamicObj().getUserObjByUserId(userId) : BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"entryentity.dpt", (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{userId})});
            if (user == null) {
                return new HashSet();
            }
            List<Long> orgs = user.getDynamicObjectCollection("entryentity").stream().map(v -> v.getLong("dpt.id")).collect(Collectors.toList());
            return ErTripStdServiceImp.getCompanys(orgs, stdPreCalContext);
        });
        companyIds = companyIds == null ? new HashSet() : companyIds;
        return companyIds.contains(companyId);
    }

    private static Set<Long> getCompanys(List<Long> orgs) {
        return ErTripStdServiceImp.getCompanys(orgs, null);
    }

    private static Set<Long> getCompanys(List<Long> orgs, StdPreCalContext stdPreCalContext) {
        HashSet<Long> companys = new HashSet<Long>(orgs.size());
        orgs.forEach(org -> {
            Long companyId = null;
            Map<String, Object> companyByOrg = null;
            companyByOrg = stdPreCalContext != null ? stdPreCalContext.getDepCompanyObj().getComByOrgs((Long)org) : OrgUnitServiceHelper.getCompanyfromOrg((Long)org);
            if (companyByOrg != null) {
                companyId = (Long)companyByOrg.getOrDefault("id", 0L);
                companys.add(companyId);
            }
        });
        return companys;
    }
}

