/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.ReverseBillServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class AmountModifyUtil {
    private static String sourceTripBillProperties = "id,billno,balanceamount,usedamount,tripentry,tripentry.oriaccbalamount,tripentry.accbalamount,tripentry.oriaccbalanceamount,tripentry.accbalanceamount,clearloanentry,clearloanentry.loanoribalanceamount,clearloanentry.loanclearamount,clearloanentry.loanaccbalanceamount";
    private static String sourceBillProperties = "id,billno,balanceamount,usedamount,expenseentryentity,expenseentryentity.oriaccbalamount,expenseentryentity.accbalamount,writeoffmoney.loanbillno,expenseentryentity.orgiexpebalanceamount,expenseentryentity.expebalanceamount";

    public static void initAmountFields(DynamicObject bill, String operation) {
        String sourceEntryKey = null;
        if (ErEntityTypeUtils.isTripReqBill(bill.getDataEntityType().getName())) {
            sourceEntryKey = "tripentry";
        } else if (ErEntityTypeUtils.isDailyLoanBill(bill.getDataEntityType().getName())) {
            sourceEntryKey = "expenseentryentity";
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(sourceEntryKey);
        for (DynamicObject entry : entrys) {
            entry.set("oriaccbalamount", (Object)entry.getBigDecimal("triporiaccappamount"));
            entry.set("accbalamount", (Object)entry.getBigDecimal("tripaccappamount"));
        }
        bill.set("balanceamount", (Object)bill.getBigDecimal("approveamount"));
        DynamicObjectCollection clearLoanEntrys = bill.getDynamicObjectCollection("clearloanentry");
        for (DynamicObject clearLoanEntry : clearLoanEntrys) {
            clearLoanEntry.set("oriaccnotpayamount", (Object)clearLoanEntry.getBigDecimal("orireceiveamount"));
            clearLoanEntry.set("accnotpayamount", (Object)clearLoanEntry.getBigDecimal("receiveamount"));
        }
        bill.set("notpayamount", (Object)bill.getBigDecimal("approveamount"));
    }

    public static void doBalanceReverse(DynamicObject targetBill, String operation) {
        String sourceEntityNumber = null;
        String sourceEntryKey = null;
        String selectProperties = null;
        String loanClearKey = null;
        String checkAmtOriKey = null;
        String checkAmtKey = null;
        String oriloanamountKey = null;
        String loanamountKey = null;
        String oriaccbalanceamountKey = null;
        String accbalanceamountKey = null;
        String loanbillnoKey = null;
        String reqaccountentryIdKey = null;
        if (ErEntityTypeUtils.isTripReimburseBill(targetBill.getDataEntityType().getName())) {
            sourceEntityNumber = "er_tripreqbill";
            loanClearKey = "clearloanentry";
            sourceEntryKey = "tripentry";
            selectProperties = sourceTripBillProperties;
            checkAmtOriKey = "loanclearoriamount";
            checkAmtKey = "loanclearamount";
            reqaccountentryIdKey = "reqaccountentryid";
            oriloanamountKey = "loanoribalanceamount";
            loanamountKey = "loanaccbalanceamount";
            oriaccbalanceamountKey = "oriaccbalanceamount";
            accbalanceamountKey = "accbalanceamount";
            loanbillnoKey = "loanbillno";
        } else if (ErEntityTypeUtils.isDailyReimburseBill(targetBill.getDataEntityType().getName())) {
            sourceEntityNumber = "er_dailyloanbill";
            loanClearKey = "writeoffmoney";
            sourceEntryKey = "expenseentryentity";
            selectProperties = sourceBillProperties;
            checkAmtOriKey = "accloanamount";
            checkAmtKey = "curraccloanamount";
            reqaccountentryIdKey = "sourceentryid";
            oriloanamountKey = "loanamount";
            loanamountKey = "currloanamount";
            oriaccbalanceamountKey = "orgiexpebalanceamount";
            accbalanceamountKey = "expebalanceamount";
            loanbillnoKey = "loanbillnov1";
        }
        DynamicObjectCollection clearLoanEntrys = targetBill.getDynamicObjectCollection(loanClearKey);
        Map<String, DynamicObject> sourceBillMap = AmountModifyUtil.getSourceBillInfos(clearLoanEntrys, sourceEntityNumber, selectProperties, loanbillnoKey);
        if (sourceBillMap == null) {
            return;
        }
        for (DynamicObject clearLoanEntry : clearLoanEntrys) {
            String sourceBillNo = "";
            sourceBillNo = clearLoanEntry.getString(loanbillnoKey);
            DynamicObject sourceBill = sourceBillMap.get(sourceBillNo);
            BigDecimal balanceAmount = sourceBill.getBigDecimal("balanceamount");
            BigDecimal usedAmount = sourceBill.getBigDecimal("usedamount");
            String sourceAccEntryId = clearLoanEntry.getString(reqaccountentryIdKey);
            DynamicObject sourceEntry = ReverseBillServiceHelper.getEntryById(sourceBill.getDynamicObjectCollection(sourceEntryKey), Long.valueOf(sourceAccEntryId));
            BigDecimal loanClearOriAmount = clearLoanEntry.getBigDecimal(checkAmtOriKey);
            BigDecimal loanClearAmount = clearLoanEntry.getBigDecimal(checkAmtKey);
            BigDecimal oriAccBalamount = clearLoanEntry.getBigDecimal(oriloanamountKey);
            BigDecimal accBalanceAmount = clearLoanEntry.getBigDecimal(loanamountKey);
            if (operation.equals("return")) {
                loanClearOriAmount = loanClearOriAmount.negate();
                loanClearAmount = loanClearAmount.negate();
            } else if (loanClearOriAmount.compareTo(oriAccBalamount) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6e90\u5355\u53ef\u7528\u4f59\u989d\u3002", (String)"AmountModifyUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            sourceEntry.set(oriaccbalanceamountKey, (Object)oriAccBalamount.subtract(loanClearOriAmount));
            sourceEntry.set(accbalanceamountKey, (Object)accBalanceAmount.subtract(loanClearAmount));
            sourceBill.set("balanceamount", (Object)balanceAmount.subtract(loanClearAmount));
            sourceBill.set("usedamount", (Object)usedAmount.add(loanClearAmount));
        }
        if (sourceBillMap != null && sourceBillMap.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])sourceBillMap.values().toArray(new DynamicObject[0]));
        }
    }

    public static void doPaymentReverse(DynamicObject bill, String operation, BigDecimal payAmount, BigDecimal payAmountOri, Long billEntryId) {
        BigDecimal billNotPayAmount = bill.getBigDecimal("notpayamount");
        BigDecimal billPayAmount = bill.getBigDecimal("payamount");
        BigDecimal balanceamount = bill.getBigDecimal("balanceamount");
        if (operation.equals("cancel")) {
            if (payAmount.compareTo(balanceamount) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u53ef\u7528\u4f59\u989d\u3002", (String)"AmountModifyUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            payAmount = payAmount.negate();
            payAmountOri = payAmountOri.negate();
        } else if (operation.equals("submit") && payAmount.compareTo(billNotPayAmount) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u4ed8\u91d1\u989d\u3002", (String)"AmountModifyUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (billEntryId != null) {
            DynamicObjectCollection accountEntrys = bill.getDynamicObjectCollection("accountentry");
            DynamicObject sourceEntry = ReverseBillServiceHelper.getEntryById(accountEntrys, billEntryId);
            BigDecimal notPayAmountOri = sourceEntry.getBigDecimal("oriaccnotpayamount");
            BigDecimal notPayAmount = sourceEntry.getBigDecimal("accnotpayamount");
            BigDecimal paidAmountOri = sourceEntry.getBigDecimal("oriaccpayedamount");
            BigDecimal paidAmount = sourceEntry.getBigDecimal("accpayedamount");
            sourceEntry.set("oriaccnotpayamount", (Object)notPayAmountOri.subtract(payAmountOri));
            sourceEntry.set("accnotpayamount", (Object)notPayAmount.subtract(payAmount));
            sourceEntry.set("oriaccpayedamount", (Object)paidAmountOri.add(payAmountOri));
            sourceEntry.set("accpayedamount", (Object)paidAmount.add(payAmount));
        }
        bill.set("notpayamount", (Object)billNotPayAmount.subtract(payAmount));
        bill.set("payamount", (Object)billPayAmount.add(payAmount));
        bill.set("balanceamount", (Object)billPayAmount.add(payAmount));
    }

    public static Map<String, DynamicObject> getSourceBillInfos(DynamicObjectCollection clearLoanEntrys, String entityName, String sourceBillProperties, String loanbillnoKey) {
        HashMap<String, DynamicObject> infoMap = new HashMap<String, DynamicObject>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (DynamicObject clearLoanEntry : clearLoanEntrys) {
            if (clearLoanEntry.get(loanbillnoKey) == null) continue;
            values.add(clearLoanEntry.get(loanbillnoKey));
        }
        if (values.size() > 0) {
            DynamicObject[] infos;
            QFilter f = new QFilter("billno", "in", values);
            for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)entityName, (String)sourceBillProperties, (QFilter[])new QFilter[]{f})) {
                infoMap.put(info.getString("billno"), info);
            }
            return infoMap;
        }
        return null;
    }
}

