/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.attachment.AttachmentData;
import kd.fi.er.common.model.invoice.InvoiceAttachmentVo;
import org.apache.commons.lang3.StringUtils;

public class AttachmentUtils {
    private static Log log = LogFactory.getLog(AttachmentUtils.class);

    public static Map<String, String> upload(IFormView view, IDataModel model, DynamicObject planebill, Boolean isweb) {
        byte[] bytes;
        HashMap<String, String> result = new HashMap<String, String>();
        String message = "";
        String ordernum = planebill.getString("ordernum");
        String downloadlink = planebill.getString("downloadlink");
        log.info("\u5f71\u50cf\u4fe1\u606f\u6587\u4ef6\u539f\u5730\u5740\uff1a{}", (Object)downloadlink);
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        if (filePanel == null) {
            log.info("\u8ba2\u5355\uff1a{} \u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u4e0d\u5b58\u5728\u9644\u4ef6\u6846\uff1a{},{}", (Object)planebill.getString("ordernum"));
            message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u4e0d\u5b58\u5728\u9644\u4ef6\u6846\u3002", (String)"AttachmentUtils_1", (String)"fi-er-business", (Object[])new Object[0]);
            result.put("message", message);
            return result;
        }
        List attachmentRowDataInBill = filePanel.getAttachmentData();
        List attachmentDataInBill = JSON.parseArray((String)JSONArray.toJSONString((Object)attachmentRowDataInBill), AttachmentData.class);
        Set oldUids = attachmentDataInBill.stream().map(data -> data.getUid()).collect(Collectors.toSet());
        log.info("\u5f71\u50cf\u4fe1\u606f\u6587\u4ef6\uff1a{}", (Object)JSON.toJSONString(oldUids));
        if (oldUids.contains(ordernum)) {
            result.put("message", message);
            return result;
        }
        ArrayList newAttachmentDatas = Lists.newArrayListWithExpectedSize((int)1);
        long currentTimeMillis = System.currentTimeMillis();
        AttachmentData attachmentDataForUpload = new AttachmentData();
        attachmentDataForUpload.setBillPkId(String.valueOf(model.getDataEntity().getPkValue()));
        String attachmentName = ordernum;
        Map<String, Object> data2 = HttpServiceHelper.doGetInputStream(downloadlink);
        InputStream inputStream = (InputStream)data2.get("in");
        if (inputStream == null) {
            log.info("\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u5f02\u5e38 no stream");
            message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u5f02\u5e38 no stream\u3002", (String)"AttachmentUtils_3", (String)"fi-er-business", (Object[])new Object[0]);
            result.put("message", message);
            return result;
        }
        String type = null;
        try {
            type = URLConnection.guessContentTypeFromStream(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!attachmentName.endsWith("." + type)) {
            attachmentName = attachmentName + "." + type;
        }
        attachmentDataForUpload.setType(type);
        log.info("\u5f71\u50cf\u4fe1\u606f\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)attachmentName);
        attachmentDataForUpload.setName(attachmentName);
        try {
            bytes = ByteStreams.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            log.info("\u8ba2\u5355\uff1a{}\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u5f02\u5e38\uff1a{}", (Object)planebill.getString("ordernum"), (Object)e.getMessage());
            message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u5f02\u5e38\u3002", (String)"AttachmentUtils_2", (String)"fi-er-business", (Object[])new Object[0]);
            result.put("message", message);
            return result;
        }
        TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String filePath = "";
        filePath = isweb != false ? tempFile.saveAsFullUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000) : tempFile.saveAsUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000);
        log.info("\u5f71\u50cf\u4fe1\u606f\u6587\u4ef6\u5730\u5740 redis \uff1a{}", (Object)filePath);
        filePath = AttachmentServiceHelper.saveTempToFileService((String)filePath, (String)"em", (String)view.getEntityId(), (Object)model.getDataEntity(true).getLong("id"), (String)attachmentName);
        log.info("\u5f71\u50cf\u4fe1\u606f\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)filePath);
        attachmentDataForUpload.setUrl(filePath);
        attachmentDataForUpload.setSize((long)bytes.length);
        attachmentDataForUpload.setClient("web");
        attachmentDataForUpload.setUid(ordernum);
        attachmentDataForUpload.setEntityNum(model.getDataEntityType().getName());
        attachmentDataForUpload.setStatus("success");
        attachmentDataForUpload.setLastModified(currentTimeMillis);
        attachmentDataForUpload.setCreatedate(currentTimeMillis);
        log.info("\u5f71\u50cf\u4fe1\u606f\u6587\u4ef6\uff1a{}", JSON.toJSON((Object)attachmentDataForUpload));
        newAttachmentDatas.add((Map)JSON.toJSON((Object)attachmentDataForUpload));
        AttachmentServiceHelper.upload((String)view.getEntityId(), (Object)model.getDataEntity(true).getLong("id"), (String)"attachmentpanel", (List)newAttachmentDatas);
        result.put("filePath", filePath);
        return result;
    }

    public static Map<String, Object> buildInvoiceAttachmentMap(InvoiceAttachmentVo attachment) {
        String attachmentName;
        String fileName;
        String attType;
        int lastIndexOfDot;
        if (!KingdeeInvoiceCloudConfig.syncInvoiceAttachmentToBill() || ErStdConfig.isDev()) {
            log.info("\u53d1\u7968\u96c6\u6210,AbstractImportInvoicePlugin_getInvoiceAttachments: \u672a\u5f00\u542f\u540c\u6b65\u9644\u4ef6");
            return null;
        }
        Map<String, Object> urlData = HttpServiceHelper.doGetInputStream(attachment.getLocalUrl());
        InputStream attachStream = (InputStream)urlData.get("in");
        if (attachStream == null) {
            return null;
        }
        Long size = (Long)urlData.get("size");
        log.info(String.format("urlData size: %d", size));
        try {
            size = size == null || size <= 0L ? Long.valueOf(attachStream.available()) : size;
            log.info(String.format("attachStream.available() : %d", attachStream.available()));
        }
        catch (Exception e) {
            log.info("\u53d1\u7968\u96c6\u6210,\u6587\u4ef6\u5927\u5c0f\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        String originalFileName = attachment.getOriginalFileName();
        String extension = "";
        if (StringUtils.isNotBlank((CharSequence)originalFileName) && (lastIndexOfDot = originalFileName.lastIndexOf(46)) >= 0) {
            String ext = originalFileName.substring(lastIndexOfDot + 1);
            String string = extension = AttType.isValid(ext) ? ext : "";
        }
        if (StringUtils.isBlank((CharSequence)extension) && !StringUtils.isBlank((CharSequence)(attType = attachment.getAttachmentType()))) {
            extension = AttType.getExtByType(attType);
        }
        String string = fileName = StringUtils.isNotBlank((CharSequence)(attachmentName = attachment.getAttachmentName())) ? attachmentName : originalFileName;
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            int lastIndexOfDot2 = fileName.lastIndexOf(46);
            if (lastIndexOfDot2 < 0) {
                fileName = fileName + "." + extension;
            } else {
                String ext = fileName.substring(lastIndexOfDot2 + 1);
                boolean valid = AttType.isValid(ext);
                if (!valid) {
                    fileName = fileName + "." + extension;
                }
            }
        } else {
            fileName = "default";
        }
        String filePath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, attachStream, 3000);
        if (size <= 0L) {
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = attachmentFileService.getInputStream(filePath);
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                size = bytes.length;
                log.info(String.format("FileServiceFactory.getAttachmentFileService() file size : %d", size));
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u9644\u4ef6\u6587\u4ef6\u5927\u5c0f\u5931\u8d25", (Throwable)e);
                size = 1024L;
            }
        }
        String uid = attachment.getSerialNo();
        HashMap<String, Object> filePanelMap = new HashMap<String, Object>(8);
        filePanelMap.put("name", fileName);
        filePanelMap.put("size", size);
        filePanelMap.put("type", "pdf");
        filePanelMap.put("status", "success");
        filePanelMap.put("url", filePath);
        filePanelMap.put("uid", uid);
        filePanelMap.put("description", attachment.getRemark());
        return filePanelMap;
    }

    public static String uploadTempfile(String url, String name) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = cache.getInputStream(url);
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)name);
        FileItem fileItem = new FileItem(name, pathParam, in);
        String downUrl = service.upload(fileItem);
        return downUrl;
    }

    public static enum AttType {
        PDF("1", "pdf"),
        PNG("2", "png"),
        DOC("3", "doc"),
        XLS("6", "xls"),
        PPTX("7", "ppt"),
        TXT("8", "txt");

        public static final String DOT = ".";
        public static final String REGEX = "(doc|docx|pdf|txt|rtf|odt|wps|wpd|pages|xls|xlsx|csv|ods|fods|ots|gnumeric|numbers|ppt|pptx|pps|ppsx|odp|fodp|otp|key|jpg|jpeg|png|gif|bmp|tiff|psd|mp3|wav|m4a|mp4|mov|avi|mkv|flv|zip|rar|7z|tar)";
        private String type;
        private String extension;

        private AttType(String type, String extension) {
            this.type = type;
            this.extension = extension;
        }

        public static boolean isValid(String extension) {
            return extension != null && extension.length() > 0 && extension.length() <= 4 && extension.matches(REGEX);
        }

        public static String getExtByType(String type) {
            if (StringUtils.isBlank((CharSequence)type)) {
                return "unknown";
            }
            AttType[] values = AttType.values();
            Optional<AttType> findFirst = Stream.of(values).filter(v -> v.getType().equals(type)).findFirst();
            if (findFirst.isPresent()) {
                return findFirst.get().getExtension();
            }
            return "unknown";
        }

        public String getType() {
            return this.type;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

