/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IMobileListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import org.apache.commons.lang3.StringUtils;

@KSObject
public class BillRelateUtils {
    public static boolean existReimburse(DynamicObject tripreqbillInfo, IFormView view) {
        int existReimburseCount;
        boolean isloan = tripreqbillInfo.getBoolean("isloan");
        return !isloan && (existReimburseCount = BillRelateUtils.showExistTripReimburseBills(view, (Long)tripreqbillInfo.getPkValue())) > 0;
    }

    public static DynamicObjectCollection getExistReimburseBills(Long sourceBillId) {
        Map targetBillGroup = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])new Long[]{sourceBillId});
        QFilter qFilter = new QFilter("id", "in", targetBillGroup.get("er_tripreimbursebill"));
        qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)"H"));
        DynamicObjectCollection existReimburseBills = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
        return existReimburseBills;
    }

    private static DynamicObjectCollection getExistTripReimburseBills(Long tripReqId) {
        Map targetBillGroup = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])new Long[]{tripReqId});
        QFilter qFilter = new QFilter("id", "in", targetBillGroup.get("er_tripreimbursebill"));
        qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)"H"));
        DynamicObjectCollection existReimburseBills = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,billstatus,billkind", (QFilter[])new QFilter[]{qFilter});
        return existReimburseBills;
    }

    @KSMethod
    public static int showExistReimburseBills(IFormView view, String targetFormId, Long sourceBillId) {
        DynamicObjectCollection existReimburseBills = BillRelateUtils.getExistReimburseBills(sourceBillId);
        int existReimburseCount = existReimburseBills.size();
        if (existReimburseCount > 0) {
            DynamicObject existReimburseBill = (DynamicObject)existReimburseBills.get(0);
            String existBillStatus = existReimburseBill.getString("billstatus");
            OperationStatus status = null;
            status = "A".equalsIgnoreCase(existBillStatus) || "D".equalsIgnoreCase(existBillStatus) ? OperationStatus.EDIT : OperationStatus.VIEW;
            Long existReimburseId = existReimburseBill.getLong("id");
            BillShowParameter billShowParameter = BillRelateUtils.getShowParameter(targetFormId, view, existReimburseId, status);
            view.showForm((FormShowParameter)billShowParameter);
            return existReimburseCount;
        }
        return existReimburseCount;
    }

    private static int showExistTripReimburseBills(IFormView view, Long tripReqId) {
        DynamicObjectCollection existReimburseBills = BillRelateUtils.getExistTripReimburseBills(tripReqId);
        int existReimburseCount = existReimburseBills.size();
        if (existReimburseCount > 0) {
            ShowType showType;
            DynamicObject existReimburseBill = (DynamicObject)existReimburseBills.get(0);
            String existBillStatus = existReimburseBill.getString("billstatus");
            OperationStatus status = null;
            status = "A".equalsIgnoreCase(existBillStatus) || "D".equalsIgnoreCase(existBillStatus) ? OperationStatus.EDIT : OperationStatus.VIEW;
            Long existReimburseId = existReimburseBill.getLong("id");
            BillShowParameter billShowPrameter = new BillShowParameter();
            String billKind = existReimburseBill.getString("billkind");
            String formId = "";
            if (view instanceof IMobileListView || view instanceof IMobileView) {
                billShowPrameter = new MobileBillShowParameter();
                showType = ShowType.Floating;
                formId = StringUtils.equals((CharSequence)billKind, (CharSequence)"1") ? "er_tripreim_grid_mb" : "er_tripreimbursebill_mob";
            } else {
                showType = view.getFormShowParameter().getFormConfig().getShowType();
                formId = StringUtils.equals((CharSequence)billKind, (CharSequence)"1") ? "er_tripreimbill_grid" : "er_tripreimbursebill";
            }
            billShowPrameter.setParentFormId(view.getFormShowParameter().getParentFormId());
            billShowPrameter.getOpenStyle().setShowType(showType);
            billShowPrameter.setFormId(formId);
            billShowPrameter.setStatus(status);
            billShowPrameter.setPkId((Object)existReimburseId);
            billShowPrameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
            view.showForm((FormShowParameter)billShowPrameter);
            return existReimburseCount;
        }
        return existReimburseCount;
    }

    private static BillShowParameter getShowParameter(String entityId, IFormView view, Long billid, OperationStatus operationStatus) {
        ShowType showType;
        BillShowParameter billShowPrameter = new BillShowParameter();
        if (view instanceof IMobileListView || view instanceof IMobileView) {
            billShowPrameter = new MobileBillShowParameter();
            showType = ShowType.Floating;
            entityId = entityId + "_mob";
        } else {
            showType = view.getFormShowParameter().getFormConfig().getShowType();
            if (entityId.equals("er_tripreimbursebill")) {
                billShowPrameter.setCaption(ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"BillRelateUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
        }
        billShowPrameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        billShowPrameter.getOpenStyle().setShowType(showType);
        billShowPrameter.setFormId(entityId);
        billShowPrameter.setStatus(operationStatus);
        billShowPrameter.setPkId((Object)billid);
        return billShowPrameter;
    }

    @KSMethod
    public static void cancelF7MulSelect(AbstractFormPlugin formPlugin) {
        BasedataEdit payerF7 = (BasedataEdit)formPlugin.getView().getControl("payer");
        payerF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(false);
        });
    }

    @Deprecated
    public static Set<Long> getTargetTravelerIdSet(DynamicObject targetTripEntry) {
        return new HashSet<Long>();
    }

    public static void setDefaultAccount(Long userId, DynamicObject targetBill, ExtendedDataEntity billDataEntity) {
        DynamicObject account;
        DynamicObject defaultAccount = PayeeServiceHelper.getDefaultAccount(userId);
        DynamicObject payMode = PayeeServiceHelper.getDefaultPayMode();
        DynamicObjectCollection accounts = targetBill.getDynamicObjectCollection("accountentry");
        DynamicObject dynamicObject = account = accounts.size() > 0 ? (DynamicObject)accounts.get(0) : accounts.addNew();
        if (defaultAccount != null) {
            DynamicObject currency;
            account.set("payeraccount02", (Object)defaultAccount.getString("payeraccount02"));
            account.set("payeraccount", (Object)defaultAccount.getString("payeraccount"));
            account.set("payeraccount01", (Object)defaultAccount.getString("payeraccount01"));
            account.set("payer", (Object)defaultAccount);
            account.set("payerbank_id", (Object)defaultAccount.getLong("payerbank_id"));
            account.set("payername", (Object)defaultAccount.getString("outpayer"));
            boolean isCurrency = targetBill.getBoolean("iscurrency");
            if (isCurrency && (currency = defaultAccount.getDynamicObject("CURRENCY")) != null) {
                account.set("accountcurrency", currency.getPkValue());
            }
        }
        account.set("paymode", (Object)payMode);
        billDataEntity.setValue("accountentry", (Object)accounts);
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, DynamicObject subEntity, String propName, DynamicObject baseData) {
        IDataEntityProperty currentProperty;
        String formID = entity.getDataEntityType().getParent().getName();
        String entityName = entity.getDataEntityType().getName();
        if (subEntity != null) {
            IDataEntityProperty subEntry = (IDataEntityProperty)((EntryProp)EntityMetadataCache.getDataEntityType((String)formID).getProperties().get((Object)entityName)).getDynamicCollectionItemPropertyType().getProperties().get((Object)"entryentity");
            currentProperty = (IDataEntityProperty)((SubEntryProp)subEntry).getDynamicCollectionItemPropertyType().getProperties().get((Object)propName);
        } else {
            currentProperty = (IDataEntityProperty)((EntryProp)EntityMetadataCache.getDataEntityType((String)formID).getProperties().get((Object)entityName)).getDynamicCollectionItemPropertyType().getProperties().get((Object)propName);
        }
        DynamicObjectType currentProType = ((MulBasedataProp)currentProperty).getDynamicCollectionItemPropertyType();
        HashMap<Object, DynamicObject> finalUserIDSet = new HashMap<Object, DynamicObject>();
        DynamicObject newObj = new DynamicObject(currentProType);
        newObj.set("fbasedataid", (Object)baseData);
        newObj.set("fbasedataid_id", baseData.getPkValue());
        finalUserIDSet.put(baseData.getPkValue(), newObj);
        DynamicObjectCollection collection = new DynamicObjectCollection(currentProType, (Object)entity);
        for (Map.Entry entry : finalUserIDSet.entrySet()) {
            collection.add(entry.getValue());
        }
        return collection;
    }

    public static void getTargetTripentryMulFieldKeyInfo(String mulFieldKey, DynamicObject sourceBillObject, BillEntityType srcMainType, BillEntityType tgtMainType, DynamicObject targetBill) {
        MulBasedataProp targetFieldProp = (MulBasedataProp)tgtMainType.findProperty(mulFieldKey);
        MulBasedataProp sourceFieldProp = (MulBasedataProp)srcMainType.findProperty(mulFieldKey);
        DynamicObjectCollection sourceBillTripentrys = sourceBillObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection targetBillTripentrys = targetBill.getDynamicObjectCollection("tripentry");
        for (int i = 0; i < sourceBillTripentrys.size(); ++i) {
            int j = i < targetBillTripentrys.size() ? i : targetBillTripentrys.size() - 1;
            DynamicObject targetBillTripentry = (DynamicObject)targetBillTripentrys.get(j);
            DynamicObjectCollection targetFieldRows = targetBillTripentry.getDynamicObjectCollection(mulFieldKey);
            targetFieldRows.clear();
            DynamicObject sourceBillTripentry = (DynamicObject)sourceBillTripentrys.get(i);
            DynamicObjectCollection sourceFieldRows = sourceBillTripentry.getDynamicObjectCollection(mulFieldKey);
            for (DynamicObject srcFieldRow : sourceFieldRows) {
                DynamicObject targetFieldRow = new DynamicObject(targetFieldProp.getDynamicCollectionItemPropertyType());
                targetFieldProp.getRefIdProp().setValue((Object)targetFieldRow, sourceFieldProp.getRefIdProp().getValue((Object)srcFieldRow));
                targetFieldRows.add((Object)targetFieldRow);
            }
        }
    }

    @Deprecated
    public static List<Map<String, Object>> initOrderEntrys(DynamicObject targetBill, DynamicObject targetTripEntry, Set<Long> travelerIdSet, Map<String, List<DynamicObject>> tripExpenseItemMap, List<Map<String, Object>> tripOrders, Map<String, Object> montrhEntryMap, boolean isShowInvoiceEntry) {
        return new ArrayList<Map<String, Object>>();
    }

    public static void getTargetTripentryMulFieldKeyInfoMutiBOTP(String mulFieldKey, DynamicObject[] sourceBillObject, BillEntityType srcMainType, BillEntityType tgtMainType, DynamicObject targetBill) {
        MulBasedataProp targetFieldProp = (MulBasedataProp)tgtMainType.findProperty(mulFieldKey);
        MulBasedataProp sourceFieldProp = (MulBasedataProp)srcMainType.findProperty(mulFieldKey);
        List sourceTripEntry = Arrays.stream(sourceBillObject).flatMap(l -> l.getDynamicObjectCollection("tripentry").stream()).collect(Collectors.toList());
        DynamicObjectCollection targetBillTripentrys = targetBill.getDynamicObjectCollection("tripentry");
        TripReimburseServiceHelper.adjuestTripEntrys(targetBillTripentrys);
        for (int i = 0; i < sourceTripEntry.size(); ++i) {
            int j = i < targetBillTripentrys.size() ? i : targetBillTripentrys.size() - 1;
            DynamicObject targetBillTripentry = (DynamicObject)targetBillTripentrys.get(j);
            DynamicObjectCollection targetFieldRows = targetBillTripentry.getDynamicObjectCollection(mulFieldKey);
            targetFieldRows.clear();
            DynamicObject sourceBillTripentry = (DynamicObject)sourceTripEntry.get(i);
            DynamicObjectCollection sourceFieldRows = sourceBillTripentry.getDynamicObjectCollection(mulFieldKey);
            for (DynamicObject srcFieldRow : sourceFieldRows) {
                DynamicObject targetFieldRow = new DynamicObject(targetFieldProp.getDynamicCollectionItemPropertyType());
                targetFieldProp.getRefIdProp().setValue((Object)targetFieldRow, sourceFieldProp.getRefIdProp().getValue((Object)srcFieldRow));
                targetFieldRows.add((Object)targetFieldRow);
            }
        }
    }
}

