/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.common.BotpPO.downNodeBill;
import org.apache.commons.collections.CollectionUtils;

public class BotpDrawServiceUtil {
    private static Log logger = LogFactory.getLog(BotpDrawServiceUtil.class);

    public static <T> Set removeExistDownLoanBill(Map<Long, List<T>> showDataMap, boolean checkPaidBill) {
        HashSet<String> set = new HashSet<String>();
        if (showDataMap == null || showDataMap.isEmpty()) {
            return set;
        }
        List lowerReachesList = BFTrackerServiceHelper.loadLinkDownNodes((String)"er_dailyapplybill", null, (Long[])showDataMap.keySet().toArray(new Long[0]));
        if (lowerReachesList != null) {
            HashMap lowerReachesMap = Maps.newHashMapWithExpectedSize((int)2);
            ArrayList allTargetBillList = Lists.newArrayList();
            for (BFRowLinkDownNode downNode : lowerReachesList) {
                ArrayList targetBillList = Lists.newArrayListWithExpectedSize((int)2);
                Iterator downNodeIt = downNode.getTNodes().values().iterator();
                while (downNodeIt.hasNext()) {
                    targetBillList.add(((BFRowLinkDownNode)downNodeIt.next()).getRowId().getBillId());
                }
                lowerReachesMap.put(downNode.getRowId(), targetBillList);
                allTargetBillList.addAll(targetBillList);
            }
            QFilter qf = new QFilter("id", "in", (Object)allTargetBillList);
            if (checkPaidBill) {
                qf.and(new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "D", "E", "F", "G"}));
            } else {
                qf.and(new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "D", "E", "F"}));
            }
            DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"er_dailyloanbill", (String)"id", (QFilter[])new QFilter[]{qf});
            List noShowlist = loanBills.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
            for (Map.Entry entrySet : lowerReachesMap.entrySet()) {
                boolean contain = false;
                for (Long noshowBill : noShowlist) {
                    if (!((List)entrySet.getValue()).contains(noshowBill)) continue;
                    contain = true;
                    break;
                }
                if (!contain) continue;
                List<T> list = showDataMap.get(((BFRowId)entrySet.getKey()).getBillId());
                showDataMap.remove(((BFRowId)entrySet.getKey()).getBillId());
                if (!checkPaidBill || list == null || list.size() <= 0) continue;
                T obj = list.get(0);
                if (obj instanceof ListSelectedRow) {
                    set.add(((ListSelectedRow)obj).getBillNo());
                    continue;
                }
                if (!(obj instanceof DynamicObject)) continue;
                set.add(((DynamicObject)obj).getString("applybillno"));
            }
        }
        return set;
    }

    public static boolean existDownBill(Map<Long, String> map, String sourceBillType, String targetBillType) {
        boolean flag = false;
        List lowerReachesList = BFTrackerServiceHelper.loadLinkDownNodes((String)sourceBillType, null, (Long[])map.keySet().toArray(new Long[0]));
        if (lowerReachesList != null) {
            HashMap lowerReachesMap = Maps.newHashMapWithExpectedSize((int)2);
            ArrayList allTargetBillList = Lists.newArrayList();
            for (BFRowLinkDownNode downNode : lowerReachesList) {
                ArrayList targetBillList = Lists.newArrayListWithExpectedSize((int)2);
                Iterator downNodeIt = downNode.getTNodes().values().iterator();
                while (downNodeIt.hasNext()) {
                    targetBillList.add(((BFRowLinkDownNode)downNodeIt.next()).getRowId().getBillId());
                }
                lowerReachesMap.put(downNode.getRowId(), targetBillList);
                allTargetBillList.addAll(targetBillList);
            }
            QFilter qf = new QFilter("id", "in", (Object)allTargetBillList);
            qf.and(new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "D", "E", "F", "G"}));
            DynamicObjectCollection bills = QueryServiceHelper.query((String)targetBillType, (String)"id", (QFilter[])new QFilter[]{qf});
            List noShowlist = bills.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
            noShowlist.retainAll(allTargetBillList);
            for (Map.Entry entrySet : lowerReachesMap.entrySet()) {
                noShowlist.retainAll((Collection)entrySet.getValue());
                if (noShowlist.size() == 0) {
                    map.remove(((BFRowId)entrySet.getKey()).getBillId());
                    continue;
                }
                flag = true;
            }
        }
        return flag;
    }

    public static String getOpenBillType(Long openBillId, IFormView view) {
        Long pkValue = (Long)view.getModel().getDataEntity().getPkValue();
        String billtype = null;
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)view.getEntityId(), (Long[])new Long[]{pkValue});
        for (Map.Entry next : sourceBills.entrySet()) {
            if (!((HashSet)next.getValue()).contains(openBillId)) continue;
            billtype = (String)next.getKey();
            break;
        }
        return billtype;
    }

    public static Map<Long, List<downNodeBill>> getDirectTrackUpBills(String entityType, Long[] pk) {
        Map downNodeMap = BFTrackerServiceHelper.loadBillLinkUpNodes((String)entityType, (Long[])pk, (boolean)true);
        return downNodeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entrySet -> {
            BFRowLinkUpNode tNodes = (BFRowLinkUpNode)entrySet.getValue();
            return tNodes.getSNodes().keySet().stream().map(e -> {
                downNodeBill downNodeBill2 = new downNodeBill();
                downNodeBill2.setPk(e.getBillId());
                downNodeBill2.setEntryPk(e.getEntryId());
                downNodeBill2.setEntityType(EntityMetadataCache.loadTableDefine((Long)e.getMainTableId()));
                return downNodeBill2;
            }).collect(Collectors.toList());
        }));
    }

    public static Map<Long, List<downNodeBill>> getDirectTrackDownBills(String entityType, Long[] pk) {
        Map downNodeMap = BFTrackerServiceHelper.loadBillLinkDownNodes((String)entityType, (Long[])pk, (boolean)true);
        return downNodeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entrySet -> {
            BFRowLinkDownNode tNodes = (BFRowLinkDownNode)entrySet.getValue();
            return tNodes.getTNodes().keySet().stream().map(e -> {
                downNodeBill downNodeBill2 = new downNodeBill();
                downNodeBill2.setPk(e.getBillId());
                downNodeBill2.setEntryPk(e.getEntryId());
                downNodeBill2.setEntityType(EntityMetadataCache.loadTableDefine((Long)e.getMainTableId()));
                return downNodeBill2;
            }).collect(Collectors.toList());
        }));
    }

    public static void showRelateBills(String entityID, String billNo, String jsonNodes, String type, IFormView view) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityID);
        String caption = String.format(mainType.getDisplayName().toString() + "(%1$s)", billNo);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_lookuptracker");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(caption);
        showParameter.getCustomParams().put("linknodes", jsonNodes);
        showParameter.getCustomParams().put("lookuptype", type);
        view.showForm(showParameter);
    }

    public static DrawArgs buildDrawArgs(String srcEntity, String tarEntity, IFormView tarView, ListSelectedRowCollection rows) {
        String ruleId = BotpDrawServiceUtil.getRuleId(srcEntity, tarEntity);
        return BotpDrawServiceUtil.buildDrawArgs(srcEntity, tarEntity, tarView, rows, ruleId);
    }

    public static DrawArgs buildDrawArgs(String srcEntity, String tarEntity, IFormView tarView, ListSelectedRowCollection rows, String ruleId) {
        List<Object> result = ErExtHelper.invokeMutiParamsExpandPlugin(ErExtcaseEnum.ER_EXTCASE_DRAWRULE, srcEntity, tarEntity, tarView, rows, ruleId);
        if (!result.isEmpty() && result.get(0) != null) {
            ruleId = (String)result.get(0);
        } else {
            QFilter qf = new QFilter("number", "=", (Object)ruleId);
            qf.and(new QFilter("enabled", "=", (Object)true));
            boolean exists = QueryServiceHelper.exists((String)"botp_crlist", (QFilter[])qf.toArray());
            if (!exists) {
                ruleId = null;
            }
        }
        if (ruleId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5355\u636e\u6ca1\u6709\u542f\u7528\u5bf9\u5e94\u7684\u4e0a\u62c9\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u6216\u8005\u91cd\u65b0\u8bbe\u7f6e\u89c4\u5219\u3002", (String)"BotpDrawServiceStdImpl_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(srcEntity);
        args.setTargetEntityNumber(tarEntity);
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(tarView.getPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        return args;
    }

    public static void dealResult(ConvertOperationResult result, List<DynamicObject> resultList, BillEntityType entityType) {
        IRefrencedataProvider refProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
            }
        };
        List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)entityType);
        resultList.addAll(dataEntitys);
        result.release(refProvider, (MainEntityType)entityType);
    }

    public static void dealResult(ConvertOperationResult result, IFormView tarView, DrawArgs args) {
        IBillView billView = (IBillView)tarView.getView(args.getTargetPageId());
        IRefrencedataProvider refProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
            }
        };
        List dataEntitys = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
        ((IBillModel)billView.getModel()).push(dataEntitys.get(0));
        tarView.sendFormAction((IFormView)billView);
        result.release(refProvider, billView.getModel().getDataEntityType());
    }

    private static String getRuleId(String sourceEntityName, String targetEntityName) {
        List loadRules = ConvertRuleCache.loadRules((String)sourceEntityName, (String)targetEntityName);
        if (CollectionUtils.isNotEmpty((Collection)loadRules)) {
            logger.info("loadRuleslxc : {}", (Object)SerializationUtils.toJsonString((Object)loadRules));
        } else {
            logger.info("\u67e5\u8be2botp\u89c4\u5219\u8fd4\u56de\u7a7a {} : {}", (Object)sourceEntityName, (Object)targetEntityName);
        }
        if (!loadRules.isEmpty()) {
            for (ConvertRuleElement rule : loadRules) {
                logger.info("\u4e0a\u62c9\u89c4\u5219\uff1a name: {}, zh: {}, en: {}, tw: {}", new Object[]{SerializationUtils.toJsonString((Object)rule.getName()), rule.getName().getLocaleValue_zh_CN(), rule.getName().getLocaleValue_en(), rule.getName().getLocaleValue_zh_TW()});
                if (!rule.isEnabled() || !rule.getName().getLocaleValue_zh_CN().contains("\u4e0a\u62c9")) continue;
                return rule.getId();
            }
        }
        return null;
    }

    public static String getRuleIdPush(String sourceEntityName, String targetEntityName) {
        List loadRules = ConvertRuleCache.loadRules((String)sourceEntityName, (String)targetEntityName);
        if (CollectionUtils.isNotEmpty((Collection)loadRules)) {
            logger.info("loadRules : {}", (Object)SerializationUtils.toJsonString((Object)loadRules));
        } else {
            logger.info("\u67e5\u8be2botp\u89c4\u5219\u8fd4\u56de\u7a7a {} : {}", (Object)sourceEntityName, (Object)targetEntityName);
        }
        if (!loadRules.isEmpty()) {
            return ((ConvertRuleElement)loadRules.get(0)).getId();
        }
        return null;
    }
}

