/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExpenseShareInvoiceUtil {
    public static Set<String> getAllSerialNos(DynamicObject bill) {
        DynamicObjectCollection waitEntrys = bill.getDynamicObjectCollection("expenseentryentity_wait");
        HashMap<String, Set> sourceBillMap = new HashMap<String, Set>();
        waitEntrys.stream().filter(m -> StringUtils.isNotEmpty((CharSequence)m.getString("srcbilltype"))).forEach(v -> {
            String srcBillType = v.getString("srcbilltype");
            HashSet<String> sourceBills = (HashSet<String>)sourceBillMap.get(srcBillType);
            if (sourceBills == null) {
                sourceBills = new HashSet<String>();
                sourceBillMap.put(srcBillType, sourceBills);
            }
            sourceBills.add(v.getString("sourcebillid"));
        });
        ArrayList allSourceBills = new ArrayList();
        sourceBillMap.forEach((k, v) -> {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)k);
            DynamicObject[] sourceBills = BusinessDataServiceHelper.load((Object[])v.toArray(), (DynamicObjectType)dataEntityType);
            allSourceBills.addAll(Arrays.asList(sourceBills));
        });
        HashSet serialNos = Sets.newHashSet();
        allSourceBills.forEach(dataEntity -> {
            DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
            serialNos.addAll(invoiceHeadEntryDOs.stream().map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toSet()));
            DynamicObjectCollection invoiceMergeEntryDOs = new DynamicObjectCollection();
            boolean hasInvoiceMergeEntry = dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoicemerge");
            if (hasInvoiceMergeEntry) {
                invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
            }
            Set serialNosFromOldTable = invoiceMergeEntryDOs.stream().map(invoiceMergeDO -> invoiceMergeDO.getString("serialno_merge")).collect(Collectors.toSet());
            serialNos.addAll(serialNosFromOldTable);
        });
        Set<String> serialNoWithoutEmpty = serialNos.stream().filter(serial -> StringUtils.isNotBlank((CharSequence)serial)).collect(Collectors.toSet());
        return serialNoWithoutEmpty;
    }
}

