/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.reimctl.ReimburseControlCurrency;
import org.apache.commons.lang3.StringUtils;

public class ReimburseControlUtils {
    private static final Log log = LogFactory.getLog(ReimburseControlUtils.class);
    private static final String COST_DEPT = "2";

    public static DynamicObject getReimburseControlCompany(DynamicObject dataEntity) {
        String controlOrgName = ReimburseControlUtils.getPersonReimCtlCompanyField();
        return dataEntity.getDynamicObject(controlOrgName);
    }

    public static DynamicObject getParameterSettingCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }

    public static boolean isUserRelateWithCompany(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "isuserrelatecompany");
        if (StringUtils.isBlank((CharSequence)result)) {
            return true;
        }
        switch (result) {
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        return true;
    }

    public static boolean isAllowPreviousYear(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "isallowpreviousyear");
        if (StringUtils.isBlank((CharSequence)result)) {
            return true;
        }
        switch (result) {
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        return true;
    }

    public static Month deadlineMonthOfAllowPreviousYes(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "deadlinemonth");
        if (StringUtils.isBlank((CharSequence)result)) {
            return Month.DECEMBER;
        }
        return Month.of(Integer.parseInt(result));
    }

    public static Integer reimUsefulLife(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "reimusefullife");
        if (StringUtils.isBlank((CharSequence)result)) {
            return 12;
        }
        return Integer.valueOf(result);
    }

    public static Boolean manuallyaddexpenseoffset(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "manuallyaddexpenseoffset");
        return StringUtils.isBlank((CharSequence)result) || StringUtils.equals((CharSequence)result, (CharSequence)"1");
    }

    public static Boolean invoiceIsMust(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "invoceismust");
        if (StringUtils.isNotBlank((CharSequence)result) && StringUtils.equals((CharSequence)result, (CharSequence)"1")) {
            return true;
        }
        return false;
    }

    public static LocalDate currentLocalDate() {
        return LocalDate.now();
    }

    public static boolean isAllowAddReimburseAmountInCompany(Long companyId, Long userId) {
        boolean isUserRelateWithCompany = ReimburseControlUtils.isUserRelateWithCompany(companyId);
        if (!isUserRelateWithCompany) {
            return true;
        }
        boolean isContainSelf = true;
        Long viewType = 1L;
        List<Long> companyList = Collections.singletonList(companyId);
        List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewType, companyList, (boolean)isContainSelf);
        DynamicObject userDO = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id,entryentity.id,entryentity.dpt");
        boolean isAllowAddReimburseAmount = userDO.getDynamicObjectCollection("entryentity").stream().anyMatch(entry -> allOrgList.contains(entry.getDynamicObject("dpt").getPkValue()));
        log.info(String.format("\u516c\u53f8:%d, \u6240\u6709\u5b50\u516c\u53f8\u4e3a: %s", companyId, JSON.toJSONString((Object)allOrgList)));
        log.info(String.format("\u5f53\u524d\u7528\u6237:%s", SerializationUtils.toJsonString((Object)userDO)));
        return isAllowAddReimburseAmount;
    }

    public static List<Long> getCompanysWithQueryPerm(String appNum, String entityId) {
        return ErPermissionServiceHelper.getOrgListWithQueryPerm(appNum, entityId);
    }

    public static boolean isOverApplyControl(Long companyId) {
        String result = (String)ErCommonUtils.getEMParameter(companyId, "isoverapplycontrol");
        if (StringUtils.isBlank((CharSequence)result)) {
            return true;
        }
        switch (result) {
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static DynamicObject getDeptReimbureControlOrg(Long companyId, DynamicObject dataEntity, int rowIndex) {
        return ReimburseControlUtils.getDeptReimbureControlOrg(companyId, dataEntity, (DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(rowIndex));
    }

    @Deprecated
    public static DynamicObject getDeptReimbureControlOrg(Long companyId, DynamicObject dataEntity, DynamicObject expenseEntryDO) {
        DynamicObject parameterSettingCompany = ReimburseControlUtils.getParameterSettingCompany(dataEntity);
        companyId = ErCommonUtils.getPk(parameterSettingCompany);
        String controlOrgName = (String)ErCommonUtils.getEMParameter(companyId, "reimcontrolorgname");
        DynamicObject controlOrg = null;
        controlOrg = StringUtils.equals((CharSequence)controlOrgName, (CharSequence)COST_DEPT) ? expenseEntryDO.getDynamicObject("entrycostdept") : dataEntity.getDynamicObject("org");
        return controlOrg;
    }

    public static QFilter getReimCtlDeptQFilter(Long companyId, Long deptId) {
        log.info("companyid = " + companyId + ",  deptId = " + deptId);
        return QFilter.of((String)"expenseentryentity.reimctldept=?", (Object[])new Object[]{deptId});
    }

    public static String getPersonReimCtlCompanyField() {
        String ctlCompanyField = ErStdConfig.get("reimctl.person.ctlCompanyField");
        if (StringUtils.isBlank((CharSequence)ctlCompanyField)) {
            ctlCompanyField = "company";
        }
        return ctlCompanyField.trim();
    }

    public static QFilter getPersonReimCtlCompanyQFilter(Long ctlCompanyId) {
        return new QFilter(ReimburseControlUtils.getPersonReimCtlCompanyField(), "=", (Object)ctlCompanyId);
    }

    public static QFilter getPersonReimCtlCompanyQFilter(Set<Long> companyIds) {
        return new QFilter(ReimburseControlUtils.getPersonReimCtlCompanyField(), "in", companyIds);
    }

    public static String getUserName(Long userId) {
        String reimburseUserName = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user").getLocaleString("name").getLocaleValue();
        return reimburseUserName;
    }

    public static String getOrgName(Long orgId) {
        String orgName = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org").getLocaleString("name").getLocaleValue();
        return orgName;
    }

    public static ReimburseControlCurrency getPersonCtlCurrency(Long companyId) {
        String personCltCurrency = SystemParamterUtil.getPersonCtlCurrency(companyId);
        return ReimburseControlCurrency.of((String)personCltCurrency);
    }

    public static ReimburseControlCurrency getDeptCtlCurrency(Long companyId) {
        String personCltCurrency = SystemParamterUtil.getDeptCtlCurrency(companyId);
        return ReimburseControlCurrency.of((String)personCltCurrency);
    }

    public static boolean isPersonReimCtl(DynamicObject expenseItemDO) {
        String reimType = expenseItemDO.getString("isreimburseamountctl");
        return StringUtils.equals((CharSequence)reimType, (CharSequence)"1");
    }

    public static boolean isDeptReimCtl(DynamicObject expenseItemDO) {
        String reimType = expenseItemDO.getString("isreimburseamountctl");
        return StringUtils.equals((CharSequence)reimType, (CharSequence)COST_DEPT);
    }

    @Deprecated
    public static Long getRelativeReimCtlDept(Long expenseItemId, Long deptId) {
        if (expenseItemId == null || deptId == null) {
            return null;
        }
        QFilter qFilter = QFilter.of((String)"enable='1' and status= 'C' and expenseitems.fbasedataId=? and deptrelation.dept.id=?", (Object[])new Object[]{expenseItemId, deptId});
        log.info(String.format("getRelativeReimCtlDept(expenseItemId:%d, expenseItemId:%d)", expenseItemId, deptId));
        DataSet deptRelationDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.er.business.utils.ReimburseControlUtils.getRelativeReimCtlDept", (String)"er_reimctldept_relation", (String)"deptrelation.dept.id as deptId, deptrelation.reimdept.id as reimdeptId", (QFilter[])new QFilter[]{qFilter}, null);
        if (deptRelationDataSet.isEmpty()) {
            return null;
        }
        Long resultId = ((Row)deptRelationDataSet.iterator().next()).getLong("reimdeptId");
        log.info(String.format("getRelativeReimCtlDept(expenseItemId:%d, expenseItemId:%d) return %d", expenseItemId, deptId, resultId));
        return resultId;
    }

    public static DynamicObject getReimCtlDeptInExpenseEntry(DynamicObject dataEntity, int expenseEntryRowIndex) {
        return ((DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(expenseEntryRowIndex)).getDynamicObject("reimctldept");
    }
}

