/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.sysparam.ApplierSelectRangeEnum;
import kd.fi.er.common.sysparam.UnitShowTypeEnum;
import kd.fi.er.common.type.SubsidiesDayParamEnum;
import org.apache.commons.lang.StringUtils;

public class SystemParamterUtil {
    private static final Log logger = LogFactory.getLog(SystemParamterUtil.class);

    private SystemParamterUtil() {
        throw new AssertionError((Object)ResManager.loadKDString((String)"\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316\u3002", (String)"SystemParamterUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
    }

    public static boolean isEnableExpItemFilterByInvoice(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "itemfilterbyinvoice");
    }

    public static boolean isMapInvoiceCloudImage(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "ismapinvoicecloudimage");
    }

    public static boolean isPaperlessReport(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "ispaperlessreport");
    }

    public static boolean isApplyBillNeedImage(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isapplybillneedimage");
    }

    public static int getExchangeRateFrom(Long companyId) {
        return SystemParamterUtil.getcheckparamDefaute(companyId, "exchangeratefrom");
    }

    public static boolean isAmountOverInvoice(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isamountoverinvoice");
    }

    public static boolean isEnableReimburseControlByCompany(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isreimburselimitcontrol");
    }

    private static boolean isEnableReimburseControlByExpenseItem(Long expenseItemId) {
        DynamicObject expenseItemDO = BusinessDataServiceHelper.loadSingleFromCache((Object)expenseItemId, (String)"er_expenseitemedit", (String)"isreimburseamountctl");
        String remburseAmountType = expenseItemDO.getString("isreimburseamountctl");
        return !org.apache.commons.lang3.StringUtils.equals((CharSequence)remburseAmountType, (CharSequence)"0");
    }

    public static boolean isEnableReimbureControlByCompanyAndExpenseItem(Long companyId, Long expenseItemId) {
        return SystemParamterUtil.isEnableReimburseControlByCompany(companyId) && SystemParamterUtil.isEnableReimburseControlByExpenseItem(expenseItemId);
    }

    public static String getReimburseLimitControlType(Long companyId) {
        if (SystemParamterUtil.isEnableReimburseControlByCompany(companyId)) {
            return (String)ErCommonUtils.getEMParameter(companyId, "reimburselimitcontroltype");
        }
        return "0";
    }

    public static boolean isShowBalanceAmtInExpdetail(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isshowbalanceamtinexpdeta");
    }

    public static boolean isAllowMergeSpanInvoice(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "allowmultinvoicemerge");
    }

    public static String enableCostCompanyEdit(Long company) {
        return ErCommonUtils.getEMParameter(company, "enablecostcompanyedit").toString();
    }

    public static boolean getTripEntryMulWayTo(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "tripentrywayto");
    }

    public static int getMulTravelersRange(long companyId) {
        return SystemParamterUtil.getloancheckparam(companyId, "multravelersrange");
    }

    public static boolean getIsMulTravelers(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "ismultravelers");
    }

    public static boolean getIsShowInvoiceEntry(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isusedmonthlyinvoiceentry");
    }

    public static boolean isShowParentbillExpenseitem(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isshowparentbillexpitem");
    }

    public static boolean getIsCurrencyShowinTripentry(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "iscurrencyshowintripentry");
    }

    public static int getloancheckparam(long companyId, String key) {
        Object value = ErCommonUtils.getEMParameter(companyId, key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.toString());
    }

    public static int getcheckparamDefaute(long companyId, String key) {
        Object value = ErCommonUtils.getEMParameter(companyId, key);
        if (value == null) {
            return 1;
        }
        return Integer.parseInt(value.toString());
    }

    public static boolean getIsAuditRevocationBill(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isauditrevocationbill");
    }

    public static boolean isUseLittleKApp(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isuselittlekap");
    }

    public static boolean manuallyaddexpenseoffset(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "manuallyaddexpenseoffset");
    }

    public static int getExpectedRepaymentDate(long companyId) {
        return SystemParamterUtil.getloancheckparam(companyId, "expectedrepaymentdate");
    }

    public static int getRepaymentDateBase(long companyId) {
        return SystemParamterUtil.getloancheckparam(companyId, "repaymentdatebase");
    }

    public static ApplierSelectRangeEnum getApplierSlectRangeType(Long companyId) {
        Object value = ErCommonUtils.getEMParameter(companyId, "applierselectrange");
        if (value == null) {
            return ApplierSelectRangeEnum.CONSIGNER_PLUS;
        }
        return ApplierSelectRangeEnum.getSelectRangeByType((String)String.valueOf(value));
    }

    public static int getBilllCloseDelayDays(Long companyId) {
        Object value = ErCommonUtils.getEMParameter(companyId, "closedelayday");
        if (value == null) {
            logger.info("\u53c2\u6570\u5e73\u53f0\u8bfb\u53d6\u7f13\u5b58\u4e3anull,\u5bfc\u81f4\u5173\u5355\u5929\u6570\u53c2\u6570\u53d6\u9ed8\u8ba4\u503c30\u5929");
            return 30;
        }
        return Integer.parseInt(String.valueOf(value));
    }

    public static String getMultiTravelerStdControlType(long companyId) {
        String result = "max";
        Object value = ErCommonUtils.getEMParameter(companyId, "trippartneraccstd");
        if (value instanceof String) {
            result = (String)value;
        }
        return result;
    }

    public static boolean getTripStdNeedSumCheck(long companyId) {
        String result = "yes";
        String res = "onlytrip";
        Object value = ErCommonUtils.getEMParameter(companyId, "tripstdsummarycheck");
        return result.equals(value) || res.equals(value);
    }

    public static boolean getTripStdNeedOnlySumCheck(long companyId) {
        String res = "onlytrip";
        Object value = ErCommonUtils.getEMParameter(companyId, "tripstdsummarycheck");
        return res.equals(value);
    }

    public static ControlMethodEnum getTripStandardControlLevel(long companyId) {
        Object value = ErCommonUtils.getEMParameter(companyId, "tripstandcontype");
        return SystemParamterUtil.getControlMethodEnumFromValue(value);
    }

    public static ControlMethodEnum getVehicleStdControlLevel(long companyId) {
        Object value = ErCommonUtils.getEMParameter(companyId, "vehiclecontype");
        return SystemParamterUtil.getControlMethodEnumFromValue(value);
    }

    private static ControlMethodEnum getControlMethodEnumFromValue(Object controlLevel) {
        Optional<ControlMethodEnum> optional = Arrays.stream(ControlMethodEnum.values()).filter(controlMethodEnum -> controlMethodEnum.getValue().equals(String.valueOf(controlLevel))).findFirst();
        return optional.orElseGet(() -> ControlMethodEnum.NO_CONTROL);
    }

    public static SubsidiesDayParamEnum getSubsidiesDaysCalculationType(long companyId) {
        Object value = ErCommonUtils.getEMParameter(companyId, "subsidiesdays");
        Optional<SubsidiesDayParamEnum> optional = Arrays.stream(SubsidiesDayParamEnum.values()).filter(subsidiesDayParamEnum -> String.valueOf(subsidiesDayParamEnum.getValue()).equals(String.valueOf(value))).findFirst();
        return optional.orElseGet(() -> SubsidiesDayParamEnum.NORMAL_CONTROL);
    }

    public static boolean isPublicreimToPayable(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "ispublicreim_to_payable");
    }

    public static boolean isQfilterProjectByUser(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isqfilterprojectbyuser");
    }

    public static boolean isToPurchasebill(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "istopurchasebill");
    }

    public static boolean isIscXk(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isiscxk");
    }

    public static boolean isReimburseAmountLargerZero(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "isamountlarger");
    }

    public static boolean isControlMulitLoan(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "controlloan");
    }

    public static boolean isEnableTripStandard(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "tripstandard");
    }

    public static boolean isEnableHighSeasonTripStandard(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "highseasontripstd");
    }

    public static boolean isSelectOtherAcctByAuth(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "selectotheracctbyauth");
    }

    public static boolean isEnableAlterCostOrgInfo(Long companyId) {
        return !SystemParamterUtil.getBoolParamResult(companyId, "altercostbear");
    }

    public static boolean isEnableItemAmountEdit(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "Itemamountedit");
    }

    public static boolean isEnableProjectShare(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "iscreateprojectcostshare");
    }

    public static boolean isEnablePushFinapbill(long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "ispublicreim_to_payable");
    }

    public static boolean getBoolParamResult(Long companyId, String paramName) {
        Object isCtl = ErCommonUtils.getEMParameter(companyId, paramName);
        return SystemParamterUtil.getBoolResult(isCtl);
    }

    public static Map<Long, Boolean> getBoolParamResults(List<Long> companyIds, String paramName) {
        Map<Long, Object> isCtls = ErCommonUtils.getEMParameter(companyIds, paramName);
        return SystemParamterUtil.getBoolResults(isCtls);
    }

    private static boolean getBoolResult(Object value) {
        if (value instanceof String) {
            String isCtlStr = (String)value;
            return org.apache.commons.lang3.StringUtils.equals((CharSequence)isCtlStr, (CharSequence)"1");
        }
        return false;
    }

    private static Map<Long, Boolean> getBoolResults(Map<Long, Object> params) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(params.size());
        params.forEach((k, v) -> result.put((Long)k, SystemParamterUtil.getBoolResult(v)));
        return result;
    }

    public static boolean isAllShare(Long companyId) {
        Object isCtl = ErCommonUtils.getEMParameter(companyId, "isallshare");
        if (isCtl == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)String.valueOf(isCtl))) {
            return true;
        }
        return SystemParamterUtil.getBoolResult(isCtl);
    }

    public static String getCurrencySource(Object company) {
        Long companyId = ErCommonUtils.getPk(company);
        if (companyId == null) {
            return "company";
        }
        String currencySource = (String)ErCommonUtils.getEMParameter(companyId, "currencysource");
        if (StringUtils.equals((String)"0", (String)currencySource)) {
            return "company";
        }
        return "costcompany";
    }

    public static boolean getDeductibleOfTaxpayer(Long companyId) {
        Object isCtl = ErCommonUtils.getEMParameter(companyId, "deductibleoftaxpayer");
        if (isCtl instanceof String) {
            String isCtlStr = (String)isCtl;
            return org.apache.commons.lang3.StringUtils.equals((CharSequence)isCtlStr, (CharSequence)"1");
        }
        return true;
    }

    public static String getTripReimburseType(Long companyId) {
        String type = (String)ErCommonUtils.getEMParameter(companyId, "tripreimbursetype");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)type)) {
            return "card";
        }
        return type;
    }

    public static String getTripReimburseOpenTypeHowGetValue(Long companyId) {
        return (String)ErCommonUtils.getEMParameter(companyId, "opentypehowgetvalue");
    }

    public static String getTripReimburseOpenType(Long CompanyId) {
        String type = SystemParamterUtil.getTripReimburseOpenTypeHowGetValue(CompanyId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)type)) {
            type = "2";
        }
        return type;
    }

    public static String getTripReimburseTypeByCurrentUser() {
        Long userId = Long.valueOf(RequestContext.getOrCreate().getUserId());
        return SystemParamterUtil.getTripReimburseTypeByUser(userId);
    }

    public static String getTripReimburseTypeByUser(Long userId) {
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId);
        if (userMap == null) {
            logger.info("\u672a\u83b7\u53d6\u5230" + userId + "\u7684\u4e2a\u4eba\u4fe1\u606f");
            return "card";
        }
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept == null) {
            logger.info("\u672a\u83b7\u53d6\u5230" + userId + "\u7684\u4e3b\u804c\u4f4d\u4fe1\u606f");
            return "card";
        }
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)ErCommonUtils.getPk(dept));
        if (company == null || company.isEmpty()) {
            logger.info("\u672a\u83b7\u53d6\u5230" + dept + "\u7684\u7ec4\u7ec7\u6240\u5c5e\u516c\u53f8\u4fe1\u606f");
            return "card";
        }
        return SystemParamterUtil.getTripReimburseType((Long)company.get("id"));
    }

    public static Long getInvoiceEntryCurrency(Long companyId) {
        Object id;
        Object invoiceEntryCurrency = ErCommonUtils.getEMParameter(companyId, "invoiceentrycurrency");
        if (invoiceEntryCurrency == null) {
            return 1L;
        }
        if (invoiceEntryCurrency instanceof LinkedHashMap && (id = ((LinkedHashMap)invoiceEntryCurrency).get("id")) != null) {
            return Long.parseLong(id.toString());
        }
        return 1L;
    }

    public static List<String> getEmpCltBillList(Long companyId) {
        String value = (String)ErCommonUtils.getEMParameter(companyId, "empquotaapplicablebill");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value)) {
            List<String> empCltList = Arrays.asList(value.split(","));
            return empCltList;
        }
        return new ArrayList<String>();
    }

    public static List<String> getDeptCltBillList(Long companyId) {
        String value = (String)ErCommonUtils.getEMParameter(companyId, "deptquotaapplicablebill");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value)) {
            List<String> deptCltList = Arrays.asList(value.split(","));
            return deptCltList;
        }
        return new ArrayList<String>();
    }

    public static String getPersonCtlCurrency(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String personCltCurrency = (String)ErCommonUtils.getEMParameter(companyId, "personctlcurrency");
        return personCltCurrency;
    }

    public static String getDeptCtlCurrency(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String deptctlcurrency = (String)ErCommonUtils.getEMParameter(companyId, "deptctlcurrency");
        return deptctlcurrency;
    }

    @Deprecated
    public static boolean getScopeOfMultiReimburserByUser(Long userId) {
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId);
        if (userMap == null) {
            logger.info("\u672a\u83b7\u53d6\u5230" + userId + "\u7684\u4e2a\u4eba\u4fe1\u606f");
            return false;
        }
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept == null) {
            logger.info("\u672a\u83b7\u53d6\u5230" + userId + "\u7684\u4e3b\u804c\u4f4d\u4fe1\u606f");
            return false;
        }
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)ErCommonUtils.getPk(dept));
        if (company == null || company.isEmpty()) {
            logger.info("\u672a\u83b7\u53d6\u5230" + dept + "\u7684\u7ec4\u7ec7\u6240\u5c5e\u516c\u53f8\u4fe1\u606f");
            return false;
        }
        return SystemParamterUtil.getScopeOfMultiReimburser((Long)company.get("id"));
    }

    public static int getScopeOfMultiReimburserByUserNew(Long userId) {
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId);
        if (userMap == null) {
            logger.info("\u672a\u83b7\u53d6\u5230" + userId + "\u7684\u4e2a\u4eba\u4fe1\u606f");
            return 0;
        }
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept == null) {
            logger.info("\u672a\u83b7\u53d6\u5230" + userId + "\u7684\u4e3b\u804c\u4f4d\u4fe1\u606f");
            return 0;
        }
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)ErCommonUtils.getPk(dept));
        if (company == null || company.isEmpty()) {
            logger.info("\u672a\u83b7\u53d6\u5230" + dept + "\u7684\u7ec4\u7ec7\u6240\u5c5e\u516c\u53f8\u4fe1\u606f");
            return 0;
        }
        return SystemParamterUtil.getScopeOfMultiReimburserNew((Long)company.get("id"));
    }

    @Deprecated
    public static boolean getScopeOfMultiReimburser(Long companyId) {
        String value = (String)ErCommonUtils.getEMParameter(companyId, "scopeofmultireimburser");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if ("0".equalsIgnoreCase(value)) {
            return false;
        }
        return "1".equalsIgnoreCase(value);
    }

    public static int getScopeOfMultiReimburserNew(Long companyId) {
        String value = (String)ErCommonUtils.getEMParameter(companyId, "scopeofmultireimburser");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        if ("0".equalsIgnoreCase(value)) {
            return 0;
        }
        if ("1".equalsIgnoreCase(value)) {
            return 1;
        }
        if ("2".equalsIgnoreCase(value)) {
            return 2;
        }
        if ("3".equalsIgnoreCase(value)) {
            return 3;
        }
        if ("4".equalsIgnoreCase(value)) {
            return 4;
        }
        return 0;
    }

    public static String isgetaccountcurrency(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String isgetaccountcurrency = (String)ErCommonUtils.getEMParameter(companyId, "isgetaccountcurrency");
        return isgetaccountcurrency;
    }

    public static boolean isOpenTripDateControl(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String tripDateControl = (String)ErCommonUtils.getEMParameter(companyId, "tripdatecontrol");
        return "1".equals(tripDateControl);
    }

    public static String getPublicupbillrange(Long companyId) {
        String publicupbillrange = (String)ErCommonUtils.getEMParameter(companyId, "publicupbillrange");
        return publicupbillrange;
    }

    public static String getShowBudgetPosition(Long companyId) {
        String showbudgetposition = (String)ErCommonUtils.getEMParameter(companyId, "showbudgetposition");
        return showbudgetposition;
    }

    public static Boolean getIsPublicUpFilterBySupplier(Long companyId) {
        String value = (String)ErCommonUtils.getEMParameter(companyId = Long.valueOf(companyId != null ? companyId.longValue() : RequestContext.get().getOrgId()), "publicupfilterbysupplier");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if ("0".equalsIgnoreCase(value)) {
            return false;
        }
        if ("1".equalsIgnoreCase(value)) {
            return true;
        }
        return false;
    }

    public static String getLoanDrawRange(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        return (String)ErCommonUtils.getEMParameter(companyId, "loandrawrange");
    }

    public static UnitShowTypeEnum getUnitShowTypes(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String value = (String)ErCommonUtils.getEMParameter(companyId, "unitshowtypes");
        return UnitShowTypeEnum.get((String)value);
    }

    public static String getRelationContract(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String relationcontract = (String)ErCommonUtils.getEMParameter(companyId, "relationcontract");
        return relationcontract;
    }

    public static String getPublicCurrentUnit(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        String publiccurrentunit = (String)ErCommonUtils.getEMParameter(companyId, "publiccurrentunit");
        return publiccurrentunit;
    }

    public static boolean isAmountToDeductibletax(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        return SystemParamterUtil.getBoolParamResult(companyId, "isamounttodeductibletax");
    }

    public static boolean getRepayRelateReceive(Long companyId) {
        companyId = companyId != null ? companyId.longValue() : RequestContext.get().getOrgId();
        return SystemParamterUtil.getBoolParamResult(companyId, "repayrelatereceive");
    }

    public static boolean isCalDayCountChange(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "caldaycountchange");
    }

    public static String getTripReserveControlType(Long companyId) {
        if (companyId == null) {
            return "2";
        }
        String controlType = (String)ErCommonUtils.getEMParameter(companyId, "tripreservecontroltype");
        return controlType == null ? "2" : controlType;
    }

    public static String getTripReimDateSelectRange(Long companyId) {
        String range = (String)ErCommonUtils.getEMParameter(companyId, "reimdateselectrange");
        return range == null ? "0" : range;
    }

    public static String getDefaultProjectOwer(Long companyId) {
        String range = (String)ErCommonUtils.getEMParameter(companyId, "defaultprojectower");
        return range == null ? "0" : range;
    }

    public static boolean getMeettingToTrip(Long companyId) {
        boolean result = SystemParamterUtil.getBoolParamResult(companyId, "meettingtotrip");
        return result;
    }

    public static boolean getExpenseAmountEdit(Long companyId) {
        boolean result = SystemParamterUtil.getBoolParamResult(companyId, "expenseamountedit");
        return result;
    }

    public static boolean getTripexpenseitemMustInput(Long companyId) {
        boolean result = SystemParamterUtil.getBoolParamResult(companyId, "tripexpenseitem");
        return result;
    }

    public static Boolean getIsTripUpFilterBySupplier(Long companyId) {
        String value = (String)ErCommonUtils.getEMParameter(companyId = Long.valueOf(companyId != null ? companyId.longValue() : RequestContext.get().getOrgId()), "tripupfilterbysupplier");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if ("0".equalsIgnoreCase(value)) {
            return false;
        }
        if ("1".equalsIgnoreCase(value)) {
            return true;
        }
        return false;
    }

    public static String getTripUpBillRange(Long companyId) {
        String publicupbillrange = (String)ErCommonUtils.getEMParameter(companyId, "triploandrawrange");
        return publicupbillrange;
    }

    public static String checkInvoiceCurrencyType(Long companyId) {
        String checkType = (String)ErCommonUtils.getEMParameter(companyId, "checkinvoicecurrencytype");
        return checkType;
    }

    public static boolean getAutoDrawLoanBill(Long companyId) {
        return SystemParamterUtil.getBoolParamResult(companyId, "autodrawloanbill");
    }
}

