/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.provider.param.req.RecognitionCheckReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TripInvoiceUtils {
    private static final Log logger = LogFactory.getLog(TripInvoiceUtils.class);

    public static Boolean checkingInvoiceIdentify(DynamicObject dynamicObject, InvoiceService instanceService) {
        return TripInvoiceUtils.checkingInvoiceIdentify(dynamicObject, instanceService, Boolean.TRUE, new HashSet<String>());
    }

    public static String getSubStr(String msg, int length) {
        if (StringUtils.isNotEmpty((CharSequence)msg) && msg.length() >= length) {
            msg = msg.substring(0, 2000);
        }
        return msg;
    }

    public static String getFileType(String url) {
        String fileType;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        switch (fileType = TripInvoiceUtils.getSuffix(url)) {
            default: {
                return "1";
            }
            case "png": 
            case "jpg": 
            case "jpeg": 
            case "gif": {
                return "2";
            }
            case "ofd": 
        }
        return "4";
    }

    public static String getSuffix(String downLoadLink) {
        String tempSuffixes = "jpeg|jpg|png|pdf|gif|ofd";
        Pattern pat = Pattern.compile("[\\w]+[\\.](" + tempSuffixes + ")");
        Matcher mc = pat.matcher(downLoadLink);
        if (mc.find()) {
            String name = mc.group();
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return "pdf";
    }

    public static Boolean checkingInvoiceIdentify(DynamicObject dynamicObject, InvoiceService instanceService, boolean setProp, Set<String> serialNos) {
        boolean identifyFlag = Boolean.FALSE;
        try {
            String imageDownLoadLink = dynamicObject.getString("downloadlink");
            RecognitionCheckReqParam reqParam = new RecognitionCheckReqParam();
            String fileType = TripInvoiceUtils.getFileType(imageDownLoadLink);
            Object expcommitcomnum = dynamicObject.get("settlemain");
            Long orgId = 0L;
            if (expcommitcomnum != null) {
                orgId = ErCommonUtils.getPk(expcommitcomnum);
            }
            reqParam.setFileDownUrl(imageDownLoadLink);
            reqParam.setFileType(fileType);
            reqParam.setOrgId(orgId);
            ValidateInvocieRespParam validateInvocieRespParam = instanceService.recognitionCheckInvoice(reqParam);
            if (validateInvocieRespParam == null) {
                return identifyFlag;
            }
            if (!validateInvocieRespParam.isPass()) {
                if (setProp) {
                    dynamicObject.set("identityerrormsg", (Object)validateInvocieRespParam.getMsg());
                }
                return identifyFlag;
            }
            String serialNo = validateInvocieRespParam.getInvoiceVO().getSerialNo();
            if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                serialNos.add(serialNo);
                if (setProp) {
                    dynamicObject.set("serialno", (Object)serialNo);
                    dynamicObject.set("invoiceidentityflag", (Object)1);
                    dynamicObject.set("identityerrormsg", (Object)"");
                }
                identifyFlag = Boolean.TRUE;
            } else if (setProp) {
                String msg = validateInvocieRespParam.getMsg();
                msg = TripInvoiceUtils.getSubStr(msg, 2000);
                dynamicObject.set("identityerrormsg", (Object)msg);
            }
        }
        catch (Exception e) {
            if (setProp) {
                dynamicObject.set("identityerrormsg", (Object)TripInvoiceUtils.getSubStr(e.getMessage(), 2000));
            }
            logger.error("error", (Throwable)e);
        }
        return identifyFlag;
    }

    public static DynamicObject[] setOrderBill(Set<DynamicObject> datas) {
        DynamicObject[] orderBills;
        Map<String, List<DynamicObject>> checkingBillMap = datas.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("allorderbase.ordernum"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("allorderbase.ordernum")));
        Optional<String> optional = datas.stream().findFirst().map(dynamicObject -> dynamicObject.getString("allorderbase.orderformid"));
        if (!optional.isPresent()) {
            return null;
        }
        String orderFormId = optional.get();
        for (DynamicObject orderBill : orderBills = BusinessDataServiceHelper.load((String)orderFormId, (String)"ordernum,serialno,identityerrormsg,kddownloadlink,downloadlink", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", checkingBillMap.keySet())})) {
            String orderNum = orderBill.getString("ordernum");
            if (!checkingBillMap.containsKey(orderNum)) continue;
            List<DynamicObject> dynamicObjects = checkingBillMap.get(orderNum);
            DynamicObject checkingBill = dynamicObjects.get(0);
            orderBill.set("serialno", (Object)checkingBill.getString("serialno"));
            orderBill.set("identityerrormsg", (Object)checkingBill.getString("identityerrormsg"));
            orderBill.set("kddownloadlink", (Object)checkingBill.getString("kddownloadlink"));
            orderBill.set("downloadlink", (Object)checkingBill.getString("downloadlink"));
        }
        return orderBills;
    }

    public static boolean checkInvoiceIdentifyByAws(DynamicObject dynamicObject, String userKey, Set<String> serialNos) {
        boolean identifyFlag = Boolean.FALSE;
        String downloadlink = dynamicObject.getString("downloadlink");
        String serialNo = "";
        String msg = "";
        try {
            dynamicObject.set("serialno", (Object)"");
            dynamicObject.set("invoiceidentityflag", (Object)0);
        }
        catch (Exception e) {
            logger.error("Line 174 \u5f53\u524d\u4e3a\u5927\u7968\u6570\u636e,\u4e0d\u9700\u8981\u8bbe\u7f6e\u5c5e\u6027,\u4e0d\u662f\u4e2a\u9519\u8bef", (Throwable)e);
        }
        try {
            serialNo = APIHelper.uploadImage(downloadlink, userKey);
        }
        catch (Exception e) {
            msg = e.getMessage();
        }
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            serialNos.add(serialNo);
            try {
                dynamicObject.set("serialno", (Object)serialNo);
                dynamicObject.set("invoiceidentityflag", (Object)1);
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u4e3a\u5927\u7968\u6570\u636e,\u4e0d\u9700\u8981\u8bbe\u7f6e\u5c5e\u6027,\u4e0d\u662f\u4e2a\u9519\u8bef", (Throwable)e);
            }
            identifyFlag = Boolean.TRUE;
        }
        msg = TripInvoiceUtils.getSubStr(msg, 2000);
        try {
            dynamicObject.set("identityerrormsg", (Object)msg);
        }
        catch (Exception e) {
            logger.error("\u5f53\u524d\u4e3a\u5927\u7968\u6570\u636e,\u4e0d\u9700\u8981\u8bbe\u7f6e\u5c5e\u6027,\u4e0d\u662f\u4e2a\u9519\u8bef", (Throwable)e);
        }
        return identifyFlag;
    }
}

