/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseTypeControlUtils {
    public static void setTripReqBillReimType(List<Long> reqBillBillIds) {
        List<Long> selectedIds = reqBillBillIds;
        if (!selectedIds.isEmpty()) {
            String entityId = "er_tripreqbill";
            DynamicObject[] selectedBills = BusinessDataServiceHelper.load((String)entityId, (String)"company,tripreimbursetype", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedIds)});
            HashMap maps = Maps.newHashMapWithExpectedSize((int)selectedBills.length);
            for (DynamicObject bill2 : selectedBills) {
                maps.put((Long)bill2.getPkValue(), SystemParamterUtil.getTripReimburseType((Long)bill2.getDynamicObject("company").getPkValue()));
            }
            List<DynamicObject> needUpdateBills = Arrays.stream(selectedBills).filter(entry -> !StringUtils.equals((CharSequence)entry.getString("tripreimbursetype"), (CharSequence)((CharSequence)maps.get(entry.getPkValue())))).collect(Collectors.toList());
            if (!needUpdateBills.isEmpty()) {
                needUpdateBills.forEach(bill -> bill.set("tripreimbursetype", maps.get(bill.getPkValue())));
                SaveServiceHelper.update((DynamicObject[])needUpdateBills.toArray(new DynamicObject[0]));
            }
        }
    }

    public static boolean companyIsSame(List<Long> selectedIds) {
        QFilter qFilter = new QFilter("id", "in", selectedIds);
        DynamicObjectCollection selectedBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"company", (QFilter[])new QFilter[]{qFilter});
        Set companyIdSet = selectedBills.stream().map(v -> ErCommonUtils.getPk(v.getLong("company"))).collect(Collectors.toSet());
        return companyIdSet != null && companyIdSet.size() != 1;
    }

    public static String getTripReqBillReimType(List<Long> selectedIds, boolean isMob) {
        QFilter qFilter = new QFilter("id", "in", selectedIds);
        DynamicObjectCollection selectedBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"company", (QFilter[])new QFilter[]{qFilter});
        String type = "";
        if (selectedBills != null) {
            if (selectedBills.size() > 1) {
                type = SystemParamterUtil.getTripReimburseTypeByCurrentUser();
            } else {
                Long companyId = ((DynamicObject)selectedBills.get(0)).getLong("company");
                type = SystemParamterUtil.getTripReimburseType(companyId);
            }
        }
        if (!isMob) {
            if (StringUtils.equals((CharSequence)type, (CharSequence)"grid")) {
                return "er_tripreimbill_grid";
            }
            return "er_tripreimbursebill";
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"grid")) {
            return "er_tripreim_grid_mb";
        }
        return "er_tripreimbursebill_mob";
    }
}

