/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TempEncashAmountUtils {
    private static String isgetaccountcurrency = "0";

    public static BigDecimal loan_getEncashedAmount(IDataModel model) {
        BigDecimal totalLoanAmount = AmountUtils.getEntryAmount(model, "expenseentryentity", "currexpenseamount");
        model.setValue("loanamount", (Object)totalLoanAmount);
        BigDecimal totalAmount = AmountUtils.getEntryAmount(model, "expenseentryentity", "expeapprovecurramount");
        BigDecimal payedAmount = (BigDecimal)model.getValue("payamount");
        model.setValue("approveamount", (Object)totalAmount);
        model.setValue("notpayamount", (Object)totalAmount.subtract(payedAmount));
        return totalLoanAmount;
    }

    public static void loan_refreshReceiveAmount(IDataModel model) {
        BigDecimal totalOrgiLoanAmount = AmountUtils.getEntryAmount(model, "expenseentryentity", "expeapproveamount");
        BigDecimal totalLoanAmount = AmountUtils.getEntryAmount(model, "expenseentryentity", "expeapprovecurramount");
        int count = model.getEntryRowCount("accountentry");
        if (totalLoanAmount.compareTo(BigDecimal.ZERO) > 0 && count <= 1 && count == 0) {
            model.createNewEntryRow("accountentry");
            String entityName = model.getDataEntityType().getName();
            if (!ErEntityTypeUtils.isPrePayBill(entityName)) {
                Object currentUser = model.getValue("applier");
                DynamicObject payer = PayeeServiceHelper.getDefaultAccount(Long.valueOf(((DynamicObject)currentUser).getPkValue().toString()));
                model.setValue("payer", payer == null ? null : payer.getPkValue(), 0);
            }
        }
        TempEncashAmountUtils.loan_setReciveAmount(totalOrgiLoanAmount, totalLoanAmount, model);
    }

    private static void loan_setReciveAmount(BigDecimal orgiAmount, BigDecimal currAmount, IDataModel dataModel) {
        Set<Long> currencySet = AmountUtils.getCurrencyIdSet(dataModel, "expenseentryentity", "entrycurrency");
        int size = dataModel.getEntryRowCount("accountentry");
        if (dataModel.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)dataModel.getValue("company")).getPkValue());
        }
        if (size == 1 && (DynamicObject)dataModel.getValue("accountcurrency", 0) != null) {
            DynamicObject accCurrency;
            long entrycurrencyid;
            BigDecimal receiveAmount = currAmount;
            BigDecimal receiveOriAmount = orgiAmount;
            BigDecimal exchangerate = BigDecimal.ZERO;
            BigDecimal accchangeRate = BigDecimal.ZERO;
            String billStatus = (String)dataModel.getValue("billstatus");
            DynamicObject entrycurrency = (DynamicObject)dataModel.getValue("entrycurrency", 0);
            long l = entrycurrencyid = entrycurrency != null ? (Long)entrycurrency.getPkValue() : 0L;
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)billStatus) && !StringUtils.equals((CharSequence)"D", (CharSequence)billStatus)) {
                String accQuoteType;
                accCurrency = (DynamicObject)dataModel.getValue("accountcurrency", 0);
                BigDecimal accExchangeRate = (BigDecimal)dataModel.getValue("accexchangerate", 0);
                int amountPrecision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(accCurrency));
                receiveOriAmount = currencySet != null && currencySet.size() == 1 && accCurrency.getPkValue().equals(entrycurrencyid) ? orgiAmount : (StringUtils.equals((CharSequence)"0", (CharSequence)(accQuoteType = (String)dataModel.getValue("accquotetype"))) ? receiveAmount.divide(accExchangeRate, amountPrecision, RoundingMode.HALF_UP) : receiveAmount.multiply(accExchangeRate).setScale(amountPrecision, RoundingMode.HALF_UP));
            } else if (currencySet != null && currencySet.size() > 1 && "0".equals(isgetaccountcurrency)) {
                dataModel.setValue("accountcurrency", (Object)ErCommonUtils.getPk(dataModel.getValue("currency")), 0);
                dataModel.setValue("accexchangerate", (Object)BigDecimal.ONE, 0);
                receiveOriAmount = currAmount;
            } else if ("0".equals(isgetaccountcurrency)) {
                if (entrycurrency != null) {
                    dataModel.setValue("accountcurrency", (Object)entrycurrencyid, 0);
                }
                exchangerate = (BigDecimal)dataModel.getValue("exchangerate", 0);
                dataModel.setValue("accexchangerate", (Object)exchangerate, 0);
            }
            accCurrency = (DynamicObject)dataModel.getValue("accountcurrency", 0);
            String billstatsus = (String)dataModel.getValue("billstatus");
            if ("1".equals(isgetaccountcurrency) && accCurrency != null) {
                receiveOriAmount = currencySet != null && currencySet.size() == 1 && accCurrency.getPkValue().equals(entrycurrencyid) ? orgiAmount : AmountUtils.getOriAmount(receiveAmount, (BigDecimal)dataModel.getValue("accexchangerate", 0), AmountUtils.getCurrencyPrecision((Long)accCurrency.getPkValue()), (String)dataModel.getValue("accquotetype", 0));
            }
            BigDecimal oriPayedAmount = (BigDecimal)dataModel.getValue("oriaccpayedamount", 0);
            BigDecimal payedAmount = (BigDecimal)dataModel.getValue("accpayedamount", 0);
            dataModel.setValue("orireceiveamount", (Object)receiveOriAmount, 0);
            dataModel.setValue("receiveamount", (Object)receiveAmount, 0);
            dataModel.setValue("oriaccnotpayamount", (Object)receiveOriAmount.subtract(oriPayedAmount), 0);
            dataModel.setValue("accnotpayamount", (Object)receiveAmount.subtract(payedAmount), 0);
        }
    }

    public static void triploan_refshAccCurrency(IDataModel model, IFormView view) {
        DynamicObjectCollection accentry = model.getEntryEntity("accountentry");
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)model.getValue("company")).getPkValue());
        }
        if (TempEncashAmountUtils.isLoan(model, view) && !accentry.isEmpty()) {
            DynamicObjectCollection tripentry = model.getEntryEntity("tripentry");
            if (tripentry.isEmpty()) {
                model.setValue("accountcurrency", (Object)ErCommonUtils.getPk(model.getValue("currency")), 0);
                return;
            }
            if (accentry.size() == 1) {
                if ("0".equals(isgetaccountcurrency)) {
                    DynamicObject currencytemp = ((DynamicObject)tripentry.get(0)).getDynamicObject("tripcurrency");
                    BigDecimal exchangeRate = ((DynamicObject)tripentry.get(0)).getBigDecimal("tripexchangerate");
                    String tripQuoteType = model.getProperty("tripquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((DynamicObject)tripentry.get(0)).getString("tripquotetype"), (Object)"0");
                    Boolean isSingleSectionCurrency = TempEncashAmountUtils.isSingleSectionCurrency(model);
                    if (!isSingleSectionCurrency.booleanValue()) {
                        currencytemp = (DynamicObject)model.getValue("currency");
                        exchangeRate = BigDecimal.ONE;
                    }
                    model.setValue("accountcurrency", (Object)ErCommonUtils.getPk(currencytemp), 0);
                    model.setValue("accexchangerate", (Object)exchangeRate, 0);
                    if (model.getProperty("accquotetype") != null) {
                        model.setValue("accquotetype", (Object)tripQuoteType, 0);
                    }
                } else {
                    String quoteType = model.getProperty("accquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("accquotetype", 0)), (Object)"0");
                    DynamicObject accountCurrency = ((DynamicObject)accentry.get(0)).getDynamicObject("accountcurrency");
                    int amtprecision = accountCurrency == null ? ((DynamicObject)model.getValue("currency")).getInt("amtprecision") : accountCurrency.getInt("amtprecision");
                    BigDecimal accExchangeRate = ((DynamicObject)accentry.get(0)).getBigDecimal("accexchangerate");
                    BigDecimal receiveamount = (BigDecimal)model.getValue("amount");
                    Set<Long> tripcurrency = AmountUtils.getCurrencyIdSet(model, "tripentry", "tripcurrency");
                    BigDecimal oriReceiveAmount = BigDecimal.ZERO;
                    DynamicObjectCollection dynamicObjectCollection = model.getDataEntity().getDynamicObjectCollection("tripentry");
                    oriReceiveAmount = tripcurrency != null && tripcurrency.size() == 1 ? oriReceiveAmount.add(dynamicObjectCollection.stream().map(v -> v.getBigDecimal("triporiaccappamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO)) : AmountUtils.getOriAmount(receiveamount, accExchangeRate, amtprecision, quoteType);
                    model.beginInit();
                    model.setValue("orireceiveamount", (Object)oriReceiveAmount, 0);
                    model.setValue("oriaccnotpayamount", (Object)oriReceiveAmount, 0);
                    model.setValue("receiveamount", (Object)receiveamount, 0);
                    model.setValue("accnotpayamount", (Object)receiveamount, 0);
                    model.endInit();
                    view.updateView("orireceiveamount", 0);
                    view.updateView("oriaccnotpayamount", 0);
                    view.updateView("receiveamount", 0);
                    view.updateView("accnotpayamount", 0);
                }
            }
        }
    }

    public static void triploan_refreshTripInfo(IDataModel model, IFormView view) {
        TempEncashAmountUtils.refreshTotalAmount(model, "tripentry", "tripamount", "amount");
        TempEncashAmountUtils.refreshTotalAmount(model, "tripentry", "tripaccappamount", "approveamount");
        if (TempEncashAmountUtils.isLoan(model, view)) {
            TempEncashAmountUtils.refreshTotalAmount(model, "tripentry", "tripaccappamount", "notpayamount");
            TempEncashAmountUtils.refreshTotalAmount(model, "tripentry", "tripaccappamount", "encashamount");
            TempEncashAmountUtils.refreshTotalAmount(model, "tripentry", "tripaccappamount", "loanamount");
        }
    }

    protected static BigDecimal refreshTotalAmount(IDataModel model, String entryField, String entryAmountField, String totalAmountField) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        int entryRowCount = model.getEntryRowCount(entryField);
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal tripAmount = (BigDecimal)model.getValue(entryAmountField, i);
            totalAmount = totalAmount.add(tripAmount);
        }
        if (totalAmountField != null) {
            model.setValue(totalAmountField, (Object)totalAmount);
        }
        return totalAmount;
    }

    public static boolean isLoan(IDataModel model, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Boolean isLoan = Boolean.FALSE;
        Object isLoanObj = formShowParameter.getCustomParam("isloan");
        isLoan = isLoanObj != null ? Boolean.valueOf(Boolean.parseBoolean(isLoanObj.toString())) : (Boolean)model.getValue("isloan");
        return isLoan;
    }

    public static boolean isSingleSectionCurrency(IDataModel model) {
        boolean isSingle = true;
        DynamicObjectCollection tripentry = model.getEntryEntity("tripentry");
        if (!tripentry.isEmpty()) {
            DynamicObject currencytemp = ((DynamicObject)tripentry.get(0)).getDynamicObject("tripcurrency");
            for (DynamicObject dobjet : tripentry) {
                DynamicObject currencyObject = dobjet.getDynamicObject("tripcurrency");
                if (currencytemp == currencyObject) continue;
                isSingle = false;
                break;
            }
        }
        return isSingle;
    }
}

